module adc_lvds
	#(
		parameter	size	=	3, // number of channels
		parameter	width	=	12 // channel resolution
	)
	(
		input	wire						lvds_dco,
		input	wire						lvds_fco,
 		input	wire	[size-1:0]			lvds_d,

		output	wire	[size*width-1:0]	adc_data
	);

	wire 	[size-1:0]	int_data_h, int_data_l;
	reg 	[width-1:0]	int_data_next [size-1:0];
//	reg 	[2*width:0]	int_data_next [size-1:0];
	reg 	[width-1:0]	int_data_reg [size-1:0];
//	reg 	[2*width:0]	int_data_reg [size-1:0];

	reg 	[width-1:0]	int_adc_data [size-1:0];

	integer i;
	genvar j;

	altddio_in #(
		.intended_device_family("Cyclone III"),
		.invert_input_clocks("ON"),
//		.invert_input_clocks("OFF"),
		.lpm_type("altddio_in"),
		.width(size)) altddio_in_unit (
		.datain(lvds_d),
		.inclock(lvds_dco),
		.aclr(1'b0),
		.dataout_h(int_data_h),
		.dataout_l(int_data_l),
		.aset(1'b0),
		.inclocken(1'b1),
		.sclr(1'b0),
		.sset(1'b0));

	always @ (posedge lvds_dco)
	begin
		for (i = 0; i < size; i = i + 1)
		begin
			int_data_reg[i] <= int_data_next[i];
		end
	end

	always @ (posedge lvds_fco)
	begin
		for (i = 0; i < size; i = i + 1)
		begin
			int_adc_data[i] <= int_data_next[i];
//			int_data_next[i] = {int_data_reg[i][2*width-2:0], int_data_l[i], int_data_h[i]};
		end
	end

	always @*
	begin
		for (i = 0; i < size; i = i + 1)
		begin
			int_data_next[i] = {int_data_reg[i][width-3:0], int_data_l[i], int_data_h[i]};
//			int_data_next[i] = {int_data_reg[i][2*width-2:0], int_data_l[i], int_data_h[i]};
		end
	end

	generate
		for (j = 0; j < size; j = j + 1)
		begin : ADC_LVDS_OUTPUT
			assign adc_data[j*width+width-1:j*width] = int_adc_data[j];
		end
	endgenerate

endmodule
