module adc_fifo
	#(
		parameter	W	=	48 // fifo width
	)
	(
		input	wire			adc_clock,
		input	wire	[W-1:0]	adc_data,

		input	wire			sys_clock,
		output	wire			sys_frame,
		output	wire	[W-1:0]	sys_data
	);

	wire	[W-1:0]	int_q;
	reg		[W-1:0]	int_data;
	
	reg				state, int_rdreq, int_frame;
	wire			int_wrfull, int_rdempty;

	dcfifo #(
		.intended_device_family("Cyclone III"),
		.lpm_numwords(16),
		.lpm_showahead("ON"),
		.lpm_type("dcfifo"),
		.lpm_width(W),
		.lpm_widthu(4),
		.rdsync_delaypipe(4),
		.wrsync_delaypipe(4),
		.overflow_checking("ON"),
		.underflow_checking("ON"),
		.use_eab("ON"),
		.write_aclr_synch("OFF")) fifo_unit (
		.aclr(1'b0),
		.data(adc_data),
		.rdclk(sys_clock),
		.rdreq((~int_rdempty) & int_rdreq),
		.wrclk(adc_clock),
		.wrreq(~int_wrfull),
		.q(int_q),
		.rdempty(int_rdempty),
		.wrfull(int_wrfull),
		.rdfull(),
		.rdusedw(),
		.wrempty(),
		.wrusedw());

	always @(posedge sys_clock)
	begin
		case (state)
			1'b0:
			begin
				int_rdreq <= 1'b1;
				int_frame <= 1'b0;
				state <= 1'b1;
			end

			1'b1: 
			begin
				if (~int_rdempty)
				begin
					int_data <= int_q;
					int_rdreq <= 1'b0;
					int_frame <= 1'b1;
					state <= 1'b0;
				end
			end
		endcase
	end
	
	assign	sys_frame = int_frame;
	assign	sys_data = int_data;

endmodule
