module adc_fifo
	(
		input	wire			adc_clk,
		input	wire	[11:0]	adc_data,

		input	wire			clk,
		output	wire			data_ready,
		output	wire	[11:0]	data
	);

	wire	[11:0]	int_q;
	reg		[11:0]	int_data;
	
	reg				state, int_rdreq, int_data_ready;
	wire			int_wrfull, int_rdempty;

	dcfifo #(
		.intended_device_family("Cyclone III"),
		.lpm_numwords(16),
		.lpm_showahead("ON"),
		.lpm_type("dcfifo"),
		.lpm_width(12),
		.lpm_widthu(4),
		.rdsync_delaypipe(4),
		.wrsync_delaypipe(4),
		.overflow_checking("ON"),
		.underflow_checking("ON"),
		.use_eab("OFF"),
		.write_aclr_synch("OFF")) fifo_unit (
		.aclr(1'b0),
		.data(adc_data),
		.rdclk(clk),
		.rdreq((~int_rdempty) & int_rdreq),
		.wrclk(adc_clk),
		.wrreq(~int_wrfull),
		.q(int_q),
		.rdempty(int_rdempty),
		.wrfull(int_wrfull),
		.rdfull(),
		.rdusedw(),
		.wrempty(),
		.wrusedw());

	always @(posedge clk)
	begin
		case (state)
			1'b0:
			begin
				int_rdreq <= 1'b1;
				int_data_ready <= 1'b0;
				state <= 1'b1;
			end

			1'b1: 
			begin
				if (~int_rdempty)
				begin
					int_data <= int_q;
					int_rdreq <= 1'b0;
					int_data_ready <= 1'b1;
					state <= 1'b0;
				end
			end

			default:
			begin
				int_rdreq <= 1'b1;
				int_data_ready <= 1'b0;
				state <= 1'b1;
			end
		endcase
	end
	
	assign	data_ready = int_data_ready;
	assign	data = int_data;

endmodule
