module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire			I2C_SDA,
		output	wire			I2C_SCL,
		inout	wire	[4:0]	CON_A,
		inout	wire	[15:0]	CON_B,
		input	wire	[12:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire	[2:0]	ADC_D,

		output	wire			USB_SLRD, 
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA, // EMPTY flag for EP6
		input	wire			USB_FLAGB, // FULL flag for EP8
		input	wire			USB_FLAGC,
		inout	wire			USB_PA0,
		inout	wire			USB_PA1,
		output	wire			USB_PA2,
		inout	wire			USB_PA3,
		output	wire			USB_PA4,
		output	wire			USB_PA5,
		output	wire			USB_PA6,
		inout	wire			USB_PA7,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_CE1,
		output	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);

	//	Turn output ports off
/*
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;
*/
	assign	RAM_CLK = CLK_50MHz;
	assign	RAM_CE1 = 1'b0;

	//	Turn inout ports to tri-state
	assign	TRG			=	4'bz;
	assign	CON_A		=	5'bz;
	assign	CON_B		=	16'bz;
	assign	USB_PA0		=	1'bz;
	assign	USB_PA1		=	1'bz;
	assign	USB_PA3		=	1'bz;
	assign	USB_PA7		=	1'bz;
//	assign	RAM_DQAP	=	1'bz;
//	assign	RAM_DQA		=	8'bz;
//	assign	RAM_DQBP	=	1'bz;
//	assign	RAM_DQB		=	8'bz;

	assign	USB_PA2		=	~usb_rden;
	assign	USB_PA4		=	usb_addr[0];
	assign	USB_PA5		=	usb_addr[1];
	assign	USB_PA6		=	~usb_pktend;

	wire			usb_wrreq, usb_rdreq, usb_rden, usb_pktend;
	wire			usb_aclr;
	wire			usb_tx_wrreq, usb_rx_rdreq;
	wire			usb_tx_full, usb_rx_empty;
	wire	[7:0]	usb_tx_data, usb_rx_data;
	wire	[1:0]	usb_addr;

	assign	USB_SLRD = ~usb_rdreq;
	assign	USB_SLWR = ~usb_wrreq;

	usb_fifo usb_unit
	(
		.usb_clk(USB_IFCLK),
		.usb_data(USB_PB),
		.usb_full(~USB_FLAGB),
		.usb_empty(~USB_FLAGA),
		.usb_wrreq(usb_wrreq),
		.usb_rdreq(usb_rdreq),
		.usb_rden(usb_rden),
		.usb_pktend(usb_pktend),
		.usb_addr(usb_addr),

		.clk(CLK_50MHz),
		.aclr(usb_aclr),

		.tx_full(usb_tx_full),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),

		.rx_empty(usb_rx_empty),
		.rx_rdreq(usb_rx_rdreq),
		.rx_q(usb_rx_data)
	);
	
	reg 			ana_reset [3:0];
	wire			ana_peak_ready [3:0];
	wire	[11:0]	ana_peak [3:0];

	reg 			osc_reset [3:0];
	reg 	[9:0]	osc_addr [3:0];
	wire	[9:0]	osc_start_addr [3:0];
	wire	[15:0]	osc_q [3:0];

	reg 			hst_reset [3:0];
	reg 	[11:0]	hst_addr [3:0];
	wire	[31:0]	hst_q [3:0];

	wire 			mux_reset, mux_type;
	wire 	[1:0]	mux_chan, mux_byte;
	wire 	[15:0]	mux_addr;
	
	reg		[7:0]	mux_q;
	reg 	[1:0]	mux_max_byte;
	reg 	[15:0]	mux_min_addr, mux_max_addr;

	wire			adc_clk [3:0];
	wire			adc_data_ready [3:0];
	wire 	[11:0]	adc_data [3:0];

    wire	[11:0]	raw_data [3:0];
    wire	[11:0]	uwt_data [3:0];
    wire	[1:0]	uwt_flag [3:0];
    
    wire	[16:0]	osc_thrs [3:0];
    wire			adc_pola [3:0];

    assign	osc_thrs[0] = 16'd40;
    assign	osc_thrs[1] = 16'd60;
    assign	osc_thrs[2] = 16'd40;
    assign	osc_thrs[3] = 16'd1650;

    assign	adc_pola[0] = 1'b1;
    assign	adc_pola[1] = 1'b1;
    assign	adc_pola[2] = 1'b1;
    assign	adc_pola[3] = 1'b0;

    assign	adc_clk[0] = ADC_FCO;
    assign	adc_clk[1] = ADC_FCO;
//    assign	adc_clk[2] = ADC_FCO;

    assign	adc_clk[3] = ADC_FCO;
/*    
    assign	adc_clk[3] = CON_CCLK[0];
    assign	adc_data[3] = CON_C[11:0];
*/
/*
	adc_para adc_para_unit (
		.lvds_dco(ADC_DCO),
		.lvds_fco(ADC_FCO),
		.para_data_ready(CON_CCLK[0]),
 		.para_data(CON_C[11:0]),
		.adc_data(adc_data[3]));
*/
/* 
	wire			adc_pll_clk;

	adc_pll adc_pll_unit(
		.inclk0(ADC_FCO),
		.c0(adc_pll_clk));
*/

	wire			tst_adc_clk;
	wire 	[11:0]	tst_adc_data;

	test test_unit(
		.clk(CLK_50MHz),
		.tst_clk(tst_adc_clk),
		.tst_data(tst_adc_data));

    assign	adc_clk[2] = tst_adc_clk;
    assign	adc_data[2] = tst_adc_data;

/*
	altserial_flash_loader #(
		.enable_shared_access("OFF"),
		.enhanced_mode(1),
		.intended_device_family("Cyclone III")) sfl_unit (
		.noe(1'b0),
		.asmi_access_granted(),
		.asmi_access_request(),
		.data0out(),
		.dclkin(),
		.scein(),
		.sdoin());
*/
/*
	adc_lvds #(
		.size(3),
		.width(12)) adc_lvds_unit (
		.lvds_dco(ADC_DCO),
//		.lvds_dco(adc_pll_clk),
		.lvds_fco(ADC_FCO),
		.lvds_d(ADC_D),
		.adc_data({ adc_data[0],
					adc_data[1],
					adc_data[2] }));
*/ 
	genvar i;
	generate
		for (i = 0; i < 3; i = i + 1)
		begin : MCA_CHAIN
			adc_fifo adc_fifo_unit (
				.adc_clk(adc_clk[i]),
				.adc_data(adc_data[i]),
				.polarity(adc_pola[i]),
				.clk(CLK_50MHz),
				.ready(adc_data_ready[i]),
				.raw_data(raw_data[i]),
				.uwt_data({uwt_flag[i], uwt_data[i]}));
	
			analyser analyser_unit (
				.clk(CLK_50MHz),
				.reset(ana_reset[i]),
				.data_ready(adc_data_ready[i]),
				.uwt_flag(uwt_flag[i]),
				.uwt_data(uwt_data[i]),
				.threshold(12'd10),
				.peak_ready(ana_peak_ready[i]),
				.peak(ana_peak[i]));

			histogram histogram_unit (
				.clk(CLK_50MHz),
				.reset(hst_reset[i]),
				.data_ready(adc_data_ready[i]),
				.data(raw_data[i]),
//				.data(uwt_data[i]),
				.address(hst_addr[i]),
				.q(hst_q[i]));
/*
			histogram histogram_unit (
				.clk(CLK_50MHz),
				.reset(hst_reset[i]),
				.data_ready(ana_peak_ready[i]),
				.data(ana_peak[i]),
				.address(hst_addr[i]),
				.q(hst_q[i]));
*/			
			oscilloscope oscilloscope_unit (
				.clk(CLK_50MHz),
				.reset(osc_reset[i]),
				.data_ready(adc_data_ready[i]),
				.raw_data(raw_data[i]),
				.uwt_data(uwt_data[i]),
				.threshold(osc_thrs[i]),
				.address(osc_addr[i]),
				.start_address(osc_start_addr[i]),
				.q(osc_q[i]));
		end
	endgenerate

	integer j;

	always @*
	begin
		for (j = 0; j < 4; j = j + 1)
		begin
			osc_reset[j] = 1'b0;
			osc_addr[j] = 10'b0;
			hst_reset[j] = 1'b0;
			hst_addr[j] = 12'b0;
		end

		case({mux_type, mux_chan})
			3'b000, 3'b001, 3'b010, 3'b011:
			begin
				osc_reset[mux_chan] = mux_reset;
				osc_addr[mux_chan] = mux_addr[9:0];
				mux_max_byte = 2'd1;	
				mux_min_addr = {6'd0, osc_start_addr[mux_chan]};
				mux_max_addr = 16'd1023;
			end

			3'b100, 3'b101, 3'b110, 3'b111:
			begin
				hst_reset[mux_chan] = mux_reset;
				hst_addr[mux_chan] = mux_addr[11:0];
				mux_max_byte = 2'd3;	
				mux_min_addr = 16'd0;
				mux_max_addr = 16'd4095;
			end
		endcase
	end
	
	always @*
	begin
		case ({mux_type, mux_byte})
			3'b000: mux_q = osc_q[mux_chan][7:0];
			3'b001: mux_q = osc_q[mux_chan][15:8];

			3'b100: mux_q = hst_q[mux_chan][7:0];
			3'b101: mux_q = hst_q[mux_chan][15:8];
			3'b110: mux_q = hst_q[mux_chan][23:16];
			3'b111: mux_q = hst_q[mux_chan][31:24];

			default: mux_q = 8'd0;
		endcase     
	end

	wire			i2c_aclr;
	wire			i2c_wrreq;
	wire			i2c_full;
	wire 	[15:0]	i2c_data;

	i2c_fifo i2c_unit(
		.clk(CLK_50MHz),
		.aclr(i2c_aclr),
		.wrreq(i2c_wrreq),
		.data(i2c_data),
		.full(i2c_full),
/*
		normal connection
		.i2c_sda(I2C_SDA),
		.i2c_scl(I2C_SCL),

		following is a cross wire connection for EPT
*/
		.i2c_sda(I2C_SCL),
		.i2c_scl(I2C_SDA));

	control control_unit (
		.clk(CLK_50MHz),
		.rx_empty(usb_rx_empty),
		.tx_full(usb_tx_full),
		.rx_data(usb_rx_data),
		.mux_max_byte(mux_max_byte),
		.mux_min_addr(mux_min_addr),
		.mux_max_addr(mux_max_addr),
		.mux_q(mux_q),
		.mux_reset(mux_reset),
		.mux_type(mux_type),
		.mux_chan(mux_chan),
		.mux_byte(mux_byte),
		.mux_addr(mux_addr),
		.rx_rdreq(usb_rx_rdreq),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),
		.ram_we(RAM_WE),
		.ram_addr(RAM_ADDR),
		.ram_data({RAM_DQA, RAM_DQAP, RAM_DQB, RAM_DQBP}),
		.i2c_wrreq(i2c_wrreq),
		.i2c_data(i2c_data),
		.i2c_full(i2c_full),
		.led(LED));

endmodule
