module adc_para
	(
		input	wire			lvds_dco,
		input	wire			lvds_fco,
		input	wire			para_data_ready,
 		input	wire	[11:0]	para_data,

		output	wire	[11:0]	adc_data
	);

	reg 	[1:0]	int_data_ready;
	reg 	[11:0]	int_data, int_adc_data;

	always @ (posedge lvds_dco)
	begin
		int_data_ready[1] <= int_data_ready[0];
		int_data_ready[0] <= para_data_ready;
		if ((int_data_ready[0]) & (~int_data_ready[1]))
		begin
			int_data <= para_data;
		end
	end

	always @ (posedge lvds_fco)
	begin
		int_adc_data <= int_data;
	end
	
	assign	adc_data = int_adc_data;

endmodule
