module test
	(
		input	wire			clk,
		output	wire			tst_clk,
		output	wire	[11:0]	tst_data
	);

	wire			int_clk;
	reg 	[11:0]	int_data;
	reg		[2:0]	state;

	test_pll test_pll_unit(
		.inclk0(clk),
		.c0(int_clk));

	always @(posedge int_clk)
	begin
		case (state)
			0: 
			begin
				int_data <= 12'd0;
				state <= 3'd1;
			end
			
			1:
			begin
				int_data <= 12'd1024;
				state <= 3'd2;
			end

			2:
			begin
				int_data <= 12'd2048;
				state <= 3'd3;
			end

			3:
			begin
				int_data <= 12'd3072;
				state <= 3'd4;
			end

			4:
			begin
				int_data <= 12'd4095;
				state <= 3'd0;
			end

			default:
			begin
				state <= 3'd0;
			end
		endcase
	end

	assign	tst_clk = int_clk;
	assign	tst_data = int_data;

endmodule
