module adc_lvds
	(
		input	wire			lvds_dco,
		input	wire			lvds_fco,
 		input	wire	[2:0]	lvds_d,

		output	reg		[11:0]	adc_db,
		output	reg		[11:0]	adc_dc,
		output	reg		[11:0]	adc_dd
	);

	wire 	[2:0]	int_data_h, int_data_l;
	reg 	[11:0]	int_data_next [2:0];
	reg 	[11:0]	int_data_reg [2:0];

	altddio_in #(
		.intended_device_family("Cyclone III"),
		.invert_input_clocks("ON"),
		.lpm_type("altddio_in"),
		.width(3)) altddio_in_unit (
		.datain(lvds_d),
		.inclock(lvds_dco),
		.aclr(1'b0),
		.dataout_h(int_data_h),
		.dataout_l(int_data_l),
		.aset(1'b0),
		.inclocken(1'b1),
		.sclr(1'b0),
		.sset(1'b0));

	always @ (posedge lvds_dco)
	begin
		int_data_reg[0] <= int_data_next[0];
		int_data_reg[1] <= int_data_next[1];
		int_data_reg[2] <= int_data_next[2];		
	end

	always @ (posedge lvds_fco)
	begin
		adc_db <= int_data_next[0];
		adc_dc <= int_data_next[1];
		adc_dd <= int_data_next[2];
	end

	always @*
	begin
		int_data_next[0] = {int_data_reg[0][9:0], int_data_l[0], int_data_h[0]};
		int_data_next[1] = {int_data_reg[1][9:0], int_data_l[1], int_data_h[1]};
		int_data_next[2] = {int_data_reg[2][9:0], int_data_l[2], int_data_h[2]};
	end

endmodule
