module adc_fifo
	(
		input	wire			adc_clk,
		input	wire	[11:0]	adc_data,

		input	wire			aclr,
		input	wire			rdclk,

		output	wire			ready,
		output	wire	[11:0]	raw_data,
		output	wire	[13:0]	uwt_data
	);

	wire 	[31:0]	uwt_d1, uwt_a1, uwt_peak1;
	wire 	[31:0]	uwt_d2, uwt_a2, uwt_peak2;
	wire 	[31:0]	uwt_d3, uwt_a3, uwt_peak3;
	wire 	[1:0]	uwt_flag1, uwt_flag2, uwt_flag3;

	wire	[11:0]	int_raw_q;
	wire	[13:0]	int_uwt_q;

	reg		[11:0]	int_raw_data;
	reg		[13:0]	int_uwt_data;

	wire	[1:0]	wrfull;
	
	reg				state;
	reg				int_rdreq, int_ready;
	wire			int_rdempty;

	uwt_bior31 #(.L(1)) uwt_1_unit (
		.clk(adc_clk),
		.x({20'h00000, adc_data}),
		.d(uwt_d1),
		.a(uwt_a1),
		.peak(uwt_peak1),
		.flag(uwt_flag1));

	uwt_bior31 #(.L(2)) uwt_2_unit (
		.clk(adc_clk),
		.x(uwt_a1),
		.d(uwt_d2),
		.a(uwt_a2),
		.peak(uwt_peak2),
		.flag(uwt_flag2));

	uwt_bior31 #(.L(3)) uwt_3_unit (
		.clk(adc_clk),
		.x(uwt_a2),
		.d(uwt_d3),
		.a(uwt_a3),
		.peak(uwt_peak3),
		.flag(uwt_flag3));

	dcfifo #(
		.intended_device_family("Cyclone III"),
		.lpm_numwords(16),
		.lpm_showahead("ON"),
		.lpm_type("dcfifo"),
		.lpm_width(12),
		.lpm_widthu(4),
		.rdsync_delaypipe(4),
		.wrsync_delaypipe(4),
		.overflow_checking("ON"),
		.underflow_checking("ON"),
		.use_eab("OFF"),
		.write_aclr_synch("OFF")) fifo_raw (
		.aclr(aclr),
		.data(adc_data),
		.rdclk(rdclk),
		.rdreq((~int_rdempty) & int_rdreq),
		.wrclk(adc_clk),
		.wrreq(~wrfull[0]),
		.q(int_raw_q),
		.rdempty(int_rdempty),
		.wrfull(wrfull[0]),
		.rdfull(),
		.rdusedw(),
		.wrempty(),
		.wrusedw());

	dcfifo #(
		.intended_device_family("Cyclone III"),
		.lpm_numwords(16),
		.lpm_showahead("ON"),
		.lpm_type("dcfifo"),
		.lpm_width(14),
		.lpm_widthu(4),
		.rdsync_delaypipe(4),
		.wrsync_delaypipe(4),
		.overflow_checking("ON"),
		.underflow_checking("ON"),
		.use_eab("OFF"),
		.write_aclr_synch("OFF")) fifo_uwt (
		.aclr(aclr),
		.data({uwt_flag3, uwt_peak3[11:0]}),
		.rdclk(rdclk),
		.rdreq((~int_rdempty) & int_rdreq),
		.wrclk(adc_clk),
		.wrreq(~wrfull[1]),
		.q(int_uwt_q),
		.rdempty(),
		.wrfull(wrfull[1]),
		.rdfull(),
		.rdusedw(),
		.wrempty(),
		.wrusedw());

	always @ (posedge rdclk)
	begin
		case (state)
			1'b0:
			begin
				int_rdreq <= 1'b1;
				int_ready <= 1'b0;
				state <= 1'b1;
			end

			1'b1: 
			begin
				if (~int_rdempty)
				begin
					int_raw_data <= int_raw_q;
					int_uwt_data <= int_uwt_q;
					int_rdreq <= 1'b0;
					int_ready <= 1'b1;
					state <= 1'b0;
				end
			end

			default:
			begin
				int_rdreq <= 1'b1;
				int_ready <= 1'b0;
				state <= 1'b1;
			end
		endcase
	end
	
	assign	ready = int_ready;
	assign	raw_data = int_raw_data;
	assign	uwt_data = int_uwt_data;

endmodule
