/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef INCLUDED_SPI_H
#define INCLUDED_SPI_H

// FX2 is SPI bus master going to fpga
#define SPI	IOA
#define SPI_OE	OEA
#define	bmSPI_OE	0x8B	// bits on PA
#define VEN_SPI_EN	0x96	// vendor commands
#define VEN_SPI_DIS	0x97
#define	VEN_SPI_RD	0x98
#define VEN_SPI_WR	0x99

#define bmSCLK	bmBIT0		// sclk on port A
#define	bmSDO	bmBIT1		// SPI MOSI
#define bmSDI	bmBIT3		// SPI MISO
#define	bmSS	bmBIT7		// Slave select
#define	SPI_FMT_HDR_MASK	(3 << 5)
#define	SPI_FMT_HDR_0	(0 << 5)	// 0 header bytes
#define	SPI_FMT_HDR_1	(1 << 5)	// 1 header byte
#define	SPI_FMT_HDR_2	(2 << 5)	// 2 header bytes

sbit at 0x80+0 bitS_CLK;		// 0x80 is the bit address of IOA
sbit at 0x80+1 bitS_OUT;		// out from FX2 point of view
sbit at 0x80+3 bitS_IN;			// in from FX2 point of view

void init_spi (void);		// one time call to init

// returns non-zero if successful, else 0
unsigned char
spi_read (unsigned char header_hi, unsigned char header_lo,
	  unsigned char enables, unsigned char format,
	  xdata unsigned char *buf, unsigned char len);

// returns non-zero if successful, else 0
unsigned char
spi_write (unsigned char header_hi, unsigned char header_lo,
	   unsigned char enables, unsigned char format,
	   const xdata unsigned char *buf, unsigned char len);

void
spi_write_byte_msb (unsigned char v);

void
spi_write_bytes_msb (const xdata unsigned char *buf, unsigned char len);

unsigned char
spi_read_byte_msb (void) _naked;

void
spi_read_bytes_msb (xdata unsigned char *buf, unsigned char len);

#endif /* INCLUDED_SPI_H */
