module delay
	#(
		parameter	width	=	12,
		parameter	length	=	32
	)
	(
		input	wire				clock, frame, reset,
		input	wire	[width-1:0]	inp_data,
		output	wire	[width-1:0]	out_data
	);
	
	reg		[width-1:0]	int_pipe_reg [length-1:0];
	
	integer i;

	always @(posedge clock)
	begin
		if (reset)
        begin
			for(i = 0; i < length; i = i + 1)
			begin
				int_pipe_reg[i] <= 0;
			end
        end
        else if (frame)
		begin
			for(i = 0; i <= 30; i = i + 1)
			begin
				int_pipe_reg[i+1] <= int_pipe_reg[i];
			end
			int_pipe_reg[0] <= inp_data;
		end
	end

	assign out_data = int_pipe_reg[length-1];

endmodule
