module coincidence
	#(
		parameter	input_width		=	4,
		parameter	window_size		=	10,
		parameter	output_width	=	3
	)
	(
		input	wire						clock, frame, reset,
		input	wire	[output_width-1:0]	cfg_data,
		input	wire	[input_width-1:0]	trg_data,
		output	wire	[output_width-1:0]	coi_data,
		output	wire						coi_flag
	);
	
	reg		[window_size-1:0]	coi_pipe_reg [input_width-1:0];
	reg							coi_flag_reg;

	wire	[output_width-1:0]	coi_data_wire;
	wire	[input_width-1:0]	int_data_wire;
	
	integer i;
	genvar j;

	always @(posedge clock)
	begin
		if (reset)
        begin
			coi_flag_reg <= 1'b0;
			for(i = 0; i <= 3; i = i + 1)
			begin
				coi_pipe_reg[i] <= 0;
			end
        end
        else if (frame)
		begin
			if (coi_data_wire >= cfg_data)
			begin
				coi_flag_reg <= 1'b1;
				for(i = 0; i < input_width; i = i + 1)
				begin
					coi_pipe_reg[i] <= 0;
				end
			end
			else
			begin
				coi_flag_reg <= 1'b0;
				for(i = 0; i < input_width; i = i + 1)
				begin
					coi_pipe_reg[i] <= {coi_pipe_reg[i][window_size-2:0], trg_data[i]};
				end
			end
		end
	end

	generate
		for (j = 0; j < input_width; j = j + 1)
		begin : INT_DATA
			assign int_data_wire[j] = (|coi_pipe_reg[j]);
		end
	endgenerate

	parallel_add #(
		.msw_subtract("NO"),
		.representation("UNSIGNED"),
		.result_alignment("LSB"),
		.pipeline(1),
		.shift(0),
		.size(input_width),
		.width(1),
		.widthr(output_width)) parallel_add_unit (
		.clock(clock),
		.data(int_data_wire),
		.result(coi_data_wire));


	assign coi_data = coi_data_wire;
	assign coi_flag = coi_flag_reg;

endmodule
