module configuration
	(
		input	wire			clock, reset,

		input	wire			bus_ssel, bus_wren,
		input	wire	[5:0]	bus_addr,
		input	wire	[15:0]	bus_mosi,

		output	wire	[15:0]	bus_miso,
		output	wire			bus_busy,
		
		output  wire	[1023:0]	cfg_bits
	);

	wire 	[63:0]	int_ssel_wire;
	wire	[15:0]	int_miso_wire;
	reg		[15:0]	int_miso_reg;

	wire 	[1023:0]	int_bits_wire;

	integer i;
	genvar j;

	generate
		for (j = 0; j < 64; j = j + 1)
		begin : BUS_OUTPUT
			lpm_ff #(
				.lpm_fftype("DFF"),
				.lpm_type("LPM_FF"),
				.lpm_width(16)) cfg_reg_unit (
				.enable(int_ssel_wire[j] & bus_ssel & bus_wren),
				.sclr(reset),
				.clock(clock),
				.data(bus_mosi),
				.q(int_bits_wire[j*16+15:j*16]),
				.aclr(),
				.aload(),
				.aset(),
				.sload(),
				.sset());
				end
	endgenerate

	lpm_mux #(
		.lpm_size(64),
		.lpm_type("LPM_MUX"),
		.lpm_width(16),
		.lpm_widths(6)) bus_miso_mux_unit (
		.sel(bus_addr),
		.data(int_bits_wire),
		.result(int_miso_wire));


	lpm_decode #(
		.lpm_decodes(64),
		.lpm_type("LPM_DECODE"),
		.lpm_width(6)) lpm_decode_unit (
		.data(bus_addr),
		.eq(int_ssel_wire),
		.aclr(),
		.clken(),
		.clock(),
		.enable());

	always @(posedge clock)
	begin
		if (reset)
		begin
			int_miso_reg <= 16'd0;
		end
		else
		begin
			int_miso_reg <= int_miso_wire;
		end
	end

	// output logic
	assign	bus_miso = int_miso_reg;
	assign	bus_busy = 1'b0;
	assign	cfg_bits = int_bits_wire;

endmodule
