module amplitude
	#(
		parameter	width	=	12 // bit width of the input data
	)
	(
		input	wire				clock, frame, reset,
		input	wire	[width-1:0]	cfg_data,
		input	wire	[width-1:0]	inp_data,
		output	wire	[width-1:0]	out_data,
		output	wire				out_flag
	);

	reg					int_case_reg, int_case_next;
	reg					out_flag_reg, out_flag_next;
	reg					int_flag_reg, int_flag_next;
	reg		[width-1:0]	int_mini_reg, int_mini_next;
	reg		[width-1:0]	out_data_reg, out_data_next;
	reg		[width-1:0]	inp_data_reg, inp_data_next;

	wire				int_comp_wire;
	reg					int_comp_reg, int_comp_next;

	assign int_comp_wire = (inp_data_reg < inp_data);

	always @(posedge clock)
	begin
		if (reset)
		begin
			int_case_reg <= 1'b0;
			int_mini_reg <= {(width){1'b0}};
			inp_data_reg <= {(width){1'b0}};
			out_data_reg <= {(width){1'b0}};
			out_flag_reg <= 1'b0;
			int_flag_reg <= 1'b0;
			int_comp_reg <= 1'b0;
		end
		else
		begin
			int_case_reg <= int_case_next;
			int_mini_reg <= int_mini_next;
			inp_data_reg <= inp_data_next;
			out_data_reg <= out_data_next;
			out_flag_reg <= out_flag_next;
			int_flag_reg <= int_flag_next;
			int_comp_reg <= int_comp_next;
		end
	end
	
	always @*
	begin
		int_case_next = int_case_reg;
		int_mini_next = int_mini_reg;
		inp_data_next = inp_data_reg;
		out_data_next = out_data_reg;
		out_flag_next = out_flag_reg;
		int_flag_next = int_flag_reg;
		int_comp_next = int_comp_reg;
		
		case (int_case_reg)
			0:
			begin
				if (frame)
				begin
					inp_data_next = inp_data;
					int_comp_next = int_comp_wire;
					out_data_next = {(width){1'b0}};
					out_flag_next = 1'b0;
					// minimum
					if ((~int_comp_reg) & (int_comp_wire))
					begin
						int_mini_next = inp_data_reg;
						int_flag_next = 1'b1;
					end
					// maximum
					else if ((int_comp_reg) & (~int_comp_wire) & (int_flag_reg))
					begin
						out_data_next = inp_data_reg - int_mini_reg;
						int_flag_next = 1'b0;
						int_case_next = 1'b1;
					end
                end
 			end
			
			1:
			begin
				out_flag_next = (out_data_reg >= cfg_data);
				int_case_next = 1'b0;
 			end

		endcase
	end

	assign out_data = out_data_reg;
	assign out_flag = out_flag_reg;

endmodule
