module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire	[6:0]	CON_A,
		inout	wire	[16:0]	CON_B,
		inout	wire	[11:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire			ADC_DB,
		input	wire			ADC_DC,
		input	wire			ADC_DD,

		inout	wire			USB_SLDR, 
		inout	wire			USB_SLWR,
		inout	wire			USB_IFCLK,
		inout	wire			USB_FLAGA,
		inout	wire			USB_FLAGB,
		input	wire			USB_FLAGC,
		inout	wire	[7:0]	USB_PA,
		inout	wire	[7:0]	USB_PB,

		inout	wire			RAM_CLK,
		inout	wire			RAM_CE1,
		inout	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);
	
	reg		[31:0]	counter;
	
	assign	LED		=	counter[25];

	always @ (posedge CLK_50MHz)
	begin
		counter <= counter + 32'd1;
	end

endmodule