module test
	(
		input	wire			clock,
		output	wire	[11:0]	data
	);

	reg 	[11:0]	int_addr;

	always @(posedge clock)
	begin
		if (int_addr == 12'd2559)
		begin
			int_addr <= 12'd0;
		end
		else
		begin
			int_addr <= int_addr + 12'd1;
		end

	end

	altsyncram #(
		.address_aclr_a("NONE"),
		.clock_enable_input_a("BYPASS"),
		.clock_enable_output_a("BYPASS"),
		.init_file("test_mwd.mif"),
		.intended_device_family("Cyclone III"),
		.lpm_hint("ENABLE_RUNTIME_MOD=NO"),
		.lpm_type("altsyncram"),
		.numwords_a(2560),
		.operation_mode("ROM"),
		.outdata_aclr_a("NONE"),
		.outdata_reg_a("CLOCK0"),
		.widthad_a(12),
		.width_a(12),
		.width_byteena_a(1)) test_rom_unit (
		.clock0(clock),
		.address_a(int_addr),
		.q_a(data),
		.aclr0(1'b0),
		.aclr1(1'b0),
		.address_b(1'b1),
		.addressstall_a(1'b0),
		.addressstall_b(1'b0),
		.byteena_a(1'b1),
		.byteena_b(1'b1),
		.clock1(1'b1),
		.clocken0(1'b1),
		.clocken1(1'b1),
		.clocken2(1'b1),
		.clocken3(1'b1),
		.data_a({12{1'b1}}),
		.data_b(1'b1),
		.eccstatus(),
		.q_b(),
		.rden_a(1'b1),
		.rden_b(1'b1),
		.wren_a(1'b0),
		.wren_b(1'b0));

endmodule
