module amplitude
	(
		input	wire			clock, frame, reset,
		input	wire	[11:0]	cfg_data,
		input	wire	[1:0]	uwt_flag,
		input	wire	[11:0]	uwt_data,
		output	wire			amp_good,
		output	wire	[11:0]	amp_data
	);

	reg				state_reg, state_next;
	reg		[11:0]	minimum_reg, minimum_next;
	reg				amp_good_reg, amp_good_next;
	reg		[11:0]	amp_data_reg, amp_data_next;
	reg		[11:0]	uwt_data_reg, uwt_data_next;

	always @(posedge clock)
	begin
		if (reset)
		begin
			state_reg <= 1'b0;
			minimum_reg <= 12'd0;
			amp_good_reg <= 1'b0;
			amp_data_reg <= 12'd0;
			uwt_data_reg <= 12'd0;
		end
		else
		begin
			state_reg <= state_next;
			minimum_reg <= minimum_next;
			amp_good_reg <= amp_good_next;
			amp_data_reg <= amp_data_next;
			uwt_data_reg <= uwt_data_next;
		end
	end
	
	always @*
	begin
		state_next = state_reg;
		minimum_next = minimum_reg;
		amp_good_next = amp_good_reg;
		amp_data_next = amp_data_reg;
		uwt_data_next = uwt_data_reg;
		
		case (state_reg)
			0:
			begin
				if (frame)
				begin
					uwt_data_next = uwt_data;
					amp_good_next = 1'b0;
					// minimum
					if (uwt_flag[0])
					begin
						minimum_next = uwt_data_reg;
					end
					else if ((uwt_flag[1]) & (uwt_data > minimum_reg))
					begin
						amp_data_next = uwt_data - minimum_reg;
						state_next = 1'b1;
					end
                end
 			end
			
			1:
			begin
				amp_good_next = (amp_data_reg >= cfg_data);
				state_next = 1'b0;
 			end

		endcase
	end

	assign amp_good = amp_good_reg;
	assign amp_data = amp_data_reg;

endmodule
