module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire			I2C_SDA,
		inout	wire			I2C_SCL,
		inout	wire	[4:0]	CON_A,
		input	wire	[15:0]	CON_B,
		input	wire	[12:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire	[2:0]	ADC_D,

		output	wire			USB_SLRD, 
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA, // EMPTY flag for EP6
		input	wire			USB_FLAGB, // FULL flag for EP8
		input	wire			USB_FLAGC,
		inout	wire			USB_PA0,
		inout	wire			USB_PA1,
		output	wire			USB_PA2,
		inout	wire			USB_PA3,
		output	wire			USB_PA4,
		output	wire			USB_PA5,
		output	wire			USB_PA6,
		inout	wire			USB_PA7,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_CE1,
		output	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);

	localparam	N		=	3;

	//	Turn output ports off
/*
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;
*/
	assign	RAM_CLK = sys_clock;
	assign	RAM_CE1 = 1'b0;

	//	Turn inout ports to tri-state
	assign	TRG			=	4'bz;
	assign	CON_A		=	5'bz;
	assign	USB_PA0		=	1'bz;
	assign	USB_PA1		=	1'bz;
	assign	USB_PA3		=	1'bz;
	assign	USB_PA7		=	1'bz;
//	assign	RAM_DQAP	=	1'bz;
//	assign	RAM_DQA		=	8'bz;
//	assign	RAM_DQBP	=	1'bz;
//	assign	RAM_DQB		=	8'bz;

	assign	USB_PA2		=	~usb_rden;
	assign	USB_PA4		=	usb_addr[0];
	assign	USB_PA5		=	usb_addr[1];
	assign	USB_PA6		=	~usb_pktend;

	wire			usb_wrreq, usb_rdreq, usb_rden, usb_pktend;
	wire			usb_tx_wrreq, usb_rx_rdreq;
	wire			usb_tx_full, usb_rx_empty;
	wire	[7:0]	usb_tx_data, usb_rx_data;
	wire	[1:0]	usb_addr;

	assign	USB_SLRD = ~usb_rdreq;
	assign	USB_SLWR = ~usb_wrreq;

	usb_fifo usb_unit
	(
		.usb_clk(USB_IFCLK),
		.usb_data(USB_PB),
		.usb_full(~USB_FLAGB),
		.usb_empty(~USB_FLAGA),
		.usb_wrreq(usb_wrreq),
		.usb_rdreq(usb_rdreq),
		.usb_rden(usb_rden),
		.usb_pktend(usb_pktend),
		.usb_addr(usb_addr),

		.clk(sys_clock),

		.tx_full(usb_tx_full),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),

		.rx_empty(usb_rx_empty),
		.rx_rdreq(usb_rx_rdreq),
		.rx_q(usb_rx_data)
	);
		
	wire			ana_good [N-1:0];
	wire	[11:0]	ana_data [N-1:0];
	wire	[11:0]	ana_base [N-1:0];

	wire	[11:0]	osc_mux_data [N-1:0];

	wire	[11:0]	trg_mux_data;
	wire			trg_flag;

	wire	[83:0]	int_mux_data [N-1:0];

	wire			sys_clock, sys_frame;

	wire 	[11:0]	adc_data [N-1:0];
    wire	[11:0]	int_data [N-1:0];
    wire	[11:0]	cmp_data;
	wire	[11:0]	nowhere;

	wire 	[31:0]	uwt_d1 [N-1:0];
	wire 	[31:0]	uwt_a1 [N-1:0];
	wire 	[31:0]	uwt_peak1 [N-1:0];
	wire 	[31:0]	uwt_d2 [N-1:0];
	wire 	[31:0]	uwt_a2 [N-1:0];
	wire 	[31:0]	uwt_peak2 [N-1:0];
	wire 	[31:0]	uwt_d3 [N-1:0];
	wire 	[31:0]	uwt_a3 [N-1:0];
	wire 	[31:0]	uwt_peak3 [N-1:0];

	wire 	[1:0]	uwt_flag1 [N-1:0];
	wire 	[1:0]	uwt_flag2 [N-1:0];
	wire 	[1:0]	uwt_flag3 [N-1:0];
	
	wire			i2c_reset;

/*
	adc_para adc_para_unit (
		.lvds_dco(ADC_DCO),
		.lvds_fco(ADC_FCO),
		.para_good(CON_CCLK[0]),
 		.para_data(CON_C[11:0]),
		.adc_data(adc_data[2]));
*/
/* 
	wire			adc_pll_clk;

	adc_pll adc_pll_unit(
		.inclk0(ADC_FCO),
		.c0(adc_pll_clk));
*/

	test test_unit(
		.clk(ADC_FCO),
//		.data(adc_data[2]));
		.data(nowhere));

	adc_lvds #(
		.size(3),
		.width(12)) adc_lvds_unit (
		.lvds_dco(ADC_DCO),
//		.lvds_dco(adc_pll_clk),
		.lvds_fco(ADC_FCO),
		.lvds_d(ADC_D[2:0]),
		.adc_data({	adc_data[2],
//		.adc_data({	nowhere,
					adc_data[1],
					adc_data[0] }));
					
	assign			cmp_data = CON_B[11:0];
	assign			sys_clock = ADC_DCO;
	assign			sys_frame = ADC_FCO;

	wire	[15:0]	cfg_bits [15:0];
	wire	[255:0]	int_cfg_bits;

	wire	[31:0]	cfg_mux_selector;

	wire 			cfg_reset;

	wire 	[7:0]	bus_ssel;
	wire			bus_wren;
	wire	[31:0]	bus_addr;
	wire	[15:0]	bus_mosi;
	wire 	[15:0]	bus_miso [5:0];
	wire 	[5:0]	bus_busy;

	wire 	[15:0]	mrg_bus_miso;
	wire 			mrg_bus_busy;

	wire 	[79:0]	int_bus_miso;

	genvar j;

	generate
		for (j = 0; j < 16; j = j + 1)
		begin : CONFIGURATION_OUTPUT
			assign cfg_bits[j] = int_cfg_bits[j*16+15:j*16];
		end
	endgenerate

	configuration configuration_unit (
		.clock(sys_clock),
		.reset(cfg_reset),
		.bus_ssel(bus_ssel[0]),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr[3:0]),
		.bus_mosi(bus_mosi),
		.bus_miso(bus_miso[0]),
		.bus_busy(bus_busy[0]),
		.cfg_bits(int_cfg_bits));

	generate
		for (j = 0; j < 3; j = j + 1)
		begin : MUX_DATA
			assign int_mux_data[j] = {
				{ana_good[j], 11'd0},
				ana_data[j],
				ana_base[j],
				uwt_a3[j][20:9],
				uwt_a2[j][17:6],
				uwt_a1[j][14:3],
				adc_data[j]};
		end
	endgenerate

	assign cfg_mux_selector = {cfg_bits[11], cfg_bits[10]};

	lpm_mux #(
		.lpm_size(21),
		.lpm_type("LPM_MUX"),
		.lpm_width(12),
		.lpm_widths(5)) trg_mux_unit (
		.sel(cfg_mux_selector[28:24]),
		.data({int_mux_data[2], int_mux_data[1], int_mux_data[0]}),
		.result(trg_mux_data));

	generate
		for (j = 0; j < 3; j = j + 1)
		begin : OSC_CHAIN
		
			lpm_mux #(
				.lpm_size(21),
				.lpm_type("LPM_MUX"),
				.lpm_width(12),
				.lpm_widths(5)) osc_mux_unit (
				.sel(cfg_mux_selector[j*8+4:j*8]),
				.data({int_mux_data[2], int_mux_data[1], int_mux_data[0]}),
				.result(osc_mux_data[j]));
		
		end
	endgenerate

	trigger trigger_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(cfg_bits[12][14]),
		.cfg_data(cfg_bits[12][11:0]),
		.trg_data(trg_mux_data),
		.trg_flag(trg_flag));
	
	oscilloscope oscilloscope_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(cfg_bits[12][13]),
		.cfg_data({cfg_bits[12][12], cfg_bits[13]}),
		.trg_flag(trg_flag),
		.osc_data({cmp_data, osc_mux_data[2], osc_mux_data[1], osc_mux_data[0]}),
		.ram_wren(RAM_WE),
		.ram_addr(RAM_ADDR),
		.ram_data({RAM_DQA, RAM_DQAP, RAM_DQB, RAM_DQBP}),
		.bus_ssel(bus_ssel[1]),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr[19:0]),
		.bus_mosi(bus_mosi),
		.bus_miso(bus_miso[1]),
		.bus_busy(bus_busy[1]));

	generate
		for (j = 0; j < 3; j = j + 1)
		begin : MCA_CHAIN

			assign int_data[j] = (cfg_bits[0][4*j]) ? (adc_data[j] ^ 12'hfff) : (adc_data[j]);

			uwt_bior31 #(.L(1)) uwt_1_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
				.x({20'h00000, int_data[j]}),
				.d(uwt_d1[j]),
				.a(uwt_a1[j]),
				.peak(uwt_peak1[j]),
				.flag(uwt_flag1[j]));
		
			uwt_bior31 #(.L(2)) uwt_2_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
				.x(uwt_a1[j]),
				.d(uwt_d2[j]),
				.a(uwt_a2[j]),
				.peak(uwt_peak2[j]),
				.flag(uwt_flag2[j]));
		
			uwt_bior31 #(.L(3)) uwt_3_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
				.x(uwt_a2[j]),
				.d(uwt_d3[j]),
				.a(uwt_a3[j]),
				.peak(uwt_peak3[j]),
				.flag(uwt_flag3[j]));
	
			analyser analyser_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(cfg_bits[2+2*j][12]),
				.cfg_data({cfg_bits[2+2*j][11:0], cfg_bits[1+2*j][12:0]}),
				.uwt_flag(uwt_flag3[j]),
				.uwt_data(uwt_peak3[j]),
				.ana_good(ana_good[j]),
				.ana_data(ana_data[j]),
				.ana_base(ana_base[j]));

			histogram histogram_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(cfg_bits[7+j][13]),
				.cfg_data(cfg_bits[7+j][12:0]),
				.hst_good(ana_good[j]),
				.hst_data(ana_data[j]),
				.bus_ssel(bus_ssel[2+j]),
				.bus_wren(bus_wren),
				.bus_addr(bus_addr[12:0]),
				.bus_mosi(bus_mosi),
				.bus_miso(bus_miso[2+j]),
				.bus_busy(bus_busy[2+j]));

		end
	endgenerate

	i2c_fifo i2c_unit(
		.clock(sys_clock),
		.reset(i2c_reset),
/*
		normal connection
		.i2c_sda(I2C_SDA),
		.i2c_scl(I2C_SCL),

		following is a cross wire connection for EPT
*/
		.i2c_sda(I2C_SCL),
		.i2c_scl(I2C_SDA),
		
		.bus_ssel(bus_ssel[5]),
		.bus_wren(bus_wren),
		.bus_mosi(bus_mosi),
		.bus_busy(bus_busy[5]));

	generate
		for (j = 0; j < 5; j = j + 1)
		begin : BUS_OUTPUT
			assign int_bus_miso[j*16+15:j*16] = bus_miso[j];
		end
	endgenerate

	lpm_mux #(
		.lpm_size(5),
		.lpm_type("LPM_MUX"),
		.lpm_width(16),
		.lpm_widths(3)) bus_miso_mux_unit (
		.sel(bus_addr[30:28]),
		.data(int_bus_miso),
		.result(mrg_bus_miso));

	lpm_mux #(
		.lpm_size(6),
		.lpm_type("LPM_MUX"),
		.lpm_width(1),
		.lpm_widths(3)) bus_busy_mux_unit (
		.sel(bus_addr[30:28]),
		.data(bus_busy),
		.result(mrg_bus_busy));

/*
	lpm_or #(
		.lpm_size(6),
		.lpm_type("LPM_OR"),
		.lpm_width(16)) bus_miso_or_unit (
		.data(int_bus_miso),
		.result(mrg_bus_miso));
*/

	lpm_decode #(
		.lpm_decodes(8),
		.lpm_type("LPM_DECODE"),
		.lpm_width(3)) lpm_decode_unit (
		.data(bus_addr[30:28]),
		.eq(bus_ssel),
		.aclr(),
		.clken(),
		.clock(),
		.enable());

	control control_unit (
		.clock(sys_clock),
		.rx_empty(usb_rx_empty),
		.tx_full(usb_tx_full),
		.rx_data(usb_rx_data),
		.rx_rdreq(usb_rx_rdreq),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr),
		.bus_mosi(bus_mosi),
		.bus_miso(mrg_bus_miso),
		.bus_busy(mrg_bus_busy),
		.led(LED));

/*
	altserial_flash_loader #(
		.enable_shared_access("OFF"),
		.enhanced_mode(1),
		.intended_device_family("Cyclone III")) sfl_unit (
		.noe(1'b0),
		.asmi_access_granted(),
		.asmi_access_request(),
		.data0out(),
		.dclkin(),
		.scein(),
		.sdoin());
*/

endmodule
