module suppression
	(
		input	wire			clk,
		input	wire	[11:0]	data,
		input	wire	[11:0]	baseline,
		
		output	wire	[11:0]	result
	);

	reg		[11:0]	result_int;

	always @(posedge clk)
	begin
		if (data > baseline)
		begin
			result_int <= data - baseline;
		end
		else
		begin
			result_int <= 12'd0;
		end
	end

	assign	result = result_int;
endmodule
