module analyser
	(
		input	wire			clk, reset,
		input	wire			data_ready,
		input	wire	[1:0]	uwt_flag,
		output	wire			peak_ready
	);

	reg				flag_reg, flag_next;
	reg		[1:0]	state_reg, state_next;
	reg		[4:0]	counter_reg, counter_next;
	reg				peak_ready_reg;

	wire			counter_max = (&counter_reg);
	wire			peak_ready_int = (flag_reg & data_ready & uwt_flag[0] & counter_max);

	always @(posedge clk)
	begin
		if (reset)
		begin
			flag_reg <= 1'b0;
			state_reg <= 2'd0;
			counter_reg <= 5'd0;
		end
		else
		begin
			flag_reg <= flag_next;
			state_reg <= state_next;
			counter_reg <= counter_next;
		end
	end
	
	always @*
	begin
		flag_next = flag_reg;
		state_next = state_reg;
		counter_next = counter_reg;
		case (state_reg)
			0: // skip first 16 samples
			begin
				flag_next = 1'b0;
				if (data_ready)
				begin
					counter_next = counter_reg + 5'd1;
					if (counter_max)
					begin
						state_next = 2'd1;
					end
                end
 			end

			1: // skip first 16 minima
			begin
				flag_next = 1'b0;
				if (data_ready & uwt_flag[1])
				begin
					counter_next = counter_reg + 5'd1;
					if (counter_max)
					begin
						state_next = 2'd2;
					end
                end
			end

			2:
			begin
				flag_next = 1'b1;
				if (data_ready)
				begin
					if (~counter_max)
					begin
						counter_next = counter_reg + 5'd1;
					end
					if (peak_ready_int)
					begin
						counter_next = 5'd0;
					end
                end
			end

			default:
			begin
				flag_next = 1'b0;
				state_next = 2'd0;
				counter_next = 5'd0;
			end
		endcase
	end

	assign	peak_ready = peak_ready_int;

endmodule
