module baseline
	(
		input	wire			clk, reset,
		input	wire			data_ready,
		input	wire	[1:0]	uwt_flag,
		input	wire	[11:0]	uwt_data,
		output	wire	[11:0]	baseline
	);

	reg		[15:0]	buffer [15:0];
	wire	[15:0]	sample;

	integer			i;

	assign	sample = {4'd0, uwt_data};
	
	always @(posedge clk)
	begin
		if (reset)
		begin
			for(i = 0; i <= 15; i = i + 1)
			begin
				buffer[i] <= 12'd0;
			end
		end
		else
		begin
			if (data_ready & uwt_flag[1])
			begin
				for(i = 0; i < 15; i = i + 1)
				begin
					buffer[i+1] <= buffer[i] + sample;
				end
				buffer[0] <= sample;
			end
		end
	end

	assign	baseline = buffer[15][15:4];
endmodule
