module trigger
	(
		input	wire			clk, reset,
		input	wire			data_ready,
		input	wire	[11:0]  data, threshold,
		output	wire			trigger
	);
	
	reg				int_trigger;

	always @(posedge clk)
	begin
		if (reset)
        begin
			int_trigger <= 1'b0;
        end
        else if (data_ready)
		begin
			int_trigger <= (data >= threshold);
		end
	end
	
	assign trigger = int_trigger;

endmodule
