module analyser
	(
		input	wire			clk, reset,
		input	wire			data_ready,
		input	wire	[1:0]	uwt_flag,
		output	wire			peak_ready
	);

	reg		[1:0]	state_reg, state_next;
	reg		[3:0]	counter_reg, counter_next;
	reg				peak_ready_reg, peak_ready_next;

	wire			counter_max = (&counter_reg);

	always @(posedge clk)
	begin
		if (reset)
		begin
			state_reg <= 2'd0;
			counter_reg <= 4'd0;
			peak_ready_reg <= 1'b0;
		end
		else
		begin
			state_reg <= state_next;
			counter_reg <= counter_next;
			peak_ready_reg <= peak_ready_next;
		end
	end
	
	always @*
	begin
		state_next = state_reg;
		counter_next = counter_reg;
		peak_ready_next = peak_ready_reg;
		case (state_reg)
			0: // skip first 16 samples
			begin
				peak_ready_next = 1'b0;
				if (data_ready)
				begin
					counter_next = counter_reg + 4'd1;
					if (counter_max)
					begin
						state_next = 2'd1;
					end
                end
 			end

			1: // skip first 16 minima
			begin
				if (data_ready & uwt_flag[1])
				begin
					counter_next = counter_reg + 4'd1;
					if (counter_max)
					begin
						state_next = 2'd2;
					end
                end
			end

			2:
			begin
				if (data_ready & uwt_flag[0] & counter_max)
				begin
					counter_next = 4'd0;
					peak_ready_next = 1'b1;
                end
                else
                begin
					if (~counter_max)
					begin
						counter_next = counter_reg + 4'd1;
					end
					peak_ready_next = 1'b0;
				end
			end

			default:
			begin
				state_next = 2'd0;
				counter_next = 4'd0;
				peak_ready_next = 1'b0;
			end
		endcase
	end

	assign	peak_ready = peak_ready_reg;
endmodule
