module baud_gen
	#(
		parameter	INC=1208,	// counter increment (115200*16*32768/F_clk)
					DIV=1		// divider (baud rate = 115200/D)
	)
	(
		input wire clk, reset,
		output wire max_tick
	);
	
	//signal declaration
	reg [15:0] acc_reg;
	reg [7:0] div_reg;
	 
	wire div_reg_max = (div_reg == (DIV-1));

	// body
	always @(posedge clk, posedge reset)
	begin
		if (reset)
			begin
				acc_reg <= 0;
				div_reg <= 0;
			end
		else
			begin
				acc_reg <= acc_reg[14:0] + INC;
				if (acc_reg[15])
					div_reg <= div_reg_max ? 0 : div_reg + 16'd1;
			end
	end

   // output logic
   assign max_tick = acc_reg[15] & div_reg_max;

endmodule
