module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire	[6:0]	CON_A,
		inout	wire	[15:0]	CON_B,
		inout	wire	[12:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire	[2:0]	ADC_D,

		output	wire			USB_SLRD, 
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA, // EMPTY flag for EP6
		input	wire			USB_FLAGB, // FULL flag for EP8
		input	wire			USB_FLAGC,
		inout	wire			USB_PA0,
		inout	wire			USB_PA1,
		output	wire			USB_PA2,
		inout	wire			USB_PA3,
		output	wire			USB_PA4,
		output	wire			USB_PA5,
		output	wire			USB_PA6,
		inout	wire			USB_PA7,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_CE1,
		output	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);

	//	Turn output ports off
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;

	//	Turn inout ports to tri-state
	assign	TRG			=	4'bz;
	assign	CON_A		=	7'bz;
	assign	CON_B		=	16'bz;
	assign	CON_C		=	13'bz;
	assign	USB_PA0		=	1'bz;
	assign	USB_PA1		=	1'bz;
	assign	USB_PA3		=	1'bz;
	assign	USB_PA7		=	1'bz;
	assign	RAM_DQAP	=	1'bz;
	assign	RAM_DQA		=	8'bz;
	assign	RAM_DQBP	=	1'bz;
	assign	RAM_DQB		=	8'bz;


	assign	USB_PA2		=	~usb_rden;
	assign	USB_PA4		=	usb_addr[0];
	assign	USB_PA5		=	usb_addr[1];
	assign	USB_PA6		=	~usb_pktend;

	reg		[31:0]	counter;	
	reg				led_reg;	
//	assign	LED			=	counter[24];
	assign	LED			=	led_reg;

	wire			usb_wrreq, usb_rdreq, usb_rden, usb_pktend;
	wire			usb_fifo_aclr;
	reg				usb_fifo_tx_wrreq;
	reg				usb_fifo_rx_rdreq;
	wire			usb_fifo_tx_full, usb_fifo_rx_empty;
	reg		[7:0]	usb_fifo_tx_data;
	wire	[7:0]	usb_fifo_rx_data;
	wire	[1:0]	usb_addr;

	assign	USB_SLRD = ~usb_rdreq;
	assign	USB_SLWR = ~usb_wrreq;

	usb_fifo usb_fifo_unit
	(
		.usb_clk(USB_IFCLK),
		.usb_data(USB_PB),
		.usb_full(~USB_FLAGB),
		.usb_empty(~USB_FLAGA),
		.usb_wrreq(usb_wrreq),
		.usb_rdreq(usb_rdreq),
		.usb_rden(usb_rden),
		.usb_pktend(usb_pktend),
		.usb_addr(usb_addr),

		.clk(CLK_50MHz),
		.aclr(usb_fifo_aclr),

		.tx_full(usb_fifo_tx_full),
		.tx_wrreq((~usb_fifo_tx_full) & usb_fifo_tx_wrreq),
		.tx_data(usb_fifo_tx_data),

		.rx_empty(usb_fifo_rx_empty),
		.rx_rdreq((~usb_fifo_rx_empty) & usb_fifo_rx_rdreq),
		.rx_q(usb_fifo_rx_data)
	);
	
	reg		[23:0]	rx_counter;
	reg		[10:0]	tst_counter;	

	reg 			ana_reset [3:0];
	wire			ana_peak_ready [3:0];
	wire	[11:0]	ana_peak [3:0];

	reg		[9:0]	osc_counter;	

	reg 			osc_reset [3:0];
	wire	[9:0]	osc_start_addr [3:0];
	reg 	[9:0]	osc_addr [3:0];
	wire	[15:0]	osc_q [3:0];
	reg		[15:0]	osc_q_mux;

	reg 			hst_reset [3:0];
	reg 	[11:0]	hst_addr [3:0];
	wire	[23:0]	hst_q [3:0];

	reg 			mux_reset, mux_type;
	reg 	[1:0]	mux_chan, mux_byte, mux_max_byte;
	reg 	[15:0]	mux_addr, mux_min_addr, mux_max_addr;
	reg		[7:0]	mux_q;

	reg		[3:0]	state1, state2;
	reg				adc_fifo_aclr;

	wire			adc_clk [3:0];

//	reg 	[11:0]	adc_data;

	wire			adc_data_ready [3:0];
	wire 	[11:0]	adc_data [3:0];

    wire	[11:0]	raw_data [3:0];
    wire	[11:0]	uwt_data [3:0];
    wire	[1:0]	uwt_flag [3:0];
    
    assign	adc_clk[0] = ADC_FCO;
    assign	adc_clk[1] = ADC_FCO;
    assign	adc_clk[2] = ADC_FCO;
    assign	adc_clk[3] = CON_B[0];
    assign	adc_data[3] = CON_B[12:1];
/* 
	pll pll_unit(
		.inclk0(CLK_50MHz),
		.c0(adc_clk));
*/
/*
	altserial_flash_loader #(
		.enable_shared_access("OFF"),
		.enhanced_mode(1),
		.intended_device_family("Cyclone III")) sfl_unit (
		.noe(1'b0),
		.asmi_access_granted(),
		.asmi_access_request(),
		.data0out(),
		.dclkin(),
		.scein(),
		.sdoin());
*/
	adc_lvds adc_lvds_unit (
		.lvds_dco(ADC_DCO),
		.lvds_fco(ADC_FCO),
		.lvds_d(ADC_D),
		.adc_db(adc_data[0]),
		.adc_dc(adc_data[1]),
		.adc_dd(adc_data[2]));
 
	genvar i;
	generate
		for (i = 0; i < 4; i = i + 1)
		begin : MCA_CHAIN
			adc_fifo adc_fifo_unit (
				.adc_clk(adc_clk[i]),
				.adc_data(adc_data[i]),
				.aclr(adc_fifo_aclr),
				.rdclk(CLK_50MHz),
				.ready(adc_data_ready[i]),
				.raw_data(raw_data[i]),
				.uwt_data({uwt_flag[i], uwt_data[i]}));
	
			analyser analyser_unit (
				.clk(CLK_50MHz),
				.reset(ana_reset[i]),
				.data_ready(adc_data_ready[i]),
				.uwt_flag(uwt_flag[i]),
				.uwt_data(uwt_data[i]),
				.peak_ready(ana_peak_ready[i]),
				.peak(ana_peak[i]));
/*
			histogram histogram_unit (
				.clk(CLK_50MHz),
				.reset(hst_reset[i]),
				.data_ready(adc_data_ready[i]),
				.data(raw_data[i]),
				.address(hst_addr[i]),
				.q(hst_q[i]));
*/
			histogram histogram_unit (
				.clk(CLK_50MHz),
				.reset(hst_reset[i]),
				.data_ready(ana_peak_ready[i]),
				.data(ana_peak[i]),
				.address(hst_addr[i]),
				.q(hst_q[i]));
			
			oscilloscope oscilloscope_unit (
				.clk(CLK_50MHz),
				.reset(osc_reset[i]),
				.data_ready(adc_data_ready[i]),
				.raw_data(raw_data[i]),
				.uwt_data(uwt_data[i]),
				.threshold(16'd100),
				.address(osc_addr[i]),
				.start_address(osc_start_addr[i]),
				.q(osc_q[i]));
		end
	endgenerate

/*
	always @ (posedge adc_clk)
	begin
		counter <= counter + 32'd1;
	end
*/

	integer j;

	always @*
	begin
		for (j = 0; j < 4; j = j + 1)
		begin
			osc_reset[j] = 1'b0;
			osc_addr[j] = 10'b0;
			hst_reset[j] = 1'b0;
			hst_addr[j] = 12'b0;
		end

		case({mux_type,mux_chan})
			3'b000, 3'b001, 3'b010, 3'b011:
			begin
				osc_reset[mux_chan] = mux_reset;
				osc_addr[mux_chan] = mux_addr[9:0];
				mux_max_byte = 2'd1;	
				mux_min_addr = {6'd0, osc_start_addr[mux_chan]};
				mux_max_addr = {6'd0, osc_start_addr[mux_chan]} + 16'd1023;
			end

			3'b100, 3'b101, 3'b110, 3'b111:
			begin
				hst_reset[mux_chan] = mux_reset;
				hst_addr[mux_chan] = mux_addr[11:0];
				mux_max_byte = 2'd2;	
				mux_min_addr = 16'd0;
				mux_max_addr = 16'd4095;
			end
		endcase
	end
	
	always @*
	begin
		case ({mux_type,mux_byte})
			5'b000: mux_q = osc_q[mux_chan][7:0];
			5'b001: mux_q = osc_q[mux_chan][15:8];

			5'b100: mux_q = hst_q[mux_chan][7:0];
			5'b101: mux_q = hst_q[mux_chan][15:8];
			5'b110: mux_q = hst_q[mux_chan][23:16];

			default: mux_q = 8'd0;
		endcase     
	end


	always @(posedge CLK_50MHz)
	begin
		if (~usb_fifo_rx_empty)
		begin
			led_reg <= 1'b0;
			rx_counter <= 24'd0;
		end
		else
		begin
			if (&rx_counter)
			begin
				led_reg <= 1'b1;
			end
			else
			begin
				rx_counter <= rx_counter + 24'd1;
			end
		end

		case(state1)
			1:
			begin
				usb_fifo_rx_rdreq <= 1'b1;
				usb_fifo_tx_wrreq <= 1'b0;
				mux_type <= 1'b0;
				mux_chan <= 2'd0;
				mux_byte <= 2'd0;	
				mux_reset <= 1'b0;
				state1 <= 4'd2;
			end

			2: 
			begin
				if (~usb_fifo_rx_empty)
				begin
					case (usb_fifo_rx_data)
						8'h40, 8'h41, 8'h42, 8'h43, 8'h50, 8'h51, 8'h52, 8'h53:
						begin
							usb_fifo_rx_rdreq <= 1'b0;
							mux_type <= usb_fifo_rx_data[4];
							mux_chan <= usb_fifo_rx_data[1:0];
							mux_reset <= 1'b1;
							state1 <= 4'd1;
						end

						8'h60, 8'h61, 8'h62, 8'h63, 8'h70, 8'h71, 8'h72, 8'h73:
						begin
							usb_fifo_rx_rdreq <= 1'b0;
							mux_type <= usb_fifo_rx_data[4];
							mux_chan <= usb_fifo_rx_data[1:0];
							state1 <= 4'd3;
						end

						8'h30:
						begin
							usb_fifo_rx_rdreq <= 1'b0;
							state1 <= 4'd1;
						end

						8'h31:
						begin
							usb_fifo_rx_rdreq <= 1'b0;
							tst_counter <= 11'd0;	
							state1 <= 4'd9;
						end
					endcase
				end
			end
			// mux transfer
			3:
			begin
				mux_addr <= mux_min_addr;
				mux_byte <= 2'd0;	
				state1 <= 4'd4;
			end
			4:
			begin
				usb_fifo_tx_data <= mux_q;
				usb_fifo_tx_wrreq <= 1'b1;
				mux_byte <= 2'd1;
				state1 <= 4'd5;
			end
			5:
			begin
				if (~usb_fifo_tx_full)
				begin
					usb_fifo_tx_data <= mux_q;
					if ((mux_byte == mux_max_byte) && (mux_addr == mux_max_addr))
					begin
						state1 <= 4'd6;
					end
					else
					begin
						if (mux_byte == mux_max_byte)
						begin
							mux_addr <= mux_addr + 16'd1;
							mux_byte <= 2'd0;
						end
						else
						begin
							mux_byte <= mux_byte + 2'd1;
						end
					end
				end
			end
			6:
			begin
				if (~usb_fifo_tx_full)
				begin
					usb_fifo_tx_wrreq <= 1'b0;
					state1 <= 4'd1;
				end
			end
			// tst transfer
			7:
			begin
				usb_fifo_tx_data <= tst_counter;
				usb_fifo_tx_wrreq <= 1'b1;
				tst_counter <= tst_counter + 11'd1;
				state1 <= 4'd8;
			end
			8:
			begin
				if (~usb_fifo_tx_full)
				begin
					usb_fifo_tx_data <= tst_counter;
					if (tst_counter == 11'd0) //(&osc_counter)
					begin
						state1 <= 4'd9;
					end
					else
					begin
						tst_counter <= tst_counter + 11'd1;
					end
				end
			end
			9:
			begin
				if (~usb_fifo_tx_full)
				begin
					usb_fifo_tx_wrreq <= 1'b0;
					state1 <= 4'd1;
				end
			end
						
			default:
			begin
				state1 <= 4'd1;
			end
		endcase
	end
/*
	always @ (posedge adc_clk)
	begin
		case (state2)
			1: 
			begin
				adc_data <= 12'd0;
				state2 <= 4'd2;
			end
			
			2:
			begin
				adc_data <= 12'd1024;
				state2 <= 4'd3;
			end

			3:
			begin
				adc_data <= 12'd2048;
				state2 <= 4'd4;
			end

			4:
			begin
				adc_data <= 12'd3072;
				state2 <= 4'd5;
			end

			5:
			begin
				adc_data <= 12'd4095;
				state2 <= 4'd1;
			end

			default:
			begin
				state2 <= 4'd1;
			end
		endcase
	end
*/
endmodule