module adc_lvds
	(
		input	wire			lvds_dco,
		input	wire			lvds_fco,
 		input	wire	[2:0]	lvds_d,

		output	wire			adc_clk,
		output	wire	[11:0]	adc_db,
		output	wire	[11:0]	adc_dc,
		output	wire	[11:0]	adc_dd
	);


	wire 	[2:0]	int_data_h, int_data_l;
	reg 	[11:0]	int_data_sr [2:0];
	reg 	[11:0]	int_data [2:0];
	reg				int_fco;

	integer			i;

	altddio_in #(
		.intended_device_family("Cyclone III"),
		.invert_input_clocks("OFF"),
		.lpm_type("altddio_in"),
		.width(3)) altddio_in_unit (
		.datain(lvds_d),
		.inclock(lvds_dco),
		.aclr(1'b0),
		.dataout_h(int_data_h),
		.dataout_l(int_data_l),
		.aset(1'b0),
		.inclocken(1'b1),
		.sclr(1'b0),
		.sset(1'b0));

	always @ (posedge lvds_dco)
	begin
		for(i = 0; i < 3; i = i + 1)
		begin
			int_data_sr[i] <= {int_data_sr[i][9:0], int_data_h[i], int_data_l[i]};
		end

		// one clock delay for FCO
		int_fco <= lvds_fco;
		
		if((lvds_fco) & (~int_fco))
		begin
			for(i = 0; i < 3; i = i + 1)
			begin
				int_data[i] <= {int_data_sr[i][9:0], int_data_h[i], int_data_l[i]};
			end
		end
	end

	assign	adc_clk = int_fco;
	assign	adc_db = int_data[0];
	assign	adc_dc = int_data[1];
	assign	adc_dd = int_data[2];

endmodule