module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire	[6:0]	CON_A,
		inout	wire	[15:0]	CON_B,
		inout	wire	[12:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire			ADC_DB,
		input	wire			ADC_DC,
		input	wire			ADC_DD,

		output	wire			USB_SLRD, 
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA, // EMPTY flag for EP6
		input	wire			USB_FLAGB, // FULL flag for EP8
		input	wire			USB_FLAGC,
		inout	wire			USB_PA0,
		inout	wire			USB_PA1,
		output	wire			USB_PA2,
		inout	wire			USB_PA3,
		output	wire			USB_PA4,
		output	wire			USB_PA5,
		output	wire			USB_PA6,
		inout	wire			USB_PA7,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_CE1,
		output	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);

	//	Turn output ports off
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;

	//	Turn inout ports to tri-state
	assign	TRG			=	4'bz;
	assign	CON_A		=	7'bz;
	assign	CON_B		=	16'bz;
	assign	CON_C		=	13'bz;
	assign	USB_PA0		=	1'bz;
	assign	USB_PA1		=	1'bz;
	assign	USB_PA3		=	1'bz;
	assign	USB_PA7		=	1'bz;
	assign	RAM_DQAP	=	1'bz;
	assign	RAM_DQA		=	8'bz;
	assign	RAM_DQBP	=	1'bz;
	assign	RAM_DQB		=	8'bz;


	assign	USB_PA2		=	~usb_rden;
	assign	USB_PA4		=	usb_addr[0];
	assign	USB_PA5		=	usb_addr[1];
	assign	USB_PA6		=	~usb_pktend;

	reg		[31:0]	counter;	
//	assign	LED			=	counter[24];
	assign	LED			=	usb_fifo_rx_empty;

	wire			usb_wrreq, usb_rdreq, usb_rden, usb_pktend;
	wire			usb_fifo_aclr, usb_fifo_led;
	reg				usb_fifo_tx_wrreq;
	reg				usb_fifo_rx_rdreq;
	wire			usb_fifo_tx_full, usb_fifo_rx_empty;
	reg		[7:0]	usb_fifo_tx_data;
	wire	[7:0]	usb_fifo_rx_data;
	wire	[1:0]	usb_addr;

	assign	USB_SLRD = ~usb_rdreq;
	assign	USB_SLWR = ~usb_wrreq;

	usb_fifo usb_fifo_unit
	(
		.usb_clk(USB_IFCLK),
		.usb_data(USB_PB),
		.usb_full(~USB_FLAGB),
		.usb_empty(~USB_FLAGA),
		.usb_wrreq(usb_wrreq),
		.usb_rdreq(usb_rdreq),
		.usb_rden(usb_rden),
		.usb_pktend(usb_pktend),
		.usb_addr(usb_addr),
		.clk(CLK_50MHz),
		.aclr(usb_fifo_aclr),
		.tx_wrreq(usb_fifo_tx_wrreq),
		.rx_rdreq(usb_fifo_rx_rdreq),
		.tx_data(usb_fifo_tx_data),
		.tx_full(usb_fifo_tx_full),
		.rx_empty(usb_fifo_rx_empty),
//		.led(usb_fifo_led),
		.rx_data(usb_fifo_rx_data)
	);
	
	reg		[9:0]	osc_counter;	
	reg 			osc_reset;
	reg 			osc_byte_num;
	wire	[9:0]	osc_start_addr;
	reg 	[9:0]	osc_addr;
	wire	[15:0]	osc_q;

	reg 			hst_reset;
	reg 	[1:0]	hst_byte_num;
	reg 	[11:0]	hst_addr;
	wire	[31:0]	hst_q;

	reg		[2:0]	state0, state1, state2;
	reg				adc_fifo_rdreq;
	wire			adc_fifo_rdempty;
	reg				adc_fifo_aclr;

	reg		[31:0]	adc_counter;
	reg				adc_data_ready;
	wire			adc_clk;
	reg 	[11:0]	adc_data;
    wire	[11:0]	raw_data;
    wire	[11:0]	uwt_data;
    wire	[1:0]	uwt_flag;
 
	pll pll_unit(
		.inclk0(CLK_50MHz),
		.c0(adc_clk));

	adc_fifo adc_fifo_unit (
		.adc_clk(adc_clk),
		.adc_data(adc_data),
		.aclr(adc_fifo_aclr),
		.rdclk(CLK_50MHz),
		.rdreq(adc_fifo_rdreq),
		.rdempty(adc_fifo_rdempty),
		.raw_data(raw_data),
		.uwt_data({uwt_flag, uwt_data}));

	histogram histogram_unit (
		.clk(CLK_50MHz),
		.reset(hst_reset),
		.data_ready(adc_data_ready),
		.data(raw_data),
		.address(hst_addr),
		.q(hst_q)
	);
	
	oscilloscope oscilloscope_unit (
		.clk(CLK_50MHz),
		.reset(osc_reset),
		.data_ready(adc_data_ready),
		.raw_data(raw_data),
		.uwt_data(uwt_data),
		.threshold(16'd100),
		.address(osc_addr),
		.start_address(osc_start_addr),
		.q(osc_q)
	);

/*
	always @ (posedge adc_clk)
	begin
		counter <= counter + 32'd1;
	end
*/

	always @ (posedge CLK_50MHz)
	begin
		case (state0)
			1:
			begin
				if (~adc_fifo_rdempty)
				begin
//					adc_counter <= adc_counter + 32'd1;
					adc_fifo_rdreq <= 1'b1;
					adc_data_ready <= 1'b1;
					state0 <= 3'd2;
				end
			end

			2:
			begin
				adc_fifo_rdreq <= 1'b0;
				adc_data_ready <= 1'b0;
				state0 <= 3'd1;
			end

			default:
			begin
				state0 <= 3'd1;
			end
		endcase
	end

	always @(posedge CLK_50MHz)
	begin
		case (state1)
			1:
			begin
				usb_fifo_rx_rdreq <= 1'b0;
				usb_fifo_tx_wrreq <= 1'b0;
				hst_reset <= 1'b0;
				osc_reset <= 1'b0;
				state1 <= 3'd2;
			end

			2: 
			begin
				if (~usb_fifo_rx_empty)
				begin
					usb_fifo_rx_rdreq <= 1'b1;
					case (usb_fifo_rx_data)
						8'h30:
						begin
							hst_reset <= 1'b1;
							state1 <= 3'd1;
						end
						8'h31:
						begin
							hst_addr <= 12'd0;
							hst_byte_num <= 2'd0;	
							state1 <= 3'd3;
						end
						8'h32:
						begin
							osc_reset <= 1'b1;
							state1 <= 3'd1;
						end
						8'h33:
						begin
							osc_addr <= osc_start_addr;
							osc_counter <= 10'd0;
							osc_byte_num <= 1'd0;	
							state1 <= 3'd4;
						end
					endcase
				end
				else
				begin
					usb_fifo_rx_rdreq <= 1'b0;
				end				
			end

			3:
			begin
				// hst transfer
				if (~usb_fifo_tx_full)
				begin
					usb_fifo_tx_wrreq <= 1'b1;

					case (hst_byte_num)
						2'd0: usb_fifo_tx_data <= hst_q[7:0];
						2'd1: usb_fifo_tx_data <= hst_q[15:8];
						2'd2: usb_fifo_tx_data <= hst_q[23:16];
						2'd3: usb_fifo_tx_data <= hst_q[31:24];
					endcase
					
					if (&hst_byte_num)
					begin
						hst_byte_num <= 2'd0;				
						if (&hst_addr)
						begin
							state1 <= 3'd1;
						end
						else
						begin
							hst_addr <= hst_addr + 12'd1;
						end
					end
					else
					begin
						hst_byte_num <= hst_byte_num + 2'd1;				
					end				
				end
				else
				begin
					usb_fifo_tx_wrreq <= 1'b0;
				end
			end

			4:
			begin
				// osc transfer
				if(~usb_fifo_tx_full)
				begin
					usb_fifo_tx_wrreq <= 1'b1;

					case (osc_byte_num)
						1'd0: usb_fifo_tx_data <= osc_q[7:0];
						1'd1: usb_fifo_tx_data <= osc_q[15:8];
					endcase
	
					if (osc_byte_num)
					begin
						osc_byte_num <= 1'd0;				
						if (&osc_counter)
						begin
							state1 <= 3'd1;
						end
						else
						begin
							osc_addr <= osc_addr + 10'd1;
							osc_counter <= osc_counter + 10'd1;
						end
					end
					else
					begin
						osc_byte_num <= 1'd1;				
					end										
				end
				else
				begin
					usb_fifo_tx_wrreq <= 1'b0;
				end
			end

			default:
			begin
				// default state is the first one
				state1 <= 3'd1;
			end
		endcase
	end
/*
	always @(posedge CLK_50MHz)
	begin
		case(state1)
			0:
			begin
				usb_fifo_tx_wrreq <= 1'b0;
				counter <= 32'd0;
				state1 <= 3'd1;
			end
			1:
			begin
				if((~usb_fifo_tx_full) & (counter < 32'd512))
				begin
					counter <= counter + 32'd1;
					state1 <= 3'd2;
					usb_fifo_tx_data <= 1;
					usb_fifo_tx_wrreq <= 1'b1;
				end
				else
				begin
					usb_fifo_tx_wrreq <= 1'b0;
				end
			end
				
			2:
			begin
				if((~usb_fifo_tx_full) & (counter < 32'd512))
				begin
					counter <= counter + 32'd1;
					state1 <= 3'd1;
					usb_fifo_tx_data <= 0;
					usb_fifo_tx_wrreq <= 1'b1;
				end
				else
				begin
					usb_fifo_tx_wrreq <= 1'b0;
				end
			end
						
			default: state1 <= 3'd0;
		endcase
	end
*/
	always @ (posedge adc_clk)
	begin
		case (state2)
			1: 
			begin
				adc_data <= 12'd0;
				state2 <= 3'd2;
			end
			
			2:
			begin
				adc_data <= 12'd1024;
				state2 <= 3'd3;
			end

			3:
			begin
				adc_data <= 12'd2048;
				state2 <= 3'd4;
			end

			4:
			begin
				adc_data <= 12'd3072;
				state2 <= 3'd5;
			end

			5:
			begin
				adc_data <= 12'd4095;
				state2 <= 3'd1;
			end

			default:
			begin
				state2 <= 3'd1;
			end
		endcase
	end

endmodule