/* -*- c++ -*- */
/*
 * Copyright 2004,2006 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 *
 *
 * Modified by Matthias P. Braendli
*/

#include "spi.h"
#include "fx2regs.h"
#include "fx2utils.h"

void
init_spi (void)
{
	SPI |= bmSS; /* active low, disable slave */
	bitS_OUT = 0;	/* idle state has CLK = 0 */
}

unsigned char
spi_read (unsigned char header_hi, unsigned char header_lo,
	  unsigned char format, unsigned char address,
	  xdata unsigned char *buf, unsigned char len)
{
	SPI &= ~bmSS; // enable slave select
	
	spi_write_byte_msb(address); // send destination periph address

	switch (format & SPI_FMT_HDR_MASK){
	case SPI_FMT_HDR_0:
		break;
	case SPI_FMT_HDR_1:
		spi_write_byte_msb (header_lo);
		break;
	case SPI_FMT_HDR_2:
		spi_write_byte_msb (header_hi);
		spi_write_byte_msb (header_lo);
		break;
	default:
		return 1;		// error
	}
	if (len != 0)
		spi_read_bytes_msb (buf, len);


	SPI |= bmSS; /* active low, disable slave */

	return 0;		// success
}


unsigned char
spi_write (unsigned char header_hi, unsigned char header_lo,
	   unsigned char format, unsigned char address,
	   const xdata unsigned char *buf, unsigned char len)
{
	SPI &= ~bmSS; // enable slave select

	spi_write_byte_msb(address); // send destination periph address

	switch (format & SPI_FMT_HDR_MASK){
	case SPI_FMT_HDR_0:
		break;
	case SPI_FMT_HDR_1:
		spi_write_byte_msb (header_lo);
		break;
	case SPI_FMT_HDR_2:
		spi_write_byte_msb (header_hi);
		spi_write_byte_msb (header_lo);
		break;
	default:
		SPI |= bmSS; /* active low, disable slave */
		return 1;		// error
	}

	if (len != 0)
		spi_write_bytes_msb (buf, len);

	SPI |= bmSS; /* active low, disable slave */
	return 0;		// success
}

// ----------------------------------------------------------------

void
spi_write_byte_msb (unsigned char v)
{
  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;

  v = (v << 1) | (v >> 7);	// rotate left (MSB into bottom bit)
  bitS_OUT = v & 0x1;
  bitS_CLK = 1;
  bitS_CLK = 0;
}

void
spi_write_bytes_msb (const xdata unsigned char *buf, unsigned char len)
{
  while (len-- != 0){
    spi_write_byte_msb (*buf++);
  }
}

unsigned char
spi_read_byte_msb (void) _naked
{
  _asm
	clr	a

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	setb	_bitS_CLK
        mov	c, _bitS_IN
	rlc	a
	clr	_bitS_CLK

	mov	dpl,a
	ret
  _endasm;
}

void
spi_read_bytes_msb (xdata unsigned char *buf, unsigned char len)
{
  while (len-- != 0){
    *buf++ = spi_read_byte_msb ();
  }
}

