module main
	(
		input	wire			CLK_100MHz,
		output	wire			LED,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire	[5:0]	ADC_D,

		output	wire			USB_SLRD,
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA, // EMPTY flag for EP6
		input	wire			USB_FLAGB, // FULL flag for EP8
		output	wire			USB_PA2,
		output	wire			USB_PA4,
		output	wire			USB_PA6,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_WE,
		output	wire	[21:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);

	localparam	N		=	6;

	//	Turn output ports off
/*
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;
*/

	assign	RAM_CLK = sys_clock;

	assign	USB_PA2		=	~usb_rden;
	assign	USB_PA4		=	usb_addr;
	assign	USB_PA6		=	~usb_pktend;

	wire			usb_wrreq, usb_rdreq, usb_rden, usb_pktend;
	wire			usb_tx_wrreq, usb_rx_rdreq;
	wire			usb_tx_full, usb_rx_empty;
	wire	[7:0]	usb_tx_data, usb_rx_data;
	wire			usb_addr;

	assign	USB_SLRD = ~usb_rdreq;
	assign	USB_SLWR = ~usb_wrreq;

	usb_fifo usb_unit
	(
		.usb_clock(USB_IFCLK),
		.usb_data(USB_PB),
		.usb_full(~USB_FLAGB),
		.usb_empty(~USB_FLAGA),
		.usb_wrreq(usb_wrreq),
		.usb_rdreq(usb_rdreq),
		.usb_rden(usb_rden),
		.usb_pktend(usb_pktend),
		.usb_addr(usb_addr),

		.clock(sys_clock),

		.tx_full(usb_tx_full),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),

		.rx_empty(usb_rx_empty),
		.rx_rdreq(usb_rx_rdreq),
		.rx_q(usb_rx_data)
	);
		
/*
	reg		[31:0]	led_counter;
	always @(posedge CLK_50MHz)
	begin
		led_counter = led_counter + 32'd1;
	end
	assign LED = led_counter[28];
*/	
	wire	[11:0]	osc_mux_data [4:0];

	wire	[11:0]	trg_mux_data;
	wire			trg_flag;

	wire	[6*12-1:0]	int_mux_data [N-1:0];

	wire	[1:0]	amp_flag [3*N-1:0];
	wire	[12:0]	amp_data [3*N-1:0];

	wire			cls_flag;
	wire	[6:0]	cls_data;

	wire	[1:0]	amp_mux_flag [2:0];
	wire	[11:0]	amp_mux_data [2:0];

	wire			cnt_good [3:0];
	wire	[15:0]	cnt_bits_wire;

	wire			sys_clock, sys_frame;

    wire	[11:0]	adc_data [N-1:0];
    wire	[11:0]	sys_data [N-1:0];
	wire	[11:0]	tst_data;

    wire	[3:0]	cmp_data;
    wire	[1:0]	del_data;

	wire	[19:0]	cic_data [N-1:0];

	wire	[11:0]	dec_data [N-1:0];
	wire	[12:0]	clp_data [N-1:0];
	wire	[11:0]	tmp_data;


	wire			i2c_reset;

	assign	tmp_data	=	12'd0;
/*
	assign	sys_clock	=	CLK_100MHz;
*/
	sys_pll sys_pll_unit(
		.inclk0(CLK_100MHz),
		.c0(sys_clock));

/*
	sys_pll sys_pll_unit(
		.inclk0(CLK_100MHz),
		.c0(sys_clock),
		.c1(ADC_DCO),
		.c2(ADC_FCO));

	wire			ADC_DCO, ADC_FCO;


	test test_unit(
		.clock(ADC_FCO),
		.data(tst_data));
*/

	adc_lvds #(
		.size(6),
		.width(12)) adc_lvds_unit (
		.clock(sys_clock),
		.lvds_dco(ADC_DCO),
		.lvds_fco(ADC_FCO),
		.lvds_d(ADC_D),
//		.test(tst_data),
		.adc_frame(sys_frame),
		.adc_data({
			adc_data[5], adc_data[3], adc_data[4],      // D3, D1, D2
			adc_data[2], adc_data[1], adc_data[0]}));   // S2, S1_S, S1_F 

	wire	[15:0]		cfg_bits [63:0];
	wire	[1023:0]	int_cfg_bits;

	wire	[39:0]	cfg_mux_selector;

	wire 			cfg_reset;

	wire 	[2:0]	bus_ssel;
	wire			bus_wren;
	wire	[31:0]	bus_addr;
	wire	[15:0]	bus_mosi;
	wire 	[15:0]	bus_miso [2:0];
	wire 	[2:0]	bus_busy;

	wire 	[15:0]	mrg_bus_miso;
	wire 			mrg_bus_busy;

	wire 	[3*16-1:0]	int_bus_miso;

	genvar j;

	generate
		for (j = 0; j < 64; j = j + 1)
		begin : CONFIGURATION_OUTPUT
			assign cfg_bits[j] = int_cfg_bits[j*16+15:j*16];
		end
	endgenerate

	configuration configuration_unit (
		.clock(sys_clock),
		.reset(cfg_reset),
		.bus_ssel(bus_ssel[0]),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr[5:0]),
		.bus_mosi(bus_mosi),
		.bus_miso(bus_miso[0]),
		.bus_busy(bus_busy[0]),
		.cfg_bits(int_cfg_bits));

	generate
		for (j = 0; j < 6; j = j + 1)
		begin : MUX_DATA
			assign int_mux_data[j] = {
				{4'd0, cls_flag, 7'd0},
				{5'd0, cls_data},
				{4'd0, amp_flag[j][0], 7'd0},
				amp_data[j][11:0],
				clp_data[j][11:0],
				sys_data[j]
				};
		end
	endgenerate

	assign cfg_mux_selector = {cfg_bits[4][7:0], cfg_bits[3], cfg_bits[2]};

	lpm_mux #(
		.lpm_size(6*6),
		.lpm_type("LPM_MUX"),
		.lpm_width(12),
		.lpm_widths(6)) trg_mux_unit (
		.sel(cfg_bits[4][13:8]),
		.data({
			int_mux_data[5], int_mux_data[4], int_mux_data[3],
			int_mux_data[2], int_mux_data[1], int_mux_data[0]}),
		.result(trg_mux_data));

	generate
		for (j = 0; j < 5; j = j + 1)
		begin : OSC_CHAIN
		
			lpm_mux #(
				.lpm_size(6*6),
				.lpm_type("LPM_MUX"),
				.lpm_width(12),
				.lpm_widths(6)) osc_mux_unit (
				.sel(cfg_mux_selector[j*8+5:j*8]),
				.data({
					int_mux_data[5], int_mux_data[4], int_mux_data[3],
					int_mux_data[2], int_mux_data[1], int_mux_data[0]}),
				.result(osc_mux_data[j]));
		end
	endgenerate

	trigger trigger_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(cfg_bits[0][0]),
		.cfg_data(cfg_bits[5][11:0]),
		.trg_data(trg_mux_data),
		.trg_flag(trg_flag));

	oscilloscope oscilloscope_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(cfg_bits[0][1]),
		.cfg_data(cfg_bits[5][12]),
		.trg_flag(trg_flag),
		.osc_data({cmp_data[3:0], osc_mux_data[4], osc_mux_data[3], osc_mux_data[2], osc_mux_data[1], osc_mux_data[0]}),
		.ram_wren(RAM_WE),
		.ram_addr(RAM_ADDR),
		.ram_data({RAM_DQA, RAM_DQAP, RAM_DQB, RAM_DQBP}),
		.bus_ssel(bus_ssel[1]),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr[19:0]),
		.bus_mosi(bus_mosi),
		.bus_miso(bus_miso[1]),
		.bus_busy(bus_busy[1]));

	filter #(.size(6), .width(12)) filter_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(1'b0),
		.inp_data({sys_data[5], sys_data[4], sys_data[3],
			sys_data[2], sys_data[1], sys_data[0]}),
		.out_data({cic_data[5], cic_data[4], cic_data[3],
			cic_data[2], cic_data[1], cic_data[0]}));
/*  
  new_filter #(.size(6), .width(12)) filter_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(1'b0),
		.inp_data({sys_data[5], sys_data[4], sys_data[3],
			sys_data[2], sys_data[1], sys_data[0]}),
		.out_data({cic_data[5], cic_data[4], cic_data[3],
			cic_data[2], cic_data[1], cic_data[0]}));
*/

	generate
		for (j = 0; j < 2; j = j + 1)
		begin : DECONV_CHAIN

			clip #(.shift(21), .width(19), .widthr(13)) clip_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
//				.del_data({6'd0, 6'd32, 6'd32, 6'd32}),
				.del_data({6'd0, cfg_bits[43+6*j][5:0], cfg_bits[41+6*j][5:0], cfg_bits[39+6*j][5:0]}),
				.amp_data({6'd0, 6'd20, 6'd20, 6'd20}),
//				.tau_data({16'd0, 16'd19835, 16'd19835, 16'd19835}),
// exp(-32/1000)*1024*20
				.tau_data({16'd0, cfg_bits[42+6*j], cfg_bits[40+6*j], cfg_bits[38+6*j]}),
				.inp_data({
					19'd0, cic_data[j*3+2][18:0], cic_data[j*3+1][18:0], cic_data[j*3+0][18:0]}),
				.out_data({
					tmp_data, clp_data[j*3+2], clp_data[j*3+1], clp_data[j*3+0]}));

		end
	endgenerate

	generate
		for (j = 0; j < 6; j = j + 1)
		begin : MCA_CHAIN
/*
			shift #(.shift(11), .width(19), .widthr(13)) shift_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
				.amp_data(6'd21),
				.inp_data(cic_data[j][18:0]),
				.out_data(clp_data[j]));    
*/
			assign sys_data[j] = (cfg_bits[1][j]) ? (adc_data[j] ^ 12'hfff) : (adc_data[j]);

			amplitude #(.width(13)) amplitude_unit (
				.clock(sys_clock),
				.frame(sys_frame),
				.reset(1'b0),
//				.min_data(13'd20),
				.min_data(cfg_bits[10+j][12:0]),
				.max_data(13'd4095),
				.inp_data(clp_data[j]),
				.out_flag(amp_flag[j]),
				.out_data(amp_data[j]));
		end
	endgenerate

//  {D3, D2, D1, S2, S1_S, S1_F}
	classifier #(.width(12)) classifier_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(1'b0),
//		.cfg_data({12'd20, 12'd20,
//			12'd20, 12'd20, 12'd20, 12'd20, 12'd2000, 12'd20,
//			12'd20, 12'd2000, 12'd2000, 12'd20, 12'd1000, 12'd1000}),
		.cfg_data({cfg_bits[37][11:0], cfg_bits[36][11:0],
			cfg_bits[35][11:0], cfg_bits[34][11:0], cfg_bits[33][11:0], cfg_bits[32][11:0],
			cfg_bits[31][11:0], cfg_bits[30][11:0], cfg_bits[29][11:0], cfg_bits[28][11:0],
			cfg_bits[27][11:0], cfg_bits[26][11:0], cfg_bits[25][11:0], cfg_bits[24][11:0], 
			cfg_bits[23][11:0], cfg_bits[22][11:0], cfg_bits[21][11:0], cfg_bits[20][11:0],
			cfg_bits[19][11:0], cfg_bits[18][11:0], cfg_bits[17][11:0], cfg_bits[16][11:0]}),
		.inp_data({amp_data[5][11:0], amp_data[4][11:0], amp_data[3][11:0],
			amp_data[2][11:0], amp_data[1][11:0], amp_data[0][11:0]}),
		.inp_flag({amp_flag[5][0], amp_flag[4][0], amp_flag[3][0],
			amp_flag[2][0], amp_flag[1][0], amp_flag[0][0]}),
		.out_flag(cls_flag),
		.out_data(cls_data));
				
	histogram32 histogram32_unit (
		.clock(sys_clock),
		.frame(sys_frame),
		.reset(cfg_bits[0][5]),
		.hst_good(cls_flag & cfg_bits[6][0]),
		.hst_data(cls_data),
		.bus_ssel(bus_ssel[2]),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr[7:0]),
		.bus_mosi(bus_mosi),
		.bus_miso(bus_miso[2]),
		.bus_busy(bus_busy[2]));


	generate
		for (j = 0; j < 3; j = j + 1)
		begin : BUS_OUTPUT
			assign int_bus_miso[j*16+15:j*16] = bus_miso[j];
		end
	endgenerate

	lpm_mux #(
		.lpm_size(3),
		.lpm_type("LPM_MUX"),
		.lpm_width(16),
		.lpm_widths(2)) bus_miso_mux_unit (
		.sel(bus_addr[29:28]),
		.data(int_bus_miso),
		.result(mrg_bus_miso));

	lpm_mux #(
		.lpm_size(3),
		.lpm_type("LPM_MUX"),
		.lpm_width(1),
		.lpm_widths(2)) bus_busy_mux_unit (
		.sel(bus_addr[29:28]),
		.data(bus_busy),
		.result(mrg_bus_busy));

	lpm_decode #(
		.lpm_decodes(3),
		.lpm_type("LPM_DECODE"),
		.lpm_width(2)) lpm_decode_unit (
		.data(bus_addr[29:28]),
		.eq(bus_ssel));


	control control_unit (
		.clock(sys_clock),
		.rx_empty(usb_rx_empty),
		.tx_full(usb_tx_full),
		.rx_data(usb_rx_data),
		.rx_rdreq(usb_rx_rdreq),
		.tx_wrreq(usb_tx_wrreq),
		.tx_data(usb_tx_data),
		.bus_wren(bus_wren),
		.bus_addr(bus_addr),
		.bus_mosi(bus_mosi),
		.bus_miso(mrg_bus_miso),
		.bus_busy(mrg_bus_busy),
		.led(LED));

/*
	altserial_flash_loader #(
		.enable_shared_access("OFF"),
		.enhanced_mode(1),
		.intended_device_family("Cyclone III")) sfl_unit (
		.noe(1'b0),
		.asmi_access_granted(),
		.asmi_access_request(),
		.data0out(),
		.dclkin(),
		.scein(),
		.sdoin());
*/

endmodule
