module trigger
	(
		input	wire			clock, frame, reset,
		input	wire	[11:0]  cfg_data,
		input	wire	[11:0]  trg_data,
		output	wire			trg_flag
	);
	
	reg				trg_flag_reg;
	reg		[11:0]	cfg_data_reg;
	reg		[11:0]	trg_data_reg;

	always @(posedge clock)
	begin
		if (reset)
        begin
			trg_flag_reg <= 1'b0;
        end
        else 
		begin
			if (frame)
			begin
				cfg_data_reg <= cfg_data;
				trg_data_reg <= trg_data;
			end
			trg_flag_reg <= (trg_data_reg >= cfg_data_reg);
		end
	end
	
	assign trg_flag = trg_flag_reg;

endmodule
