module cic_pipeline
	#(
		parameter	width	=	192
	)
	(
		input	wire				clock,
		input	wire	[width-1:0]	data,
		input	wire	[7:0]		rdaddress_a,
		input	wire	[7:0]		rdaddress_b,
		input	wire	[7:0]		wraddress,
		input	wire				wren,
		output	wire	[width-1:0]	qa,
		output	wire	[width-1:0]	qb
	);
	
	altsyncram #(
		.address_aclr_b("NONE"),
		.address_reg_b("CLOCK0"),
		.clock_enable_input_a("BYPASS"),
		.clock_enable_input_b("BYPASS"),
		.clock_enable_output_b("BYPASS"),
		.intended_device_family("Cyclone III"),
		.lpm_type("altsyncram"),
		.numwords_a(256),
		.numwords_b(256),
		.operation_mode("DUAL_PORT"),
		.outdata_aclr_b("NONE"),
		.outdata_reg_b("CLOCK0"),
		.power_up_uninitialized("FALSE"),
		.read_during_write_mode_mixed_ports("DONT_CARE"),
		.widthad_a(8),
		.widthad_b(8),
		.width_a(width),
		.width_b(width),
		.width_byteena_a(1)) ram_unit_a(
		.wren_a(wren),
		.clock0(clock),
		.address_a(wraddress),
		.address_b(rdaddress_a),
		.data_a(data),
		.q_b(qa),
		.aclr0(1'b0),
		.aclr1(1'b0),
		.addressstall_a(1'b0),
		.addressstall_b(1'b0),
		.byteena_a(1'b1),
		.byteena_b(1'b1),
		.clock1(1'b1),
		.clocken0(1'b1),
		.clocken1(1'b1),
		.clocken2(1'b1),
		.clocken3(1'b1),
		.data_b({width{1'b1}}),
		.eccstatus(),
		.q_a(),
		.rden_a(1'b1),
		.rden_b(1'b1),
		.wren_b(1'b0));

	altsyncram #(
		.address_aclr_b("NONE"),
		.address_reg_b("CLOCK0"),
		.clock_enable_input_a("BYPASS"),
		.clock_enable_input_b("BYPASS"),
		.clock_enable_output_b("BYPASS"),
		.intended_device_family("Cyclone III"),
		.lpm_type("altsyncram"),
		.numwords_a(256),
		.numwords_b(256),
		.operation_mode("DUAL_PORT"),
		.outdata_aclr_b("NONE"),
		.outdata_reg_b("CLOCK0"),
		.power_up_uninitialized("FALSE"),
		.read_during_write_mode_mixed_ports("DONT_CARE"),
		.widthad_a(8),
		.widthad_b(8),
		.width_a(width),
		.width_b(width),
		.width_byteena_a(1)) ram_unit_b(
		.wren_a(wren),
		.clock0(clock),
		.address_a(wraddress),
		.address_b(rdaddress_b),
		.data_a(data),
		.q_b(qb),
		.aclr0(1'b0),
		.aclr1(1'b0),
		.addressstall_a(1'b0),
		.addressstall_b(1'b0),
		.byteena_a(1'b1),
		.byteena_b(1'b1),
		.clock1(1'b1),
		.clocken0(1'b1),
		.clocken1(1'b1),
		.clocken2(1'b1),
		.clocken3(1'b1),
		.data_b({width{1'b1}}),
		.eccstatus(),
		.q_a(),
		.rden_a(1'b1),
		.rden_b(1'b1),
		.wren_b(1'b0));

endmodule
