module pwm
	(
		input	wire			clock,
		input	wire	[47:0]	cfg_data,
		output	wire	[3:0]	out_data

	);

	reg		[12:0]	int_data_reg [3:0];
	wire	[11:0]	cfg_data_wire [3:0];

	integer i;
	genvar j;

	always @ (posedge clock)
	begin
		for(i = 0; i <= 3; i = i + 1)
		begin
			int_data_reg[i] <= {1'b0, int_data_reg[i][11:0]} + {1'b0, cfg_data_wire[i]};
		end
	end

	generate
		for (j = 0; j <= 3; j = j + 1)
		begin : PWM_DATA
			assign cfg_data_wire[j] = cfg_data[j*12+11:j*12];
			assign out_data[j] = int_data_reg[j][12] ? 1'bz : 1'b0;
		end
	endgenerate

endmodule
