module Paella
	(
		input	wire			CLK_50MHz,
		output	wire			LED,

		inout	wire	[3:0]	TRG,
		inout	wire	[6:0]	CON_A,
		inout	wire	[16:0]	CON_B,
		inout	wire	[11:0]	CON_C,
		input	wire	[1:0]	CON_BCLK,
		input	wire	[1:0]	CON_CCLK,

		input	wire			ADC_DCO,
		input	wire			ADC_FCO,
		input	wire			ADC_DB,
		input	wire			ADC_DC,
		input	wire			ADC_DD,

		output	wire			USB_SLRD, 
		output	wire			USB_SLWR,
		input	wire			USB_IFCLK,
		input	wire			USB_FLAGA,
		input	wire			USB_FLAGB,
		input	wire			USB_FLAGC,
		inout	wire	[7:0]	USB_PA,
		inout	wire	[7:0]	USB_PB,

		output	wire			RAM_CLK,
		output	wire			RAM_CE1,
		output	wire			RAM_WE,
		output	wire	[19:0]	RAM_ADDR,
		inout	wire			RAM_DQAP,
		inout	wire	[7:0]	RAM_DQA,
		inout	wire			RAM_DQBP,
		inout	wire	[7:0]	RAM_DQB
	);
	
	//	Turn off all output ports
	assign	USB_SLRD	=	1'b0;
	assign	USB_SLWR	=	1'b0;
	assign	RAM_CLK		=	1'b0;
	assign	RAM_CE1		=	1'b0;
	assign	RAM_WE		=	1'b0;
	assign	RAM_ADDR	=	20'h00000;

	//	All inout ports turn to tri-state
	assign	TRG			=	4'bz;
	assign	CON_A		=	7'bz;
	assign	CON_B		=	17'bz;
	assign	CON_C		=	12'bz;
	assign	USB_PA		=	8'bz;
	assign	USB_PB		=	8'bz;
	assign	RAM_DQAP	=	1'bz;
	assign	RAM_DQA		=	8'bz;
	assign	RAM_DQBP	=	1'bz;
	assign	RAM_DQB		=	8'bz;

	reg		[31:0]	counter;
	
	assign	LED			=	counter[25];

	always @ (posedge CLK_50MHz)
	begin
		counter <= counter + 32'd1;
	end

endmodule