module adc_lvds
	#(
		parameter	size	=	8, // number of channels
		parameter	width	=	24 // channel resolution
	)
	(
		input	wire						clock,

		input	wire						lvds_dco,
		input	wire						lvds_fco,
 		input	wire	[size-1:0]			lvds_d,

		output	wire						adc_frame,
		output	wire	[size*width-1:0]	adc_data

	);

	reg				state, int_rdreq, adc_frame_reg;
	wire			int_wrfull, int_rdempty;

	reg		[size-1:0]	int_data_h, int_data_l;

	reg 	[size*width-1:0]	int_data_reg;
	wire	[size*width-1:0]	int_data_wire;

	wire	[size*width-1:0]	int_q_wire;
	reg		[size*width-1:0]	adc_data_reg;
	

	genvar j;

	generate
		for (j = 0; j < size; j = j + 1)
		begin : INT_DATA
			assign int_data_wire[j*width+width-1:j*width] = {int_data_reg[j*width+width-3:j*width], int_data_h[j], int_data_l[j]};
		end
	endgenerate

	dcfifo #(
		.intended_device_family("Cyclone III"),
		.lpm_numwords(16),
		.lpm_showahead("ON"),
		.lpm_type("dcfifo"),
		.lpm_width(size*width),
		.lpm_widthu(4),
		.rdsync_delaypipe(4),
		.wrsync_delaypipe(4),
		.overflow_checking("ON"),
		.underflow_checking("ON"),
		.use_eab("ON")) fifo_unit (
		.data(int_data_wire),
		.rdclk(clock),
		.rdreq((~int_rdempty) & int_rdreq),
		.wrclk(lvds_fco),
		.wrreq(~int_wrfull),
		.q(int_q_wire),
		.rdempty(int_rdempty),
		.wrfull(int_wrfull),
		.aclr(),
		.rdfull(),
		.rdusedw(),
		.wrempty(),
		.wrusedw());

	always @ (posedge clock)
	begin
		case (state)
			1'b0:
			begin
				int_rdreq <= 1'b1;
				adc_frame_reg <= 1'b0;
				state <= 1'b1;
			end

			1'b1: 
			begin
				if (~int_rdempty)
				begin
					int_rdreq <= 1'b0;
					adc_data_reg <= int_q_wire;
					adc_frame_reg <= 1'b1;
					state <= 1'b0;
				end
			end
		endcase
	end
	
	always @ (negedge lvds_dco)
	begin
		int_data_l <= lvds_d;
	end

	always @ (posedge lvds_dco)
	begin
		int_data_h <= lvds_d;
		int_data_reg <= int_data_wire;
	end

	assign	adc_frame = adc_frame_reg;
	assign	adc_data = adc_data_reg;

endmodule
