(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19130,        707]
NotebookOptionsPosition[     17416,        640]
NotebookOutlinePosition[     17775,        656]
CellTagsIndexPosition[     17732,        653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", 
  "\"\</Users/marcozaro/Physics/feyncalc-master/FeynCalc/fc.m\>\""}]], "Input"],

Cell[CellGroupData[{

Cell["Spin correlations in W production at the LHC", "Title",
 CellChangeTimes->{{3.693039048153269*^9, 3.693039055120265*^9}, {
  3.6931272387546*^9, 3.693127245297575*^9}}],

Cell[CellGroupData[{

Cell["we compute the cross section u(p1) d~(p2) > e+(p3) v(p4)", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039094965802*^9}, {
  3.69312725160856*^9, 3.69312727245778*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p4", ",", "p4"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6930391053897133`*^9, 3.6930391058309107`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The quark trace", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.6931272774560013`*^9, 3.693127278919252*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quarks", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "/", "2"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "2"}], " ", 
   RowBox[{"Tr", "[", 
    RowBox[{
     RowBox[{"GS", "[", "p2", "]"}], ".", 
     RowBox[{"GA", "[", "mu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}], ".", 
     RowBox[{"GS", "[", "p1", "]"}], ".", 
     RowBox[{"GA", "[", "nu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.693127298399377*^9, 3.693127394646652*^9}, 
   3.69312746452773*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"s", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["mu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["nu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}], "+", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693127361202207*^9, 3.6931273949216747`*^9}, {
  3.693127449133382*^9, 3.6931274699152*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The lepton trace", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.6931272774560013`*^9, 3.6931272881985397`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leptons", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "/", "2"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "2"}], " ", 
   RowBox[{"Tr", "[", 
    RowBox[{
     RowBox[{"GS", "[", "p3", "]"}], ".", 
     RowBox[{"GA", "[", "mu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}], ".", 
     RowBox[{"GS", "[", "p4", "]"}], ".", 
     RowBox[{"GA", "[", "nu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.693127298399377*^9, 3.693127412051713*^9}, {
  3.693127446690196*^9, 3.693127447336274*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["g", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"s", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}]}], "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["mu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["nu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}], "+", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693127361202207*^9, 3.6931274126831636`*^9}, {
  3.693127449211101*^9, 3.693127469971283*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The full amplitude", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.6931272774560013`*^9, 3.6931272881985397`*^9}, {3.6931274262839108`*^9, 
  3.693127442056554*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", "3"}], "*", 
     RowBox[{"1", "/", "4"}]}], ")"}], 
   RowBox[{"Contract", "[", 
    RowBox[{"quarks", " ", "leptons"}], "]"}]}], " ", "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"ampQQtoWtoLep", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", "3"}], "*", 
       RowBox[{"1", "/", "4"}]}], ")"}], 
     RowBox[{"Contract", "[", 
      RowBox[{"quarks", " ", "leptons"}], "]"}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "\[Rule]", 
       RowBox[{
        RowBox[{"s", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "cth"}], ")"}]}]}], ",", " ", 
      RowBox[{"u", "\[Rule]", 
       RowBox[{
        RowBox[{"s", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", "cth"}], ")"}]}]}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.6931274444580717`*^9, 3.6931274691028147`*^9}, {
  3.693127515662874*^9, 3.6931275296530113`*^9}, {3.6931276811473618`*^9, 
  3.693127728502334*^9}, {3.693127859453828*^9, 3.693127864500692*^9}, {
  3.6931318801364937`*^9, 3.693131885075254*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["g", "4"], " ", 
    SuperscriptBox["u", "2"]}], "12"], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693127693708705*^9, 3.6931277288724747`*^9}, 
   3.69312786556639*^9, {3.693131882313046*^9, 3.693131885521887*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "48"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"cth", "+", "1"}], ")"}], "2"], " ", 
   SuperscriptBox["g", "4"], " ", 
   SuperscriptBox["s", "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693127693708705*^9, 3.6931277288724747`*^9}, 
   3.69312786556639*^9, {3.693131882313046*^9, 3.693131885703227*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"ampQQtoWtoLep", " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"cth", ",", " ", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6931277333491583`*^9, 3.6931277475883427`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["g", "4"], " ", 
    SuperscriptBox["s", "2"]}], "18"], TraditionalForm]], "Output",
 CellChangeTimes->{3.693127747961013*^9, 3.6931278678277073`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The product of production and decay amplitudes ", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.6931272774560013`*^9, 3.6931272881985397`*^9}, {3.6931274262839108`*^9, 
  3.693127442056554*^9}, {3.693127759701359*^9, 3.693127771091069*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ampQQtoW", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", "3"}], "*", 
     RowBox[{"1", "/", "4"}]}], ")"}], 
   RowBox[{"Contract", "[", 
    RowBox[{"quarks", " ", 
     RowBox[{"MT", "[", 
      RowBox[{"mu", ",", "nu"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ampWtoLep", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", "3"}], ")"}], 
   RowBox[{"Contract", "[", 
    RowBox[{"leptons", " ", 
     RowBox[{"MT", "[", 
      RowBox[{"mu", ",", "nu"}], "]"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.6931277751204863`*^9, 3.693127787156171*^9}, {
  3.6931278195498867`*^9, 3.693127881299366*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g", "2"], " ", "s"}], "12"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.693127787525576*^9, 3.693127842399394*^9, {3.6931278773450193`*^9, 
   3.693127882528571*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g", "2"], " ", "s"}], "3"]}], TraditionalForm]], "Output",\

 CellChangeTimes->{
  3.693127787525576*^9, 3.693127842399394*^9, {3.6931278773450193`*^9, 
   3.693127882540578*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ampQQtoW", " ", "*", " ", "ampWtoLep", " "}]], "Input",
 CellChangeTimes->{{3.693127908932888*^9, 3.6931279227785063`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["g", "4"], " ", 
    SuperscriptBox["s", "2"]}], "36"], TraditionalForm]], "Output",
 CellChangeTimes->{3.693127924166553*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ampQQtoW", " ", "*", " ", "ampWtoLep"}], " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"cth", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.693127930003166*^9, 3.6931279405690203`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["g", "4"], " ", 
    SuperscriptBox["s", "2"]}], "18"], TraditionalForm]], "Output",
 CellChangeTimes->{3.6931279408780527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", 
  RowBox[{
   RowBox[{"LeviCivita", "[", 
    RowBox[{"mu", ",", "nu", ",", " ", "a", ",", "b"}], "]"}], 
   RowBox[{"LeviCivita", "[", 
    RowBox[{"mu", ",", "nu", ",", " ", "c", ",", " ", "d"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.693128066707815*^9, 3.6931280909859657`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    FormBox[
     SuperscriptBox[
      OverscriptBox["g", "_"], 
      RowBox[{
       FormBox[
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SuperscriptBox[
      OverscriptBox["g", "_"], 
      RowBox[{
       FormBox[
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm]}]],
     TraditionalForm]}], "-", 
   RowBox[{"2", " ", 
    FormBox[
     SuperscriptBox[
      OverscriptBox["g", "_"], 
      RowBox[{
       FormBox[
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SuperscriptBox[
      OverscriptBox["g", "_"], 
      RowBox[{
       FormBox[
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.693128091400392*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 596},
WindowMargins->{{147, Automatic}, {19, Automatic}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 109, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[692, 26, 174, 2, 148, "Title"],
Cell[CellGroupData[{
Cell[891, 32, 188, 2, 64, "Section"],
Cell[1082, 36, 1767, 55, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2886, 96, 151, 2, 64, "Section"],
Cell[CellGroupData[{
Cell[3062, 102, 647, 19, 28, "Input"],
Cell[3712, 123, 2739, 106, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6500, 235, 154, 2, 64, "Section"],
Cell[CellGroupData[{
Cell[6679, 241, 672, 19, 28, "Input"],
Cell[7354, 262, 2741, 106, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10144, 374, 207, 3, 64, "Section"],
Cell[CellGroupData[{
Cell[10376, 381, 1217, 36, 63, "Input"],
Cell[11596, 419, 293, 7, 50, "Output"],
Cell[11892, 428, 389, 10, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12318, 443, 264, 6, 28, "Input"],
Cell[12585, 451, 220, 6, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12854, 463, 282, 3, 64, "Section"],
Cell[CellGroupData[{
Cell[13161, 470, 676, 20, 46, "Input"],
Cell[13840, 492, 271, 9, 50, "Output"],
Cell[14114, 503, 269, 9, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14420, 517, 147, 2, 28, "Input"],
Cell[14570, 521, 196, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14803, 532, 304, 7, 28, "Input"],
Cell[15110, 541, 198, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15345, 552, 335, 8, 28, "Input"],
Cell[15683, 562, 1693, 73, 33, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

