(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     97158,       3262]
NotebookOptionsPosition[     90849,       3045]
NotebookOutlinePosition[     91347,       3064]
CellTagsIndexPosition[     91304,       3061]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["gg \[Rule] H at NLO in the HEFT", "Title",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.6924444471962833`*^9, 3.6924444683925543`*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc", "Subsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "HighEnergyPhysics`fc`"}]], "Input",
 PageWidth->PaperWidth],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"Get", "::", "noopen"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"HighEnergyPhysics`fc`\\\\\\\"\\\", \
TraditionalForm]\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.6925155192937403`*^9, 3.6925217772912483`*^9, 
  3.69252240256242*^9, 3.692522450767223*^9}],

Cell[BoxData[
 FormBox["$Failed", TraditionalForm]], "Output",
 CellChangeTimes->{3.6925217772943497`*^9, 3.692522402580044*^9, 
  3.6925224507858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", 
  "\"\</Users/marcozaro/Physics/feyncalc-master/FeynCalc/fc.m\>\""}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"FeynCalc \"\>", "Text",
     StripOnInput->False,
     FontWeight->Bold], "\[InvisibleSpace]", 
    StyleBox["\<\"9.1.0 (development version). For help, use the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"documentation", " ", "center"}],
       BaseStyle->"Link",
       ButtonData:>"paclet:FeynCalc/",
       ButtonNote->"paclet:FeynCalc/"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\", check out the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox["wiki",
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None},
       ButtonNote->"https://github.com/FeynCalc/feyncalc/wiki"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" or write to the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"mailing", " ", 
        RowBox[{"list", "."}]}],
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["http://www.feyncalc.org/forum/"], None},
       ButtonNote->"http://www.feyncalc.org/forum/"],
      DisplayForm], "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["FeynCalc ", "Text", Bold], 
    Style["9.1.0 (development version). For help, use the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "documentation center", BaseStyle -> "Link", ButtonData :> 
       "paclet:FeynCalc/", ButtonNote -> "paclet:FeynCalc/"]], "Text"], 
    Style[", check out the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["wiki", ButtonData :> {
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> 
       "https://github.com/FeynCalc/feyncalc/wiki"]], "Text"], 
    Style[" or write to the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["mailing list.", ButtonData :> {
         URL["http://www.feyncalc.org/forum/"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> "http://www.feyncalc.org/forum/"]], "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692522403983714*^9, 3.692522452074922*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"See also the supplied \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"examples", "."}],
       BaseStyle->"Hyperlink",
       ButtonFunction:>SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]],
       Evaluator->Automatic,
       Method->"Preemptive"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" If you use FeynCalc in your research, please cite\"\>", 
     "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["See also the supplied ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "examples.", BaseStyle -> "Hyperlink", ButtonFunction :> SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]], Evaluator -> 
       Automatic, Method -> "Preemptive"]], "Text"], 
    Style[" If you use FeynCalc in your research, please cite", "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692522403983714*^9, 3.69252245208001*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] V. Shtabovenko, R. Mertig and F. Orellana, TUM-EFT \
71/15, arXiv:1601.01167\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692522403983714*^9, 3.692522452084078*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] R. Mertig, M. B\[ODoubleDot]hm, and A. Denner, \
Comput. Phys. Commun., 64, 345-359, 1991.\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692522403983714*^9, 3.692522452087838*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LimitTo4", "=", "False"}], ";"}]], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Virtual diagrams :preliminaries", "Section",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell["Kinematics", "Subsection",
 PageWidth->PaperWidth],

Cell["\<\
-----I take all momenta outgoing  

     p1 + p2 + p3  = 0     
     
     p1^2=0
     p2^2=0
     p3^3=Q^2
     

        \
\>", "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], "=", "Q2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "=", 
   RowBox[{"Q2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", " ", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p2", ",", "e1"}], "]"}], "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "Q2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{"Q2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", " ", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verteces and Propagators", "Subsection",
 PageWidth->PaperWidth],

Cell[TextData[{
 StyleBox["GGG is the kinematic part of the three-gluon vtx (momenta \
outgoing, clockwise ordering):\nVTX(ggg) = (-\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ) (\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "abc"], TraditionalForm]],
  FontSize->14],
 StyleBox[") GGG\nVTX(qqg) = ( -\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 ")",
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"(", 
     SuperscriptBox["T", "a"], ")"}], "ij"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]],
  FontSize->14],
 StyleBox["\nGluon Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["g", "\[Mu]\[Nu]"]}],
     FontSize->16], 
    SuperscriptBox["p", "2"]], TraditionalForm]],
  FontSize->14],
 "\nQuark ",
 StyleBox["Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"\[ImaginaryI]", " "}],
     FontSize->16], 
    OverscriptBox["p", "^"]], TraditionalForm]],
  FontSize->14]
}], "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GGG", "[", 
    RowBox[{
    "p1_", ",", "p2_", ",", "p3_", ",", "m1_", ",", "m2_", ",", "m3_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FV", "[", 
      RowBox[{
       RowBox[{"p1", "-", "p2"}], ",", "m3"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FV", "[", 
      RowBox[{
       RowBox[{"p2", "-", "p3"}], ",", "m1"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FV", "[", 
      RowBox[{
       RowBox[{"p3", "-", "p1"}], ",", "m2"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GGGD", "[", 
    RowBox[{
    "p1_", ",", "p2_", ",", "p3_", ",", "m1_", ",", "m2_", ",", "m3_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FVD", "[", 
      RowBox[{
       RowBox[{"p1", "-", "p2"}], ",", "m3"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FVD", "[", 
      RowBox[{
       RowBox[{"p2", "-", "p3"}], ",", "m1"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FVD", "[", 
      RowBox[{
       RowBox[{"p3", "-", "p1"}], ",", "m2"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GGGG", "[", 
    RowBox[{"m1_", ",", "m2_", ",", "m3_", ",", "m4_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m3", ",", "m4"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m2", ",", "m4"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m4"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GGGGD", "[", 
    RowBox[{"m1_", ",", "m2_", ",", "m3_", ",", "m4_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m3", ",", "m4"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m2", ",", "m4"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m4"}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PropQuark", "=", "I"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PropGluon", " ", "=", 
   RowBox[{"-", "I"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vtx", "=", 
   RowBox[{
    RowBox[{"-", "I"}], " ", "gs"}]}], ";"}]}], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Born Matrix element ", "Subsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"factborn", "=", "gs2"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Born", "=", 
   RowBox[{
    RowBox[{"factborn", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"MTD", "[", 
         RowBox[{"mu", ",", "nu"}], "]"}], " ", 
        RowBox[{"SPD", "[", 
         RowBox[{"p1", ",", "p2"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"FVD", "[", 
         RowBox[{"p1", ",", "nu"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
         RowBox[{"p2", ",", "mu"}], "]"}]}]}], ")"}], " ", 
     RowBox[{"FVD", "[", 
      RowBox[{"e1", ",", "mu"}], "]"}], " ", 
     RowBox[{"FVD", "[", 
      RowBox[{"e2", ",", "nu"}], "]"}]}], "//", "Contract"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Born4", "=", 
   RowBox[{"Born", "/.", " ", 
    RowBox[{"D", "\[Rule]", "4"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Born", "=", "Born"}]}], "Input",
 PageWidth->PaperWidth],

Cell[BoxData[
 FormBox["gs2", TraditionalForm]], "Output",
 CellChangeTimes->{3.5426318223635883`*^9, 3.692515519604402*^9, 
  3.6925218211499767`*^9, 3.692522404445462*^9, 3.692522452532443*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", "gs2", " ", "Q2", " ", 
   RowBox[{"(", 
    RowBox[{
     FormBox[
      FormBox["e1",
       TraditionalForm],
      TraditionalForm], 
     FormBox["\<\"\[CenterDot]\"\>",
      TraditionalForm], 
     FormBox[
      FormBox["e2",
       TraditionalForm],
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5426318223635883`*^9, 3.692515519604402*^9, 
  3.6925218211499767`*^9, 3.692522404445462*^9, 3.692522452550085*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"BornSq", "=", 
  RowBox[{
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"gs2", "^", "2"}], " ", "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"D", "-", "2"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"MTD", "[", 
              RowBox[{"mu", ",", "nu"}], "]"}], " ", 
             RowBox[{"SPD", "[", 
              RowBox[{"p1", ",", "p2"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"FVD", "[", 
              RowBox[{"p1", ",", "nu"}], "]"}], " ", 
             RowBox[{"FVD", "[", 
              RowBox[{"p2", ",", "mu"}], "]"}]}]}], ")"}], 
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"MTD", "[", 
              RowBox[{"mu", ",", "nu"}], "]"}], " ", 
             RowBox[{"SPD", "[", 
              RowBox[{"p1", ",", "p2"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"FVD", "[", 
              RowBox[{"p1", ",", "nu"}], "]"}], " ", 
             RowBox[{"FVD", "[", 
              RowBox[{"p2", ",", "mu"}], "]"}]}]}], ")"}]}], " ", "//", 
         "Contract"}], ")"}], " ", "/.", " ", 
       RowBox[{"D", "\[Rule]", 
        RowBox[{"4", "-", 
         RowBox[{"2", "e"}]}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BornSq4", "=", 
   RowBox[{"BornSq", "/.", " ", 
    RowBox[{"e", "\[Rule]", "0"}]}]}], ";"}]}], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["e", "2"], "+", "e", "+", "1"}], ")"}], " ", 
   SuperscriptBox["gs2", "2"], " ", 
   SuperscriptBox["Q2", "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.542631822489691*^9, 3.692515519701975*^9, 
  3.6925218211943827`*^9, 3.692522404519568*^9, 3.6925224525920267`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
My Scalar Integrals
The commented expression seems not to work on Mathematica 10 + FC9\
\>", "Subsection",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692521838667712*^9, 3.692521858834566*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"subInt", "[", "expr_", "]"}], ":=", 
     RowBox[{"expr", "/.", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"B0", "[", "x__", "]"}], "\[Rule]", " ", 
         RowBox[{
          RowBox[{"DUPI", "/", 
           RowBox[{"(", 
            RowBox[{"I", " ", 
             RowBox[{"Pi", "^", "2"}]}], ")"}]}], " ", 
          RowBox[{"MyB0", "[", "x", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"C0", "[", "x__", "]"}], "\[Rule]", " ", 
         RowBox[{
          RowBox[{"DUPI", "/", 
           RowBox[{"(", 
            RowBox[{"I", " ", 
             RowBox[{"Pi", "^", "2"}]}], ")"}]}], " ", 
          RowBox[{"MyC0", "[", "x", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"D0", "[", "x__", "]"}], "\[Rule]", " ", 
         RowBox[{
          RowBox[{"DUPI", "/", 
           RowBox[{"(", 
            RowBox[{"I", " ", 
             RowBox[{"Pi", "^", "2"}]}], ")"}]}], " ", 
          RowBox[{"MyD0", "[", "x", "]"}]}]}]}], "}"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"subInt", "[", "expr_", "]"}], " ", ":=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{"expr", " ", "/.", "  ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"PaVe", "[", 
            RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"Join", "[", 
              RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            "6"}]}], "\[Rule]", 
          RowBox[{
           RowBox[{"DUPI", "/", 
            RowBox[{"(", 
             RowBox[{"I", " ", 
              RowBox[{"Pi", "^", "2"}]}], ")"}]}], "MyC0"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"PaVe", "[", 
            RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"Join", "[", 
              RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            "3"}]}], "\[Rule]", 
          RowBox[{
           RowBox[{"DUPI", "/", 
            RowBox[{"(", 
             RowBox[{"I", " ", 
              RowBox[{"Pi", "^", "2"}]}], ")"}]}], "MyB0"}]}]}], " ", "}"}]}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MyC0", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c\[CapitalGamma]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "/", 
           RowBox[{"e", "^", "2"}]}], "-", 
          RowBox[{"Pi", "^", "2"}], "-", 
          RowBox[{
           RowBox[{"2", "/", "e"}], "*", 
           RowBox[{"Log", "[", 
            RowBox[{"Q2", "/", "mu2"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"Q2", "/", "mu2"}], "]"}], "^", "2"}]}], ")"}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "Q2"}], ")"}]}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"this", " ", "is", " ", 
      RowBox[{"C0", "[", 
       RowBox[{"0", ",", "0", ",", "Q2", ",", "0", ",", "0", ",", "0"}], 
       "]"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"MyB0", "=", 
     RowBox[{"c\[CapitalGamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "e"}], "+", "2", "-", 
        RowBox[{"Log", "[", 
         RowBox[{"Q2", "/", "mu2"}], "]"}]}], ")"}]}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"this", " ", "is", " ", 
       RowBox[{"B0", "[", 
        RowBox[{"Q2", ",", "0", ",", "0"}], "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"B0", "[", 
        RowBox[{"0", ",", "0", ",", "0"}], "]"}], " ", "is", " ", 
       "automatically", " ", "discarded", " ", "by", " ", "FC", " ", 
       RowBox[{"(", 
        RowBox[{"it", " ", "is", " ", "0"}], ")"}]}]}], "*)"}], 
    "\n"}]}]}]], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692521981776946*^9, 3.692522061165731*^9}, 
   3.692522128293076*^9, 3.692522194390325*^9, {3.692522247972107*^9, 
   3.6925223829969473`*^9}, {3.692522439712294*^9, 3.692522440039565*^9}, {
   3.69252247672123*^9, 3.692522488719124*^9}}],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CDR", "Section"],

Cell[CellGroupData[{

Cell["Vertex Diagram ", "Subsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"colorvtx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"SUNF", "[", 
      RowBox[{"b", ",", "x", ",", "y"}], "]"}], 
     RowBox[{"SUNF", "[", 
      RowBox[{"y", ",", "a", ",", "x"}], "]"}]}], " ", "//", 
    "SUNSimplify"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"num", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"gs2", "^", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{"-", "gs2"}], ")"}], "*", "I", "*", "\[IndentingNewLine]", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"MTD", "[", 
         RowBox[{"al", ",", "be"}], "]"}], " ", 
        RowBox[{"SPD", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "l"}], "+", "p1"}], ",", 
          RowBox[{"p2", "+", "l"}]}], "]"}]}], "-", "  ", 
       RowBox[{
        RowBox[{"FVD", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "l"}], "+", "p1"}], ",", "be"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
         RowBox[{
          RowBox[{"p2", "+", "l"}], ",", "al"}], "]"}]}]}], ")"}], " ", "*", 
     " ", 
     RowBox[{"GGGD", "[", 
      RowBox[{
       RowBox[{"-", "l"}], ",", "p1", ",", 
       RowBox[{"l", "-", "p1"}], ",", "ro", ",", "mu", ",", "al"}], "]"}], 
     "*", "\[IndentingNewLine]", 
     RowBox[{"GGGD", "[", 
      RowBox[{"p2", ",", "l", ",", 
       RowBox[{
        RowBox[{"-", "l"}], "-", "p2"}], ",", "nu", ",", "ro", ",", "be"}], 
      "]"}], "*", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"MTD", "[", 
         RowBox[{"mu", ",", "nu"}], "]"}], " ", 
        RowBox[{"SPD", "[", 
         RowBox[{"p1", ",", "p2"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"FVD", "[", 
         RowBox[{"p1", ",", "nu"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
         RowBox[{"p2", ",", "mu"}], "]"}]}]}], ")"}]}], " ", "//", 
    "Contract"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dens", "=", 
   RowBox[{"FAD", "[", 
    RowBox[{"l", ",", 
     RowBox[{"p1", "-", "l"}], ",", 
     RowBox[{"l", "+", "p2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amp", "=", 
   RowBox[{"CA", " ", "dens", "*", " ", 
    RowBox[{"num", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"D", "-", "2"}], ")"}], "^", "2"}]}]}]}], ";"}], "\n", 
 RowBox[{"inte1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"OneLoop", "[", 
           RowBox[{"l", ",", 
            RowBox[{"amp", "/", "DUPI"}]}], "]"}], "//", "PaVeReduce"}], "//",
          "Simplify"}], ")"}], "//", "Factor"}], "//", "Simplify"}], ")"}], "/.",
     " ", 
    RowBox[{
     RowBox[{"B0", "[", 
      RowBox[{"0", ",", "0", ",", "0"}], "]"}], "\[Rule]", "0"}]}], " ", "//",
    "Simplify"}]}]}], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692522149415956*^9, 3.6925221619920483`*^9}, {
  3.692522495640565*^9, 3.6925224959986963`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["C", "A"], " ", 
   SuperscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.692522404810404*^9, 3.69252245267111*^9, 
  3.692522499089229*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["gs2", "3"], " ", 
     SuperscriptBox["Q2", "2"], " ", 
     SubscriptBox["C", "A"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"20", " ", 
            SuperscriptBox["D", "2"]}]}], "+", 
          RowBox[{"73", " ", "D"}], "-", "52"}], ")"}], " ", 
        FormBox[
         RowBox[{
          SubscriptBox["\<\"B\"\>", "\<\"0\"\>"], "(", 
          RowBox[{"Q2", ",", "0", ",", "0"}], ")"}],
         TraditionalForm]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["D", "2"], "-", 
          RowBox[{"3", " ", "D"}], "+", "2"}], ")"}], " ", "Q2", " ", 
        FormBox[
         RowBox[{
          SubscriptBox["\<\"C\"\>", "\<\"0\"\>"], "(", 
          RowBox[{"0", ",", "0", ",", "Q2", ",", "0", ",", "0", ",", "0"}], 
          ")"}],
         TraditionalForm]}]}], ")"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"D", "-", "2"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"D", "-", "1"}], ")"}], " ", "DUPI"}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.692522404810404*^9, 3.69252245267111*^9, 
  3.6925225004402237`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4-gluon Diagram ", "Subsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"color", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"SUNF", "[", 
      RowBox[{"b", ",", "c", ",", "y"}], "]"}], 
     RowBox[{"SUNF", "[", 
      RowBox[{"y", ",", "a", ",", "c"}], "]"}]}], " ", "//", 
    "SUNSimplify"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"num", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"gs2", "^", "2"}], "*", "I", "*", " ", "gs2", "*", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"MTD", "[", 
         RowBox[{"ro", ",", "si"}], "]"}], " ", 
        RowBox[{"SPD", "[", 
         RowBox[{"l", ",", 
          RowBox[{
           RowBox[{"-", "l"}], "+", "p1", "+", "p2"}]}], "]"}]}], "-", "  ", 
       RowBox[{
        RowBox[{"FVD", "[", 
         RowBox[{"l", ",", "si"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "l"}], "+", "p1", "+", "p2"}], ",", "ro"}], "]"}]}]}],
       ")"}], " ", "*", " ", 
     RowBox[{"GGGGD", "[", 
      RowBox[{"nu", ",", "mu", ",", "ro", ",", "si"}], "]"}], " ", "*", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"MTD", "[", 
         RowBox[{"mu", ",", "nu"}], "]"}], " ", 
        RowBox[{"SPD", "[", 
         RowBox[{"p1", ",", "p2"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"FVD", "[", 
         RowBox[{"p1", ",", "nu"}], "]"}], " ", 
        RowBox[{"FVD", "[", 
         RowBox[{"p2", ",", "mu"}], "]"}]}]}], ")"}]}], " ", "//", 
    "Contract"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dens", "=", 
   RowBox[{"FAD", "[", 
    RowBox[{"l", ",", 
     RowBox[{"l", "-", "p1", "-", "p2"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"amp", "=", 
   RowBox[{
    RowBox[{"CA", "/", "2"}], "  ", "dens", "*", 
    RowBox[{"num", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"D", "-", "2"}], ")"}], "^", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"inte2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"OneLoop", "[", 
        RowBox[{"l", ",", 
         RowBox[{"amp", "/", "DUPI"}]}], "]"}], "//", "PaVeReduce"}], "//", 
      "Simplify"}], ")"}], "//", "Factor"}], "//", "Simplify"}]}]}], "Input",
 PageWidth->PaperWidth],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "D"}], "-", "3"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["D", "2"]}], "-", 
       RowBox[{"5", " ", "D"}], "+", "4"}], ")"}], " ", 
     SuperscriptBox["gs2", "3"], " ", 
     SuperscriptBox["Q2", "2"], " ", 
     SubscriptBox["C", "A"], " ", 
     FormBox[
      RowBox[{
       SubscriptBox["\<\"B\"\>", "\<\"0\"\>"], "(", 
       RowBox[{"Q2", ",", "0", ",", "0"}], ")"}],
      TraditionalForm]}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"D", "-", "2"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"D", "-", "1"}], ")"}], " ", "DUPI"}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5426318360589*^9, 3.692515521760001*^9, 
  3.692521920374544*^9, 3.692522407076551*^9, 3.692522514659532*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sum the virtuals", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"res1", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], "*", "\[IndentingNewLine]", 
        RowBox[{"Normal", "[", 
         RowBox[{"Series", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", "inte1", ")"}], "/", "BornSq"}], "/", "I"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"mu2", "/", "Q2"}], ")"}], "^", 
               RowBox[{"(", "e", ")"}]}]}], " ", "/.", " ", 
             RowBox[{"D", "\[Rule]", 
              RowBox[{"4", "-", 
               RowBox[{"2", "e"}]}]}]}], "//", " ", "subInt"}], ",", 
           RowBox[{"{", 
            RowBox[{"e", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "//", 
       "Simplify"}], "//", "PowerExpand"}], "//", "Expand"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"res2", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], "*", "\[IndentingNewLine]", 
        RowBox[{"Normal", "[", 
         RowBox[{"Series", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", "inte2", ")"}], "/", "BornSq"}], "/", "I"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"mu2", "/", "Q2"}], ")"}], "^", 
               RowBox[{"(", "e", ")"}]}]}], " ", "/.", " ", 
             RowBox[{"D", "\[Rule]", 
              RowBox[{"4", "-", 
               RowBox[{"2", "e"}]}]}]}], "//", " ", "subInt"}], ",", 
           RowBox[{"{", 
            RowBox[{"e", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "//", 
       "Simplify"}], "//", "PowerExpand"}], "//", "Expand"}]}], 
   "\n"}]}]], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.54263188574975*^9, 3.542631902626193*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"c\[CapitalGamma]", " ", "gs2", " ", 
      SubscriptBox["C", "A"]}], 
     SuperscriptBox["e", "2"]]}], "+", 
   FractionBox[
    RowBox[{"5", " ", "c\[CapitalGamma]", " ", "gs2", " ", 
     SubscriptBox["C", "A"]}], 
    RowBox[{"3", " ", "e"}]], "+", 
   RowBox[{
    FractionBox["179", "72"], " ", "c\[CapitalGamma]", " ", "gs2", " ", 
    SubscriptBox["C", "A"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"], " ", "c\[CapitalGamma]", " ", "gs2", " ", 
    SubscriptBox["C", "A"]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.542631840971065*^9, {3.542631900146366*^9, 3.542631903265226*^9}, 
   3.69251552178992*^9, 3.692521932580472*^9, {3.692522077916459*^9, 
   3.692522101803856*^9}, 3.692522134521243*^9, 3.692522519476282*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", "c\[CapitalGamma]", " ", "gs2", " ", 
      SubscriptBox["C", "A"]}], 
     RowBox[{"3", " ", "e"}]]}], "-", 
   RowBox[{
    FractionBox["179", "72"], " ", "c\[CapitalGamma]", " ", "gs2", " ", 
    SubscriptBox["C", "A"]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.542631840971065*^9, {3.542631900146366*^9, 3.542631903265226*^9}, 
   3.69251552178992*^9, 3.692521932580472*^9, {3.692522077916459*^9, 
   3.692522101803856*^9}, 3.692522134521243*^9, 3.692522519526516*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"res", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "*", "\[IndentingNewLine]", 
       RowBox[{"Normal", "[", 
        RowBox[{"Series", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"inte1", "+", "inte2"}], ")"}], "/", "BornSq"}], "/", 
              "I"}], "/", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"mu2", "/", "Q2"}], ")"}], "^", 
              RowBox[{"(", "e", ")"}]}]}], " ", "/.", " ", 
            RowBox[{"D", "\[Rule]", 
             RowBox[{"4", "-", 
              RowBox[{"2", "e"}]}]}]}], "//", " ", "subInt"}], ",", 
          RowBox[{"{", 
           RowBox[{"e", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "//", 
      "Simplify"}], "//", "PowerExpand"}], "//", "Expand"}]}]}]], "Input",
 PageWidth->PaperWidth],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"], " ", "c\[CapitalGamma]", " ", "gs2", " ", 
    SubscriptBox["C", "A"]}], "-", 
   FractionBox[
    RowBox[{"c\[CapitalGamma]", " ", "gs2", " ", 
     SubscriptBox["C", "A"]}], 
    SuperscriptBox["e", "2"]]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.542631840971065*^9, 3.692515521882228*^9, 
  3.692522543770403*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Add is the contribution from Hgg operator", "Subsection",
 CellChangeTimes->{{3.692531754609666*^9, 3.692531767359894*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"add", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"19", "/", "4"}], "/", "\[Pi]"}], " ", 
              RowBox[{"gs2", "/", 
               RowBox[{"(", 
                RowBox[{"4", "\[Pi]"}], ")"}]}]}]}], " ", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              RowBox[{
               RowBox[{"gs2", "/", 
                RowBox[{"(", 
                 RowBox[{"4", "\[Pi]"}], ")"}]}], "/", "\[Pi]"}]}]}], ")"}]}],
           ")"}], ",", 
         RowBox[{"{", 
          RowBox[{"gs2", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], "-", 
      "1"}], ")"}], "c\[CapitalGamma]", " ", 
    RowBox[{"CA", "/", "3"}], " ", "16", 
    RowBox[{"Pi", "^", "2"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"virt", "=", 
   RowBox[{"add", "+", "res"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"virt1", "=", "res1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"virt2", "=", "res2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "add"}], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.5426319374668407`*^9, 3.542631949496957*^9}, 
   3.692522571042892*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["11", "6"], " ", "c\[CapitalGamma]", " ", "gs2", " ", 
   SubscriptBox["C", "A"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5426318443159647`*^9, 3.542631976167509*^9, 
  3.5426321214075212`*^9, 3.692515521927043*^9, 3.692522580645241*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"virt", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"virt", "*", 
        RowBox[{
         RowBox[{"2", "/", "gs2"}], "/", "c\[CapitalGamma]"}]}], ")"}], "//", 
      "Expand"}], ")"}], "*", 
    FractionBox["as", 
     RowBox[{"2", "\[Pi]"}]], "c\[CapitalGamma]"}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"eq", " ", "39"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"virt1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"virt1", "*", 
        RowBox[{
         RowBox[{"2", "/", "gs2"}], "/", "c\[CapitalGamma]"}]}], ")"}], "//", 
      "Expand"}], ")"}], "*", 
    FractionBox["as", 
     RowBox[{"2", "\[Pi]"}]], "c\[CapitalGamma]"}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"virt2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"virt2", "*", 
       RowBox[{
        RowBox[{"2", "/", "gs2"}], "/", "c\[CapitalGamma]"}]}], ")"}], "//", 
     "Expand"}], ")"}], "*", 
   FractionBox["as", 
    RowBox[{"2", "\[Pi]"}]], "c\[CapitalGamma]", " "}]}]}], "Input",
 CellChangeTimes->{{3.542631852564522*^9, 3.542631853826531*^9}, {
  3.5426319547565536`*^9, 3.54263197179709*^9}, {3.5426320982454357`*^9, 
  3.542632118569233*^9}, {3.692525395151532*^9, 3.692525397947733*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"as", " ", "c\[CapitalGamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SubscriptBox["C", "A"]}], 
        SuperscriptBox["e", "2"]]}], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubscriptBox["C", "A"]}], "+", 
      FractionBox[
       RowBox[{"11", " ", 
        SubscriptBox["C", "A"]}], "3"]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.542631848559409*^9, 3.54263185425035*^9}, {
   3.542631972325842*^9, 3.542631978338317*^9}, {3.542632099603859*^9, 
   3.542632122724947*^9}, 3.692515521976563*^9, 3.692524472065591*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"as", " ", "c\[CapitalGamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SubscriptBox["C", "A"]}], 
        SuperscriptBox["e", "2"]]}], "+", 
      FractionBox[
       RowBox[{"10", " ", 
        SubscriptBox["C", "A"]}], 
       RowBox[{"3", " ", "e"}]], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubscriptBox["C", "A"]}], "+", 
      FractionBox[
       RowBox[{"179", " ", 
        SubscriptBox["C", "A"]}], "36"]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.542631848559409*^9, 3.54263185425035*^9}, {
   3.542631972325842*^9, 3.542631978338317*^9}, {3.542632099603859*^9, 
   3.542632122724947*^9}, 3.692515521976563*^9, 3.69252447207027*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"as", " ", "c\[CapitalGamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"10", " ", 
         SubscriptBox["C", "A"]}], 
        RowBox[{"3", " ", "e"}]]}], "-", 
      FractionBox[
       RowBox[{"179", " ", 
        SubscriptBox["C", "A"]}], "36"]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.542631848559409*^9, 3.54263185425035*^9}, {
   3.542631972325842*^9, 3.542631978338317*^9}, {3.542632099603859*^9, 
   3.542632122724947*^9}, 3.692515521976563*^9, 3.692524472073923*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"32", "/", "256"}], "/", "3"}], "/", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "e"}], ")"}], "^", "2"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{"24", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "e"}], ")"}], "2"]}]], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The real contributions", "Section",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell["Kinematics", "Subsection",
 PageWidth->PaperWidth],

Cell["\<\
-----I take all momenta outgoing  

     p1 + p2 + p3 + p4 = 0     
     
     p1^2=0
     p2^2=0
     p3^3=0
     p4^2=mh^2
     
-----invariants

     s  = (p1 + p2)^2 = (p3 + p4)^2=2 p1.p2=mh^2+2 p3.p4
     t  = (p1 + p3)^2 = (p2+  p4)^2 =2 p1.p3=mh^2+2 p2.p4
     u  = (p2 + p3)^2 = (p1 + p4)^2=2 p1.p4+mh^2=+2 p2.p3
    
     s + t + u = mh^2
    
     \[Sigma]+\[Tau]+\[Upsilon]=1
        
 -----scalar products    
     
     p1.p2=s/2
     p1.p3=(t)/2
     p1.p4= (u-mh^2)/2
     p2.p3= (u)/2
     p2.p4=(t-mh^2)/2
     p3.p4=(s-mh^2)/2
    
-----physical region for production   p1+p2=-p3-p4

      s>(mh)^2 ; 
      t<0; 
      u<0;
         
\
\>", "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"q", ",", "p3"}], "]"}], "=", 
    RowBox[{"u", "/", "2"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"q", "=", 
    RowBox[{"p2", "+", "p3"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"q", ",", "p2"}], "]"}], "=", 
    RowBox[{"u", "/", "2"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"q", "=", 
    RowBox[{"p2", "+", "p3"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"q", ",", "q"}], "]"}], "=", "u"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"q", "=", 
    RowBox[{"p2", "+", "p3"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p4", ",", "p4"}], "]"}], "=", "mh2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "=", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], "=", 
   RowBox[{"t", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p4"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "-", "mh2"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], "=", 
   RowBox[{"u", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p4"}], "]"}], "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"t", "-", "mh2"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p4"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"s", "-", "mh2"}], ")"}], "/", "2"}]}], "  ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "e3"}], "]"}], "=", "0"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1"}], "]"}], "=", "0"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2"}], "]"}], "=", "0"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s13", "=", "t"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s23", "=", "u"}], ";"}]}], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verteces and Propagators", "Subsection",
 PageWidth->PaperWidth],

Cell[TextData[{
 StyleBox["GGG is the kinematic part of the three-gluon vtx (momenta \
outgoing, clockwise ordering):\nVTX(ggg) = (-\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ) (\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "abc"], TraditionalForm]],
  FontSize->14],
 StyleBox[") GGG\nVTX(qqg) = ( -\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 ")",
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"(", 
     SuperscriptBox["T", "a"], ")"}], "ij"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]],
  FontSize->14],
 StyleBox["\nGluon Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["g", "\[Mu]\[Nu]"]}],
     FontSize->16], 
    SuperscriptBox["p", "2"]], TraditionalForm]],
  FontSize->14],
 "\nQuark ",
 StyleBox["Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"\[ImaginaryI]", " "}],
     FontSize->16], 
    OverscriptBox["p", "^"]], TraditionalForm]],
  FontSize->14]
}], "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GGGD", "[", 
    RowBox[{
    "p1_", ",", "p2_", ",", "p3_", ",", "m1_", ",", "m2_", ",", "m3_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p1", "-", "p2"}], ",", "m3", ",", " ", 
       RowBox[{"Dimension", " ", "\[Rule]", "D"}]}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p2", "-", "p3"}], ",", "m1", ",", " ", 
       RowBox[{"Dimension", " ", "\[Rule]", " ", "D"}]}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p3", "-", "p1"}], ",", "m2", ",", " ", 
       RowBox[{"Dimension", " ", "\[Rule]", " ", "D"}]}], "]"}], " ", 
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H", "[", 
    RowBox[{"p1_", ",", "p2_", ",", "m1_", ",", "m2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"MTD", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}], " ", 
     RowBox[{"SPD", "[", 
      RowBox[{"p1", ",", "p2"}], "]"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{"p1", ",", "m2", ",", " ", 
       RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "*", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"FourVector", "[", 
      RowBox[{"p2", ",", "m1", ",", " ", 
       RowBox[{"Dimension", " ", "\[Rule]", "D"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PropQuark", "=", "I"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PropGluon", " ", "=", 
   RowBox[{"-", "I"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vtx", "=", 
   RowBox[{
    RowBox[{"-", "I"}], " ", "gs"}]}], ";"}]}], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sum over the  four Feynman diagrams", "Subsection"],

Cell["\<\

uno= - gs (-f123) GGGD[p1,p2,-p1-p2,m1,m2,mu]  (-I MTD[mu,nu]/s) (I A) \
H[p3,p1+p2,m3,nu]//Contract;
tre= - gs (-f123) GGGD[p3,p1,-p3-p1,m3,m1,mu] (-I MTD[mu,nu]/t) (I A)  \
H[p2,p1+p3,m2,nu]//Contract;
qua= - gs (-f123) GGGD[p2,p3,-p3-p2,m2,m3,mu] (-I MTD[mu,nu]/u) (I A)  \
H[p1,p2+p3,m1,nu]//Contract;
due= -  A gs (-f123) GGGD[p1,p2,p3,m1,m2,m3];
res=uno+due+tre+qua//ExpandScalarProduct;\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now I have to square the amplitude.  The sum is performed over the physical \
polarizations  of the gluons:\
\>", "Subsection"],

Cell["\<\
res1=res;
res2=res /. m1->m1p /. m2->m2p /. m3-> m3p;
tot=res1*(-MTD[m1,m1p]+(FVD[p1,m1] FVD[p2,m1p]+FVD[p1,m1p] \
FVD[p2,m1])/SPD[p1,p2])//Contract;
tot=tot*(-MTD[m2,m2p]+(FVD[p2,m2] FVD[p3,m2p]+FVD[p2,m2p] \
FVD[p3,m2])/SPD[p3,p2])//Contract;
tot=tot*(-MTD[m3,m3p]+(FVD[p1,m3] FVD[p3,m3p]+FVD[p1,m3p] \
FVD[p3,m3])/SPD[p3,p1])//Contract;
tot=tot*res2//Contract//Expand;\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Amp2=((tot//Contract//Factor)/. A-> as/3/Pi/v /. gs^2-> 4 Pi as/. f123^2-> 24 \
//Simplify)//Factor\
\>", "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", " ", "\[Pi]", " ", "s", " ", "t", " ", "u", " ", 
     SuperscriptBox["v", "2"]}]], 
   RowBox[{"32", " ", 
    SuperscriptBox["as", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", " ", 
       SuperscriptBox["s", "4"]}], "+", 
      RowBox[{"2", " ", "D", " ", 
       SuperscriptBox["s", "3"], " ", "t"}], "+", 
      RowBox[{"2", " ", "D", " ", 
       SuperscriptBox["s", "3"], " ", "u"}], "+", 
      RowBox[{"3", " ", "D", " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{"8", " ", "D", " ", 
       SuperscriptBox["s", "2"], " ", "t", " ", "u"}], "+", 
      RowBox[{"3", " ", "D", " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", "D", " ", "s", " ", 
       SuperscriptBox["t", "3"]}], "+", 
      RowBox[{"8", " ", "D", " ", "s", " ", 
       SuperscriptBox["t", "2"], " ", "u"}], "+", 
      RowBox[{"8", " ", "D", " ", "s", " ", "t", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", "D", " ", "s", " ", 
       SuperscriptBox["u", "3"]}], "+", 
      RowBox[{"D", " ", 
       SuperscriptBox["t", "4"]}], "+", 
      RowBox[{"2", " ", "D", " ", 
       SuperscriptBox["t", "3"], " ", "u"}], "+", 
      RowBox[{"3", " ", "D", " ", 
       SuperscriptBox["t", "2"], " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", "D", " ", "t", " ", 
       SuperscriptBox["u", "3"]}], "+", 
      RowBox[{"D", " ", 
       SuperscriptBox["u", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["s", "4"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["s", "3"], " ", "t"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["s", "3"], " ", "u"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["t", "2"]}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["s", "2"], " ", "t", " ", "u"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"4", " ", "s", " ", 
       SuperscriptBox["t", "3"]}], "-", 
      RowBox[{"20", " ", "s", " ", 
       SuperscriptBox["t", "2"], " ", "u"}], "-", 
      RowBox[{"20", " ", "s", " ", "t", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"4", " ", "s", " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["t", "4"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["t", "3"], " ", "u"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["t", "2"], " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"4", " ", "t", " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["u", "4"]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.6925262025482817`*^9}]
}, Open  ]],

Cell["\<\

Amp2=Amp2 /. D->4-2e//Simplify;\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData["Amp2"], "Input",
 CellChangeTimes->{{3.692526234576797*^9, 3.6925262356483517`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"64", " ", 
     SuperscriptBox["as", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "-", "1"}], ")"}], " ", 
        SuperscriptBox["s", "4"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"e", "-", "1"}], ")"}], " ", 
        SuperscriptBox["s", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"t", "+", "u"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"e", "-", "1"}], ")"}], " ", 
           SuperscriptBox["t", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "e"}], "-", "3"}], ")"}], " ", "t", " ", "u"}],
           "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"e", "-", "1"}], ")"}], " ", 
           SuperscriptBox["u", "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "s", " ", 
        RowBox[{"(", 
         RowBox[{"t", "+", "u"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"e", "-", "1"}], ")"}], " ", 
           SuperscriptBox["t", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "e"}], "-", "2"}], ")"}], " ", "t", " ", "u"}],
           "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"e", "-", "1"}], ")"}], " ", 
           SuperscriptBox["u", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "-", "1"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["t", "2"], "+", 
           RowBox[{"t", " ", "u"}], "+", 
           SuperscriptBox["u", "2"]}], ")"}], "2"]}]}], ")"}]}], 
    RowBox[{"3", " ", "\[Pi]", " ", "s", " ", "t", " ", "u", " ", 
     SuperscriptBox["v", "2"]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.692526236388625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Real Amplitude Squared in D dimensions", "Subsection",
 PageWidth->PaperWidth],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Emme", "=", 
     RowBox[{
      RowBox[{"1", "/", "s"}], 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mh2", "^", "4"}], "+", 
              RowBox[{"s", "^", "4"}], "+", 
              RowBox[{"t", "^", "4"}], "+", 
              RowBox[{"u", "^", "4"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "e"}]}], ")"}]}], "+", " ", 
           RowBox[{
            RowBox[{"e", "/", "2"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mh2", "^", "2"}], "+", 
               RowBox[{"s", "^", "2"}], "+", 
               RowBox[{"t", "^", "2"}], "+", 
               RowBox[{"u", "^", "2"}]}], ")"}], "^", "2"}]}]}], ")"}], "/", 
         "s"}], "/", "t"}], "/", "u"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RealD", "=", 
     RowBox[{"Emme", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "e"}], ")"}], "^", "2"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Real4", "=", 
     RowBox[{"RealD", "/.", " ", 
      RowBox[{"e", "\[Rule]", "0"}]}]}], ";"}]}]}]], "Input",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Amp2", "/", "s"}], " ", "-", " ", 
    RowBox[{"Emme", " ", "*", "64", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"as", "^", "3"}], " ", "/", " ", "3"}], "/", "Pi"}], " ", "/", 
      RowBox[{"v", "^", "2"}]}]}]}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{"mh2", "\[Rule]", 
     RowBox[{"s", "+", "t", "+", "u"}]}], "}"}]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.6925266643363037`*^9, 3.692526665304311*^9}, {
  3.692526755257955*^9, 3.692526892252841*^9}, {3.692526952170274*^9, 
  3.69252696194454*^9}, {3.69252704067334*^9, 3.692527040832261*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"64", " ", 
    SuperscriptBox["as", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e", "-", "1"}], ")"}], " ", 
       SuperscriptBox["s", "4"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"e", "-", "1"}], ")"}], " ", 
       SuperscriptBox["s", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"t", "+", "u"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["s", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"e", "-", "1"}], ")"}], " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "e"}], "-", "3"}], ")"}], " ", "t", " ", "u"}], 
         "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"e", "-", "1"}], ")"}], " ", 
          SuperscriptBox["u", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "s", " ", 
       RowBox[{"(", 
        RowBox[{"t", "+", "u"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"e", "-", "1"}], ")"}], " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "e"}], "-", "2"}], ")"}], " ", "t", " ", "u"}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"e", "-", "1"}], ")"}], " ", 
          SuperscriptBox["u", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e", "-", "1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["t", "2"], "+", 
          RowBox[{"t", " ", "u"}], "+", 
          SuperscriptBox["u", "2"]}], ")"}], "2"]}]}], ")"}]}], 
   RowBox[{"3", " ", "\[Pi]", " ", 
    SuperscriptBox["s", "2"], " ", "t", " ", "u", " ", 
    SuperscriptBox["v", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692526794285302*^9, 3.6925268046529827`*^9}, {
   3.692526834935911*^9, 3.692526852357235*^9}, {3.692526953105447*^9, 
   3.6925269622524967`*^9}, 3.692527041841333*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Phase space in D dimensions", "Subsection",
 PageWidth->PaperWidth],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PS", "=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", "\[Pi]"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"4", " ", "\[Pi]", " "}], "mh2"], ")"}], "e"], 
      FractionBox["1", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "e"}], "]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["mh2", "s"], ")"}], "e"], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["mh2", "s"]}], ")"}], 
       RowBox[{"1", "-", 
        RowBox[{"2", "e"}]}]], " ", 
      SuperscriptBox["v", 
       RowBox[{"-", "e"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", "omv", ")"}], 
       RowBox[{"-", "e"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"substu", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "\[Rule]", " ", 
        RowBox[{
         RowBox[{"-", "s"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["mh2", "s"]}], ")"}], 
         RowBox[{"(", "omv", ")"}]}]}], ",", " ", 
       RowBox[{"u", "\[Rule]", " ", 
        RowBox[{
         RowBox[{"-", "s"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["mh2", "s"]}], ")"}], "v"}]}], " ", ",", 
       RowBox[{"s", "\[Rule]", " ", 
        RowBox[{"mh2", "/", "z"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cGamma", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "16"}], ")"}], "/", 
       RowBox[{"Pi", "^", "2"}]}], " ", 
      RowBox[{"mh2", "^", 
       RowBox[{"(", 
        RowBox[{"-", "e"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", " ", "Pi"}], ")"}], "^", "e"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "e"}], "]"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "-", "e"}], "]"}], "^", "2"}], "/", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "e"}]}], "]"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"pgg", "=", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"PlusDistribution", "[", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], "/", "z"}], "+", 
        RowBox[{"z", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"11", "/", "12"}], " ", 
         RowBox[{"DeltaFunction", "[", 
          RowBox[{"1", "-", "z"}], "]"}]}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s0", "=", "z"}], ";"}]}]}]], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["CDR", "Subsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"intando", "=", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"FullSimplify", "[", 
       FractionBox[
        RowBox[{"RealD", " ", "PS", " ", "c\[CapitalGamma]"}], "cGamma"], 
       "]"}], "//.", "\[InvisibleSpace]", "substu"}], "]"}], "/.", 
    "\[InvisibleSpace]", 
    RowBox[{"omv", "\[Rule]", 
     RowBox[{"1", "-", "v"}]}]}]}], ";"}], "\n", 
 RowBox[{"intando", "=", 
  FractionBox["intando", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "e"}], "-", "1"}]]]}]}], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c\[CapitalGamma]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "mh2"], ")"}], "e"], " ", 
      SuperscriptBox["mh2", "e"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "v"}], ")"}], 
       RowBox[{
        RowBox[{"-", "e"}], "-", "1"}]], " ", 
      SuperscriptBox["v", 
       RowBox[{
        RowBox[{"-", "e"}], "-", "1"}]], " ", 
      SuperscriptBox["z", "e"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "v"}], ")"}], "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["z", "2"], "+", "1"}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "v"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["v", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"z", "-", "1"}], ")"}], "2"]}], "+", 
              SuperscriptBox["z", "2"], "+", "1"}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["z", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"]}], "+", "3"}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "v"}], ")"}], "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "4"]}], "+", 
           RowBox[{
            SuperscriptBox["v", "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}], "4"]}], "+", 
           SuperscriptBox["z", "4"], "+", "1"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "e"}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"e", "-", "1"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"1", "-", "e"}], ")"}], "3"], " ", 
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"e", "+", "1"}], ")"}]}], ")"}]}]}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"intando", ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", " ", 
      RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}], "//", 
    "PowerExpand"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"\[Sigma]r", ",", 
        RowBox[{"{", 
         RowBox[{"e", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], "//", 
     "Factor"}], "//", "FullSimplify"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]r", " ", "=", 
   RowBox[{"\[Sigma]r", "  ", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"-", "1"}], 
        RowBox[{"2", "e"}]], 
       RowBox[{"DeltaFunction", "[", 
        RowBox[{"1", "-", "z"}], "]"}]}], "+", 
      RowBox[{"PlusDistribution", "[", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", "z"}], ")"}]}], "]"}], "-", 
      RowBox[{"2", " ", "e", " ", 
       RowBox[{"PlusDistribution", "[", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "z"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"\[Sigma]r", "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", "e", "+", 
          RowBox[{"e", "^", "2"}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}], "//", 
    "Expand"}]}], ";"}]}], "Input",
 PageWidth->PaperWidth]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Results", "Section"],

Cell[CellGroupData[{

Cell["Virtual+Real+Counterterms  in CDR", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]rn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[Sigma]r", "/", "c\[CapitalGamma]"}], "/", "\[Pi]"}], "/", 
      "2"}], " ", "CA"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "e"}], " ", "2", " ", "Pgg", " ", "z", " ", "CA"}], 
    "+", 
    RowBox[{
     RowBox[{"1", "/", "e"}], " ", "2", " ", "pgg", " ", "z", " ", "CA"}]}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]rn", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"\[Sigma]rn", ",", 
            RowBox[{"DeltaFunction", "[", 
             RowBox[{"1", "-", "z"}], "]"}]}], "]"}], "/.", 
          RowBox[{"z", "\[Rule]", "1"}]}], "//", "FullSimplify"}], ")"}], "*", 
       RowBox[{"DeltaFunction", "[", 
        RowBox[{"1", "-", "z"}], "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"\[Sigma]rn", ",", 
            RowBox[{"PlusDistribution", "[", 
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], "]"}], "//", 
          "FullSimplify"}], ")"}], ")"}], 
       RowBox[{"PlusDistribution", "[", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"\[Sigma]rn", ",", 
            RowBox[{"PlusDistribution", "[", 
             RowBox[{
              RowBox[{"Log", "[", 
               RowBox[{"1", "-", "z"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], "]"}], "//", 
          "FullSimplify"}], ")"}], ")"}], 
       RowBox[{"PlusDistribution", "[", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "z"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Sigma]rn", "/.", 
         RowBox[{
          RowBox[{"DeltaFunction", "[", "x_", "]"}], "\[Rule]", "0"}]}], "/.", 
        RowBox[{
         RowBox[{"PlusDistribution", "[", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"1", "-", "z"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", "z"}], ")"}]}], "]"}], "\[Rule]", "0"}]}], "/.", 
       RowBox[{
        RowBox[{"PlusDistribution", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", "z"}], ")"}]}], "]"}], "\[Rule]", "0"}]}], 
      ")"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]rn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"\[Sigma]rn", ",", 
             RowBox[{
              RowBox[{"1", "/", "e"}], " ", 
              RowBox[{"PlusDistribution", "[", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", "z"}], ")"}]}], "//", "FullSimplify"}], ")"}], 
        ")"}], 
       RowBox[{"1", "/", "e"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"\[Sigma]rn", "-", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"\[Sigma]rn", ",", 
          RowBox[{
           RowBox[{"1", "/", "e"}], " ", 
           RowBox[{"PlusDistribution", "[", 
            RowBox[{"1", "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}]}], "]"}], 
        RowBox[{"1", "/", "e"}], " ", 
        RowBox[{"PlusDistribution", "[", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}]}], ")"}]}], "//", 
    "Expand"}]}], ";"}]}], "Input",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divD", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"\[Sigma]rn", ",", 
     RowBox[{"DeltaFunction", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}], "]"}], "*", 
   RowBox[{
    RowBox[{"as", "/", "2"}], "/", "\[Pi]"}], " ", 
   "c\[CapitalGamma]"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"as", " ", "c\[CapitalGamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"11", " ", 
        SubscriptBox["C", "A"]}], 
       RowBox[{"3", " ", "e"}]], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        SubscriptBox["C", "A"]}], 
       SuperscriptBox["e", "2"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SubscriptBox["C", "A"]}], "3"]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UVC", "=", " ", 
  RowBox[{
   RowBox[{"1", "/", "e"}], " ", "4", "*", 
   FractionBox[
    RowBox[{"-", "11"}], "6"], "CA", " ", 
   FractionBox["as", 
    RowBox[{"4", "\[Pi]"}]], "c\[CapitalGamma]", " "}]}]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"11", " ", "as", " ", 
     SubscriptBox["C", "A"], " ", "c\[CapitalGamma]"}], 
    RowBox[{"6", " ", "e", " ", "\[Pi]"}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"divD", "+", "UVC"}], ")"}], "/", "as"}], "/", 
      "c\[CapitalGamma]"}], " ", "2", " ", "\[Pi]"}], "//", "Expand"}], ")"}],
   " ", "as", " ", 
  RowBox[{
   RowBox[{"c\[CapitalGamma]", "/", "2"}], "/", "\[Pi]"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"as", " ", "c\[CapitalGamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        SubscriptBox["C", "A"]}], 
       SuperscriptBox["e", "2"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SubscriptBox["C", "A"]}], "3"], "+", 
      FractionBox[
       SubscriptBox["C", "A"], "3"]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sally", "=", 
   RowBox[{
    RowBox[{"as", "/", "\[Pi]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "11"}], "/", "2"}], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "z"}], ")"}], "^", "3"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"z", "^", "4"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "z"}], ")"}], "^", "4"}]}], ")"}], " ", 
       RowBox[{"PlusDistribution", "[", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "z"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"z", "^", "2"}], " ", 
          RowBox[{"PlusDistribution", "[", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], "+", 
         RowBox[{
          RowBox[{"z", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "z"}], ")"}]}]}], ")"}], 
       RowBox[{"Log", "[", "z", "]"}]}]}], ")"}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Sigma]rn", "*", 
            RowBox[{
             RowBox[{"as", "/", "2"}], "/", "\[Pi]"}]}], "/.", 
           RowBox[{
            RowBox[{"DeltaFunction", "[", "x_", "]"}], "\[Rule]", "0"}]}], 
          ")"}], "-", "sally"}], "/.", 
        RowBox[{"CA", "\[Rule]", "3"}]}], "/.", 
       RowBox[{"Pgg", "\[Rule]", "0"}]}], "//", "Expand"}], "//", 
     "Simplify"}], ")"}], "/.", 
   RowBox[{
    RowBox[{"PlusDistribution", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}]}], "]"}], "\[Rule]", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}]}]}], "//", "Factor"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gluon initiated process", "Section",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell["Kinematics for the Born", "Subsection",
 PageWidth->PaperWidth],

Cell["\<\
-----I take all momenta outgoing  

     p1 + p2 + p3  = 0     
     
     p1^2=0
     p2^2=0
     p3^3=Q^2
     

        \
\>", "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], "=", "Q2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "=", 
   RowBox[{"Q2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", " ", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p2", ",", "e1"}], "]"}], "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "Q2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{"Q2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", " ", "Q2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e2", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e1", ",", 
     RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Real Amplitude", "Subsection",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Emme", "=", 
   RowBox[{"CF", " ", 
    RowBox[{"1", "/", "s"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "+", 
         RowBox[{"u", "^", "2"}]}], ")"}], " ", "-", 
       RowBox[{"e", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s", "+", "u"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
     "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RealD", "=", 
   RowBox[{"Emme", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "e"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Real4", "=", 
   RowBox[{"RealD", "/.", " ", 
    RowBox[{"e", "\[Rule]", "0"}]}]}], ";"}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integration over the phase space in D dimensions", "Subsection",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PS", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", "\[Pi]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"4", " ", "\[Pi]", " "}], "mh2"], ")"}], "e"], 
    FractionBox["1", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "-", "e"}], "]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["mh2", "s"], ")"}], "e"], "  ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["mh2", "s"]}], ")"}], 
     RowBox[{"1", "-", 
      RowBox[{"2", "e"}]}]], " ", 
    SuperscriptBox["v", 
     RowBox[{"-", "e"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "v"}], ")"}], 
     RowBox[{"-", "e"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"substu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", "s"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["mh2", "s"]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "v"}], ")"}]}]}], ",", " ", 
     RowBox[{"u", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"-", "s"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["mh2", "s"]}], ")"}], "v"}]}], " ", ",", 
     RowBox[{"s", "\[Rule]", " ", 
      RowBox[{"mh2", "/", "z"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cGamma", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "16"}], ")"}], "/", 
     RowBox[{"Pi", "^", "2"}]}], " ", 
    RowBox[{"mh2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "e"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", " ", "Pi"}], ")"}], "^", "e"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "e"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "-", "e"}], "]"}], "^", "2"}], "/", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "e"}]}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pgq", "=", 
   RowBox[{
    RowBox[{"CF", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], "2"], "+", "1"}], ")"}], "/", 
      "z"}]}], " ", "//", "Factor"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell["dim-reg", "Subsubsection",
 PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"RealD", " ", "PS", " ", 
           RowBox[{"c\[CapitalGamma]", "/", "cGamma"}]}], " ", "//", 
          "Simplify"}], ")"}], "//.", " ", "substu"}], "//", "Expand"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", " ", 
      RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}], "//", 
    "Simplify"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"\[Sigma]r", "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", " ", "e"}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"e", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}], "/.", " ", 
     RowBox[{
      RowBox[{"gs", "^", "2"}], " ", "\[Rule]", " ", 
      RowBox[{"as", " ", "4", " ", "\[Pi]"}]}]}], " ", "//", 
    "FullSimplify"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Sigma]r"}], "/", "c\[CapitalGamma]"}], "/", "\[Pi]"}], 
     "/", "2"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "e"}], " ", "z", "   ", "Pgq"}], " ", "+", 
    RowBox[{
     RowBox[{"1", "/", "e"}], "  ", "z", "  ", "pgq"}]}]}], ";"}], "\n", 
 RowBox[{"\[Sigma]r", "=", 
  RowBox[{
   RowBox[{"\[Sigma]r", "//", "PowerExpand"}], "//", "Expand"}]}]}], "Input",
 PageWidth->PaperWidth],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["z", "2"], " ", 
     SubscriptBox["C", "F"]}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "2"], " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", "z", ")"}]}], "+", 
   RowBox[{"3", " ", "z", " ", 
    SubscriptBox["C", "F"]}], "-", 
   RowBox[{"4", " ", "z", " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "+", 
   RowBox[{"2", " ", "z", " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", "z", ")"}]}], "+", 
   RowBox[{"4", " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "-", 
   RowBox[{"2", " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"log", "(", "z", ")"}]}], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SubscriptBox["C", "F"]}], "2"], "-", 
   FractionBox[
    RowBox[{"Pgq", " ", "z"}], "e"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.6925287222347727`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sally", "=", 
  RowBox[{"2", "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "  ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "z"}], ")"}]}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"3", "z"}]}], ")"}], "/", "3"}]}], " ", "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "z", " ", "pgq", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "z"}], "]"}]}], "-", 
        RowBox[{"Log", "[", "z", "]"}]}], ")"}]}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Sigma]r", "-", " ", "sally"}], ")"}], "/.", " ", 
     RowBox[{"CF", "->", 
      RowBox[{"4", "/", "3"}]}]}], "/.", " ", 
    RowBox[{"Pgq", "\[Rule]", "0"}]}], ")"}], "//", "Simplify"}]}], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", 
        RowBox[{"2", " ", "z"}], "+", "2"}], ")"}], " ", 
      SubscriptBox["C", "F"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "z"}], ")"}]}], "-", 
        RowBox[{"log", "(", "z", ")"}], "+", "1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        RowBox[{"3", " ", "z"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.692528722627721*^9}],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellChangeTimes->{3.6925287226323357`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1049, 665},
WindowMargins->{{98, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 142, 2, 148, "Title"],
Cell[CellGroupData[{
Cell[746, 28, 60, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[831, 33, 89, 2, 28, "Input"],
Cell[923, 37, 603, 13, 24, "Message"],
Cell[1529, 52, 151, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1717, 60, 109, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[1851, 66, 2390, 64, 25, "Print"],
Cell[4244, 132, 1130, 30, 25, "Print"],
Cell[5377, 164, 258, 5, 26, "Print"],
Cell[5638, 171, 272, 5, 26, "Print"]
}, Open  ]]
}, Open  ]],
Cell[5937, 180, 103, 3, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6077, 188, 74, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[6176, 193, 56, 1, 44, "Subsection"],
Cell[6235, 196, 171, 12, 201, "Text"],
Cell[6409, 210, 3591, 116, 386, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10037, 331, 70, 1, 44, "Subsection"],
Cell[10110, 334, 1432, 59, 170, "Text"],
Cell[11545, 395, 3106, 100, 301, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14688, 500, 66, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[14779, 505, 939, 28, 148, "Input"],
Cell[15721, 535, 195, 3, 28, "Output"],
Cell[15919, 540, 525, 17, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16481, 562, 1716, 49, 80, "Input"],
Cell[18200, 613, 397, 10, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18646, 629, 206, 5, 94, "Subsection"],
Cell[18855, 636, 4351, 120, 352, "Input"],
Cell[23209, 758, 26, 0, 28, "Input"],
Cell[23238, 760, 26, 0, 28, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23313, 766, 22, 0, 64, "Section"],
Cell[CellGroupData[{
Cell[23360, 770, 61, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[23446, 775, 2964, 92, 267, "Input"],
Cell[26413, 869, 398, 15, 33, "Output"],
Cell[26814, 886, 1373, 42, 56, "Output"]
}, Open  ]],
Cell[28202, 931, 26, 0, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28265, 936, 62, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[28352, 941, 2218, 71, 233, "Input"],
Cell[30573, 1014, 984, 30, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31606, 1050, 38, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[31669, 1054, 2077, 58, 233, "Input"],
Cell[33749, 1114, 872, 22, 50, "Output"],
Cell[34624, 1138, 579, 14, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35240, 1157, 1039, 30, 131, "Input"],
Cell[36282, 1189, 441, 12, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36772, 1207, 129, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[36926, 1212, 1506, 44, 199, "Input"],
Cell[38435, 1258, 299, 6, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38771, 1269, 1345, 41, 118, "Input"],
Cell[40119, 1312, 730, 20, 59, "Output"],
Cell[40852, 1334, 851, 24, 59, "Output"],
Cell[41706, 1360, 635, 17, 59, "Output"]
}, Open  ]],
Cell[42356, 1380, 45, 0, 46, "Input"],
Cell[CellGroupData[{
Cell[42426, 1384, 171, 6, 28, "Input"],
Cell[42600, 1392, 181, 6, 52, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42842, 1405, 65, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[42932, 1410, 56, 1, 44, "Subsection"],
Cell[42991, 1413, 701, 37, 676, "Text"],
Cell[43695, 1452, 3054, 105, 318, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46786, 1562, 70, 1, 44, "Subsection"],
Cell[46859, 1565, 1432, 59, 170, "Text"],
Cell[48294, 1626, 1942, 57, 233, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50273, 1688, 57, 0, 44, "Subsection"],
Cell[50333, 1690, 419, 10, 104, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50789, 1705, 137, 3, 44, "Subsection"],
Cell[50929, 1710, 396, 10, 104, "Input"],
Cell[CellGroupData[{
Cell[51350, 1724, 124, 3, 29, "Input"],
Cell[51477, 1729, 2906, 76, 98, "Output"]
}, Open  ]],
Cell[54398, 1808, 57, 3, 44, "Input"],
Cell[CellGroupData[{
Cell[54480, 1815, 98, 1, 28, "Input"],
Cell[54581, 1818, 2131, 64, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56761, 1888, 84, 1, 44, "Subsection"],
Cell[56848, 1891, 1388, 43, 131, "Input"],
Cell[CellGroupData[{
Cell[58261, 1938, 652, 17, 28, "Input"],
Cell[58916, 1957, 2228, 66, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61193, 2029, 73, 1, 44, "Subsection"],
Cell[61269, 2032, 2906, 93, 260, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64212, 2130, 49, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[64286, 2135, 636, 20, 92, "Input"],
Cell[64925, 2157, 3179, 92, 109, "Output"]
}, Open  ]],
Cell[68119, 2252, 1760, 55, 240, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69928, 2313, 26, 0, 64, "Section"],
Cell[CellGroupData[{
Cell[69979, 2317, 55, 0, 44, "Subsection"],
Cell[70037, 2319, 4178, 125, 369, "Input"],
Cell[CellGroupData[{
Cell[74240, 2448, 301, 9, 28, "Input"],
Cell[74544, 2459, 551, 18, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75132, 2482, 244, 7, 49, "Input"],
Cell[75379, 2491, 222, 6, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75638, 2502, 359, 12, 28, "Input"],
Cell[76000, 2516, 493, 16, 64, "Output"]
}, Open  ]],
Cell[76508, 2535, 1311, 41, 63, "Input"],
Cell[77822, 2578, 845, 27, 46, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78716, 2611, 66, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[78807, 2616, 69, 1, 44, "Subsection"],
Cell[78879, 2619, 171, 12, 201, "Text"],
Cell[79053, 2633, 3591, 116, 386, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82681, 2754, 60, 1, 44, "Subsection"],
Cell[82744, 2757, 738, 25, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83519, 2787, 94, 1, 44, "Subsection"],
Cell[83616, 2790, 2373, 82, 212, "Input"],
Cell[CellGroupData[{
Cell[86014, 2876, 56, 1, 35, "Subsubsection"],
Cell[CellGroupData[{
Cell[86095, 2881, 1586, 48, 165, "Input"],
Cell[87684, 2931, 1212, 38, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88933, 2974, 925, 30, 46, "Input"],
Cell[89861, 3006, 792, 26, 48, "Output"],
Cell[90656, 3034, 100, 2, 28, "Output"]
}, Open  ]],
Cell[90771, 3039, 26, 0, 28, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

