(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    234051,       7934]
NotebookOptionsPosition[    230355,       7801]
NotebookOutlinePosition[    230715,       7817]
CellTagsIndexPosition[    230672,       7814]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.693214928496599*^9}],

Cell[CellGroupData[{

Cell["BUSSTEP 2018: Exercises for QCD and collider physics", "Title",
 CellChangeTimes->{{3.6926133610426397`*^9, 3.6926133940467367`*^9}, {
  3.74436138565263*^9, 3.7443613983705072`*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc (change to your installation)", "Subsection",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692943673110405*^9, 3.692943679690876*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"<<", "HighEnergyPhysics`fc`"}], "*)"}]], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692943682731015*^9, 3.6929436847790537`*^9}}],

Cell[BoxData[
 RowBox[{"<<", 
  "\"\</Users/marcozaro/Physics/feyncalc-master/FeynCalc/fc.m\>\""}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.1: 4-gluon vertex", "Chapter",
 CellChangeTimes->{{3.692613426285159*^9, 3.6926134324672422`*^9}, {
  3.6926219265062923`*^9, 3.69262192669018*^9}}],

Cell[CellGroupData[{

Cell["Verteces and Propagators", "Subsection",
 PageWidth->PaperWidth],

Cell[TextData[{
 StyleBox["GGG is the kinematic part of the three-gluon vtx (momenta \
outgoing, clockwise ordering):\nVTX(ggg) = (-\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ) (\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "abc"], TraditionalForm]],
  FontSize->14],
 StyleBox[") GGG\nVTX(qqg) = ( -\[ImaginaryI] ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "s"], TraditionalForm]],
  FontSize->14],
 ")",
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"(", 
     SuperscriptBox["T", "a"], ")"}], "ij"], TraditionalForm]],
  FontSize->14],
 StyleBox[" ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]],
  FontSize->14],
 StyleBox["\nGluon Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["g", "\[Mu]\[Nu]"]}],
     FontSize->16], 
    SuperscriptBox["p", "2"]], TraditionalForm]],
  FontSize->14],
 "\nQuark ",
 StyleBox["Propagator= ",
  FontSize->14],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"\[ImaginaryI]", " "}],
     FontSize->16], 
    OverscriptBox["p", "^"]], TraditionalForm]],
  FontSize->14]
}], "Text",
 PageWidth->PaperWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GGG", "[", 
    RowBox[{
    "p1_", ",", "p2_", ",", "p3_", ",", "m1_", ",", "m2_", ",", "m3_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p1", "-", "p2"}], ",", "m3"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m2"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p2", "-", "p3"}], ",", "m1"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m2", ",", "m3"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FourVector", "[", 
      RowBox[{
       RowBox[{"p3", "-", "p1"}], ",", "m2"}], "]"}], " ", 
     RowBox[{"MT", "[", 
      RowBox[{"m1", ",", "m3"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PropQuark", "=", "I"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PropGluon", "[", 
    RowBox[{"p_", ",", "mu_", ",", "nu_"}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"I", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"MT", "[", 
          RowBox[{"mu", ",", "nu"}], "]"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Xi]"}], ")"}], 
         RowBox[{"FV", "[", 
          RowBox[{"p", ",", "mu"}], "]"}], 
         RowBox[{
          RowBox[{"FV", "[", 
           RowBox[{"p", ",", "nu"}], "]"}], "/", 
          RowBox[{"SP", "[", "p", "]"}]}]}]}], ")"}], "/", 
      RowBox[{"SP", "[", "p", "]"}]}]}], "//", "ExpandScalarProduct"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vtx", "=", 
   RowBox[{
    RowBox[{"-", "I"}], " ", "gs"}]}], ";"}]}], "Input",
 PageWidth->PaperWidth,
 CellChangeTimes->{{3.692613545298967*^9, 3.692613576234826*^9}, {
  3.692615113418083*^9, 3.69261518221594*^9}, {3.692615289413321*^9, 
  3.6926152953216248`*^9}, {3.692619057332005*^9, 3.692619059218863*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar products (p1 p2 > p3 p4)", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p4", ",", "p4"}], "]"}], " ", "=", " ", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "e1"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "e2"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "e3"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p4", ",", "e4"}], "]"}], " ", "=", " ", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.692613638907701*^9, 3.692613661866912*^9}, {
   3.692616305122611*^9, 3.692616330720419*^9}, {3.6926163755266438`*^9, 
   3.692616402595954*^9}, {3.692616457656052*^9, 3.692616495830961*^9}, {
   3.692616545674967*^9, 3.692616651884303*^9}, {3.6926167096078253`*^9, 
   3.692616713317981*^9}, {3.692616874648031*^9, 3.692616886428197*^9}, {
   3.692616941697814*^9, 3.6926169483044987`*^9}, {3.692617048978189*^9, 
   3.6926170523196774`*^9}, 3.692940715985712*^9, {3.692941530040926*^9, 
   3.692941559445057*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "check", " ", "that", " ", "everything", " ", "is", " ", "consistent"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.692941543394758*^9, 3.69294155349966*^9}, 
   3.69312402160058*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SP", "[", 
    RowBox[{"p1", "+", "p2", "-", "p3", "-", "p4"}], "]"}], "//", 
   "ExpandScalarProduct"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.692614045713563*^9, 3.692614059870042*^9}, {
  3.6926146056833763`*^9, 3.692614611937336*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"s", "+", "t", "+", "u"}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692614052820998*^9, 3.692614060801106*^9}, 
   3.692614612344434*^9, 3.692615217236927*^9, 3.6926153042645206`*^9, 
   3.692616414235757*^9, {3.692616477002037*^9, 3.692616505938065*^9}, 
   3.692616661409111*^9, 3.692616726099124*^9, 3.69261689455098*^9, 
   3.692616957471612*^9, 3.692617062422418*^9, 3.6926172366788588`*^9, 
   3.692617355272015*^9, 3.692617930682822*^9, 3.692619069069003*^9, 
   3.6926220577810163`*^9, 3.692939282165938*^9, 3.6929407310064096`*^9, 
   3.692941450708425*^9, 3.693124017639719*^9, 3.693124176364273*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Let us re-derive the case for q(p2) qx(p1) > g g. Excluding the 3-gluon \
vertex, there are two diagrams\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692939027863969*^9, 
  3.692939066178437*^9}, {3.692939656978591*^9, 3.692939660888845*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"diag1", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SpinorV", "[", "p1", "]"}], ".", 
      RowBox[{"GA", "[", "mu3", "]"}], ".", 
      RowBox[{"GS", "[", 
       RowBox[{"p1", "-", "p3"}], "]"}], ".", 
      RowBox[{"GA", "[", "mu4", "]"}], ".", 
      RowBox[{"SpinorU", "[", "p2", "]"}]}], " ", 
     RowBox[{
      RowBox[{"SUNT", "[", "a3", "]"}], ".", 
      RowBox[{"SUNT", "[", "a4", "]"}]}], 
     RowBox[{"1", "/", 
      RowBox[{"SP", "[", 
       RowBox[{"p1", "-", "p3"}], "]"}]}]}], "//", "ExpandScalarProduct"}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"diag2", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SpinorV", "[", "p1", "]"}], ".", 
     RowBox[{"GA", "[", "mu4", "]"}], ".", 
     RowBox[{"GS", "[", 
      RowBox[{"p2", "-", "p3"}], "]"}], ".", 
     RowBox[{"GA", "[", "mu3", "]"}], ".", 
     RowBox[{"SpinorU", "[", "p2", "]"}]}], " ", 
    RowBox[{
     RowBox[{"SUNT", "[", "a4", "]"}], ".", 
     RowBox[{"SUNT", "[", "a3", "]"}]}], 
    RowBox[{"1", "/", 
     RowBox[{"SP", "[", 
      RowBox[{"p1", "-", "p4"}], "]"}]}]}], "//", 
   "ExpandScalarProduct"}]}]}], "Input",
 CellChangeTimes->{{3.6929390728150377`*^9, 3.692939081998135*^9}, {
  3.692939120935576*^9, 3.692939317921928*^9}, {3.692939463980194*^9, 
  3.6929395071402483`*^9}, {3.6931240307916517`*^9, 3.6931240351412783`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      FormBox[
       FormBox["a3",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["T", 
      FormBox[
       FormBox["a4",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p1",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}], ".", 
     SuperscriptBox[
      OverscriptBox["\[Gamma]", "_"], 
      FormBox[
       FormBox["mu3",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", "(", 
       FormBox[
        FormBox[
         RowBox[{
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"], "-", 
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"]}],
         TraditionalForm],
        TraditionalForm], ")"}], ")"}], ".", 
     SuperscriptBox[
      OverscriptBox["\[Gamma]", "_"], 
      FormBox[
       FormBox["mu4",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p2",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}]}]}], "t"], TraditionalForm]], "Output",
 CellChangeTimes->{3.693124035741987*^9, 3.6931241763941708`*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      FormBox[
       FormBox["a4",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["T", 
      FormBox[
       FormBox["a3",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p1",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}], ".", 
     SuperscriptBox[
      OverscriptBox["\[Gamma]", "_"], 
      FormBox[
       FormBox["mu4",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", "(", 
       FormBox[
        FormBox[
         RowBox[{
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"], "-", 
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"]}],
         TraditionalForm],
        TraditionalForm], ")"}], ")"}], ".", 
     SuperscriptBox[
      OverscriptBox["\[Gamma]", "_"], 
      FormBox[
       FormBox["mu3",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p2",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}]}]}], "u"], TraditionalForm]], "Output",
 CellChangeTimes->{3.693124035741987*^9, 3.693124176399372*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We check gauge invariance by contracting the amplitude with the gluon \
momentum (p3) instead of the polarisation e3\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692939027863969*^9, 
  3.692939066178437*^9}, {3.692939656978591*^9, 3.692939660888845*^9}, {
  3.692941076605266*^9, 3.692941138816452*^9}, {3.692941201395165*^9, 
  3.692941212146483*^9}, {3.692941490672728*^9, 3.692941504694332*^9}, {
  3.692943492248446*^9, 3.692943559761331*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ampqqgg", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"diag1", "+", "diag2"}], ")"}], " ", 
      RowBox[{"FV", "[", 
       RowBox[{"p3", ",", "mu3"}], "]"}], " ", 
      RowBox[{"FV", "[", 
       RowBox[{"e4", ",", "mu4"}], "]"}]}], "//", "Contract"}], "//", 
    "Simplify"}], "//", "DiracSimplify2"}]}]], "Input",
 CellChangeTimes->{{3.6929393019278107`*^9, 3.692939408564536*^9}, 
   3.6929394479749527`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["T", 
      FormBox[
       FormBox["a3",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["T", 
      FormBox[
       FormBox["a4",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p1",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
       FormBox[
        OverscriptBox[
         FormBox["e4",
          TraditionalForm], "_"],
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[CurlyPhi]\"\>",
        TraditionalForm], 
       FormBox["\<\"(\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p2",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\")\"\>",
        TraditionalForm]}], ")"}]}]}], "-", 
   RowBox[{
    SuperscriptBox["T", 
     FormBox[
      FormBox["a4",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["T", 
     FormBox[
      FormBox["a3",
       TraditionalForm],
      TraditionalForm]], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[CurlyPhi]\"\>",
       TraditionalForm], 
      FormBox["\<\"(\"\>",
       TraditionalForm], 
      FormBox[
       OverscriptBox[
        FormBox["p1",
         TraditionalForm], "_"],
       TraditionalForm], 
      FormBox["\<\")\"\>",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
      FormBox[
       OverscriptBox[
        FormBox["e4",
         TraditionalForm], "_"],
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[CurlyPhi]\"\>",
       TraditionalForm], 
      FormBox["\<\"(\"\>",
       TraditionalForm], 
      FormBox[
       OverscriptBox[
        FormBox["p2",
         TraditionalForm], "_"],
       TraditionalForm], 
      FormBox["\<\")\"\>",
       TraditionalForm]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692939364247861*^9, 3.69293937171659*^9}, 
   3.692939409260255*^9, {3.692939448343082*^9, 3.692939514106633*^9}, 
   3.6929407311426497`*^9, 3.692941450846944*^9, 3.6931241765470257`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Let us try to build the 3-glu vertex starting from this result, uncontracting \
some Lorentz indexes \
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692939027863969*^9, 
  3.692939066178437*^9}, {3.692939656978591*^9, 3.692939660888845*^9}, {
  3.692941076605266*^9, 3.692941138816452*^9}, {3.692941201395165*^9, 
  3.692941212146483*^9}, {3.692941490672728*^9, 3.692941504694332*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diag3", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SpinorV", "[", "p1", "]"}], ".", 
      RowBox[{"GA", "[", "mu", "]"}], ".", 
      RowBox[{"SpinorU", "[", "p2", "]"}]}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"mu", ",", "nua"}], "]"}], 
       RowBox[{"1", "/", 
        RowBox[{"SP", "[", 
         RowBox[{"p1", "+", "p2"}], "]"}]}]}], ")"}], 
     RowBox[{"FV", "[", 
      RowBox[{"e4", ",", "nub"}], "]"}], " ", 
     RowBox[{"FV", "[", 
      RowBox[{"p3", ",", "nuc"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"nub", ",", "nua"}], "]"}], 
       RowBox[{"FV", "[", 
        RowBox[{
         RowBox[{"p4", "+", 
          RowBox[{"(", 
           RowBox[{"p3", "+", "p4"}], ")"}]}], ",", "nuc"}], "]"}]}], " ", 
      ")"}]}], "//", "Contract"}], "//", "DiracSimplify"}]}]], "Input",
 CellChangeTimes->{{3.6929396422623243`*^9, 3.692939748150084*^9}, {
  3.692939799828507*^9, 3.692939816926909*^9}, {3.6929399094098043`*^9, 
  3.692939910766464*^9}, {3.692940112132062*^9, 3.692940229822454*^9}, {
  3.6929402657779408`*^9, 3.692940315577467*^9}, {3.692940370143971*^9, 
  3.6929404297212353`*^9}, {3.692940478023863*^9, 3.692940491686718*^9}, {
  3.692940538480098*^9, 3.6929406150288963`*^9}, {3.692940658281687*^9, 
  3.6929406794289303`*^9}, {3.692940959878302*^9, 3.692940980258583*^9}, {
  3.692941057736762*^9, 3.692941059050293*^9}, {3.692941180909075*^9, 
  3.692941181860361*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[CurlyPhi]\"\>",
      TraditionalForm], 
     FormBox["\<\"(\"\>",
      TraditionalForm], 
     FormBox[
      OverscriptBox[
       FormBox["p1",
        TraditionalForm], "_"],
      TraditionalForm], 
     FormBox["\<\")\"\>",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
     FormBox[
      OverscriptBox[
       FormBox["e4",
        TraditionalForm], "_"],
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[CurlyPhi]\"\>",
      TraditionalForm], 
     FormBox["\<\"(\"\>",
      TraditionalForm], 
     FormBox[
      OverscriptBox[
       FormBox["p2",
        TraditionalForm], "_"],
      TraditionalForm], 
     FormBox["\<\")\"\>",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6929398058886127`*^9, 3.692939817251027*^9}, 
   3.692939911086081*^9, {3.692940190722788*^9, 3.692940199758647*^9}, 
   3.69294023131234*^9, 3.6929404936932573`*^9, {3.6929405609022093`*^9, 
   3.692940615525085*^9}, {3.6929406598057537`*^9, 3.692940680276863*^9}, 
   3.692940731291744*^9, 3.69294098067632*^9, 3.6929410656314793`*^9, 
   3.692941182193736*^9, 3.692941450889511*^9, 3.693124176599927*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
This gives the correct result (bar for the color factor). We can complete it \
by requiring that the momentum-space dependence of the 3-glu vertex is \
anti-symmetric, as the color part.\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692939027863969*^9, 
  3.692939066178437*^9}, {3.692939656978591*^9, 3.692939660888845*^9}, {
  3.692941076605266*^9, 3.692941138816452*^9}, {3.692941201395165*^9, 
  3.692941271647245*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diag3full", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SpinorV", "[", "p1", "]"}], ".", 
      RowBox[{"GA", "[", "mu", "]"}], ".", 
      RowBox[{"SpinorU", "[", "p2", "]"}]}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"mu", ",", "nua"}], "]"}], 
       RowBox[{"1", "/", 
        RowBox[{"SP", "[", 
         RowBox[{"p1", "+", "p2"}], "]"}]}]}], ")"}], 
     RowBox[{"FV", "[", 
      RowBox[{"e4", ",", "nub"}], "]"}], " ", 
     RowBox[{"FV", "[", 
      RowBox[{"p3", ",", "nuc"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"MT", "[", 
         RowBox[{"nub", ",", "nua"}], "]"}], 
        RowBox[{"FV", "[", 
         RowBox[{
          RowBox[{"p4", "+", 
           RowBox[{"(", 
            RowBox[{"p3", "+", "p4"}], ")"}]}], ",", "nuc"}], "]"}]}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"MT", "[", 
         RowBox[{"nua", ",", "nuc"}], "]"}], " ", 
        RowBox[{"FV", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"p3", "+", "p4"}], ")"}]}], "-", "p3"}], ",", "nub"}], 
         "]"}]}], "\[IndentingNewLine]", "+", 
       RowBox[{
        RowBox[{"MT", "[", 
         RowBox[{"nuc", ",", "nub"}], "]"}], 
        RowBox[{"FV", "[", 
         RowBox[{
          RowBox[{"p3", "-", "p4"}], ",", "nua"}], "]"}]}]}], ")"}]}], "//", 
    "Contract"}], "//", "DiracSimplify"}]}]], "Input",
 CellChangeTimes->{{3.6929396422623243`*^9, 3.692939748150084*^9}, {
  3.692939799828507*^9, 3.692939816926909*^9}, {3.6929399094098043`*^9, 
  3.692939910766464*^9}, {3.692940112132062*^9, 3.692940229822454*^9}, {
  3.6929402657779408`*^9, 3.692940315577467*^9}, {3.692940370143971*^9, 
  3.6929404297212353`*^9}, {3.692940478023863*^9, 3.692940491686718*^9}, {
  3.692940538480098*^9, 3.6929406150288963`*^9}, {3.692940658281687*^9, 
  3.6929406794289303`*^9}, {3.692940959878302*^9, 3.692940980258583*^9}, {
  3.692941057736762*^9, 3.692941059050293*^9}, {3.692941175141336*^9, 
  3.6929411755894213`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[CurlyPhi]\"\>",
       TraditionalForm], 
      FormBox["\<\"(\"\>",
       TraditionalForm], 
      FormBox[
       OverscriptBox[
        FormBox["p1",
         TraditionalForm], "_"],
       TraditionalForm], 
      FormBox["\<\")\"\>",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
      FormBox[
       OverscriptBox[
        FormBox["e4",
         TraditionalForm], "_"],
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[CurlyPhi]\"\>",
       TraditionalForm], 
      FormBox["\<\"(\"\>",
       TraditionalForm], 
      FormBox[
       OverscriptBox[
        FormBox["p2",
         TraditionalForm], "_"],
       TraditionalForm], 
      FormBox["\<\")\"\>",
       TraditionalForm]}], ")"}]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox[
        OverscriptBox[
         FormBox["e4",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\"\[CenterDot]\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p3",
          TraditionalForm], "_"],
        TraditionalForm]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[CurlyPhi]\"\>",
         TraditionalForm], 
        FormBox["\<\"(\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\")\"\>",
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[CurlyPhi]\"\>",
         TraditionalForm], 
        FormBox["\<\"(\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\")\"\>",
         TraditionalForm]}], ")"}]}]}], "s"], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox[
        OverscriptBox[
         FormBox["e4",
          TraditionalForm], "_"],
        TraditionalForm], 
       FormBox["\<\"\[CenterDot]\"\>",
        TraditionalForm], 
       FormBox[
        OverscriptBox[
         FormBox["p3",
          TraditionalForm], "_"],
        TraditionalForm]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[CurlyPhi]\"\>",
         TraditionalForm], 
        FormBox["\<\"(\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\")\"\>",
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Gamma]", "_"], "\[CenterDot]", 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[CurlyPhi]\"\>",
         TraditionalForm], 
        FormBox["\<\"(\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\")\"\>",
         TraditionalForm]}], ")"}]}]}], "s"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.692941175997158*^9, 3.692941450997813*^9, 
  3.693124176732133*^9}]
}, Open  ]]
}, Open  ]],

Cell["\<\
The two extra term cancel to zero because of the Dirac eq. (summing them one \
gets V[p1].GS[p3+p4].U[p2], plus momentum conservation( p3+p4=p1+p2)\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692939027863969*^9, 
  3.692939066178437*^9}, {3.692939656978591*^9, 3.692939660888845*^9}, {
  3.692941076605266*^9, 3.692941138816452*^9}, {3.692941201395165*^9, 
  3.692941364052196*^9}, {3.6931241116170073`*^9, 3.69312413253623*^9}}],

Cell[CellGroupData[{

Cell["\<\
Let us go back to the 4-gluon case. Excluding the 4-gluon vertex, there are 3 \
diagrams (s, t and u channel)\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692941372915619*^9, 
  3.692941383306806*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "A", " ", "bunch", " ", "of", " ", "new", " ", "scalar", " ", 
       "products"}], "..."}], " ", "\[IndentingNewLine]", "we", " ", 
     "eliminate", " ", "p4", " ", "in", " ", "the", " ", "SP", " ", "with", 
     " ", "the", " ", "polarisations", " ", "1"}], "-", "2", "-", 
    RowBox[{"3", " ", "using", " ", "momentum", " ", "conservation"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"p4", ",", "e1"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"SP", "[", 
       RowBox[{"p1", ",", "e1"}], "]"}], "+", 
      RowBox[{"SP", "[", 
       RowBox[{"p2", ",", "e1"}], "]"}], "-", 
      RowBox[{"SP", "[", 
       RowBox[{"p3", ",", "e1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"p4", ",", "e2"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"SP", "[", 
       RowBox[{"p1", ",", "e2"}], "]"}], "+", 
      RowBox[{"SP", "[", 
       RowBox[{"p2", ",", "e2"}], "]"}], "-", 
      RowBox[{"SP", "[", 
       RowBox[{"p3", ",", "e2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"p4", ",", "e3"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"SP", "[", 
       RowBox[{"p1", ",", "e3"}], "]"}], "+", 
      RowBox[{"SP", "[", 
       RowBox[{"p2", ",", "e3"}], "]"}], "-", 
      RowBox[{"SP", "[", 
       RowBox[{"p3", ",", "e3"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "we", " ", "eliminate", " ", "p3", " ", "in", " ", "the", " ", "SP", " ", 
     "with", " ", "the", " ", "polarisations", " ", "4", " ", "using", " ", 
     "momentum", " ", "conservation"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"p3", ",", "e4"}], "]"}], "=", 
     RowBox[{
      RowBox[{"SP", "[", 
       RowBox[{"p1", ",", "e4"}], "]"}], "+", 
      RowBox[{"SP", "[", 
       RowBox[{"p2", ",", "e4"}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.692943587077097*^9, 3.6929435966042624`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagS", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"vtx", " ", "^", "2"}], " ", 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{"-", "p1"}], ",", " ", 
        RowBox[{"p1", "+", "p2"}], ",", 
        RowBox[{"-", "p2"}], ",", " ", "mu1", ",", " ", "mu", ",", " ", 
        "mu2"}], "]"}], 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "p1"}], "-", "p2"}], ",", " ", "p3", ",", " ", "p4", 
        ",", " ", "nu", ",", " ", "mu3", ",", " ", "mu4"}], "]"}], 
      RowBox[{"PropGluon", "[", 
       RowBox[{
        RowBox[{"p1", "+", "p2"}], ",", " ", "mu", ",", "nu"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"SUNF", "[", 
          RowBox[{"a1", ",", "a", ",", "a2"}], "]"}], 
         RowBox[{"SUNF", "[", 
          RowBox[{"a", ",", "a3", ",", "a4"}], "]"}]}], "//", "SUNSimplify"}],
        ")"}]}], "//", "Contract"}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diagT", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"vtx", " ", "^", "2"}], 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{"-", "p1"}], ",", "p3", ",", 
        RowBox[{"p1", "-", "p3"}], ",", " ", "mu1", ",", " ", "mu3", ",", " ",
         "mu"}], "]"}], 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "p1"}], "+", "p3"}], ",", " ", "p4", ",", " ", 
        RowBox[{"-", "p2"}], ",", " ", "nu", ",", " ", "mu4", ",", " ", 
        "mu2"}], "]"}], 
      RowBox[{"PropGluon", "[", 
       RowBox[{
        RowBox[{"p1", "-", "p3"}], ",", " ", "mu", ",", "nu"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"SUNF", "[", 
          RowBox[{"a1", ",", "a3", ",", "a"}], "]"}], 
         RowBox[{"SUNF", "[", 
          RowBox[{"a", ",", "a4", ",", "a2"}], "]"}]}], "//", "SUNSimplify"}],
        ")"}]}], "//", "Contract"}], " ", "//", "Simplify"}]}], ";", 
  RowBox[{"diagU", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"vtx", " ", "^", "2"}], 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{"-", "p1"}], ",", "p4", ",", 
        RowBox[{"p1", "-", "p4"}], ",", " ", "mu1", ",", " ", "mu4", ",", " ",
         "mu"}], "]"}], 
      RowBox[{"GGG", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "p1"}], "+", "p4"}], ",", " ", "p3", ",", " ", 
        RowBox[{"-", "p2"}], ",", " ", "nu", ",", " ", "mu3", ",", " ", 
        "mu2"}], "]"}], 
      RowBox[{"PropGluon", "[", 
       RowBox[{
        RowBox[{"p1", "-", "p4"}], ",", " ", "mu", ",", "nu"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"SUNF", "[", 
          RowBox[{"a1", ",", "a4", ",", "a"}], "]"}], 
         RowBox[{"SUNF", "[", 
          RowBox[{"a", ",", "a3", ",", "a2"}], "]"}]}], "//", "SUNSimplify"}],
        ")"}]}], "//", "Contract"}], " ", "//", "Simplify"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.692613814880018*^9, 3.692613917818449*^9}, {
   3.692613950554772*^9, 3.692613957521719*^9}, {3.692614546932832*^9, 
   3.6926145619196043`*^9}, {3.6926146440022707`*^9, 3.692614736605809*^9}, 
   3.692614770819673*^9, {3.692614836052224*^9, 3.692614927950474*^9}, {
   3.692615225380364*^9, 3.692615282986795*^9}, {3.692615727869773*^9, 
   3.692615770909458*^9}, {3.692615892953589*^9, 3.6926159013934717`*^9}, {
   3.692615938099309*^9, 3.692615943833743*^9}, {3.692617190120591*^9, 
   3.69261722729668*^9}, {3.692617668883873*^9, 3.6926176872260857`*^9}, 
   3.692617920994087*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now we contract mu1 with p1 and all the other momenta with the physical \
polarizations\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}}],

Cell[CellGroupData[{

Cell[BoxData["diagU"], "Input",
 CellChangeTimes->{{3.692615926878953*^9, 3.692615928354073*^9}, {
  3.69261611622011*^9, 3.692616128241695*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["u", "2"]], 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["gs", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu4",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"s", "-", "t"}], ")"}], " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu3",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"2", " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{"2", " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p3",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          RowBox[{"(", 
           RowBox[{
            FormBox[
             SuperscriptBox[
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox[
               FormBox[
                FormBox["mu3",
                 TraditionalForm],
                TraditionalForm],
               TraditionalForm]],
             TraditionalForm], "+", 
            FormBox[
             SuperscriptBox[
              FormBox[
               OverscriptBox[
                FormBox["p4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox[
               FormBox[
                FormBox["mu3",
                 TraditionalForm],
                TraditionalForm],
               TraditionalForm]],
             TraditionalForm]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", "u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu3",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu4",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu4",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu4",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu4",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{"\[Xi]", " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu4",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p4",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu3",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu4",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "-", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p1",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", " ", 
             FormBox[
              SuperscriptBox[
               OverscriptBox["g", "_"], 
               RowBox[{
                FormBox[
                 FormBox[
                  FormBox["mu3",
                   TraditionalForm],
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox[
                  FormBox["mu4",
                   TraditionalForm],
                  TraditionalForm],
                 TraditionalForm]}]],
              TraditionalForm]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\[Xi]", "-", "1"}], ")"}], " ", 
             FormBox[
              SuperscriptBox[
               FormBox[
                OverscriptBox[
                 FormBox["p2",
                  TraditionalForm], "_"],
                TraditionalForm], 
               FormBox[
                FormBox[
                 FormBox["mu3",
                  TraditionalForm],
                 TraditionalForm],
                TraditionalForm]],
              TraditionalForm], " ", 
             FormBox[
              SuperscriptBox[
               FormBox[
                OverscriptBox[
                 FormBox["p1",
                  TraditionalForm], "_"],
                TraditionalForm], 
               FormBox[
                FormBox[
                 FormBox["mu4",
                  TraditionalForm],
                 TraditionalForm],
                TraditionalForm]],
              TraditionalForm]}]}], ")"}]}], "-", 
         RowBox[{
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p3",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu2",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", " ", 
             FormBox[
              SuperscriptBox[
               OverscriptBox["g", "_"], 
               RowBox[{
                FormBox[
                 FormBox[
                  FormBox["mu3",
                   TraditionalForm],
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox[
                  FormBox["mu4",
                   TraditionalForm],
                  TraditionalForm],
                 TraditionalForm]}]],
              TraditionalForm]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\[Xi]", "-", "1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               FormBox[
                SuperscriptBox[
                 FormBox[
                  OverscriptBox[
                   FormBox["p1",
                    TraditionalForm], "_"],
                  TraditionalForm], 
                 FormBox[
                  FormBox[
                   FormBox["mu3",
                    TraditionalForm],
                   TraditionalForm],
                  TraditionalForm]],
                TraditionalForm], "-", 
               FormBox[
                SuperscriptBox[
                 FormBox[
                  OverscriptBox[
                   FormBox["p4",
                    TraditionalForm], "_"],
                  TraditionalForm], 
                 FormBox[
                  FormBox[
                   FormBox["mu3",
                    TraditionalForm],
                   TraditionalForm],
                  TraditionalForm]],
                TraditionalForm]}], ")"}], " ", 
             FormBox[
              SuperscriptBox[
               FormBox[
                OverscriptBox[
                 FormBox["p1",
                  TraditionalForm], "_"],
                TraditionalForm], 
               FormBox[
                FormBox[
                 FormBox["mu4",
                  TraditionalForm],
                 TraditionalForm],
                TraditionalForm]],
              TraditionalForm]}]}], ")"}]}], "+", 
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu3",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p2",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu4",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}], "+", 
         RowBox[{"u", " ", 
          FormBox[
           SuperscriptBox[
            OverscriptBox["g", "_"], 
            RowBox[{
             FormBox[
              FormBox[
               FormBox["mu2",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               FormBox["mu3",
                TraditionalForm],
               TraditionalForm],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SuperscriptBox[
            FormBox[
             OverscriptBox[
              FormBox["p3",
               TraditionalForm], "_"],
             TraditionalForm], 
            FormBox[
             FormBox[
              FormBox["mu4",
               TraditionalForm],
              TraditionalForm],
             TraditionalForm]],
           TraditionalForm]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu3",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"\[Xi]", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"\[Xi]", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"\[Xi]", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"u", " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu1",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu2",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"\[Xi]", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu1",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu2",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu3",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu4",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}]}], ")"}], " ", 
    SuperscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a1",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a4",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a2",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a3",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692615928720977*^9, 3.692615951914709*^9}, {
   3.692616117201549*^9, 3.692616128680936*^9}, 3.692616419301153*^9, {
   3.692616482168438*^9, 3.692616510932992*^9}, 3.6926166662361393`*^9, 
   3.6926167310253363`*^9, 3.6926168994114122`*^9, 3.6926169631011066`*^9, 
   3.6926170672860193`*^9, 3.6926172417327423`*^9, 3.692617360263195*^9, 
   3.692617935490901*^9, 3.69261907267662*^9, 3.692622060882275*^9, 
   3.692940734448763*^9, 3.692941454330248*^9, {3.69312417316147*^9, 
   3.693124180346133*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Amp4g", "=", 
  RowBox[{
   RowBox[{"Contract", "[", 
    RowBox[{
     RowBox[{"FV", "[", 
      RowBox[{"p1", ",", "mu1"}], "]"}], " ", 
     RowBox[{"FV", "[", 
      RowBox[{"e2", ",", "mu2"}], "]"}], " ", 
     RowBox[{"FV", "[", 
      RowBox[{"e3", ",", "mu3"}], "]"}], " ", 
     RowBox[{"FV", "[", 
      RowBox[{"e4", ",", "mu4"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"diagS", "+", "diagT", "+", "diagU"}], ")"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.692615828534959*^9, 3.692615877130622*^9}, {
  3.69261597173477*^9, 3.692616003979336*^9}, {3.692616043275064*^9, 
  3.692616079909423*^9}, {3.6926161937429934`*^9, 3.692616196644211*^9}, {
  3.692617056334735*^9, 3.6926170565665483`*^9}, {3.692617315076572*^9, 
  3.692617319555043*^9}, {3.6926173862851553`*^9, 3.692617436293618*^9}, {
  3.6926174700247602`*^9, 3.692617524395886*^9}, {3.69262202405676*^9, 
  3.692622024494514*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"s", " ", "t", " ", "u"}]], 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["gs", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "t"}], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p2",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p2",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p2",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p2",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p1",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e2",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p3",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p1",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "-", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            FormBox[
             RowBox[{
              FormBox[
               OverscriptBox[
                FormBox["e4",
                 TraditionalForm], "_"],
               TraditionalForm], 
              FormBox["\<\"\[CenterDot]\"\>",
               TraditionalForm], 
              FormBox[
               OverscriptBox[
                FormBox["p2",
                 TraditionalForm], "_"],
               TraditionalForm]}],
             TraditionalForm], ")"}], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a1",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a2",
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SuperscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a3",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["a4",
               TraditionalForm],
              TraditionalForm]}]]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p3",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e4",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["p1",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm], "+", 
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm]}], ")"}], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm]}]]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e3",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["p1",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   FormBox[
                    OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                    TraditionalForm], 
                   FormBox["\<\"\[CenterDot]\"\>",
                    TraditionalForm], 
                   FormBox[
                    OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                    TraditionalForm]}], ")"}], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}], "-", 
                RowBox[{"t", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   FormBox[
                    OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                    TraditionalForm], 
                   FormBox["\<\"\[CenterDot]\"\>",
                    TraditionalForm], 
                   FormBox[
                    OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                    TraditionalForm]}], ")"}], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]]}]}], ")"}]}], "+", 
             RowBox[{"t", " ", "u", " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e3",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["e4",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]]}], "-", 
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}], "+", 
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e2",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e3",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["p1",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}], "-", 
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 FormBox[
                  OverscriptBox[
                   FormBox["e3",
                    TraditionalForm], "_"],
                  TraditionalForm], 
                 FormBox["\<\"\[CenterDot]\"\>",
                  TraditionalForm], 
                 FormBox[
                  OverscriptBox[
                   FormBox["p2",
                    TraditionalForm], "_"],
                  TraditionalForm]}], "+", 
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm], "+", 
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]]}], "-", 
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}], "+", 
                RowBox[{
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FormBox[
           OverscriptBox[
            FormBox["e2",
             TraditionalForm], "_"],
           TraditionalForm], 
          FormBox["\<\"\[CenterDot]\"\>",
           TraditionalForm], 
          FormBox[
           OverscriptBox[
            FormBox["p1",
             TraditionalForm], "_"],
           TraditionalForm]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", " ", "t", " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["e4",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm]}]]}], "+", 
             RowBox[{
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]]}]}], ")"}]}], "+", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              OverscriptBox[
               FormBox["e3",
                TraditionalForm], "_"],
              TraditionalForm], 
             FormBox["\<\"\[CenterDot]\"\>",
              TraditionalForm], 
             FormBox[
              OverscriptBox[
               FormBox["p2",
                TraditionalForm], "_"],
              TraditionalForm]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm], "+", 
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm]}], ")"}], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]]}], "-", 
             RowBox[{"s", " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e4",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["p1",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm]}]]}]}], ")"}]}], "-", 
          RowBox[{"u", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 FormBox[
                  OverscriptBox[
                   FormBox["e4",
                    TraditionalForm], "_"],
                  TraditionalForm], 
                 FormBox["\<\"\[CenterDot]\"\>",
                  TraditionalForm], 
                 FormBox[
                  OverscriptBox[
                   FormBox["p1",
                    TraditionalForm], "_"],
                  TraditionalForm]}], "+", 
                RowBox[{
                 FormBox[
                  OverscriptBox[
                   FormBox["e4",
                    TraditionalForm], "_"],
                  TraditionalForm], 
                 FormBox["\<\"\[CenterDot]\"\>",
                  TraditionalForm], 
                 FormBox[
                  OverscriptBox[
                   FormBox["p2",
                    TraditionalForm], "_"],
                  TraditionalForm]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm], "+", 
                FormBox[
                 RowBox[{
                  FormBox[
                   OverscriptBox[
                    FormBox["e3",
                    TraditionalForm], "_"],
                   TraditionalForm], 
                  FormBox["\<\"\[CenterDot]\"\>",
                   TraditionalForm], 
                  FormBox[
                   OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                   TraditionalForm]}],
                 TraditionalForm]}], ")"}], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a1",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a2",
                  TraditionalForm],
                 TraditionalForm]}]], " ", 
              SuperscriptBox["f", 
               RowBox[{
                FormBox[
                 FormBox["a",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a3",
                  TraditionalForm],
                 TraditionalForm], 
                FormBox[
                 FormBox["a4",
                  TraditionalForm],
                 TraditionalForm]}]]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FormBox[
                 OverscriptBox[
                  FormBox["e3",
                   TraditionalForm], "_"],
                 TraditionalForm], 
                FormBox["\<\"\[CenterDot]\"\>",
                 TraditionalForm], 
                FormBox[
                 OverscriptBox[
                  FormBox["p1",
                   TraditionalForm], "_"],
                 TraditionalForm]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   FormBox[
                    OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                    TraditionalForm], 
                   FormBox["\<\"\[CenterDot]\"\>",
                    TraditionalForm], 
                   FormBox[
                    OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                    TraditionalForm]}], ")"}], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}], "-", 
                RowBox[{"t", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   FormBox[
                    RowBox[{
                    FormBox[
                    OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                    TraditionalForm], 
                    FormBox["\<\"\[CenterDot]\"\>",
                    TraditionalForm], 
                    FormBox[
                    OverscriptBox[
                    FormBox["p1",
                    TraditionalForm], "_"],
                    TraditionalForm]}],
                    TraditionalForm], "+", 
                   FormBox[
                    RowBox[{
                    FormBox[
                    OverscriptBox[
                    FormBox["e4",
                    TraditionalForm], "_"],
                    TraditionalForm], 
                    FormBox["\<\"\[CenterDot]\"\>",
                    TraditionalForm], 
                    FormBox[
                    OverscriptBox[
                    FormBox["p2",
                    TraditionalForm], "_"],
                    TraditionalForm]}],
                    TraditionalForm]}], ")"}], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a1",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a2",
                    TraditionalForm],
                    TraditionalForm]}]], " ", 
                 SuperscriptBox["f", 
                  RowBox[{
                   FormBox[
                    FormBox["a",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a3",
                    TraditionalForm],
                    TraditionalForm], 
                   FormBox[
                    FormBox["a4",
                    TraditionalForm],
                    TraditionalForm]}]]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.6926179368868713`*^9, 3.692619074074085*^9, 3.692622062482294*^9, 
   3.692940735779708*^9, 3.692941455688466*^9, {3.693124173308194*^9, 
   3.693124181896801*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AmpSimp4g", "=", 
  RowBox[{
   RowBox[{"SUNSimplify", "[", 
    RowBox[{"Amp4g", ",", 
     RowBox[{"SUNFJacobi", "\[Rule]", "True"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.692617536061657*^9, 3.692617563954812*^9}, {
  3.692617734907619*^9, 3.692617736602909*^9}, {3.6926195449341183`*^9, 
  3.69261955489699*^9}, {3.692622039662298*^9, 3.6926220463087053`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SuperscriptBox["gs", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FormBox[
            OverscriptBox[
             FormBox["e3",
              TraditionalForm], "_"],
            TraditionalForm], 
           FormBox["\<\"\[CenterDot]\"\>",
            TraditionalForm], 
           FormBox[
            OverscriptBox[
             FormBox["p1",
              TraditionalForm], "_"],
            TraditionalForm]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a1",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a2",
                TraditionalForm],
               TraditionalForm]}]], " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a3",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a4",
                TraditionalForm],
               TraditionalForm]}]]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a1",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a3",
                TraditionalForm],
               TraditionalForm]}]], " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a2",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a4",
                TraditionalForm],
               TraditionalForm]}]]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           FormBox[
            OverscriptBox[
             FormBox["e3",
              TraditionalForm], "_"],
            TraditionalForm], 
           FormBox["\<\"\[CenterDot]\"\>",
            TraditionalForm], 
           FormBox[
            OverscriptBox[
             FormBox["p2",
              TraditionalForm], "_"],
            TraditionalForm]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a1",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a4",
                TraditionalForm],
               TraditionalForm]}]], " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a2",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a3",
                TraditionalForm],
               TraditionalForm]}]]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a1",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a3",
                TraditionalForm],
               TraditionalForm]}]], " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a2",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a4",
                TraditionalForm],
               TraditionalForm]}]]}], "+", 
           RowBox[{
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a1",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a2",
                TraditionalForm],
               TraditionalForm]}]], " ", 
            SuperscriptBox["f", 
             RowBox[{
              FormBox[
               FormBox["a",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a3",
                TraditionalForm],
               TraditionalForm], 
              FormBox[
               FormBox["a4",
                TraditionalForm],
               TraditionalForm]}]]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a1",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a4",
             TraditionalForm],
            TraditionalForm]}]], " ", 
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a2",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a3",
             TraditionalForm],
            TraditionalForm]}]]}], "-", 
        RowBox[{
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a1",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a3",
             TraditionalForm],
            TraditionalForm]}]], " ", 
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a2",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a4",
             TraditionalForm],
            TraditionalForm]}]]}], "+", 
        RowBox[{
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a1",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a2",
             TraditionalForm],
            TraditionalForm]}]], " ", 
         SuperscriptBox["f", 
          RowBox[{
           FormBox[
            FormBox["a",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a3",
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox["a4",
             TraditionalForm],
            TraditionalForm]}]]}]}], ")"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692616420713436*^9, {3.692616483637841*^9, 3.6926165124354*^9}, 
   3.692616679772766*^9, 3.692616732506304*^9, 3.69261690086381*^9, 
   3.692616964589859*^9, 3.692617068653575*^9, 3.6926172433546877`*^9, 
   3.692617320819441*^9, 3.692617361848568*^9, {3.692617490454344*^9, 
   3.6926174954059343`*^9}, 3.6926175264730387`*^9, {3.69261755752717*^9, 
   3.6926175646190166`*^9}, 3.6926179371921*^9, 3.69261907434236*^9, {
   3.692619545855597*^9, 3.692619555544076*^9}, 3.692622063183185*^9, 
   3.69294073604916*^9, 3.69294145595831*^9, {3.693124173367807*^9, 
   3.6931241822202597`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.692618068627322*^9, 3.692618076577537*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNSimplify", "[", 
  RowBox[{"AmpSimp4g", ",", " ", 
   RowBox[{"SUNFJacobi", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.692618068711218*^9, 3.692618072106385*^9}, {
   3.6926181657714863`*^9, 3.692618190735327*^9}, 3.6926182265137043`*^9, {
   3.692618256956256*^9, 3.6926182652036867`*^9}, {3.692618306876439*^9, 
   3.692618311033248*^9}, {3.692619385718408*^9, 3.692619525792911*^9}, {
   3.692619561954356*^9, 3.692619566992593*^9}, {3.6926196948273973`*^9, 
   3.6926197012913*^9}, {3.692620386201343*^9, 3.692620445251412*^9}, {
   3.692622047788809*^9, 3.692622047868909*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SuperscriptBox["gs", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FormBox[
         OverscriptBox[
          FormBox["e3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox["\<\"\[CenterDot]\"\>",
         TraditionalForm], 
        FormBox[
         OverscriptBox[
          FormBox["e4",
           TraditionalForm], "_"],
         TraditionalForm]}], ")"}], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a1",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a2",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a3",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a4",
          TraditionalForm],
         TraditionalForm]}]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692619453272781*^9, 3.692619462919716*^9}, {
   3.692619516470133*^9, 3.692619520154277*^9}, {3.6926195634654016`*^9, 
   3.6926195676063843`*^9}, {3.692620420743376*^9, 3.692620445924453*^9}, 
   3.692622063444206*^9, 3.692940736241342*^9, 3.692941456119411*^9, {
   3.6931241734325323`*^9, 3.6931241824094543`*^9}}]
}, Open  ]]
}, Open  ]],

Cell["\<\
The last two lines are zero because of Jacobi Id. Applying the Jacobi Id. \
gives back the textbook result.
Point b) follows from the form of the vertex\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.4: Renormalisation schemes", "Chapter",
 CellChangeTimes->{{3.692613426285159*^9, 3.6926134324672422`*^9}, {
  3.6926219265062923`*^9, 3.69262192669018*^9}, {3.692625478990284*^9, 
  3.692625491516202*^9}}],

Cell[CellGroupData[{

Cell["\<\
a) We write the definition of beta in terms of a generic alpha\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}, {3.692625501772744*^9, 3.692625513899186*^9}, {
  3.6926261351061983`*^9, 3.692626135479179*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BetaF", "[", "as_", "]"}], " ", ":=", " ", 
   RowBox[{"b", " ", 
    RowBox[{"as", "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"b1", " ", "as"}], "+", " ", 
      RowBox[{"b2", " ", 
       RowBox[{"as", "^", "2"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaF", "[", "asA", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"asA", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.692624936489541*^9, 3.692624987968774*^9}, {
  3.69262552178106*^9, 3.692625521948695*^9}}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["asA", "2"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["asA", "3"], " ", "b", " ", "b1"}], "+", 
    RowBox[{
     SuperscriptBox["asA", "4"], " ", "b", " ", "b2"}], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["asA", "5"], ")"}],
     SeriesData[$CellContext`asA, 0, {}, 2, 5, 1],
     Editable->False]}],
   SeriesData[$CellContext`asA, 
    0, {$CellContext`b, $CellContext`b $CellContext`b1, $CellContext`b \
$CellContext`b2}, 2, 5, 1],
   Editable->False], TraditionalForm]], "Output",
 CellChangeTimes->{3.692625522605631*^9, 3.6929407363059473`*^9, 
  3.692941456171633*^9, 3.693124182472146*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We compute the beta function for alphaSA, by using the one of alphaSB and \
changing the scheme\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}, {3.692625501772744*^9, 3.692625513899186*^9}, {
  3.6926255519733057`*^9, 3.692625573706592*^9}, {3.692625628463838*^9, 
  3.692625642551269*^9}, {3.6926260410004168`*^9, 3.692626065045793*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"betaA", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"BetaF", "[", "asB", "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{"asB", "\[Rule]", 
       RowBox[{"asA", "+", 
        RowBox[{"c1", " ", 
         RowBox[{"asA", "^", "2"}]}], "+", 
        RowBox[{"c2", " ", 
         RowBox[{"asA", "^", "3"}]}]}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"asA", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.692625028415299*^9, 3.6926250934626427`*^9}, {
  3.6926259797415667`*^9, 3.692625982171582*^9}}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["asA", "2"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["asA", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "b1"}], "+", 
       RowBox[{"2", " ", "b", " ", "c1"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["asA", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "b", " ", "b1", " ", "c1"}], "+", 
       RowBox[{"b", " ", "b2"}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["c1", "2"]}], "+", 
       RowBox[{"2", " ", "b", " ", "c2"}]}], ")"}]}], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["asA", "5"], ")"}],
     SeriesData[$CellContext`asA, 0, {}, 2, 5, 1],
     Editable->False]}],
   SeriesData[$CellContext`asA, 
    0, {$CellContext`b, $CellContext`b $CellContext`b1 + 
     2 $CellContext`b $CellContext`c1, $CellContext`b $CellContext`b2 + 
     3 $CellContext`b $CellContext`b1 $CellContext`c1 + $CellContext`b \
$CellContext`c1^2 + 2 $CellContext`b $CellContext`c2}, 2, 5, 1],
   Editable->False], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692625072533464*^9, 3.692625093872745*^9}, 
   3.692625992027192*^9, 3.6929407363439007`*^9, 3.692941456222253*^9, 
   3.693124182511261*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We compute the beta function for alphaSB, as 
dalphaSB/dmu = dalphaSB/dalphaSA * dalphaSA/dmu\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}, {3.692625501772744*^9, 3.692625513899186*^9}, {
  3.6926255519733057`*^9, 3.692625573706592*^9}, {3.692625628463838*^9, 
  3.6926257183046427`*^9}, {3.692626067749858*^9, 3.6926260763250427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"betaB", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"asA", "+", 
        RowBox[{"c1", " ", 
         RowBox[{"asA", "^", "2"}]}], "+", 
        RowBox[{"c2", " ", 
         RowBox[{"asA", "^", "3"}]}]}], ",", " ", "asA"}], "]"}], "*", 
     RowBox[{"BetaF", "[", "asA", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"asA", ",", " ", "0", ",", " ", "4"}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.69262518933298*^9, 3.692625254107587*^9}, {
  3.692625414636454*^9, 3.692625438913671*^9}, {3.69262598496443*^9, 
  3.6926259863398123`*^9}}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["asA", "2"], " ", "b"}], "+", 
    RowBox[{
     SuperscriptBox["asA", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "b1"}], "+", 
       RowBox[{"2", " ", "b", " ", "c1"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["asA", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "b", " ", "b1", " ", "c1"}], "+", 
       RowBox[{"b", " ", "b2"}], "+", 
       RowBox[{"3", " ", "b", " ", "c2"}]}], ")"}]}], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["asA", "5"], ")"}],
     SeriesData[$CellContext`asA, 0, {}, 2, 5, 1],
     Editable->False]}],
   SeriesData[$CellContext`asA, 
    0, {$CellContext`b, $CellContext`b $CellContext`b1 + 
     2 $CellContext`b $CellContext`c1, $CellContext`b $CellContext`b2 + 
     2 $CellContext`b $CellContext`b1 $CellContext`c1 + 
     3 $CellContext`b $CellContext`c2}, 2, 5, 1],
   Editable->False], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6926252396542377`*^9, 3.692625243401655*^9}, 
   3.692625300194817*^9, 3.6926254391660843`*^9, {3.692625986876377*^9, 
   3.692625992086767*^9}, 3.692940736388238*^9, 3.692941456271041*^9, 
   3.6931241825717287`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The difference is", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}, {3.692625501772744*^9, 3.692625513899186*^9}, {
  3.6926255519733057`*^9, 3.692625573706592*^9}, {3.692625628463838*^9, 
  3.6926257183046427`*^9}, {3.692626067749858*^9, 3.692626092212718*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"betaB", "-", "betaA"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.6926259937683783`*^9, 3.6926260157855883`*^9}}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SuperscriptBox["asA", "4"], " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b1", " ", "c1"}], "+", 
        SuperscriptBox["c1", "2"], "-", "c2"}], ")"}]}]}], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["asA", "5"], ")"}],
     SeriesData[$CellContext`asA, 0, {}, 4, 5, 1],
     Editable->False]}],
   SeriesData[$CellContext`asA, 
    0, {-$CellContext`b ($CellContext`b1 $CellContext`c1 + $CellContext`c1^2 - \
$CellContext`c2)}, 4, 5, 1],
   Editable->False], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692626001417677*^9, 3.6926260161746807`*^9}, 
   3.69294073643788*^9, 3.6929414563218403`*^9, 3.69312418263839*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
b) using the definition for Lambda, the hint is easily verified. We do the \
integration using only the first order of beta and of the asA -> asB change \
of scheme, and we take the leading term of the result\
\>", "Subsection",
 CellChangeTimes->{{3.692613597944758*^9, 3.692613636916294*^9}, {
  3.6926137866433907`*^9, 3.69261380584085*^9}, {3.692615800854991*^9, 
  3.692615820540888*^9}, {3.6926214826547203`*^9, 3.692621498412581*^9}, {
  3.692621541883204*^9, 3.69262158712852*^9}, {3.6926219060614977`*^9, 
  3.6926219139309196`*^9}, {3.692625501772744*^9, 3.692625513899186*^9}, {
  3.6926261351061983`*^9, 3.692626201680035*^9}, {3.692626355705297*^9, 
  3.69262636603194*^9}, {3.692626396373218*^9, 3.692626408116714*^9}, {
  3.692626474532464*^9, 3.692626480899115*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "b"}], " ", "/", 
       RowBox[{"x", "^", "2"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "asA", ",", " ", 
        RowBox[{"asA", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c1", " ", "asA"}]}], ")"}]}]}], "}"}]}], "]"}]}], " ", 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"asA", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.692626218559719*^9, 3.692626270897923*^9}, {
  3.6926263357033587`*^9, 3.692626339094391*^9}, {3.692626369944179*^9, 
  3.692626429028923*^9}, {3.692626509889593*^9, 3.692626512753497*^9}, {
  3.6926266452201633`*^9, 3.692626651354129*^9}, {3.692626695350904*^9, 
  3.692626711212742*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"ConditionalExpression", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{
      FractionBox["c1", 
       RowBox[{"2", " ", "b"}]], "+", 
      InterpretationBox[
       RowBox[{"O", "(", 
        SuperscriptBox["asA", "1"], ")"}],
       SeriesData[$CellContext`asA, 0, {}, 0, 1, 1],
       Editable->False]}],
     SeriesData[$CellContext`asA, 0, {
      Rational[1, 2] $CellContext`b^(-1) $CellContext`c1}, 0, 1, 1],
     Editable->False], ",", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"asA", " ", "c1"}]], "\[Element]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[And]", 
       RowBox[{
        RowBox[{"-", "1"}], "\[LessEqual]", 
        RowBox[{"Re", "(", 
         FractionBox["1", 
          RowBox[{"asA", " ", "c1"}]], ")"}], "<", "0"}], "\[And]", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{"asA", " ", "c1"}]], "\[GreaterEqual]", "0"}], "\[Or]", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"asA", " ", "c1"}]], "<", 
           RowBox[{"-", "1"}]}]}], ")"}]}]}], ")"}]}]}], "]"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692626261713792*^9, 3.692626339690404*^9, {3.692626373197838*^9, 
   3.692626382524496*^9}, 3.6926264434469137`*^9, 3.692626514725747*^9, {
   3.692626646864758*^9, 3.692626652948028*^9}, 3.692626715795827*^9, 
   3.692940741196389*^9, 3.692941461357312*^9, 3.693124188169265*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 597},
WindowMargins->{{Automatic, 608}, {328, Automatic}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 85, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[668, 25, 189, 2, 148, "Title"],
Cell[CellGroupData[{
Cell[882, 31, 156, 2, 44, "Subsection"],
Cell[1041, 35, 182, 4, 28, "Input"],
Cell[1226, 41, 109, 2, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1372, 48, 158, 2, 65, "Chapter"],
Cell[CellGroupData[{
Cell[1555, 54, 70, 1, 44, "Subsection"],
Cell[1628, 57, 1432, 59, 170, "Text"],
Cell[3063, 118, 1933, 58, 165, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5033, 181, 119, 1, 44, "Subsection"],
Cell[5155, 184, 2909, 84, 284, "Input"],
Cell[8067, 270, 231, 6, 28, "Input"],
Cell[CellGroupData[{
Cell[8323, 280, 299, 7, 28, "Input"],
Cell[8625, 289, 703, 12, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9377, 307, 345, 6, 69, "Subsection"],
Cell[CellGroupData[{
Cell[9747, 317, 1411, 38, 80, "Input"],
Cell[11161, 357, 1818, 68, 52, "Output"],
Cell[12982, 427, 1816, 68, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14847, 501, 550, 9, 69, "Subsection"],
Cell[CellGroupData[{
Cell[15422, 514, 485, 14, 28, "Input"],
Cell[15910, 530, 2592, 96, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18551, 632, 486, 8, 69, "Subsection"],
Cell[CellGroupData[{
Cell[19062, 644, 1548, 38, 63, "Input"],
Cell[20613, 684, 1340, 42, 34, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22002, 732, 525, 9, 94, "Subsection"],
Cell[CellGroupData[{
Cell[22552, 745, 2127, 56, 80, "Input"],
Cell[24682, 803, 3779, 141, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[28488, 948, 533, 8, 69, "Subsection"],
Cell[CellGroupData[{
Cell[29046, 960, 304, 6, 61, "Subsection"],
Cell[29353, 968, 2269, 62, 165, "Input"],
Cell[31625, 1032, 3608, 94, 216, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35270, 1131, 282, 6, 69, "Subsection"],
Cell[CellGroupData[{
Cell[35577, 1141, 145, 2, 28, "Input"],
Cell[35725, 1145, 60148, 2248, 325, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95910, 3398, 955, 22, 46, "Input"],
Cell[96868, 3422, 81685, 2556, 441, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178590, 5983, 417, 9, 28, "Input"],
Cell[179010, 5994, 19837, 730, 104, "Output"]
}, Open  ]],
Cell[198862, 6727, 92, 1, 28, "Input"],
Cell[CellGroupData[{
Cell[198979, 6732, 628, 10, 28, "Input"],
Cell[199610, 6744, 17875, 695, 104, "Output"]
}, Open  ]]
}, Open  ]],
Cell[217512, 7443, 496, 9, 94, "Subsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218045, 7457, 216, 3, 65, "Chapter"],
Cell[CellGroupData[{
Cell[218286, 7464, 503, 8, 44, "Subsection"],
Cell[CellGroupData[{
Cell[218814, 7476, 618, 18, 46, "Input"],
Cell[219435, 7496, 731, 20, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[220215, 7522, 633, 10, 69, "Subsection"],
Cell[CellGroupData[{
Cell[220873, 7536, 595, 16, 28, "Input"],
Cell[221471, 7554, 1299, 34, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222819, 7594, 633, 10, 69, "Subsection"],
Cell[CellGroupData[{
Cell[223477, 7608, 655, 18, 28, "Input"],
Cell[224135, 7628, 1275, 33, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[225459, 7667, 547, 7, 44, "Subsection"],
Cell[CellGroupData[{
Cell[226031, 7678, 158, 3, 28, "Input"],
Cell[226192, 7683, 775, 21, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[227016, 7710, 792, 12, 94, "Subsection"],
Cell[CellGroupData[{
Cell[227833, 7726, 869, 23, 28, "Input"],
Cell[228705, 7751, 1598, 44, 48, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

