(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     36654,       1171]
NotebookOptionsPosition[     34232,       1082]
NotebookOutlinePosition[     34664,       1099]
CellTagsIndexPosition[     34621,       1096]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Calculation for gg>H with full top mass dependence ", "Title",
 CellChangeTimes->{{3.692444489003084*^9, 3.692444517685689*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynCalc`"}]], "Input",
 CellChangeTimes->{3.692451954377186*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"Get", "::", "noopen"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"FeynCalc`\\\\\\\"\\\", \
TraditionalForm]\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.692511575152804*^9, 3.6925118342385178`*^9, 
  3.6925130738099127`*^9, 3.6925170817600527`*^9, 3.692518106515353*^9}],

Cell[BoxData[
 FormBox["$Failed", TraditionalForm]], "Output",
 CellChangeTimes->{3.692511575155848*^9, 3.6925118342578897`*^9, 
  3.6925130738166857`*^9, 3.692517081778297*^9, 3.692518106567068*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", 
  "\"\</Users/marcozaro/Physics/feyncalc-master/FeynCalc/fc.m\>\""}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"FeynCalc \"\>", "Text",
     StripOnInput->False,
     FontWeight->Bold], "\[InvisibleSpace]", 
    StyleBox["\<\"9.1.0 (development version). For help, use the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"documentation", " ", "center"}],
       BaseStyle->"Link",
       ButtonData:>"paclet:FeynCalc/",
       ButtonNote->"paclet:FeynCalc/"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\", check out the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox["wiki",
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None},
       ButtonNote->"https://github.com/FeynCalc/feyncalc/wiki"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" or write to the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"mailing", " ", 
        RowBox[{"list", "."}]}],
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["http://www.feyncalc.org/forum/"], None},
       ButtonNote->"http://www.feyncalc.org/forum/"],
      DisplayForm], "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["FeynCalc ", "Text", Bold], 
    Style["9.1.0 (development version). For help, use the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "documentation center", BaseStyle -> "Link", ButtonData :> 
       "paclet:FeynCalc/", ButtonNote -> "paclet:FeynCalc/"]], "Text"], 
    Style[", check out the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["wiki", ButtonData :> {
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> 
       "https://github.com/FeynCalc/feyncalc/wiki"]], "Text"], 
    Style[" or write to the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["mailing list.", ButtonData :> {
         URL["http://www.feyncalc.org/forum/"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> "http://www.feyncalc.org/forum/"]], "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692511576512598*^9, 3.692511835506633*^9, 
  3.692513076189733*^9, 3.6925170831289682`*^9, 3.692518108090785*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"See also the supplied \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"examples", "."}],
       BaseStyle->"Hyperlink",
       ButtonFunction:>SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]],
       Evaluator->Automatic,
       Method->"Preemptive"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" If you use FeynCalc in your research, please cite\"\>", 
     "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["See also the supplied ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "examples.", BaseStyle -> "Hyperlink", ButtonFunction :> SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]], Evaluator -> 
       Automatic, Method -> "Preemptive"]], "Text"], 
    Style[" If you use FeynCalc in your research, please cite", "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692511576512598*^9, 3.692511835506633*^9, 
  3.692513076189733*^9, 3.6925170831289682`*^9, 3.692518108099052*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] V. Shtabovenko, R. Mertig and F. Orellana, TUM-EFT \
71/15, arXiv:1601.01167\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692511576512598*^9, 3.692511835506633*^9, 
  3.692513076189733*^9, 3.6925170831289682`*^9, 3.6925181081053534`*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] R. Mertig, M. B\[ODoubleDot]hm, and A. Denner, \
Comput. Phys. Commun., 64, 345-359, 1991.\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.692511576512598*^9, 3.692511835506633*^9, 
  3.692513076189733*^9, 3.6925170831289682`*^9, 3.6925181081130238`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Subsection"],

Cell[CellGroupData[{

Cell["Kinematics 2->1 ", "Subsubsection"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q1", ",", "q1"}], "]"}], "=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q2", ",", "q2"}], "]"}], "=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q1", ",", "q2"}], "]"}], "=", 
     RowBox[{
      RowBox[{"mh", "^", "2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q", ",", "q1"}], "]"}], "=", 
     RowBox[{
      RowBox[{"mh", "^", "2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q", ",", "q2"}], "]"}], "=", 
     RowBox[{
      RowBox[{"mh", "^", "2"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"q", ",", "q"}], "]"}], "=", 
     RowBox[{"mh", "^", "2"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.69245254913195*^9, 3.692452553746846*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Amplitude (2 diagrams)", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Amp", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "I"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "I"}], " ", "gs"}], ")"}], "^", "2"}]}], "  ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", " ", "I"}], " ", 
              RowBox[{"mt", " ", "/", "v"}]}], ")"}], " ", "*", " ", 
            RowBox[{"I", "^", "3"}], "*", 
            RowBox[{"deltaAB", "/", "2"}], "*", 
            RowBox[{"Tr", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", 
                  RowBox[{"l", "+", "q1"}], "]"}], "+", "mt"}], ")"}], ".", 
               RowBox[{"GAD", "[", "mu", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", "l", "]"}], "+", "mt"}], ")"}], ".", 
               RowBox[{"GAD", "[", "nu", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", 
                  RowBox[{"l", "-", "q2"}], "]"}], "+", "mt"}], ")"}]}], "+", 
              
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", 
                  RowBox[{"l", "+", "q2"}], "]"}], "+", "mt"}], ")"}], ".", 
               RowBox[{"GAD", "[", "nu", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", "l", "]"}], "+", "mt"}], ")"}], ".", 
               RowBox[{"GAD", "[", "mu", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"GSD", "[", 
                  RowBox[{"l", "-", "q1"}], "]"}], "+", "mt"}], ")"}]}]}], 
             "]"}]}], " ", "//", "DiracSimplify"}], ")"}], "/.", " ", 
         RowBox[{
          RowBox[{"Pair", "[", 
           RowBox[{
            RowBox[{"Momentum", "[", "q2", "]"}], ",", 
            RowBox[{"LorentzIndex", "[", "nu", "]"}]}], "]"}], "\[Rule]", 
          "0"}]}], "/.", " ", 
        RowBox[{
         RowBox[{"Pair", "[", 
          RowBox[{
           RowBox[{"Momentum", "[", "q1", "]"}], ",", 
           RowBox[{"LorentzIndex", "[", "mu", "]"}]}], "]"}], "\[Rule]", 
         "0"}]}], ")"}]}], " ", "//", "Simplify"}]}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "deltaAB", " ", 
    SuperscriptBox["gs", "2"], " ", 
    SuperscriptBox["mt", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        FormBox[
         SuperscriptBox["g", 
          RowBox[{
           FormBox[
            FormBox[
             FormBox["mu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox[
             FormBox["nu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            FormBox[
             FormBox["l",
              TraditionalForm],
             TraditionalForm], "2"]}], "+", 
          SuperscriptBox["mh", "2"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["mt", "2"]}]}], ")"}]}]}], "+", 
      RowBox[{"8", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["l",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["l",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "+", 
      RowBox[{"2", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["q2",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["q1",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["q1",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          FormBox["q2",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}]}], ")"}]}], "v"], TraditionalForm]], "Output",
 CellChangeTimes->{3.692452170263329*^9, 3.69245255666861*^9, 
  3.692452972716131*^9, 3.6924538156646147`*^9, 3.692510939269392*^9, 
  3.692511576946205*^9, 3.692511835928535*^9, 3.692513076828374*^9, 
  3.6925170835612497`*^9, 3.692518108761848*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Let's ask FeynCalc to do the tensor reduction", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", " ", "Pi"}], ")"}], "^", "4"}]}], "*", 
         RowBox[{"OneLoop", "[", 
          RowBox[{"l", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"FAD", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"l", ",", "mt"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"l", "+", "q1"}], ",", "mt"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"l", "-", "q2"}], ",", "mt"}], "}"}]}], "]"}], " ", 
             "Amp"}], "//", "Contract"}]}], "]"}]}], "//", "PaVeReduce"}], "//",
        "Factor"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"res", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"res", "/.", " ", 
        RowBox[{
         RowBox[{"Pair", "[", 
          RowBox[{
           RowBox[{"Momentum", "[", "q2", "]"}], ",", 
           RowBox[{"LorentzIndex", "[", "nu", "]"}]}], "]"}], "\[Rule]", 
         "0"}]}], "/.", " ", 
       RowBox[{
        RowBox[{"Pair", "[", 
         RowBox[{
          RowBox[{"Momentum", "[", "q1", "]"}], ",", 
          RowBox[{"LorentzIndex", "[", "mu", "]"}]}], "]"}], "\[Rule]", 
        "0"}]}], " ", ")"}], "//", "Simplify"}]}]}]}]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"D", "-", "2"}], ")"}], " ", 
     SuperscriptBox["mh", "2"], " ", "v"}]], 
   RowBox[{"deltaAB", " ", 
    SuperscriptBox["gs", "2"], " ", 
    SuperscriptBox["mt", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["mh", "2"], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["q2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["q1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"D", "-", "4"}], ")"}], " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"B\"\>", "\<\"0\"\>"], "(", 
         RowBox[{
          SuperscriptBox["mh", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"]}], ")"}],
        TraditionalForm]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"D", "-", "2"}], ")"}], " ", 
          SuperscriptBox["mh", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["mt", "2"]}]}], ")"}], " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"C\"\>", "\<\"0\"\>"], "(", 
         RowBox[{"0", ",", "0", ",", 
          SuperscriptBox["mh", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"]}], ")"}],
        TraditionalForm]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.69245217851362*^9, 3.692452559992298*^9, 
  3.692452977284349*^9, 3.692453819606213*^9, 3.692510960462818*^9, 
  3.6925115775440702`*^9, 3.692511836507619*^9, 3.6925130777097187`*^9, 
  3.692517084203616*^9, 3.6925181096158943`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The scalar integral C0 can be evaluated with the help of the Feynman \
parameters (by hand), and the result is (\[Tau] = mh^2 / (4 mt^2):\
\>", "Subsection",
 CellChangeTimes->{{3.692515977056491*^9, 3.6925159820148697`*^9}, {
  3.692516016057069*^9, 3.69251602591861*^9}, {3.6925179204440413`*^9, 
  3.692517920634293*^9}, {3.692520466725155*^9, 3.692520468165311*^9}, {
  3.692521738384965*^9, 3.692521741980186*^9}}],

Cell["\<\
c0x=-I/(16 Pi^2)*1/mt^2*Integrate[1/(1-4 \[Tau] x y),{y,0,1-x}, Assumptions \
\[Rule] {\[Tau]<1, \[Tau]>0, x>0, x<1}]//Simplify;
c0 = Integrate[c0x, {x,0,1}, Assumptions \[Rule] {\[Tau]<1, \[Tau]>0}];
c0FC=(2 Pi)^4/(I Pi^2) c0;\
\>", "Input",
 CellChangeTimes->{{3.692511045749646*^9, 3.692511049611127*^9}, {
  3.692511557857853*^9, 3.692511560335854*^9}, {3.69251225244053*^9, 
  3.692512255516741*^9}, {3.69251503727313*^9, 3.692515038073168*^9}, {
  3.692515120413361*^9, 3.692515195614604*^9}, {3.6925155941637917`*^9, 
  3.692515599171131*^9}, {3.692515651379901*^9, 3.69251568391683*^9}, {
  3.692515780222146*^9, 3.69251583934918*^9}, {3.692515875890379*^9, 
  3.692515880441649*^9}, {3.692516835243518*^9, 3.692516838585149*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The scalar integral B0, we just need the 1/\[Epsilon] part, as it comes \
multiplied by D-4)\
\>", "Subsection",
 CellChangeTimes->{{3.692515977056491*^9, 3.6925159820148697`*^9}, {
  3.692516016057069*^9, 3.69251602591861*^9}, {3.6925168604493313`*^9, 
  3.692516890286077*^9}, {3.692520454657867*^9, 3.692520455316841*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"b01oeps", "=", 
   RowBox[{
    RowBox[{"I", " ", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", " ", "Pi"}], ")"}], "^", "2"}]}], " ", 
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"4", "-", "D"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0FC", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "Pi"}], ")"}], "^", "4"}], "/", 
     RowBox[{"(", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "^", "2"}]}], ")"}]}], " ", "b01oeps"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.692516899350171*^9, 3.692517026300687*^9}, {
  3.692517146586252*^9, 3.692517151088367*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
This is rather cumbersome, but it is just to replace FeynCalc\
\[CloseCurlyQuote]s C0 and B0 functions with ours, as the commented (simpler) \
expression seems not to work on Mathematica 10 + FC9\
\>", "Subsection",
 CellChangeTimes->{
  3.692520284321138*^9, {3.692520319819466*^9, 3.692520379301304*^9}, {
   3.6925204827584248`*^9, 3.692520484348297*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"subint", "[", "expr_", "]"}], " ", ":=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"expr", " ", "/.", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"C0", "[", "x_", "]"}], "\[Rule]", "c0FC"}], ",", " ", 
       RowBox[{"\[AliasDelimiter]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"B0", "[", "x_", "]"}], "\[Rule]", "b0FC"}], " ", "}"}], 
           "]"}], ";"}], "*)"}]}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.692520387110497*^9, 3.6925204126273193`*^9}, {
  3.6925204890200253`*^9, 3.6925205027299833`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"subint", "[", "expr_", "]"}], " ", ":=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"expr", " ", "/.", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PaVe", "[", 
          RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Join", "[", 
            RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", "\[Equal]", " ", 
          "6"}]}], "\[Rule]", "c0FC"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"PaVe", "[", 
          RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Join", "[", 
            RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", "\[Equal]", " ", 
          "3"}]}], "\[Rule]", "b0FC"}]}], " ", "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.692511088650519*^9, 3.6925111026315603`*^9}, {
   3.69251122689157*^9, 3.692511251466298*^9}, {3.692511287165449*^9, 
   3.692511390180458*^9}, {3.692511420580585*^9, 3.692511428562236*^9}, {
   3.692511486942605*^9, 3.692511501291944*^9}, {3.692511541963472*^9, 
   3.692511544297491*^9}, {3.6925115908150187`*^9, 3.692511592571269*^9}, {
   3.69251164296789*^9, 3.692511663704157*^9}, {3.6925117165619698`*^9, 
   3.692511817361938*^9}, 3.692511849421681*^9, {3.692512176273435*^9, 
   3.692512189790781*^9}, {3.692513611230301*^9, 3.69251361647466*^9}, {
   3.692513648480934*^9, 3.6925136568424397`*^9}, {3.692513694800782*^9, 
   3.692513702188364*^9}, {3.6925170421818333`*^9, 3.69251705299717*^9}, {
   3.6925172275141287`*^9, 3.6925172318887367`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.692513736504738*^9, 3.69251374487772*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Let's take the mt->Infinity limit and see that the amplitude does not depend \
on m_top:\
\>", "Subsection",
 CellChangeTimes->{3.692520284321138*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myamp", "=", 
  RowBox[{
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", " ", 
            RowBox[{"res", " ", "//", "Simplify"}], ")"}], "/.", " ", 
           RowBox[{
            RowBox[{"gs", "^", "2"}], " ", "\[Rule]", " ", 
            RowBox[{"as", " ", "4", " ", "Pi"}]}]}], "/.", " ", 
          RowBox[{"mh2", "\[Rule]", 
           RowBox[{"mh", "^", "2"}]}]}], "/.", " ", 
         RowBox[{"\[Tau]", "\[Rule]", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"mh", "^", "2"}], "/", "4"}], "/", 
           RowBox[{"mt", "^", "2"}]}]}]}], "//", "PowerExpand"}], "//", 
       "FullSimplify"}], ",", 
      RowBox[{"{", 
       RowBox[{"mt", ",", "Infinity", ",", "4"}], "}"}]}], "]"}], "]"}], "//",
    "Simplify"}]}]], "Input",
 CellChangeTimes->{3.692511068164669*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{"D", "-", "2"}], ")"}], " ", 
     SuperscriptBox["mh", "2"], " ", "v"}]], 
   RowBox[{"as", " ", "deltaAB", " ", 
    SuperscriptBox["mt", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["mh", "2"], " ", 
       FormBox[
        SuperscriptBox[
         OverscriptBox["g", "_"], 
         RowBox[{
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm]}], "-", 
      RowBox[{"2", " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["q2",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SuperscriptBox[
         FormBox[
          OverscriptBox[
           FormBox["q1",
            TraditionalForm], "_"],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"D", "-", "4"}], ")"}], " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"B\"\>", "\<\"0\"\>"], "(", 
         RowBox[{
          SuperscriptBox["mh", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"]}], ")"}],
        TraditionalForm]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"D", "-", "2"}], ")"}], " ", 
          SuperscriptBox["mh", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["mt", "2"]}]}], ")"}], " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"C\"\>", "\<\"0\"\>"], "(", 
         RowBox[{"0", ",", "0", ",", 
          SuperscriptBox["mh", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"], ",", 
          SuperscriptBox["mt", "2"]}], ")"}],
        TraditionalForm]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.692511052510167*^9, 3.692511074721478*^9}, 
   3.692511518596458*^9, {3.6925115780945807`*^9, 3.692511597069365*^9}, {
   3.6925116517937403`*^9, 3.692511666762609*^9}, 3.692511727680943*^9, 
   3.692511836997037*^9, 3.6925121970051394`*^9, 3.692513126501425*^9, 
   3.6925137048363113`*^9, 3.692517062946196*^9, 3.6925171054400797`*^9, 
   3.692517156544361*^9, 3.692517246551955*^9, 3.692518130912465*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"finalamp", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"subint", "[", "myamp", "]"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "\[Rule]", "4"}], ",", " ", 
      RowBox[{
       RowBox[{"mt", "^", "2"}], "\[Rule]", 
       RowBox[{
        RowBox[{"mh", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "\[Tau]"}], ")"}]}]}]}], "}"}]}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.692511396567629*^9, 3.69251140477779*^9}, {
  3.69251718353259*^9, 3.692517257077794*^9}, {3.692517912037135*^9, 
  3.692517914900489*^9}, {3.6925179647563257`*^9, 3.692517976859829*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"as", " ", "deltaAB", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Tau]", "-", "1"}], ")"}], " ", 
        TemplateBox[{"2",FractionBox[
           RowBox[{"2", " ", "\[Tau]"}], 
           RowBox[{"\[Tau]", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox[
                RowBox[{
                  RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"\[Tau]", "-", "1"}], ")"}]}], " ", 
                  "\[Tau]"}]]}]}]]},
         "PolyLog"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Tau]", "-", "1"}], ")"}], " ", 
        TemplateBox[{"2",FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Tau]"}], 
           RowBox[{
             RowBox[{"\[ImaginaryI]", " ", "\[Tau]"}], "+", 
             SqrtBox[
              RowBox[{
                RowBox[{"-", 
                  RowBox[{"(", 
                    RowBox[{"\[Tau]", "-", "1"}], ")"}]}], " ", 
                "\[Tau]"}]]}]]},
         "PolyLog"]}], "+", 
       RowBox[{"2", " ", "\[Tau]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["mh", "2"], " ", 
        FormBox[
         SuperscriptBox[
          OverscriptBox["g", "_"], 
          RowBox[{
           FormBox[
            FormBox[
             FormBox["mu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox[
             FormBox["nu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"2", " ", 
        FormBox[
         SuperscriptBox[
          FormBox[
           OverscriptBox[
            FormBox["q2",
             TraditionalForm], "_"],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SuperscriptBox[
          FormBox[
           OverscriptBox[
            FormBox["q1",
             TraditionalForm], "_"],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]],
         TraditionalForm]}]}], ")"}]}], 
    RowBox[{"8", " ", "\[Pi]", " ", 
     SuperscriptBox["\[Tau]", "2"], " ", "v"}]]}], TraditionalForm]], "Output",\

 CellChangeTimes->{{3.692511405202662*^9, 3.69251143518386*^9}, {
   3.6925115074304533`*^9, 3.69251151865038*^9}, {3.692511578190337*^9, 
   3.692511597121833*^9}, {3.6925116546982393`*^9, 3.6925116668026123`*^9}, {
   3.6925117277323923`*^9, 3.692511780284226*^9}, {3.6925118370505447`*^9, 
   3.69251185243128*^9}, 3.6925119259368773`*^9, 3.692512199011361*^9, 
   3.6925131301000423`*^9, 3.6925136429395638`*^9, 3.6925137086067123`*^9, 
   3.692517105499065*^9, 3.692517156624544*^9, 3.692517191590906*^9, {
   3.692517246612756*^9, 3.692517257431817*^9}, 3.692517978839405*^9, 
   3.69251813100445*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"finalampEFT", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{"finalamp", ",", " ", 
    RowBox[{"\[Tau]", "->", " ", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6925172739166203`*^9, 3.692517329921995*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"as", " ", "deltaAB", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["mh", "2"], " ", 
        FormBox[
         SuperscriptBox[
          OverscriptBox["g", "_"], 
          RowBox[{
           FormBox[
            FormBox[
             FormBox["mu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm], 
           FormBox[
            FormBox[
             FormBox["nu",
              TraditionalForm],
             TraditionalForm],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"2", " ", 
        FormBox[
         SuperscriptBox[
          FormBox[
           OverscriptBox[
            FormBox["q2",
             TraditionalForm], "_"],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["mu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SuperscriptBox[
          FormBox[
           OverscriptBox[
            FormBox["q1",
             TraditionalForm], "_"],
           TraditionalForm], 
          FormBox[
           FormBox[
            FormBox["nu",
             TraditionalForm],
            TraditionalForm],
           TraditionalForm]],
         TraditionalForm]}]}], ")"}]}], 
    RowBox[{"6", " ", "\[Pi]", " ", "v"}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6925173203674393`*^9, 3.69251733165294*^9}, 
   3.692517993143227*^9, 3.6925181320293016`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"4", " ", "x", " ", "y"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"\[Tau]", " ", "x", " ", "y"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"1", "-", "x"}]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"\[Tau]", "==", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.542627525077577*^9, 3.542627611656934*^9}}],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 CellChangeTimes->{{3.542627586138248*^9, 3.542627615440257*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{710, 706},
WindowMargins->{{148, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (June 27, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 134, 1, 148, "Title"],
Cell[CellGroupData[{
Cell[738, 27, 36, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[799, 31, 95, 2, 28, "Input"],
Cell[897, 35, 616, 13, 24, "Message"],
Cell[1516, 50, 199, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1752, 58, 109, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[1886, 64, 2461, 65, 44, "Print"],
Cell[4350, 131, 1202, 31, 25, "Print"],
Cell[5555, 164, 331, 6, 26, "Print"],
Cell[5889, 172, 345, 6, 26, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6295, 185, 35, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[6355, 189, 41, 0, 35, "Subsubsection"],
Cell[6399, 191, 1192, 36, 148, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7640, 233, 44, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[7709, 237, 2570, 69, 182, "Input"],
Cell[10282, 308, 3319, 121, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13650, 435, 67, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[13742, 439, 1534, 45, 131, "Input"],
Cell[15279, 486, 2896, 96, 76, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18224, 588, 429, 7, 69, "Subsection"],
Cell[18656, 597, 748, 12, 59, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19441, 614, 335, 6, 69, "Subsection"],
Cell[19779, 622, 697, 23, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20513, 650, 368, 7, 94, "Subsection"],
Cell[20884, 659, 677, 19, 28, "Input"],
Cell[21564, 680, 1720, 37, 63, "Input"],
Cell[23287, 719, 91, 1, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23415, 725, 160, 4, 69, "Subsection"],
Cell[CellGroupData[{
Cell[23600, 733, 952, 27, 97, "Input"],
Cell[24555, 762, 3019, 96, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27611, 863, 653, 17, 28, "Input"],
Cell[28267, 882, 3231, 97, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31535, 984, 231, 5, 28, "Input"],
Cell[31769, 991, 1608, 57, 53, "Output"]
}, Open  ]],
Cell[33392, 1051, 26, 0, 28, "Input"],
Cell[CellGroupData[{
Cell[33443, 1055, 632, 18, 46, "Input"],
Cell[34078, 1075, 114, 2, 48, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

