(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20744,        719]
NotebookOptionsPosition[     18991,        651]
NotebookOutlinePosition[     19348,        667]
CellTagsIndexPosition[     19305,        664]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", 
  "\"\</Users/marcozaro/Physics/feyncalc-master/FeynCalc/fc.m\>\""}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"FeynCalc \"\>", "Text",
     StripOnInput->False,
     FontWeight->Bold], "\[InvisibleSpace]", 
    StyleBox["\<\"9.1.0 (development version). For help, use the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"documentation", " ", "center"}],
       BaseStyle->"Link",
       ButtonData:>"paclet:FeynCalc/",
       ButtonNote->"paclet:FeynCalc/"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\", check out the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox["wiki",
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None},
       ButtonNote->"https://github.com/FeynCalc/feyncalc/wiki"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" or write to the \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"mailing", " ", 
        RowBox[{"list", "."}]}],
       BaseStyle->"Hyperlink",
       ButtonData:>{
         URL["http://www.feyncalc.org/forum/"], None},
       ButtonNote->"http://www.feyncalc.org/forum/"],
      DisplayForm], "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["FeynCalc ", "Text", Bold], 
    Style["9.1.0 (development version). For help, use the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "documentation center", BaseStyle -> "Link", ButtonData :> 
       "paclet:FeynCalc/", ButtonNote -> "paclet:FeynCalc/"]], "Text"], 
    Style[", check out the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["wiki", ButtonData :> {
         URL["https://github.com/FeynCalc/feyncalc/wiki"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> 
       "https://github.com/FeynCalc/feyncalc/wiki"]], "Text"], 
    Style[" or write to the ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox["mailing list.", ButtonData :> {
         URL["http://www.feyncalc.org/forum/"], None}, BaseStyle -> 
       "Hyperlink", ButtonNote -> "http://www.feyncalc.org/forum/"]], "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.69303902949454*^9, 3.6930399100242023`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"See also the supplied \"\>", "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox[
     TagBox[
      ButtonBox[
       RowBox[{"examples", "."}],
       BaseStyle->"Hyperlink",
       ButtonFunction:>SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]],
       Evaluator->Automatic,
       Method->"Preemptive"],
      DisplayForm], "Text",
     StripOnInput->False], "\[InvisibleSpace]", 
    StyleBox["\<\" If you use FeynCalc in your research, please cite\"\>", 
     "Text",
     StripOnInput->False]}],
   SequenceForm[
    Style["See also the supplied ", "Text"], 
    Style[
     DisplayForm[
      ButtonBox[
      "examples.", BaseStyle -> "Hyperlink", ButtonFunction :> SystemOpen[
         FileNameJoin[{FeynCalc`$FeynCalcDirectory, "Examples"}]], Evaluator -> 
       Automatic, Method -> "Preemptive"]], "Text"], 
    Style[" If you use FeynCalc in your research, please cite", "Text"]],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.69303902949454*^9, 3.693039910029832*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] V. Shtabovenko, R. Mertig and F. Orellana, TUM-EFT \
71/15, arXiv:1601.01167\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.69303902949454*^9, 3.693039910034374*^9}],

Cell[BoxData[
 FormBox[
  StyleBox["\<\" \[Bullet] R. Mertig, M. B\[ODoubleDot]hm, and A. Denner, \
Comput. Phys. Commun., 64, 345-359, 1991.\"\>", "Text",
   StripOnInput->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.69303902949454*^9, 3.69303991003861*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spin-1/2 vs scalar quarks", "Title",
 CellChangeTimes->{{3.693039048153269*^9, 3.693039055120265*^9}}],

Cell[CellGroupData[{

Cell["we compute the cross section e+(p1) e-(p2) > q(p3) q~(p4)", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039094965802*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p2"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p3"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p4", ",", "p4"}], "]"}], " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p3", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{"s", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p4"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p2", ",", "p3"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "u"}], "/", "2"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6930391053897133`*^9, 3.6930391058309107`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The leptonic part of the cross section", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lmunu", " ", "=", " ", 
  RowBox[{"Tr", "[", 
   RowBox[{
    RowBox[{"GS", "[", "p1", "]"}], ".", 
    RowBox[{"GA", "[", "mu", "]"}], ".", 
    RowBox[{"GS", "[", "p2", "]"}], ".", 
    RowBox[{"GA", "[", "nu", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.693039125452209*^9, 3.6930391752723217`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"s", " ", 
      FormBox[
       SuperscriptBox[
        OverscriptBox["g", "_"], 
        RowBox[{
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]}]],
       TraditionalForm]}], "-", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}], "-", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p1",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p2",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6930391756863317`*^9, 3.693039188289091*^9}, 
   3.693039910482806*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The hadronic part of the cross section for spin-1/2, and the total matrix \
element\
\>", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.693039203772478*^9, 3.693039252982416*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WmunuFermion", " ", "=", " ", 
  RowBox[{"Tr", "[", 
   RowBox[{
    RowBox[{"GS", "[", "p3", "]"}], ".", 
    RowBox[{"GA", "[", "mu", "]"}], ".", 
    RowBox[{"GS", "[", "p4", "]"}], ".", 
    RowBox[{"GA", "[", "nu", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.693039125452209*^9, 3.6930391752723217`*^9}, {
  3.6930392149801083`*^9, 3.693039230919681*^9}, {3.693127070874337*^9, 
  3.6931271027239437`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"s", " ", 
      FormBox[
       SuperscriptBox[
        OverscriptBox["g", "_"], 
        RowBox[{
         FormBox[
          FormBox[
           FormBox["mu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           FormBox["nu",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm]}]],
       TraditionalForm]}], "-", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}], "-", 
     RowBox[{"2", " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p3",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["mu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm], " ", 
      FormBox[
       SuperscriptBox[
        FormBox[
         OverscriptBox[
          FormBox["p4",
           TraditionalForm], "_"],
         TraditionalForm], 
        FormBox[
         FormBox[
          FormBox["nu",
           TraditionalForm],
          TraditionalForm],
         TraditionalForm]],
       TraditionalForm]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.693039242861771*^9, 3.693039910541121*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AmpFermion", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Contract", " ", "[", 
     RowBox[{"WmunuFermion", " ", "Lmunu"}], "]"}], "/", " ", 
    RowBox[{
     RowBox[{"SP", "[", 
      RowBox[{"p1", "+", "p2"}], "]"}], "^", "2"}]}], " ", "//", 
   "ExpandScalarProduct"}]}]], "Input",
 CellChangeTimes->{{3.693039245802354*^9, 3.693039312937352*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["t", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["u", "2"]}]}], 
   SuperscriptBox["s", "2"]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.693039276340749*^9, {3.693039308093046*^9, 3.6930393131384697`*^9}, 
   3.693039910587453*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The hadronic part of the cross section for a scalar, and the total matrix \
element. The S(k)S(k\[CloseCurlyQuote])V(-k-k\[CloseCurlyQuote], mu) vertex \
is ie(k-k\[CloseCurlyQuote])^mu\
\>", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.693039203772478*^9, 3.693039252982416*^9}, {3.693039320241497*^9, 
  3.693039408731784*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WmunuScalar", "=", 
  RowBox[{
   RowBox[{"FV", "[", 
    RowBox[{
     RowBox[{"p3", "-", "p4"}], ",", "mu"}], "]"}], 
   RowBox[{"FV", "[", 
    RowBox[{
     RowBox[{"p3", "-", "p4"}], ",", "nu"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.693039323525537*^9, 3.6930393334056673`*^9}, {
  3.693039420533457*^9, 3.6930394353167067`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    FormBox[
     SuperscriptBox[
      RowBox[{"(", 
       FormBox[
        FormBox[
         RowBox[{
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"], "-", 
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"]}],
         TraditionalForm],
        TraditionalForm], ")"}], 
      FormBox[
       FormBox[
        FormBox["mu",
         TraditionalForm],
        TraditionalForm],
       TraditionalForm]],
     TraditionalForm],
    TraditionalForm], " ", 
   FormBox[
    FormBox[
     SuperscriptBox[
      RowBox[{"(", 
       FormBox[
        FormBox[
         RowBox[{
          OverscriptBox[
           FormBox["p3",
            TraditionalForm], "_"], "-", 
          OverscriptBox[
           FormBox["p4",
            TraditionalForm], "_"]}],
         TraditionalForm],
        TraditionalForm], ")"}], 
      FormBox[
       FormBox[
        FormBox["nu",
         TraditionalForm],
        TraditionalForm],
       TraditionalForm]],
     TraditionalForm],
    TraditionalForm]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.693039458151698*^9, 3.693039910631071*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AmpScalar", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Contract", " ", "[", 
      RowBox[{"WmunuScalar", " ", "Lmunu"}], "]"}], "/", " ", 
     RowBox[{
      RowBox[{"SP", "[", 
       RowBox[{"p1", "+", "p2"}], "]"}], "^", "2"}]}], " ", "//", 
    "ExpandScalarProduct"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.693039447693351*^9, 3.693039466254558*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["s", "2"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"t", "-", "u"}], ")"}], "2"]}], ")"}]}], 
   SuperscriptBox["s", "2"]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693039454137134*^9, 3.693039466695468*^9}, 
   3.693039910690022*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["In DIS, we need to replace s->T, t->S, u->U", "Section",
 CellChangeTimes->{{3.693039062567734*^9, 3.693039121124161*^9}, {
  3.693039203772478*^9, 3.693039252982416*^9}, {3.693039320241497*^9, 
  3.693039408731784*^9}, {3.693039486354397*^9, 3.6930395019281816`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DISreplace", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", "T"}], ",", " ", 
     RowBox[{"t", "\[Rule]", "S"}], ",", " ", 
     RowBox[{"u", "\[Rule]", "U"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DISreplace2", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "\[Rule]", 
      RowBox[{"-", "Q2"}]}], ",", " ", 
     RowBox[{"U", "\[Rule]", " ", 
      RowBox[{"S", 
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}]}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.693039511539997*^9, 3.693039521223592*^9}, {
  3.693039662301601*^9, 3.69303966997472*^9}, {3.6930398660399427`*^9, 
  3.6930399277280912`*^9}}],

Cell[BoxData[{
 RowBox[{"AmpFermionDIS", " ", "=", " ", 
  RowBox[{
   RowBox[{"AmpFermion", " ", "/.", "DISreplace"}], " ", "/.", 
   "DISreplace2"}]}], "\[IndentingNewLine]", 
 RowBox[{"AmpScalarDIS", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"AmpScalar", " ", "/.", "DISreplace"}], "/.", "DISreplace2"}], 
     " ", "/.", 
     RowBox[{"{", 
      RowBox[{"Q2", "\[Rule]", " ", 
       RowBox[{
        RowBox[{"-", "S"}], "  ", "x", " ", "y"}]}], "}"}]}], " ", "/.", " ", 
    
    RowBox[{"x", "\[Rule]", "1"}]}], "//", "Simplify", " "}]}]}], "Input",
 CellChangeTimes->{{3.693039562590953*^9, 3.693039609767437*^9}, {
  3.69303988989855*^9, 3.6930399001178102`*^9}, {3.693039933415969*^9, 
  3.693039948918563*^9}, {3.6930412006969213`*^9, 3.6930412010710793`*^9}, {
  3.6930419330796423`*^9, 3.693041934379951*^9}, {3.693041982923629*^9, 
  3.693041984041925*^9}, {3.6930423392707987`*^9, 3.693042370214587*^9}, {
  3.693042462398498*^9, 3.6930425194736233`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"at", " ", "LO"}], " ", "+", " ", 
    RowBox[{
    "with", " ", "our", " ", "choice", " ", "of", " ", "momenta", " ", "one", 
     " ", "has", " ", "x"}]}], "=", "1"}]}]], "Input",
 CellChangeTimes->{{3.693042525358066*^9, 3.693042539751954*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["S", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", "-", "1"}], ")"}], "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["S", "2"]}]}], 
   SuperscriptBox["Q2", "2"]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693042470856336*^9, 3.6930424885340147`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"y", "-", "1"}], ")"}]}], 
   SuperscriptBox["y", "2"]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.693042470856336*^9, 3.693042488546664*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 596},
WindowMargins->{{12, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 109, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[714, 28, 2391, 64, 44, "Print"],
Cell[3108, 94, 1130, 30, 25, "Print"],
Cell[4241, 126, 257, 5, 26, "Print"],
Cell[4501, 133, 270, 5, 26, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4820, 144, 108, 1, 92, "Title"],
Cell[CellGroupData[{
Cell[4953, 149, 142, 1, 64, "Section"],
Cell[5098, 152, 1767, 55, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6902, 212, 123, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[7050, 217, 332, 8, 28, "Input"],
Cell[7385, 227, 2085, 83, 34, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9519, 316, 225, 5, 99, "Section"],
Cell[CellGroupData[{
Cell[9769, 325, 441, 10, 28, "Input"],
Cell[10213, 337, 2055, 82, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12305, 424, 383, 10, 28, "Input"],
Cell[12691, 436, 349, 11, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13089, 453, 376, 7, 99, "Section"],
Cell[CellGroupData[{
Cell[13490, 464, 364, 10, 28, "Input"],
Cell[13857, 476, 1205, 49, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15099, 530, 420, 11, 28, "Input"],
Cell[15522, 543, 382, 12, 54, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15953, 561, 274, 3, 64, "Section"],
Cell[16230, 566, 733, 20, 46, "Input"],
Cell[16966, 588, 1008, 23, 46, "Input"],
Cell[CellGroupData[{
Cell[17999, 615, 312, 8, 28, "Input"],
Cell[18314, 625, 391, 12, 55, "Output"],
Cell[18708, 639, 243, 7, 52, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

