(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    113358,       2897]
NotebookOptionsPosition[    108069,       2719]
NotebookOutlinePosition[    108507,       2736]
CellTagsIndexPosition[    108464,       2733]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Phenomenology of pp\[Rule]H+X at NLO", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[TextData[{
 StyleBox["In this notebook we calculate the inclusive cross section for \
Higgs production at hadron colliders, at NLO in the strong coupling. We use \
the analytic results obtained in a previous notebook corresponding to the \
original calculation by Sally Dawson (Nuclear Physics B (1991) 283). To get \
useful numbers we use a modern set of PDF, i.e. the MRST as implemented in ",
  FontSize->16],
 StyleBox["Mathematica",
  FontSize->16,
  FontSlant->"Italic"],
 StyleBox[" by J.Andersen (many thanks!).  A description of the calculation, \
including the formulas used here for the numerical results, is given in the \
notes.",
  FontSize->16]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell["\<\
Off[General::spell];
Off[General::spell1];
Clear[\"Global`*\"];\
\>", "Input"],

Cell[CellGroupData[{

Cell["Install Vegas", "Subsection"],

Cell["\<\
I use the  Vegas package of CUBA library of T. Hahn (hep-ph/0404043). If you \
do not want to use it, use NIntegrate instead of Vegas\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Install", "[", "\"\</Users/fabiomaltoni/Physics/Codes/CUBA/VegasX\>\"", 
   "]"}], 
  RowBox[{
  "Install", "[", "\"\</Users/fabiomaltoni/Physics/Codes/CUBA/SuaveX\>\"", 
   "]"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"LinkOpen", "::", "linke"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"Could not find \
MathLink executable\\\\\\\"\\\", TraditionalForm]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinkOpen/linke\\\", \
ButtonNote -> \\\"LinkOpen::linke\\\"]\\)\"\>"}], TraditionalForm]], "Message",\
 "MSG",
 CellChangeTimes->{3.692597281046434*^9, 3.6925973706453047`*^9, 
  3.692598560178931*^9, 3.692600928086647*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"LinkOpen", "::", "linke"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"Could not find \
MathLink executable\\\\\\\"\\\", TraditionalForm]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinkOpen/linke\\\", \
ButtonNote -> \\\"LinkOpen::linke\\\"]\\)\"\>"}], TraditionalForm]], "Message",\
 "MSG",
 CellChangeTimes->{3.692597281046434*^9, 3.6925973706453047`*^9, 
  3.692598560178931*^9, 3.692600928130375*^9}],

Cell[BoxData[
 FormBox[
  SuperscriptBox["$Failed", "2"], TraditionalForm]], "Output",
 CellChangeTimes->{3.692597281097068*^9, 3.69259737067906*^9, 
  3.692598560229701*^9, 3.692600928162171*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Call special graphics routines", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
<< Graphics`Colors`;
<< Graphics`Graphics`;\
\>", "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"Get", "::", "noopen"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"Graphics`Colors`\\\\\\\"\\\", \
TraditionalForm]\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.692597281174869*^9, 3.692597370755665*^9, 
  3.692598560342369*^9, 3.692600928264494*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"Get", "::", "noopen"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"Graphics`Graphics`\\\\\\\"\\\", \
TraditionalForm]\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.692597281174869*^9, 3.692597370755665*^9, 
  3.692598560342369*^9, 3.692600928322658*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Install PDF'S: for help read the PDF-HOWTO document", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "\"\<~/DropBox/GGI/GGHiggs/Jeppe\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Install", "[", "\"\<pdf.exe\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.6925973632884817`*^9, 3.692597419539439*^9}}],

Cell[BoxData[
 FormBox["\<\"/Users/marcozaro/Dropbox/GGI/GGHiggs/Jeppe\"\>", 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.6925972813152027`*^9, {3.692597370915719*^9, 3.692597375754075*^9}, 
   3.69259742117518*^9, 3.6925985604805*^9, 3.692600928383765*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"LinkOpen", "::", "linke"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"\[NoBreak]\\!\\(\\*FormBox[\\\"\\\\\\\"Could not find \
MathLink executable\\\\\\\"\\\", TraditionalForm]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinkOpen/linke\\\", \
ButtonNote -> \\\"LinkOpen::linke\\\"]\\)\"\>"}], TraditionalForm]], "Message",\
 "MSG",
 CellChangeTimes->{
  3.6925972813085747`*^9, {3.692597370911001*^9, 3.692597375749536*^9}, 
   3.6925974212093563`*^9, 3.692598560484562*^9, 3.692600928387562*^9}],

Cell[BoxData[
 FormBox["$Failed", TraditionalForm]], "Output",
 CellChangeTimes->{
  3.6925972813152027`*^9, {3.692597370915719*^9, 3.692597375754075*^9}, 
   3.69259742117518*^9, 3.6925985604805*^9, 3.692600928390266*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

<<\"loadCTEQ5.m\";\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Loading Package: PDF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.692600928429875*^9}],

Cell[BoxData[
 FormBox["\<\"PDF's from CTEQ5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.692600928434042*^9}],

Cell[BoxData[
 FormBox["\<\"Eur.Phys.J.C12:375-392,2000 \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.6926009284386387`*^9}],

Cell[BoxData[
 FormBox["\<\"*** Warning *** Unofficial release. \"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.6926009284427223`*^9}],

Cell[BoxData[
 FormBox["\<\"*** Cross-check with official Fortran code.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.6926009284466553`*^9}],

Cell[BoxData[
 FormBox["\<\" Version 1.0: Written by Tamara Trout & Fred Olness, October 1, \
2000\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.692600928450611*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.692600928454577*^9}],

Cell[BoxData[
 FormBox["\<\"In case of problems, contact:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.692600928458466*^9}],

Cell[BoxData[
 FormBox["\<\"Fred Olness: olness@mail.physics.smu.edu\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.692597444321074*^9, 3.6925985605638103`*^9, 
  3.6926009284624033`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Wrapper to call the pdf. Notation is self-explanatory. Just notice that all \
parton distribution codes usually return x f(x). To avoid confusion, at \
expense of a couple more floating point operations, I divide all the values \
by the corresponding x.  pdfcall calculates the parton-parton luminoties, gg \
qg, qq~\
\>", "Subsubsection"],

Cell["\<\
(* MRST *)

pdfMRST[X1_,X2_,q_]:=Module[
{Q,xgDF,xdDF,xdbDF,xuDF,xubDF,xsDF,xcDF,xbDF,pd1,pd2,xgg,xqg,xqq},
Q=q*1.;
xgDF =f[3,X1,Q]/X1;
xdbDF=f[8,X1,Q]/X1;
xdDF =f[2,X1,Q]/X1+xdbDF;
xubDF=f[4,X1,Q]/X1;
xuDF =f[1,X1,Q]/X1+xubDF;
xsDF =f[6,X1,Q]/X1;
xcDF =f[5,X1,Q]/X1;
xbDF =f[7,X1,Q]/X1;

pd1={xgDF,xdDF,xdbDF,xuDF,xubDF,xsDF,xcDF,xbDF};
xgDF =f[3,X2,Q]/X2;
xdbDF=f[8,X2,Q]/X2;
xdDF =f[2,X2,Q]/X2+xdbDF;
xubDF=f[4,X2,Q]/X2;
xuDF =f[1,X2,Q]/X2+xubDF;
xsDF =f[6,X2,Q]/X2;
xcDF =f[5,X2,Q]/X2;
xbDF =f[7,X2,Q]/X2;
pd2={xgDF,xdDF,xdbDF,xuDF,xubDF,xsDF,xcDF,xbDF};


xgg=pd1[[1]]*pd2[[1]];
xqg=pd1[[1]]*(pd2[[2]]+pd2[[3]]+pd2[[4]]+pd2[[5]]+2(pd2[[6]]+pd2[[7]]+pd2[[8]]\
))+
   pd2[[1]]*(pd1[[2]]+pd1[[3]]+pd1[[4]]+pd1[[5]]+2(pd1[[6]]+pd1[[7]]+pd1[[8]])\
);
xqq=pd1[[2]]*pd2[[3]]+pd1[[4]]*pd2[[5]]+pd1[[3]]*pd2[[2]]+pd1[[5]]*pd2[[4]]+
   2(pd1[[6]] pd2[[6]]+pd1[[7]] pd2[[7]]+pd1[[8]] pd2[[8]]);
  
  Return[{xgg,xqg,xqq}]; 
];\
\>", "Input"],

Cell["\<\

(* cteq5 *)\
\>", "Input"],

Cell["\<\
pdfCTEQ[X1_,X2_,q_]:=Module[
{Q,pd1,pd2,xgg,xqg,xqq},
Q=q*1.;

pd1={cteq5pdf[1,0,X1,Q],
     cteq5pdf[1,2,X1,Q],
     cteq5pdf[1,-2,X1,Q],
     cteq5pdf[1,1,X1,Q],
     cteq5pdf[1,-1,X1,Q],
     cteq5pdf[1,3,X1,Q],
     cteq5pdf[1,4,X1,Q],
     cteq5pdf[1,5,X1,Q]};
pd2={cteq5pdf[1,0,X2,Q],
     cteq5pdf[1,2,X2,Q],
     cteq5pdf[1,-2,X2,Q],
     cteq5pdf[1,1,X2,Q],
     cteq5pdf[1,-1,X2,Q],
     cteq5pdf[1,3,X2,Q],
     cteq5pdf[1,4,X2,Q],
     cteq5pdf[1,5,X2,Q]};
     
xgg=pd1[[1]]*pd2[[1]];
xqg=pd1[[1]]*(pd2[[2]]+pd2[[3]]+pd2[[4]]+pd2[[5]]+2(pd2[[6]]+pd2[[7]]+pd2[[8]]\
))+
   pd2[[1]]*(pd1[[2]]+pd1[[3]]+pd1[[4]]+pd1[[5]]+2(pd1[[6]]+pd1[[7]]+pd1[[8]])\
);
xqq=pd1[[2]]*pd2[[3]]+pd1[[4]]*pd2[[5]]+pd1[[3]]*pd2[[2]]+pd1[[5]]*pd2[[4]]+
   2(pd1[[6]] pd2[[6]]+pd1[[7]] pd2[[7]]+pd1[[8]] pd2[[8]]);
  
  Return[{xgg,xqg,xqq}]; 
];

pdfCTEQLO[X1_,X2_,q_]:=Module[
{Q,xgDF,xdDF,xdbDF,xuDF,xubDF,xsDF,xcDF,xbDF,pd1,pd2,xgg,xqg,xqq},
Q=q*1.;

pd1={cteq5pdf[3,0,X1,Q],
     cteq5pdf[3,2,X1,Q],
     cteq5pdf[3,-2,X1,Q],
     cteq5pdf[3,1,X1,Q],
     cteq5pdf[3,-1,X1,Q],
     cteq5pdf[3,3,X1,Q],
     cteq5pdf[3,4,X1,Q],
     cteq5pdf[3,5,X1,Q]};
pd2={cteq5pdf[3,0,X2,Q],
     cteq5pdf[3,2,X2,Q],
     cteq5pdf[3,-2,X2,Q],
     cteq5pdf[3,1,X2,Q],
     cteq5pdf[3,-1,X2,Q],
     cteq5pdf[3,3,X2,Q],
     cteq5pdf[3,4,X2,Q],
     cteq5pdf[3,5,X2,Q]};
     
xgg=pd1[[1]]*pd2[[1]];
xqg=pd1[[1]]*(pd2[[2]]+pd2[[3]]+pd2[[4]]+pd2[[5]]+2(pd2[[6]]+pd2[[7]]+pd2[[8]]\
))+
   pd2[[1]]*(pd1[[2]]+pd1[[3]]+pd1[[4]]+pd1[[5]]+2(pd1[[6]]+pd1[[7]]+pd1[[8]])\
);
xqq=pd1[[2]]*pd2[[3]]+pd1[[4]]*pd2[[5]]+pd1[[3]]*pd2[[2]]+pd1[[5]]*pd2[[4]]+
   2(pd1[[6]] pd2[[6]]+pd1[[7]] pd2[[7]]+pd1[[8]] pd2[[8]]);
  
  Return[{xgg,xqg,xqq}]; 
];\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decide the pdf family to be used ", "Subsubsection"],

Cell["pdfcall[x__] = pdfCTEQ[x];", "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Alpha_S: Very basic implementation of Alpha_S. 
Check that the value of Lamda_4 or Lambda_5 is consistent with that of the \
PDF. 
One simple, but indirect way to do it is to compare the value of alphas(MZ) \
with the one quoted by MRST.\
\>", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"b", "[", "nf_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"33", "-", 
        RowBox[{"2", " ", "nf"}]}], ")"}], "/", "12"}], "/", "Pi"}]}], ";"}], 
  "                                  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bp", "[", "nf_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"153", "-", 
        RowBox[{"19", " ", "nf"}]}], ")"}], "/", "2"}], "/", "Pi"}], "/", 
    RowBox[{"(", 
     RowBox[{"33", "-", 
      RowBox[{"2", " ", "nf"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", "nf", "]"}], ":=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"q", "^", "2"}], "/", 
     RowBox[{
      RowBox[{"\[CapitalLambda]", "[", "nf", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mb", "=", "4.75"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalLambda]", "[", "5", "]"}], "=", "0.146"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asLO", "[", 
    RowBox[{"q_", ",", "nf_"}], "]"}], "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "[", "nf", "]"}], " ", 
      RowBox[{"t", "[", "nf", "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalLambda]", "[", "5", "]"}], "=", "0.226"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asNLO", "[", 
    RowBox[{"q_", ",", "nf_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "[", "nf", "]"}], " ", 
       RowBox[{"t", "[", "nf", "]"}]}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{
        RowBox[{"bp", "[", "nf", "]"}], "/", 
        RowBox[{"b", "[", "nf", "]"}]}], " ", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"t", "[", "nf", "]"}], "]"}], "/", 
        RowBox[{"t", "[", "nf", "]"}]}]}]}], ")"}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell["Check the values of alpha_S at the scale MZ", "Subsubsection"],

Cell[CellGroupData[{

Cell["asNLO[91.118,5]", "Input"],

Cell[BoxData[
 FormBox["0.11799518835498904`", TraditionalForm]], "Output",
 CellChangeTimes->{3.692597281533689*^9, 3.692597537385448*^9, 
  3.692598560867756*^9, 3.6926009285672293`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Color factors ", "Subsection"],

Cell["\<\
CF=4/3;
CA=3;
nf=5;
TF=1/2;
b0=11/6 CA -2 nf TF/3;
\
\>", "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LO cross section", "Section"],

Cell[CellGroupData[{

Cell["\<\
Integral of the LO loop. The sign of the Imaginary part is given by the usual \
prescription mt^2-i eps which is equivalent to t+i eps in the notation below.
t=mh^2/4/mt^2;\
\>", "Subsubsection"],

Cell[" ", "Input"],

Cell[CellGroupData[{

Cell["\<\
eps=0.00000001;
inte01[t_]=Integrate[(1-4 x y)/(1-4 t x y),{x,0,1},{y,0,1-x}, \
Assumptions->{t>0, t<1}]//Simplify
integt1[t_]=Integrate[(1-4 x y)/(1-4 t x y),{x,0,1},{y,0,1-x}, \
Assumptions->{Im[t]>0, Re[t]>1}]//Simplify
inte[t_]:=3*If[ Re[t]<1, inte01[t], integt1[t]]
Plot[{Re[inte[t+I eps]],Im[inte[t+I \
eps]]},{t,0,10},PlotStyle\[Rule]{{Blue,Thickness[0.007]},{Red,Thickness[0.007]\
}}]\
\>", "Input",
 CellChangeTimes->{{3.692598014632957*^9, 3.692598098844996*^9}, {
   3.692598128904375*^9, 3.6925981341662483`*^9}, {3.692598281716309*^9, 
   3.6925982901939507`*^9}, 3.692598627050342*^9, 3.692598666202496*^9, 
   3.692598717354951*^9, {3.69259877873766*^9, 3.6925987812311983`*^9}, {
   3.69259881448775*^9, 3.692598872665801*^9}, {3.692598907681793*^9, 
   3.692598969264979*^9}, {3.692599025202613*^9, 3.692599123951459*^9}, {
   3.6925992374042807`*^9, 3.692599269005123*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], " ", 
     TemplateBox[{"2",RowBox[{
         RowBox[{"2", " ", "t"}], "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           SqrtBox[
            RowBox[{
              RowBox[{"-", 
                RowBox[{"(", 
                  RowBox[{"t", "-", "1"}], ")"}]}], " ", "t"}]]}]}]},
      "PolyLog"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], " ", 
     TemplateBox[{"2",RowBox[{
         RowBox[{"2", " ", "t"}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           SqrtBox[
            RowBox[{
              RowBox[{"-", 
                RowBox[{"(", 
                  RowBox[{"t", "-", "1"}], ")"}]}], " ", "t"}]]}]}]},
      "PolyLog"]}], "+", 
    RowBox[{"2", " ", "t"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["t", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692598901668117*^9, 3.692598959121788*^9, {3.692599021175414*^9, 
   3.692599046704132*^9}, 3.6925991193441973`*^9, 3.692599187436233*^9, 
   3.69259928561417*^9, 3.6926009513029757`*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], " ", 
     TemplateBox[{"2",RowBox[{
         RowBox[{"2", " ", "t"}], "-", 
         RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{"t", "-", "1"}], ")"}], " ", "t"}]]}]}]},
      "PolyLog"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], " ", 
     TemplateBox[{"2",RowBox[{"2", " ", 
         RowBox[{"(", 
           RowBox[{"t", "+", 
             SqrtBox[
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"t", "-", "1"}], ")"}], " ", "t"}]]}], ")"}]}]},
      "PolyLog"]}], "+", 
    RowBox[{"2", " ", "t"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["t", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692598901668117*^9, 3.692598959121788*^9, {3.692599021175414*^9, 
   3.692599046704132*^9}, 3.6925991193441973`*^9, 3.692599187436233*^9, 
   3.69259928561417*^9, 3.6926010000319*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{{}, {}, 
     {RGBColor[0, 0, 1], Thickness[0.007], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVlnc81t3/x82oqBRCsi5JSDRkxOtTaQ8qpWGvVMqtW6lQomGklFGJlF1u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       "]]}, 
     {RGBColor[1, 0, 0], Thickness[0.007], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV13k4VG8bB/Cxz9iSLakkM5E1imw59xMRJVnak0LWEClUshTREIVWUUlC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       "]]}}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
     AbsolutePointSize[6], "ScalingFunctions" -> None},
   PlotRange->{{0, 10}, {0., 1.7384634940975814`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692598901668117*^9, 3.692598959121788*^9, {3.692599021175414*^9, 
   3.692599046704132*^9}, 3.6925991193441973`*^9, 3.692599187436233*^9, 
   3.69259928561417*^9, 3.692601000884819*^9}]
}, Open  ]],

Cell["\<\
Plot of the real and imaginary part of 3*I(a) as defined in the notes (I use \
3*I(a) so that the function goes to 1 as a->0.)\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Function to be integrated to get the LO cross section. In general, we use \
the convention that all functions to be numerically integrated in the \
hypercubes ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}], "d"], TraditionalForm]]],
 ", where d is the dimension of the integration space. dsigma depends on the \
Higgs mass (mh), the total collider energy (sqrtS) and from the arbitrary \
normalization and factorization scales (mur,muf)."
}], "Subsubsection"],

Cell["\<\
dsigmaLO[zz_,mh_,sqrtS_,muf_,mur_]:=Module[
{y,x1,x2,gg0,qg0,qq0,s0,ymin,ymax,JAC,v,S,tau0},
Muf=muf*1.;
v=246.;
S=sqrtS^2;
tau0=mh^2/S;
ymax=-Log[Sqrt[tau0]];
ymin=-ymax;
y=ymin+(ymax-ymin)*zz;
JAC=ymax-ymin;
x1=Sqrt[tau0] Exp[y];
x2=Sqrt[tau0] Exp[-y];
{gg0,qg0,qq0}=pdfCTEQLO[x1,x2,Muf];
s0=asLO[mur,5]^2/576/Pi/v^2*tau0;
s0=s0*gg0;
s0=s0*389379660; (*to picobarns*)
s0=s0*JAC;
Return[s0];
];\
\>", "Input"],

Cell[CellGroupData[{

Cell["sLO=NIntegrate[dsigmaLO[xx,100,14000,100,100],{xx,0,1}]", "Input"],

Cell[BoxData[
 FormBox["32.22522904747175`", TraditionalForm]], "Output",
 CellChangeTimes->{3.692597362173498*^9, 3.692597627791092*^9, 
  3.692599370554532*^9, 3.6926010013707323`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Get the cross section for various Higgs masses and including the form factor \
of the loop.
I first build a table with the results of the cross section in picobarns, and \
then plot it.\
\>", "Subsection"],

Cell["\<\
resEFT=Table[{i,NIntegrate[dsigmaLO[x,i*1.,14000.,i*1.,i*1.],{x,0,1}]},{i,20,\
600,10}];\
\>", "Input"],

Cell["\<\
resFULL=Table[{resEFT[[i]][[1]],Abs[inte[resEFT[[i]][[1]]^2/175^2/4]]^2*\
resEFT[[i]][[2]]},{i,1,Length[resEFT]}];\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"resEFT", ",", " ", "resFULL"}], "}"}], ",", " ", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"PlotLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"EFT", ",", " ", "FULL"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6925995130057592`*^9, 3.692599673664235*^9}, {
  3.6925997070262327`*^9, 3.692599793542263*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtz3lIk3EYwPFpqamYKWaiKVoNypT2Ryrl9UwSmYo2FaXD2GRz6srpUucx
d5natbL+sBlikivBJRGbZYJNuqaRMFJnojkvbGZJeLQ8mBm/54WXlw/P7/l9
eYNyBGlcewqFErnz/v+S5yRs9iZ/WVT5AHEMVIdOKvPp3ugzYGx6NG8WeqEZ
0Nni2HXU6olOgRLpIa8YrQexjAkK33ZB24N9OM8A4xzr1Okwd5xnQsSTpbB4
vhvOz4FpwviX1u+K8wsQGn1zLSreBeeXgKUfsaZ820MMLDgobzAIbzvheTb4
vWzKqk91JO7LAW1sXabTEQfc58CGN80y47Qb97kQSRUrOOv2uJ8LPUPp0f5W
O9znQQ4nBEzbFNzPh+xRlaHWEw0FcC9pVay8aIsl+3xgKwuK1eot4r7LUJCX
+nR1c4OYUgguz7zpyex1YhAAr9bZ0DxkRRdBkNU2uMb8QzxVBAFlnWrZ+Cre
XwyKurZesWCFOFAI9k5NXVFuy9gTwuf2JNNh3W9i1lX41Jq+lWBYwn4J0Nyz
dKLwn8StJcBspn/8oVvAfincvy6iDtC/Y78U0iUTyuSJOeyXwfsxd9Wbmhns
i8DRp3KvKGIK+yLwU/St6H6NY78cRqTU7heKUexXAM92ljoWMoT9CjBZpgu5
pkHsV0J2Vba5s+ID9itB4/88+FVND/arIHzSuJ/fpca+GK5tP5SUBDfqSV8M
jruWGx1OdBGzqqE5I6rtTuJbYooEAjQBMx3mAeJWCWjFnjabxkgMUmBY0npT
zg8TT0khMPfr44TNUZzLIJETx+PeHSdukEH5jTh3/wNmPC+DllC+tpAxTUyT
Q9jx/u56u1limRz0zFt5rro5YqMcXlOveBxjzxMHKoCpWutwc7YQF+3Yd2xr
VrOA/6cA43rQu2HGov4fQF8saQ==
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1z3lIk3EYB/B55U2HszTEFAcloXYp6Ui/pLlKMM0jTFzTtG3p8kin89zm
MMNAs2FgieJRoYVliRP/aLIRlKGZ/qGIOo9KTM0ybXl08T698PLy4fl93+/z
c09KP59iymKxuH/ff1/mOYaO0rlHBbVOYByIuYMjwUshu8khOJKwOeohY5PP
oCy29pyR5UAOR7+hKVXUu5OxPBJhupXF9dYdNI/GyJvtKcvC7TSPhX6u+Lem
zZ7mcWge/Ljh4WRH83hwFjm9RQ9saM5HaIKVeU+kNWMIMOEnaDY6WtH5RMgu
O7p7Lm9jrE2CSLxROD5uQflkeIvtLu0bN6d8Cs5yeZLYBTPKX0FRZvtxXxuy
Vohb1fWSNl9TyovxvNVpYExiQvmrSLPQWDt2sCifCnbrQ/1bE7I2DZuzSz7+
3b+CmPw1iPg+FQrVFmOkw7vrXuXhlE1yBjxbItjR8RuMDRmIrDazDROuM5Zn
glVfHTJz8ydjtyw4xKldpHojY20WJHVmEx7OZMF1OEvvtwdW/KD+bLzyqUxw
dyM3ZGMwqUXFmVqj/hwgRuV3978NOYiwDT+hEdJ5uRR1uhqRsYb+75YLz7rG
rVP+tI82F/Y8Dfd9KlmQh+EwkSGCR2bJUMqtP+o6SfkGGaQzPeV7T5KRj8b5
p3eeFVCfIR9eAbzKTjXtIy8AZ0iktFCvUn8h+lzmPliWfKf+QjRY7mkyv7hC
/UVYy2IlCw98o/5i6MvKR5YXlqm/GJ2yUH5X1BfqL4Enf8r/a+8C9ZegO93k
yY398zSXI38s7MLnsk+Mq+Rwbqvecp2epfNyRCXGr/YFTDM+pMBWU9WLZs4k
7a+A164Mq8dDo4zfKZD3snPxtmqY7qNETKkgbiCzn3GGEsEer71WZnR0PyXU
zuzTYl1H0B9RsCB4
       "]]}}, {{{}, 
      {GrayLevel[0.4], AbsoluteThickness[0.5], 
       StyleBox[{
         LineBox[{
          Scaled[{0.02, 0}, {600., -0.8527625857530499}], 
           Offset[{3, 0}, Scaled[{0.02, 0}, {600., -0.8527625857530499}]], 
           Offset[{7, 0}, Scaled[{0.02, 0}, {600., -0.8527964031541225}]], 
           Offset[{12, 0}, Scaled[{0.02, 0}, {600., -0.8527964031541225}]]}], 
         LineBox[{
          Scaled[{0.02, 0}, {600., 0.07329423913697602}], 
           Offset[{3, 0}, Scaled[{0.02, 0}, {600., 0.07329423913697602}]], 
           Offset[{7, 0}, Scaled[{0.02, 0}, {600., 0.07332816341223422}]], 
           Offset[{12, 0}, Scaled[{0.02, 0}, {600., 0.07332816341223422}]]}]},
        
        FontColor->GrayLevel[0.4]]}, {
       InsetBox["EFT", Offset[{15, 0}, 
        Scaled[{0.02, 0}, {600., -0.8527964031541225}]], 
        ImageScaled[{0, 0.5}]], 
       InsetBox["FULL", Offset[{15, 0}, 
        Scaled[{0.02, 0}, {600., 0.07332816341223422}]], 
        ImageScaled[{0, 0.5}]]}, 
      {GrayLevel[0.4], AbsoluteThickness[0.5], 
       StyleBox[{{}, {}},
        FontColor->GrayLevel[0.4]]}}, {}}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, -1.3610902020354156`},
   DisplayFunction->Identity,
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{{{-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.916290731874155, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.6931471805599453, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.791759469228055, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.995732273553991, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.0943445622221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.248495242049359, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.382026634673881, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.499809670330265, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.298317366548036, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.703782474656201, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.991464547107982, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.214608098422191, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.396929655216146, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.551080335043404, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.684611727667927, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.802394763324311, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.907755278982137, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.313220387090301, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.600902459542082, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.824046010856292, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->{{All, 50.2}, {All, All}},
   Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
          Part[#, 1]], 
         (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
          Part[#, 1]], 
         (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 600.}, {-1.24185285994449, 6.150862349692874}},
   PlotRangeClipping->False,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.313220387090301, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.824046010856292, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.692599645527886*^9, 3.692599721491393*^9, {3.6925997870283203`*^9, 
   3.692599794342276*^9}, 3.692601005643268*^9}]
}, Open  ]],

Cell["\<\
Cross section (pb) as a function of the Higgs mass. This plot shows how well \
the EFT does. For a Higgs<200 GeV the approximation is very good.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Various ways to do the integration over the x1 and x2.", "Subsection"],

Cell[CellGroupData[{

Cell["\<\

uno=Integrate[x1*x2,{x1,t0,1},{x2,t0/x1,1}]//Expand
due=Integrate[ta,{ta,t0,1},{y,Log[Sqrt[ta]],-Log[Sqrt[ta]]}]//PowerExpand//\
Expand
tre=Integrate[t0/z \
t0/z^2,{z,t0,1},{y,Log[Sqrt[t0/z]],-Log[Sqrt[t0/z]]}]//PowerExpand//Expand\
\>", "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"ConditionalExpression", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["t0", "2"], "4"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["t0", "2"], " ", 
      RowBox[{"log", "(", "t0", ")"}]}], "+", 
     FractionBox["1", "4"]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "(", 
           FractionBox["t0", 
            RowBox[{"1", "-", "t0"}]], ")"}], "\[GreaterEqual]", "0"}], 
         "\[And]", 
         RowBox[{
          FractionBox["t0", 
           RowBox[{"t0", "-", "1"}]], "\[NotEqual]", "0"}]}], ")"}], "\[Or]", 
       
       RowBox[{
        FractionBox["t0", 
         RowBox[{"1", "-", "t0"}]], "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", 
         FractionBox["t0", 
          RowBox[{"1", "-", "t0"}]], ")"}], "<", 
        RowBox[{"-", "1"}]}]}], ")"}], "\[And]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"t0", "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", "t0", ")"}], ">", "1"}], "\[Or]", 
       RowBox[{"0", "<", 
        RowBox[{"Re", "(", "t0", ")"}], "<", "1"}]}], ")"}]}]}], "]"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.692599859998564*^9, 3.6926010108109922`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"ConditionalExpression", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["t0", "2"], "4"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["t0", "2"], " ", 
      RowBox[{"log", "(", "t0", ")"}]}], "+", 
     FractionBox["1", "4"]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "(", 
           FractionBox["t0", 
            RowBox[{"1", "-", "t0"}]], ")"}], "\[GreaterEqual]", "0"}], 
         "\[And]", 
         RowBox[{
          FractionBox["t0", 
           RowBox[{"t0", "-", "1"}]], "\[NotEqual]", "0"}]}], ")"}], "\[Or]", 
       
       RowBox[{
        FractionBox["t0", 
         RowBox[{"1", "-", "t0"}]], "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", 
         FractionBox["t0", 
          RowBox[{"1", "-", "t0"}]], ")"}], "<", 
        RowBox[{"-", "1"}]}]}], ")"}], "\[And]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"t0", "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", "t0", ")"}], ">", "1"}], "\[Or]", 
       RowBox[{"0", "<", 
        RowBox[{"Re", "(", "t0", ")"}], "<", "1"}]}], ")"}]}]}], "]"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.692599859998564*^9, 3.69260101499305*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"ConditionalExpression", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["t0", "2"], "4"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["t0", "2"], " ", 
      RowBox[{"log", "(", "t0", ")"}]}], "+", 
     FractionBox["1", "4"]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "(", 
           FractionBox["t0", 
            RowBox[{"1", "-", "t0"}]], ")"}], "\[GreaterEqual]", "0"}], 
         "\[And]", 
         RowBox[{
          FractionBox["t0", 
           RowBox[{"t0", "-", "1"}]], "\[NotEqual]", "0"}]}], ")"}], "\[Or]", 
       
       RowBox[{
        FractionBox["t0", 
         RowBox[{"1", "-", "t0"}]], "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", 
         FractionBox["t0", 
          RowBox[{"1", "-", "t0"}]], ")"}], "<", 
        RowBox[{"-", "1"}]}]}], ")"}], "\[And]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"t0", "\[NotElement]", 
        TagBox["\[DoubleStruckCapitalR]",
         Function[{}, Reals]]}], "\[Or]", 
       RowBox[{
        RowBox[{"Re", "(", "t0", ")"}], ">", "1"}], "\[Or]", 
       RowBox[{"0", "<", 
        RowBox[{"Re", "(", "t0", ")"}], "<", "1"}]}], ")"}]}]}], "]"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.692599859998564*^9, 3.692601019133106*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NLO cross section", "Section"],

Cell["\<\
We have integrated over the angular variables, so we are only left with two \
integrations. One is over z (=mh/S/x1/x2) and the other over the rapidity y \
of the partonic cms. For every point in the phase space we have to calculate \
an event and a corresponding counter-event with z=1 to implement the + \
distributions in the gg channel. Various contributions add to the final result:

virtual: gg>h  at 1-loop + corrections to the effective lagrangian (UV and IR \
divergent)
real: qq~ >h g (finite)
           qg > qh (collinear divergent)
            gg>gh  (soft and collinear divergent)
\
\>", "Text",
 CellChangeTimes->{3.6925999095314913`*^9},
 FontSize->16],

Cell[CellGroupData[{

Cell["Born+Virtual ", "Subsection"],

Cell[TextData[{
 "dsigmaBV[yy_,mh_,sqrtS_,muf_,mur_]:=Module[\n",
 StyleBox["(* local variables *)",
  FontColor->RGBColor[0, 1, 0]],
 "\n{y0,x10,x20,sig0,ymax0,JAC0,v,S,tau0,beta,gg0,qg0,qq0},\nMuf=muf 1.;\n\
Mur=mur 1.;\nv=246.;\nS=sqrtS^2;\ntau0=mh^2/S;\nbeta=Sqrt[1-tau0];\n\n",
 StyleBox["(* calculate quantities for z=1 *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nymax0=-Log[Sqrt[tau0]];\ny0=-ymax0+2*ymax0*yy;\nJAC0=2*ymax0;\n\
x10=Sqrt[tau0] Exp[y0];\nx20=Sqrt[tau0] Exp[-y0];\n\
{gg0,qg0,qq0}=pdfcall[x10,x20,Muf];\n\n",
 StyleBox["(* sigma0 *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nsig0=asNLO[Mur,5]^2/576/Pi/v^2*tau0;\nsig0=sig0+sig0*asNLO[Mur,5]/2/Pi*\n\
(11/3 CA+ 2 Pi^2 - 2 b0 2 Log[Muf/Mur]+\n16 CA Log[beta] Log[mh/Muf]+16 CA \
Log[beta]^2);\nsig0=sig0*gg0;\nsig0=sig0*389379660; (*to picobarns*)\n\
sig0=sig0*JAC0;\n\n\
(*Print[{muf,mur,v,S,tau0,beta,ymax0,y0,JAC0,x10,x20,gg0,qg0,qq0,sig0}];*)\n\
Return[sig0];\n];"
}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Real contributions", "Subsection"],

Cell[TextData[{
 "dsigmaR[xx_,yy_,mh_,sqrtS_,muf_,mur_]:=Module[\n",
 StyleBox["(* local variables *)",
  FontColor->RGBColor[0, 1, 0]],
 "\n{v,S,tau0,\n y,y0,z,tau,\n x1,x2,x10,x20,\n ymax0,ymax,\n JAC,JAC0,\n \
gg,qg,qq,gg0,qg0,qq0,\n qqterm,qgterm,ggterm,ggterm0,\n sig,sig0,\n Muf},\n\n\
v=246.;\nS=sqrtS^2;\ntau0=mh^2/S;\nMuf=muf*1.0;\n\n",
 StyleBox["(* calculate quantities for an event *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nz=tau0+(1-tau0)*xx;\ntau=tau0/z;\nymax =-Log[Sqrt[tau]];\n\
y=-ymax+2*ymax*yy;\nJAC =2*ymax*(1-tau0)*tau0/z^2;\nx1=Sqrt[tau] Exp[y];\n\
x2=tau/x1;\n",
 StyleBox["(* call the pdf *)\n",
  FontColor->RGBColor[1, 0, 0]],
 "\n{gg,qg,qq}=pdfcall[x1,x2,Muf];\n\n",
 StyleBox["(* calculate quantities for counter-event *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nymax0=-Log[Sqrt[tau0]];\ny0=-ymax0+2*ymax0*yy;\n\
JAC0=2*ymax0*(1-tau0)*tau0;\nx10=Sqrt[tau0] Exp[y0];\nx20=tau0/x10;\n",
 StyleBox["(* call the pdf at z=1 *)",
  FontColor->RGBColor[1, 0, 0]],
 "\n{gg0,qg0,qq0}=pdfcall[x10,x20,Muf];\n\n",
 StyleBox["(* sigma0 *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nsig0=asNLO[mur,5]^2/576/Pi/v^2;\nsig0=sig0*asNLO[mur,5]/2/Pi;\n\n",
 StyleBox["(* qq channnel : no counter event *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nqqterm=64/27*(1-z)^3;\nqqterm=qqterm*sig0*JAC*qq;\n\n",
 StyleBox["(* qg channnel : no counter event *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nqgterm=CF*( (1+(1-z)^2)/z (2*Log[mh/muf]+2 Log[1-z]-Log[z])\n           \
+(z^2-3/2(1-z)^2)/z )*z;\nqgterm=qgterm*sig0*JAC*qg;\n\n",
 StyleBox["(* gg channnel *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nggterm=CA*(2 (2 (z/(1-z)+(1-z)/z+z (1-z) )) * (2*Log[mh/muf])-\n       \
11/3 (1-z)^3/z -\n       4 (1-z+z^2)^2/z/(1-z) Log[z]+\n       8 \
(1-z+z^2)^2/z Log[1-z]/(1-z) )*z;\nggterm=ggterm*sig0*JAC*gg;\n",
 StyleBox["(* gg counter-event *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nggterm0=CA*(-4/(1-z) 2*Log[mh/muf] - 8*Log[1-z]/(1-z) );\n\
ggterm0=ggterm0*sig0*JAC0*gg0;\n\n\n",
 StyleBox["(* total *)",
  FontColor->RGBColor[1, 0, 0]],
 "\nsig=0;\nsig=sig+qqterm;\nsig=sig+qgterm;\nsig=sig+ggterm+ggterm0;\n\
sig=sig*389379660; (*to picobarns*)\n\nReturn[sig];\n\n];\n"
}], "Input"],

Cell[CellGroupData[{

Cell["\<\
virt=NIntegrate[dsigmaBV[xvar,100,14000,100,100],{xvar,0,1}];
virt\
\>", "Input"],

Cell[BoxData[
 FormBox["33.568776025755255`", TraditionalForm]], "Output",
 CellChangeTimes->{3.69259998438443*^9, 3.6926010194034967`*^9}]
}, Open  ]],

Cell["\<\
eps=0.0000000001;
(* real=Vegas[dsigmaR[xvar,yvar,100,14000,100,100],{xvar,eps,1-eps},{yvar,eps,\
1-eps},Compiled->False,NStart->1000,MaxPoints->10000]*)\
\>", "Input",
 CellChangeTimes->{{3.692600210806891*^9, 3.692600216702009*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"real", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"dsigmaR", "[", 
     RowBox[{
     "xvar", ",", "yvar", ",", "100", ",", "14000", ",", "100", ",", "100"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"xvar", ",", "eps", ",", 
      RowBox[{"1", "-", "eps"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"yvar", ",", "eps", ",", 
      RowBox[{"1", "-", "eps"}]}], "}"}], ",", 
    RowBox[{"Compiled", "->", "False"}], ",", 
    RowBox[{"MaxPoints", "->", "10000"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.692600166376462*^9, 3.692600177417946*^9}, {
  3.692600360649798*^9, 3.6926003615777073`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(\\*FormBox[\\\"10013\\\", TraditionalForm]\\)\[NoBreak] \
integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(\\*FormBox[\\\"16.66201077391391`\\\", TraditionalForm]\\)\
\[NoBreak] and \[NoBreak]\\!\\(\\*FormBox[\\\"0.000022383172924215294`\\\", \
TraditionalForm]\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::maxp\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{3.6926010228788767`*^9}],

Cell[BoxData[
 FormBox["16.66201077391391`", TraditionalForm]], "Output",
 CellChangeTimes->{3.692599984614505*^9, 3.692601022882782*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["asNLO[100,5]", "Input"],

Cell[BoxData[
 FormBox["0.11636176382460801`", TraditionalForm]], "Output",
 CellChangeTimes->{3.69259998466387*^9, 3.692601022979712*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Do a mass-scan for a couple of points and plot LO vs NLO", "Subsection",
 CellChangeTimes->{{3.692600821201602*^9, 3.692600848006814*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealList", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"dsigmaR", "[", 
          RowBox[{"xvar", ",", " ", "yvar", ",", 
           RowBox[{"i", "*", "1."}], ",", "14000.", ",", 
           RowBox[{"i", "*", "1."}], ",", 
           RowBox[{"i", "*", "1."}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"xvar", ",", "eps", ",", 
           RowBox[{"1", "-", "eps"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"yvar", ",", "eps", ",", 
           RowBox[{"1", "-", "eps"}]}], "}"}], ",", 
         RowBox[{"Compiled", "->", "False"}], ",", 
         RowBox[{"MaxPoints", "->", "10000"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20", ",", "600", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6926002896875057`*^9, 3.692600331110671*^9}, 
   3.692600365642234*^9, 3.692600613795476*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(\\*FormBox[\\\"10013\\\", TraditionalForm]\\)\[NoBreak] \
integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(\\*FormBox[\\\"249.53858371108677`\\\", TraditionalForm]\\)\
\[NoBreak] and \[NoBreak]\\!\\(\\*FormBox[\\\"0.00046671005854989264`\\\", \
TraditionalForm]\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::maxp\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.692601026809997*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(\\*FormBox[\\\"10013\\\", TraditionalForm]\\)\[NoBreak] \
integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(\\*FormBox[\\\"136.30122409849506`\\\", TraditionalForm]\\)\
\[NoBreak] and \[NoBreak]\\!\\(\\*FormBox[\\\"0.00021920270660652564`\\\", \
TraditionalForm]\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::maxp\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.692601030482253*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.692601032828919*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "maxp"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"The integral failed to converge after \
\[NoBreak]\\!\\(\\*FormBox[\\\"10013\\\", TraditionalForm]\\)\[NoBreak] \
integrand evaluations. NIntegrate obtained \
\[NoBreak]\\!\\(\\*FormBox[\\\"86.01964094871275`\\\", TraditionalForm]\\)\
\[NoBreak] and \[NoBreak]\\!\\(\\*FormBox[\\\"0.0004496982081794881`\\\", \
TraditionalForm]\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::maxp\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.69260103462813*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"General", "::", "stop"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*FormBox[StyleBox[RowBox[{\\\"NIntegrate\\\", \\\"::\\\", \
\\\"maxp\\\"}], \\\"MessageName\\\"], TraditionalForm]\\)\[NoBreak] will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.6926010346650553`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.69260104075222*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.692601137065007*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox[
    RowBox[{"General", "::", "stop"}], "MessageName"], 
   RowBox[{
   ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*FormBox[StyleBox[RowBox[{\\\"NIntegrate\\\", \\\"::\\\", \
\\\"slwcon\\\"}], \\\"MessageName\\\"], TraditionalForm]\\)\[NoBreak] will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}], TraditionalForm]], "Message", "MSG",
 CellChangeTimes->{{3.692600349011602*^9, 3.69260036971212*^9}, 
   3.6926011371117573`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"BVirtList", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"dsigmaBV", "[", 
          RowBox[{"xvar", ",", " ", 
           RowBox[{"i", "*", "1."}], ",", "14000.", ",", 
           RowBox[{"i", "*", "1."}], ",", 
           RowBox[{"i", "*", "1."}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"xvar", ",", "eps", ",", 
           RowBox[{"1", "-", "eps"}]}], "}"}], ",", 
         RowBox[{"Compiled", "->", "False"}], ",", 
         RowBox[{"MaxPoints", "->", "10000"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20", ",", "600", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.692600478345191*^9, 3.692600492712871*^9}, {
  3.692600599484334*^9, 3.6926006178505993`*^9}, {3.6926007853172293`*^9, 
  3.692600799250576*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NLOList", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"RealList", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"RealList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"BVirtList", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "RealList", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.692600623114683*^9, 3.692600630569345*^9}, {
   3.6926006758401203`*^9, 3.692600712764638*^9}, {3.692600749786141*^9, 
   3.692600774211691*^9}, 3.692600858174468*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"resEFT", ",", " ", "NLOList"}], "}"}], ",", " ", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"PlotLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EFT", " ", "LO"}], ",", " ", 
      RowBox[{"EFT", " ", "NLO"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6926008857897587`*^9, 3.692600898076047*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtz3lIk3EYwPFpqamYKWaiKVoNypT2Ryrl9UwSmYo2FaXD2GRz6srpUucx
d5natbL+sBlikivBJRGbZYJNuqaRMFJnojkvbGZJeLQ8mBm/54WXlw/P7/l9
eYNyBGlcewqFErnz/v+S5yRs9iZ/WVT5AHEMVIdOKvPp3ugzYGx6NG8WeqEZ
0Nni2HXU6olOgRLpIa8YrQexjAkK33ZB24N9OM8A4xzr1Okwd5xnQsSTpbB4
vhvOz4FpwviX1u+K8wsQGn1zLSreBeeXgKUfsaZ820MMLDgobzAIbzvheTb4
vWzKqk91JO7LAW1sXabTEQfc58CGN80y47Qb97kQSRUrOOv2uJ8LPUPp0f5W
O9znQQ4nBEzbFNzPh+xRlaHWEw0FcC9pVay8aIsl+3xgKwuK1eot4r7LUJCX
+nR1c4OYUgguz7zpyex1YhAAr9bZ0DxkRRdBkNU2uMb8QzxVBAFlnWrZ+Cre
XwyKurZesWCFOFAI9k5NXVFuy9gTwuf2JNNh3W9i1lX41Jq+lWBYwn4J0Nyz
dKLwn8StJcBspn/8oVvAfincvy6iDtC/Y78U0iUTyuSJOeyXwfsxd9Wbmhns
i8DRp3KvKGIK+yLwU/St6H6NY78cRqTU7heKUexXAM92ljoWMoT9CjBZpgu5
pkHsV0J2Vba5s+ID9itB4/88+FVND/arIHzSuJ/fpca+GK5tP5SUBDfqSV8M
jruWGx1OdBGzqqE5I6rtTuJbYooEAjQBMx3mAeJWCWjFnjabxkgMUmBY0npT
zg8TT0khMPfr44TNUZzLIJETx+PeHSdukEH5jTh3/wNmPC+DllC+tpAxTUyT
Q9jx/u56u1limRz0zFt5rro5YqMcXlOveBxjzxMHKoCpWutwc7YQF+3Yd2xr
VrOA/6cA43rQu2HGov4fQF8saQ==
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtzn8s1HEcx/Hr/LjkR8dpYbudhiV/cNO1kuLdZDcmyY6Rau7kQs6d8+M4
zp1LTGuYTaVJZKOSdZqKortlfkaR22qzIceJmB9XiTSVz/u73b577P197XkH
BOLIRCqFQvH/9/v/Jg8HpK657z/edwbiALjtvlA2n70ffRq8Phif8wb3oUOg
eJo9GpfsiA4HgV15hMKfQaw6B0nCkoQ6Xwe880CcXtw3HWyP92gA2/ZvoWI6
3mPBjm1knYrai/c4SGneTqqat8X7JRjoaJ0x3LIhhng40hq3XBprjd/zIcLE
L2/03kOsE0CVRdu9OYYV7i+DsaEhUUjbjftEqK5xbi6n0XAvhBINv5/OsMT9
FZg93tI06GmB+2QIdzvT1cc1x30KsJpkARyxGe6vQnhMtWdMLRX3qSCjlt2s
1O/CfRqMMuuHo+zRIIbJo3X17jwKWgLTLu/8WX7bgTuekoD+jZtYqP9DrEoH
pxsTJ1Nzt4hdpdBrcuouP/ibWCcF79gpfuDEBnF8BnjI7U+s1/wipmRCkT6J
HpiwTlyXCY8NaT6P2D+JIQtS73IOjZr/wH4WmDS0F+cnTdjPBmW/1GpVu4Z9
GShaKoeCG1exLwNt/LqGXrmC/RxI04T5MC2XsZ8LKz2Hr1PXFrGfC16fH9y5
OLeAfTl06iIlb2e/Yl8OXNHZpKFFI/bzgBtiGcTcmsF+PkwNO4xfYBiwnw+l
9E7FMd8v2FdA9DWjeY9mAvsFkNeh7nOzHsd+AdQuhTw0y/iEfSVkLIu8DXNj
2FeCY21oLzd5BO8qsAnjt+UtDRBXqCC9uHrzKasbv1eBVQUz6NVIOzG7EOSi
BP6mSxP+/0LQVYkmuzpztDseKQTN6nyR5cYTYlc1jPnpxzeCXxNL1OAhUK+9
/N5NrFMDQ/mMZ80Z1P4FZ18hFw==
       "]]}}, {{{}, 
      {GrayLevel[0.4], AbsoluteThickness[0.5], 
       StyleBox[{
         LineBox[{
          Scaled[{0.02, 0}, {600., -0.8527625857530499}], 
           Offset[{3, 0}, Scaled[{0.02, 0}, {600., -0.8527625857530499}]], 
           Offset[{7, 0}, Scaled[{0.02, 0}, {600., -1.0023245080873902`}]], 
           Offset[{12, 0}, Scaled[{0.02, 0}, {600., -1.0023245080873902`}]]}],
          LineBox[{
          Scaled[{0.02, 0}, {600., -0.20471326480491622`}], 
           Offset[{3, 0}, Scaled[{0.02, 0}, {600., -0.20471326480491622`}]], 
           Offset[{7, 0}, Scaled[{0.02, 0}, {600., -0.05515117037456525}]], 
           Offset[{12, 0}, Scaled[{0.02, 0}, {600., -0.05515117037456525}]]}]},
        FontColor->GrayLevel[0.4]]}, {InsetBox[
        RowBox[{"EFT", " ", "LO"}], Offset[{15, 0}, 
        Scaled[{0.02, 0}, {600., -1.0023245080873902`}]], 
        ImageScaled[{0, 0.5}]], InsetBox[
        RowBox[{"EFT", " ", "NLO"}], Offset[{15, 0}, 
        Scaled[{0.02, 0}, {600., -0.05515117037456525}]], 
        ImageScaled[{0, 0.5}]]}, 
      {GrayLevel[0.4], AbsoluteThickness[0.5], 
       StyleBox[{{}, {}},
        FontColor->GrayLevel[0.4]]}}, {}}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, -1.3796138896023795`},
   DisplayFunction->Identity,
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{{{-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.6931471805599453, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.791759469228055, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2.995732273553991, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.0943445622221, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.248495242049359, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.382026634673881, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4.499809670330265, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.298317366548036, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.703782474656201, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {5.991464547107982, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.396929655216146, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.551080335043404, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.684611727667927, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.802394763324311, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6.907755278982137, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.003065458786462, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.090076835776092, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.170119543449628, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.24422751560335, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.313220387090301, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7.3777589082278725`, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline],
            "CacheGraphics" -> False], 
          Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->{{All, 67.2}, {All, All}},
   Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
          Part[#, 1]], 
         (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
          Part[#, 1]], 
         (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 600.}, {-1.2560314849957466`, 6.406077600615491}},
   PlotRangeClipping->False,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox["500", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.003065458786462, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.090076835776092, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.170119543449628, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.24422751560335, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.313220387090301, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.3777589082278725`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}], TraditionalForm]], "Output",
 CellChangeTimes->{3.6926008986771097`*^9, 3.692601225779516*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{872, 573},
WindowMargins->{{131, Automatic}, {106, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 53, 0, 92, "Title"],
Cell[CellGroupData[{
Cell[658, 26, 31, 0, 64, "Section"],
Cell[692, 28, 676, 14, 143, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1405, 47, 32, 0, 64, "Section"],
Cell[1440, 49, 88, 4, 59, "Input"],
Cell[CellGroupData[{
Cell[1553, 57, 35, 0, 44, "Subsection"],
Cell[1591, 59, 157, 3, 49, "Text"],
Cell[CellGroupData[{
Cell[1773, 66, 230, 7, 46, "Input"],
Cell[2006, 75, 611, 13, 24, "Message"],
Cell[2620, 90, 611, 13, 24, "Message"],
Cell[3234, 105, 196, 4, 33, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3479, 115, 52, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[3556, 119, 68, 3, 44, "Input"],
Cell[3627, 124, 595, 13, 24, "Message"],
Cell[4225, 139, 597, 13, 24, "Message"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4871, 158, 73, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[4969, 162, 247, 4, 46, "Input"],
Cell[5219, 168, 268, 5, 28, "Output"],
Cell[5490, 175, 663, 14, 24, "Message"],
Cell[6156, 191, 222, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6415, 200, 44, 3, 44, "Input"],
Cell[CellGroupData[{
Cell[6484, 207, 173, 3, 20, "Print"],
Cell[6660, 212, 169, 3, 20, "Print"],
Cell[6832, 217, 183, 3, 20, "Print"],
Cell[7018, 222, 194, 4, 20, "Print"],
Cell[7215, 228, 201, 4, 20, "Print"],
Cell[7419, 234, 223, 4, 20, "Print"],
Cell[7645, 240, 154, 3, 20, "Print"],
Cell[7802, 245, 182, 3, 20, "Print"],
Cell[7987, 250, 198, 4, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8234, 260, 349, 6, 107, "Subsubsection"],
Cell[8586, 268, 945, 37, 524, "Input"],
Cell[9534, 307, 37, 3, 44, "Input"],
Cell[9574, 312, 1739, 64, 899, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11350, 381, 58, 0, 35, "Subsubsection"],
Cell[11411, 383, 43, 0, 29, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11503, 389, 267, 6, 119, "Subsection"],
Cell[11773, 397, 2107, 72, 165, "Input"],
Cell[CellGroupData[{
Cell[13905, 473, 68, 0, 35, "Subsubsection"],
Cell[CellGroupData[{
Cell[13998, 477, 32, 0, 29, "Input"],
Cell[14033, 479, 188, 3, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14282, 489, 36, 0, 44, "Subsection"],
Cell[14321, 491, 76, 7, 104, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14446, 504, 35, 0, 64, "Section"],
Cell[CellGroupData[{
Cell[14506, 508, 205, 4, 83, "Subsubsection"],
Cell[14714, 514, 18, 0, 29, "Input"],
Cell[CellGroupData[{
Cell[14757, 518, 901, 17, 89, "Input"],
Cell[15661, 537, 1162, 34, 55, "Output"],
Cell[16826, 573, 1056, 32, 55, "Output"],
Cell[17885, 607, 14813, 258, 237, "Output"]
}, Open  ]],
Cell[32713, 868, 150, 3, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32900, 876, 532, 12, 108, "Subsubsection"],
Cell[33435, 890, 420, 20, 299, "Input"],
Cell[CellGroupData[{
Cell[33880, 914, 72, 0, 29, "Input"],
Cell[33955, 916, 186, 3, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34190, 925, 215, 5, 69, "Subsection"],
Cell[34408, 932, 113, 3, 29, "Input"],
Cell[34524, 937, 139, 3, 29, "Input"],
Cell[CellGroupData[{
Cell[34688, 944, 429, 10, 28, "Input"],
Cell[35120, 956, 26458, 602, 214, "Output"]
}, Open  ]],
Cell[61593, 1561, 168, 3, 49, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61798, 1569, 76, 0, 44, "Subsection"],
Cell[CellGroupData[{
Cell[61899, 1573, 257, 7, 74, "Input"],
Cell[62159, 1582, 1522, 47, 89, "Output"],
Cell[63684, 1631, 1519, 47, 89, "Output"],
Cell[65206, 1680, 1520, 47, 89, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66787, 1734, 36, 0, 64, "Section"],
Cell[66826, 1736, 678, 15, 231, "Text"],
Cell[CellGroupData[{
Cell[67529, 1755, 35, 0, 44, "Subsection"],
Cell[67567, 1757, 945, 19, 464, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68549, 1781, 40, 0, 44, "Subsection"],
Cell[68592, 1783, 2174, 45, 1109, "Input"],
Cell[CellGroupData[{
Cell[70791, 1832, 91, 3, 44, "Input"],
Cell[70885, 1837, 139, 2, 28, "Output"]
}, Open  ]],
Cell[71039, 1842, 244, 5, 44, "Input"],
Cell[CellGroupData[{
Cell[71308, 1851, 655, 17, 46, "Input"],
Cell[71966, 1870, 791, 15, 42, "Message"],
Cell[72760, 1887, 137, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72934, 1894, 29, 0, 29, "Input"],
Cell[72966, 1896, 138, 2, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73153, 1904, 144, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[73322, 1909, 1024, 26, 63, "Input"],
Cell[74349, 1937, 838, 16, 42, "Message"],
Cell[75190, 1955, 838, 16, 42, "Message"],
Cell[76031, 1973, 660, 13, 42, "Message"],
Cell[76694, 1988, 835, 16, 42, "Message"],
Cell[77532, 2006, 675, 14, 24, "Message"],
Cell[78210, 2022, 659, 13, 42, "Message"],
Cell[78872, 2037, 660, 13, 42, "Message"],
Cell[79535, 2052, 677, 14, 24, "Message"]
}, Open  ]],
Cell[80227, 2069, 945, 24, 63, "Input"],
Cell[81175, 2095, 921, 26, 46, "Input"],
Cell[CellGroupData[{
Cell[82121, 2125, 434, 11, 28, "Input"],
Cell[82558, 2138, 25459, 575, 204, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

