(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14703,        517]
NotebookOptionsPosition[     12682,        441]
NotebookOutlinePosition[     13040,        457]
CellTagsIndexPosition[     12997,        454]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculation for ",
 StyleBox[" ", "DisplayFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["W", "+"], TraditionalForm]]],
 StyleBox["\[RightArrow] ", "DisplayFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", "+"], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", "e"], TraditionalForm]]]
}], "Title",
 CellChangeTimes->{{3.42892672627883*^9, 3.428926824323577*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "HighEnergyPhysics`fc`"}], ";"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preliminaries", "Subsection"],

Cell[CellGroupData[{

Cell["Kinematics 1->2", "Subsubsection",
 CellChangeTimes->{{3.428926835790217*^9, 3.428926837886043*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"P", ",", "P"}], "]"}], "=", "mw2"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pe", ",", "pe"}], "]"}], "=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"p\[Nu]", ",", "p\[Nu]"}], "]"}], "=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"P", ",", "pe"}], "]"}], "=", 
     RowBox[{"mw2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"P", ",", "p\[Nu]"}], "]"}], "=", 
     RowBox[{"mw2", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pe", ",", "p\[Nu]"}], "]"}], "=", 
     RowBox[{"mw2", "/", "2"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4289268403011503`*^9, 3.428926946965074*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Amplitude (1 diagram)", "Subsection",
 CellChangeTimes->{{3.4289292421393127`*^9, 3.428929244675111*^9}}],

Cell["The summed and averaged square matrix element", "Text",
 CellChangeTimes->{{3.4289271420095243`*^9, 3.4289271454722757`*^9}, {
  3.4289273354903717`*^9, 3.428927351049911*^9}, {3.4289275105378*^9, 
  3.42892751343362*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{
   RowBox[{"1", "/", "3"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"gw", "/", "2"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "2"}], 
   RowBox[{"Tr", "[", 
    RowBox[{
     RowBox[{"GSD", "[", "pe", "]"}], ".", 
     RowBox[{"GAD", "[", "mu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}], ".", 
     RowBox[{"GSD", "[", "p\[Nu]", "]"}], ".", 
     RowBox[{"GAD", "[", "nu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}]}], "]"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"MetricTensor", "[", 
       RowBox[{"mu", ",", "nu"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"FV", "[", 
       RowBox[{"P", ",", "mu"}], "]"}], 
      RowBox[{
       RowBox[{"FV", "[", 
        RowBox[{"P", ",", "nu"}], "]"}], "/", "mw2"}]}]}], ")"}]}]}]], "Input",\

 CellChangeTimes->{{3.428927033246361*^9, 3.4289271401967373`*^9}, {
   3.42892727787171*^9, 3.428927413135103*^9}, {3.4289274432481937`*^9, 
   3.4289274930463*^9}, {3.428929121395401*^9, 3.428929122088388*^9}, 
   3.428929375657975*^9, {3.428929541763723*^9, 3.428929566521463*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["gw", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["P", "mu"], " ", 
       SuperscriptBox["P", "nu"]}], "mw2"], "-", 
     SuperscriptBox["g", 
      RowBox[{"mu", "nu"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["mu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["nu",
          TraditionalForm],
         TraditionalForm], 
        FormBox["pe",
         TraditionalForm], 
        FormBox["p\[Nu]",
         TraditionalForm]}]]}], "-", 
     RowBox[{"mw2", " ", 
      SuperscriptBox["g", 
       RowBox[{"mu", "nu"}]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       FormBox["p\[Nu]",
        TraditionalForm], 
       FormBox[
        FormBox["mu",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["pe",
        TraditionalForm], 
       FormBox[
        FormBox["nu",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       FormBox["pe",
        TraditionalForm], 
       FormBox[
        FormBox["mu",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p\[Nu]",
        TraditionalForm], 
       FormBox[
        FormBox["nu",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4289272789512367`*^9, 3.428927318445057*^9, {3.4289273534290743`*^9, 
   3.428927404797317*^9}, {3.4289274516566753`*^9, 3.42892749447148*^9}, 
   3.4289291227183*^9, {3.428929370895793*^9, 3.428929376751039*^9}, 
   3.428929567605669*^9, 3.428938985716309*^9}]
}, Open  ]],

Cell["We contract the Lorentz indices", "Text",
 CellChangeTimes->{{3.428927497453924*^9, 3.428927503026804*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{"Contract", "[", "M2", "]"}]}]], "Input",
 CellChangeTimes->{{3.428927540707325*^9, 3.42892754927673*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["gw", "2"], " ", "mw2"}], "3"], TraditionalForm]], "Output",\

 CellChangeTimes->{3.428927549552278*^9, 3.4289291245462008`*^9, 
  3.4289293726684103`*^9, 3.428929569719249*^9, 3.428938985747068*^9}]
}, Open  ]],

Cell["We insert he definition of the Fermi constant", "Text",
 CellChangeTimes->{{3.428927552171399*^9, 3.428927561923086*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{"M2", "/.", 
   RowBox[{
    RowBox[{"gw", "^", "2"}], "\[Rule]", 
    RowBox[{"8", " ", "mw2", " ", 
     RowBox[{"Gf", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.428927568404044*^9, 3.42892758705121*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["4", "3"], " ", 
   SqrtBox["2"], " ", "Gf", " ", 
   SuperscriptBox["mw2", "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.428927588058874*^9, 3.4289291256255703`*^9, 
  3.428929571106011*^9, 3.428938985780642*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Phase Space", "Subsection",
 CellChangeTimes->{{3.4289292202493353`*^9, 3.428929221917066*^9}}],

Cell["The massless two particle phase space is", "Text",
 CellChangeTimes->{{3.4289286541859837`*^9, 3.428928662992796*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d\[CapitalPhi]2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "Pi"}], ")"}], "^", "4"}], 
   RowBox[{"\[Delta]", "[", 
    RowBox[{"P", "-", "pe", "-", "p\[Nu]"}], "]"}], 
   RowBox[{
    RowBox[{
     RowBox[{"d3pe", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "Pi"}], ")"}], "^", "3"}]}], "/", "2"}], "/", "Ee"}], 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"d3p\[Nu]", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "Pi"}], ")"}], "^", "3"}]}], "/", "2"}], "/", 
    "E\[Nu]"}]}]}]], "Input",
 CellChangeTimes->{{3.428928668808182*^9, 3.428928748243292*^9}, {
  3.4289288594542103`*^9, 3.428928869884198*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"d3pe", " ", "d3p\[Nu]", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{"P", "-", "pe", "-", "p\[Nu]"}], ")"}]}], 
   RowBox[{"16", " ", "Ee", " ", "E\[Nu]", " ", 
    SuperscriptBox["\[Pi]", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428928862716354*^9, 3.428928870072042*^9}, 
   3.428929126861431*^9, 3.428929574710586*^9, 3.428938985810316*^9}]
}, Open  ]],

Cell["\<\
Performing the integration over d3p\[Nu] in the rest frame of the W gives\
\>", "Text",
 CellChangeTimes->{{3.428928749821361*^9, 3.428928784904477*^9}, {
  3.4289288233373938`*^9, 3.428928824472897*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "4"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "Pi"}], ")"}], "^", "2"}]}], " ", 
   RowBox[{"\[Delta]", "[", 
    RowBox[{"mw", "-", 
     RowBox[{"2", "Ee"}]}], "]"}], 
   RowBox[{"d3pe", "/", 
    RowBox[{"Ee", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4289287922794847`*^9, 3.4289288819309*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"d3pe", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{"mw", "-", 
      RowBox[{"2", " ", "Ee"}]}], ")"}]}], 
   RowBox[{"16", " ", 
    SuperscriptBox["Ee", "2"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428928849656254*^9, 3.428928882523725*^9}, 
   3.428929068231016*^9, 3.428929127845537*^9, 3.428929574829381*^9, 
   3.428938985844248*^9}]
}, Open  ]],

Cell["\<\
Going to spherical coordinates, and usging pe dpe = Ee dEe, we get\
\>", "Text",
 CellChangeTimes->{{3.428928883567082*^9, 3.4289289264749002`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{
   RowBox[{"PS", "/.", 
    RowBox[{
     RowBox[{"\[Delta]", "[", 
      RowBox[{"mw", "-", 
       RowBox[{"2", "Ee"}]}], "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"1", "/", "2"}], 
      RowBox[{"\[Delta]", "[", 
       RowBox[{"Ee", "-", 
        RowBox[{"mw", "/", "2"}]}], "]"}]}]}]}], "/.", " ", 
   RowBox[{"d3pe", "\[Rule]", 
    RowBox[{"4", "Pi", " ", 
     RowBox[{"Ee", "^", "2"}], " ", "dEe"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4289289441444197`*^9, 3.428929022421103*^9}, 
   3.428929070151713*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"dEe", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{"Ee", "-", 
      FractionBox["mw", "2"]}], ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.428929025150517*^9, 3.428929070325218*^9, 
  3.4289291311060667`*^9, 3.428929574875102*^9, 3.4289389858778963`*^9}]
}, Open  ]],

Cell["Performing the integration", "Text",
 CellChangeTimes->{{3.428929031938621*^9, 3.428929037282918*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{"PS", "/.", 
   RowBox[{
    RowBox[{"dEe", " ", 
     RowBox[{"\[Delta]", "[", 
      RowBox[{"Ee", "-", 
       RowBox[{"mw", "/", "2"}]}], "]"}]}], "\[Rule]", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.428929044586605*^9, 3.428929056603554*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{"8", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428929056861126*^9, 3.428929071114458*^9}, 
   3.4289291321148567`*^9, 3.428929574912538*^9, 3.4289389861836767`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Result", "Subsection",
 CellChangeTimes->{{3.4289292627868023`*^9, 3.4289292633475027`*^9}}],

Cell["The decay rate of the W then becomes", "Text",
 CellChangeTimes->{{3.428929073874954*^9, 3.428929081291203*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalGamma]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "2"}], "/", "mw"}], " ", "PS", " ", "M2"}], "/.", 
   RowBox[{"mw2", "\[Rule]", 
    RowBox[{"mw", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.428929087038114*^9, 3.428929107627933*^9}, 
   3.428929346599481*^9, 3.428938975232931*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"Gf", " ", 
    SuperscriptBox["mw", "3"]}], 
   RowBox[{"6", " ", 
    SqrtBox["2"], " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428929108658009*^9, 3.428929133003119*^9}, 
   3.4289293476527367`*^9, 3.4289295771229353`*^9, 3.428938986228635*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{710, 706},
WindowMargins->{{Automatic, 230}, {Automatic, 4}},
ShowSelection->True,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 427, 15, 79, "Title"],
Cell[CellGroupData[{
Cell[1042, 42, 36, 0, 34, "Subsection"],
Cell[1081, 44, 83, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1201, 51, 35, 0, 26, "Subsection"],
Cell[CellGroupData[{
Cell[1261, 55, 106, 1, 25, "Subsubsection"],
Cell[1370, 58, 1112, 33, 133, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[2531, 97, 111, 1, 26, "Subsection"],
Cell[2645, 100, 228, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[2898, 107, 1191, 34, 43, "Input"],
Cell[4092, 143, 1924, 68, 70, "Output"]
}, Open  ]],
Cell[6031, 214, 113, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[6169, 219, 151, 3, 27, "Input"],
Cell[6323, 224, 269, 7, 70, "Output"]
}, Open  ]],
Cell[6607, 234, 127, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[6759, 239, 295, 8, 27, "Input"],
Cell[7057, 249, 275, 7, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7381, 262, 101, 1, 26, "Subsection"],
Cell[7485, 265, 124, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[7634, 270, 696, 23, 27, "Input"],
Cell[8333, 295, 417, 9, 70, "Output"]
}, Open  ]],
Cell[8765, 307, 214, 4, 26, "Text"],
Cell[CellGroupData[{
Cell[9004, 315, 404, 13, 27, "Input"],
Cell[9411, 330, 450, 12, 70, "Output"]
}, Open  ]],
Cell[9876, 345, 158, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[10059, 352, 569, 17, 27, "Input"],
Cell[10631, 371, 358, 9, 70, "Output"]
}, Open  ]],
Cell[11004, 383, 108, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[11137, 388, 293, 8, 27, "Input"],
Cell[11433, 398, 245, 5, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11727, 409, 98, 1, 26, "Subsection"],
Cell[11828, 412, 118, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[11971, 417, 347, 9, 27, "Input"],
Cell[12321, 428, 321, 8, 52, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
