(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14721,        497]
NotebookOptionsPosition[     12913,        429]
NotebookOutlinePosition[     13290,        446]
CellTagsIndexPosition[     13247,        443]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
The Drell-Yan cross-section in the narrow width approximation\
\>", "Title",
 CellChangeTimes->{{3.42892672627883*^9, 3.428926824323577*^9}, {
  3.428937703319875*^9, 3.428937712432496*^9}, {3.428941361957245*^9, 
  3.4289413752252607`*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "HighEnergyPhysics`fc`"}], ";"}]], "Input",
 CellChangeTimes->{{3.428941446581498*^9, 3.428941449045033*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The partonic cross - section", "Section",
 CellChangeTimes->{{3.428941607370674*^9, 3.428941611186956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Near", " ", "the", " ", "W", " ", "resonance"}], ",", " ", 
  RowBox[{
   RowBox[{
   "the", " ", "partonic", " ", "cross", " ", "section", " ", "\[Sigma]p", 
    " ", "for", " ", "u", " ", "dbar"}], " ", "\[RightArrow]", " ", 
   SuperscriptBox["W", "+"], "\[RightArrow]", " ", 
   RowBox[{
    SuperscriptBox["e", "+"], "  ", 
    SubscriptBox["\[Nu]", 
     RowBox[{"e", " "}]], "can", " ", "be", " ", "written"}]}]}]], "Text",
 CellChangeTimes->{{3.428941462807769*^9, 3.428941586342557*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]p", "=", 
  RowBox[{"4", 
   RowBox[{"Pi", "/", "3"}], " ", "\[CapitalGamma]ud", " ", 
   RowBox[{"\[CapitalGamma]ev", " ", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"sp", " ", "-", " ", 
         RowBox[{"mw", "^", "2"}]}], ")"}], "^", "2"}], " ", "+", 
      RowBox[{
       RowBox[{"mw", "^", "2"}], 
       RowBox[{"\[CapitalGamma]tot", "^", "2"}]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.428941591115911*^9, 3.428941670219965*^9}, {
  3.428941861583827*^9, 3.428941864412772*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
   "4", " ", "\[Pi]", " ", "\[CapitalGamma]ev", " ", "\[CapitalGamma]ud"}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"sp", "-", 
         SuperscriptBox["mw", "2"]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["mw", "2"], " ", 
       SuperscriptBox["\[CapitalGamma]tot", "2"]}]}], ")"}]}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.428941671372353*^9, 3.4289418646862993`*^9, 
  3.428942151070161*^9, 3.428942597586359*^9}]
}, Open  ]],

Cell["\<\
where 

* \[CapitalGamma]ud is the partial width of the W into u d
* \[CapitalGamma]ev is the partial width of the W into e \[Nu]
*\[CapitalGamma]tot is the totel width

At tree-level, we can write approximatively

\[CapitalGamma]ev = \[CapitalGamma]
\[CapitalGamma]ud = 3 \[CapitalGamma]
\[CapitalGamma]tot = 9 \[CapitalGamma]
\
\>", "Text",
 CellChangeTimes->{{3.428941673641809*^9, 3.428941779762138*^9}, {
  3.4289418146980762`*^9, 3.428941823801876*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]p", "=", 
  RowBox[{"\[Sigma]p", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalGamma]ud", "\[Rule]", 
      RowBox[{"3", "\[CapitalGamma]"}]}], ",", 
     RowBox[{"\[CapitalGamma]ev", "->", "\[CapitalGamma]"}], ",", 
     RowBox[{"\[CapitalGamma]tot", "\[Rule]", 
      RowBox[{"9", "\[CapitalGamma]"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.4289418266514587`*^9, 3.4289418551565723`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"4", " ", "\[Pi]", " ", 
    SuperscriptBox["\[CapitalGamma]", "2"]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"sp", "-", 
       SuperscriptBox["mw", "2"]}], ")"}], "2"], "+", 
    RowBox[{"81", " ", 
     SuperscriptBox["mw", "2"], " ", 
     SuperscriptBox["\[CapitalGamma]", "2"]}]}]], TraditionalForm]], "Output",\

 CellChangeTimes->{{3.428941855531948*^9, 3.428941867874544*^9}, 
   3.4289421541207457`*^9, 3.42894260090372*^9}]
}, Open  ]],

Cell[TextData[{
 "In the narrow width approximation, using\n\n\[Delta](x) = lim ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "\[Pi]"], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Epsilon]", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["\[Epsilon]", "2"]}]], TraditionalForm]]],
 "\n          \[Epsilon]\[RightArrow]0\nwe have"
}], "Text",
 CellChangeTimes->{{3.428941885053216*^9, 3.4289420421627827`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]pNW", "=", 
  RowBox[{"9", "mw", " ", "\[CapitalGamma]", " ", "\[Sigma]pw", " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"sp", " ", "-", " ", 
     SuperscriptBox["mw", "2"]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.428942043694252*^9, 3.4289421458530283`*^9}, {
  3.4289423809661303`*^9, 3.428942388280025*^9}, {3.4289426098473177`*^9, 
  3.428942609966979*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"9", " ", "mw", " ", "\[CapitalGamma]", " ", "\[Sigma]pw", " ", 
   RowBox[{
    InterpretationBox["\[Delta]",
     DiracDelta,
     Editable->False,
     Selectable->False], "(", 
    RowBox[{"sp", "-", 
     SuperscriptBox["mw", "2"]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.42894212937996*^9, 3.4289421574093657`*^9}, 
   3.428942389290112*^9, 3.4289426110242777`*^9}]
}, Open  ]],

Cell["\<\
where \[Sigma]pw is \[Sigma]p evaluated at sp = mw^2\
\>", "Text",
 CellChangeTimes->{{3.4289421593269777`*^9, 3.428942176694747*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The hadronic cross - section @ Tevatron", "Section",
 CellChangeTimes->{{3.4289421851120443`*^9, 3.4289421961269503`*^9}}],

Cell["We now fold the partonic cross - section with the pdf' s", "Text",
 CellChangeTimes->{{3.428942204656125*^9, 3.4289422175994797`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "x_", "]"}], ":=", 
   RowBox[{"6", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "x_", "]"}], ":=", 
   RowBox[{"3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], "^", "2"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4289422228675957`*^9, 3.428942241154451*^9}}],

Cell[TextData[{
 "The limits of the integration are \n\nx1: [0, 1]\nx2: ",
 Cell[BoxData[
  FormBox["[", TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["mw", "2"], "/", "s"}], ",", " ", "1"}], "]"}], 
   TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.428942264303419*^9, 3.428942324108612*^9}}],

Cell["Integration in x1:", "Text",
 CellChangeTimes->{{3.42894232586976*^9, 3.428942341099662*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "x1", "]"}], 
   RowBox[{"d", "[", "x2", "]"}], "\[Sigma]pNW"}], "/.", 
  RowBox[{"{", 
   RowBox[{"sp", "\[Rule]", 
    RowBox[{"s", " ", "x1", " ", "x2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4289431681668463`*^9, 3.4289431694285183`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"162", " ", "mw", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x1"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x2"}], ")"}], "2"], " ", "\[CapitalGamma]", " ", 
   "\[Sigma]pw", " ", 
   RowBox[{
    InterpretationBox["\[Delta]",
     DiracDelta,
     Editable->False,
     Selectable->False], "(", 
    RowBox[{
     SuperscriptBox["mw", "2"], "-", 
     FractionBox["s", 
      RowBox[{"x1", " ", "x2"}]]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.428943155912224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", "x1", "]"}], 
      RowBox[{"d", "[", "x2", "]"}], "\[Sigma]pNW"}], "/.", 
     RowBox[{"{", 
      RowBox[{"sp", "\[Rule]", 
       RowBox[{"s", " ", "x1", " ", "x2"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"mw", "^", "2"}], "/", "s"}], "<", "x2", "<", "1"}], ")"}], "&&",
       
      RowBox[{"(", 
       RowBox[{"mw", ">", "0"}], ")"}], "&&", 
      RowBox[{"(", 
       RowBox[{"s", ">", "0"}], ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.428942342103321*^9, 3.428942375261568*^9}, {
  3.428942406883278*^9, 3.428942462485826*^9}, {3.428942620176518*^9, 
  3.428942620422737*^9}, {3.428943124604053*^9, 3.42894321367962*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"162", " ", "mw", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x2", "-", "1"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["mw", "2"], "-", 
       RowBox[{"s", " ", "x2"}]}], ")"}], "2"], " ", "\[CapitalGamma]", " ", 
    "\[Sigma]pw"}], 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    SuperscriptBox["x2", "3"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.428942400145671*^9, {3.4289424466850643`*^9, 3.428942465656705*^9}, 
   3.4289425295180407`*^9, 3.428942621257402*^9, 3.428942755459882*^9, 
   3.4289429048806868`*^9, 3.428943215227071*^9}]
}, Open  ]],

Cell["Integration in x2:", "Text",
 CellChangeTimes->{{3.42894232586976*^9, 3.428942341099662*^9}, {
  3.428942481054343*^9, 3.428942481204427*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"\[Sigma]", ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", 
        RowBox[{
         RowBox[{"mw", "^", "2"}], "/", "s"}], ",", "1"}], "}"}]}], "]"}], "//",
     "Expand"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.428942483394573*^9, 3.42894252477667*^9}, {
  3.4289427584498053`*^9, 3.4289427585792522`*^9}, {3.428942966307247*^9, 
  3.428942997247208*^9}, {3.428943223022503*^9, 3.428943273216826*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
    "162", " ", "mw", " ", "\[CapitalGamma]", " ", "\[Sigma]pw", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["mw", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["s", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["mw", "4"], "+", 
          RowBox[{"4", " ", "s", " ", 
           SuperscriptBox["mw", "2"]}], "+", 
          SuperscriptBox["s", "2"]}], ")"}], " ", 
        RowBox[{"log", "(", 
         FractionBox[
          SuperscriptBox["mw", "2"], "s"], ")"}]}]}], ")"}]}], 
    SuperscriptBox["s", "3"]]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428942519914587*^9, 3.428942553721361*^9}, 
   3.428942628541798*^9, 3.428942765391282*^9, 3.428942937050954*^9, 
   3.428942998707487*^9, {3.428943229928903*^9, 3.428943278718606*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]pw", "=", 
  RowBox[{"\[Sigma]p", "/.", 
   RowBox[{"sp", "\[Rule]", 
    RowBox[{"mw", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.428943280891795*^9, 3.428943298023265*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"4", " ", "\[Pi]"}], 
   RowBox[{"81", " ", 
    SuperscriptBox["mw", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428943298212599*^9, 3.4289433089075317`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "//", "Expand"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.42894331467972*^9, 3.428943330039212*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"8", " ", "\[Pi]", " ", "\[CapitalGamma]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["mw", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["s", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["mw", "4"], "+", 
          RowBox[{"4", " ", "s", " ", 
           SuperscriptBox["mw", "2"]}], "+", 
          SuperscriptBox["s", "2"]}], ")"}], " ", 
        RowBox[{"log", "(", 
         FractionBox[
          SuperscriptBox["mw", "2"], "s"], ")"}]}]}], ")"}]}], 
    RowBox[{"mw", " ", 
     SuperscriptBox["s", "3"]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428943318260807*^9, 3.42894333060226*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 683},
WindowMargins->{{0, Automatic}, {0, Automatic}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 251, 5, 185, "Title"],
Cell[CellGroupData[{
Cell[866, 32, 36, 0, 51, "Subsection"],
Cell[905, 34, 149, 3, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1091, 42, 113, 1, 100, "Section"],
Cell[1207, 45, 531, 12, 39, "Text"],
Cell[CellGroupData[{
Cell[1763, 61, 574, 15, 40, "Input"],
Cell[2340, 78, 573, 17, 75, "Output"]
}, Open  ]],
Cell[2928, 98, 469, 15, 287, "Text"],
Cell[CellGroupData[{
Cell[3422, 117, 444, 10, 40, "Input"],
Cell[3869, 129, 511, 15, 79, "Output"]
}, Open  ]],
Cell[4395, 147, 462, 14, 144, "Text"],
Cell[CellGroupData[{
Cell[4882, 165, 403, 8, 49, "Input"],
Cell[5288, 175, 427, 11, 49, "Output"]
}, Open  ]],
Cell[5730, 189, 144, 3, 39, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5911, 197, 128, 1, 100, "Section"],
Cell[6042, 200, 140, 1, 39, "Text"],
Cell[6185, 203, 464, 16, 66, "Input"],
Cell[6652, 221, 365, 13, 115, "Text"],
Cell[7020, 236, 99, 1, 39, "Text"],
Cell[CellGroupData[{
Cell[7144, 241, 304, 8, 40, "Input"],
Cell[7451, 251, 584, 19, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8072, 275, 948, 26, 64, "Input"],
Cell[9023, 303, 682, 19, 75, "Output"]
}, Open  ]],
Cell[9720, 325, 148, 2, 39, "Text"],
Cell[CellGroupData[{
Cell[9893, 331, 532, 13, 40, "Input"],
Cell[10428, 346, 954, 26, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11419, 377, 213, 5, 40, "Input"],
Cell[11635, 384, 225, 6, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11897, 395, 158, 3, 40, "Input"],
Cell[12058, 400, 815, 24, 83, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
