(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22013,        705]
NotebookOptionsPosition[     19831,        624]
NotebookOutlinePosition[     20189,        640]
CellTagsIndexPosition[     20146,        637]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Tree-level decays of the top quark\
\>", "Title",
 CellChangeTimes->{{3.42892672627883*^9, 3.428926824323577*^9}, {
  3.428937703319875*^9, 3.428937712432496*^9}, {3.4289403678900433`*^9, 
  3.428940370752344*^9}}],

Cell[CellGroupData[{

Cell["Input FeynCalc", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "HighEnergyPhysics`fc`"}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t \[RightArrow] bW", "Section",
 CellChangeTimes->{{3.4289377207239313`*^9, 3.428937731049849*^9}, {
  3.428940376434594*^9, 3.428940384134904*^9}}],

Cell[CellGroupData[{

Cell["Kinematics 1->2", "Subsection",
 CellChangeTimes->{{3.428926835790217*^9, 3.428926837886043*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pt", ",", "pt"}], "]"}], "=", 
     RowBox[{"mt", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pb", ",", "pb"}], "]"}], "=", "0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pw", ",", "pw"}], "]"}], "=", 
     RowBox[{"mw", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pt", ",", "pb"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mt", "^", "2"}], "/", "2"}], "-", 
      RowBox[{
       RowBox[{"mw", "^", "2"}], "/", "2"}]}]}], ";"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pt", ",", "pw"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mt", "^", "2"}], "/", "2"}], "+", 
      RowBox[{
       RowBox[{"mw", "^", "2"}], "/", "2"}]}]}], ";"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{"pb", ",", "pw"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mt", "^", "2"}], "/", "2"}], "-", 
      RowBox[{
       RowBox[{"mw", "^", "2"}], "/", "2"}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4289268403011503`*^9, 3.428926946965074*^9}, {
  3.428937810100576*^9, 3.428937873020487*^9}, {3.428938071207912*^9, 
  3.428938078071608*^9}, {3.428938213984881*^9, 3.428938224130307*^9}, {
  3.4289384819556913`*^9, 3.428938484248788*^9}, {3.428939959216198*^9, 
  3.428939982716838*^9}, {3.4289400233100157`*^9, 3.428940028333314*^9}, {
  3.428940095373877*^9, 3.428940115206889*^9}, {3.4289403078974743`*^9, 
  3.428940317454282*^9}, {3.4289403562310753`*^9, 3.428940356350072*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Amplitude (1 diagram)", "Subsection",
 CellChangeTimes->{{3.4289292421393127`*^9, 3.428929244675111*^9}}],

Cell["The summed and averaged square matrix element", "Text",
 CellChangeTimes->{{3.4289271420095243`*^9, 3.4289271454722757`*^9}, {
  3.4289273354903717`*^9, 3.428927351049911*^9}, {3.4289275105378*^9, 
  3.42892751343362*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"gw", "/", "2"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "2"}], "Vtb2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"MetricTensor", "[", 
       RowBox[{"mu", ",", "nu"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"FV", "[", 
       RowBox[{"pw", ",", "mu"}], "]"}], 
      RowBox[{
       RowBox[{"FV", "[", 
        RowBox[{"pw", ",", "nu"}], "]"}], "/", 
       RowBox[{"mw", "^", "2"}]}]}]}], ")"}], 
   RowBox[{"Tr", "[", 
    RowBox[{
     RowBox[{"GSD", "[", "pb", "]"}], ".", 
     RowBox[{"GAD", "[", "mu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GSD", "[", "pt", "]"}], "+", "mt"}], ")"}], ".", 
     RowBox[{"GAD", "[", "nu", "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"1", "-", "GA5"}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.428927033246361*^9, 3.4289271401967373`*^9}, {
   3.42892727787171*^9, 3.428927413135103*^9}, {3.4289274432481937`*^9, 
   3.4289274930463*^9}, {3.428929121395401*^9, 3.428929122088388*^9}, 
   3.428929375657975*^9, {3.428929541763723*^9, 3.428929566521463*^9}, {
   3.428937860468915*^9, 3.428937864548534*^9}, {3.4289380364317427`*^9, 
   3.428938062823503*^9}, {3.42893809477054*^9, 3.4289381246774197`*^9}, {
   3.4289382285018063`*^9, 3.428938230286139*^9}, {3.4289401410610647`*^9, 
   3.428940262985488*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["gw", "2"], " ", "Vtb2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["pw", "mu"], " ", 
       SuperscriptBox["pw", "nu"]}], 
      SuperscriptBox["mw", "2"]], "-", 
     SuperscriptBox["g", 
      RowBox[{"mu", "nu"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["g", 
        RowBox[{"mu", "nu"}]]}], " ", 
      SuperscriptBox["mt", "2"]}], "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["mu",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["nu",
          TraditionalForm],
         TraditionalForm], 
        FormBox["pb",
         TraditionalForm], 
        FormBox["pt",
         TraditionalForm]}]]}], "+", 
     RowBox[{
      SuperscriptBox["mw", "2"], " ", 
      SuperscriptBox["g", 
       RowBox[{"mu", "nu"}]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       FormBox["pt",
        TraditionalForm], 
       FormBox[
        FormBox["mu",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["pb",
        TraditionalForm], 
       FormBox[
        FormBox["nu",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       FormBox["pb",
        TraditionalForm], 
       FormBox[
        FormBox["mu",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["pt",
        TraditionalForm], 
       FormBox[
        FormBox["nu",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4289272789512367`*^9, 3.428927318445057*^9, {3.4289273534290743`*^9, 
   3.428927404797317*^9}, {3.4289274516566753`*^9, 3.42892749447148*^9}, 
   3.4289291227183*^9, {3.428929370895793*^9, 3.428929376751039*^9}, 
   3.428929567605669*^9, {3.428938112386113*^9, 3.428938125511932*^9}, 
   3.4289382307430983`*^9, {3.428938486376433*^9, 3.4289384975076303`*^9}, 
   3.428939015665769*^9, 3.428940263914661*^9, {3.428940301403697*^9, 
   3.428940318910907*^9}, 3.428940388164935*^9}]
}, Open  ]],

Cell["We contract the Lorentz indices", "Text",
 CellChangeTimes->{{3.42894027176694*^9, 3.4289402767919693`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{
   RowBox[{"Contract", "[", "M2", "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.428940286320468*^9, 3.4289402931521072`*^9}, {
  3.4289403938410273`*^9, 3.42894039536911*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["gw", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["mt", "4"], "+", 
      RowBox[{
       SuperscriptBox["mw", "2"], " ", 
       SuperscriptBox["mt", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["mw", "4"]}]}], ")"}], " ", "Vtb2"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["mw", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428940293573032*^9, 3.428940320656869*^9}, {
  3.428940389419715*^9, 3.4289403959046288`*^9}}]
}, Open  ]],

Cell["We insert he definition of the Fermi constant, and x=mw/mt", "Text",
 CellChangeTimes->{{3.428927552171399*^9, 3.428927561923086*^9}, {
  3.4289404070234756`*^9, 3.428940412095091*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"M2", "/.", 
     RowBox[{"gw", "\[Rule]", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Gf", " ", "8", 
        RowBox[{
         RowBox[{"mw", "^", "2"}], " ", "/", 
         RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]}]}], "/.", 
    RowBox[{"mw", "\[Rule]", 
     RowBox[{"x", " ", "mt"}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.428927568404044*^9, 3.42892758705121*^9}, {
   3.4289381595073957`*^9, 3.4289381716760798`*^9}, {3.428940329450939*^9, 
   3.4289403469848347`*^9}, {3.428940417769717*^9, 3.428940437988619*^9}, 
   3.428940474202092*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    SqrtBox["2"]}], " ", "Gf", " ", 
   SuperscriptBox["mt", "4"], " ", "Vtb2", " ", 
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", "1"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.428927588058874*^9, 3.4289291256255703`*^9, 3.428929571106011*^9, 
   3.428938172246612*^9, 3.428938233053894*^9, 3.4289384978556747`*^9, 
   3.428939015694807*^9, 3.4289403476319036`*^9, {3.4289404226184263`*^9, 
   3.428940438583735*^9}, 3.428940474667651*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Phase Space", "Subsection",
 CellChangeTimes->{{3.4289292202493353`*^9, 3.428929221917066*^9}}],

Cell["The two particle phase space is", "Text",
 CellChangeTimes->{{3.4289286541859837`*^9, 3.428928662992796*^9}, {
  3.428938253498197*^9, 3.428938253866067*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d\[CapitalPhi]2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "Pi"}], ")"}], "^", "4"}], 
   RowBox[{"\[Delta]", "[", 
    RowBox[{"pt", "-", "pb", "-", "pw"}], "]"}], 
   RowBox[{
    RowBox[{
     RowBox[{"d3pb", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "Pi"}], ")"}], "^", "3"}]}], "/", "2"}], "/", "Eb"}], 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"d3pw", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "Pi"}], ")"}], "^", "3"}]}], "/", "2"}], "/", 
    "Ew"}]}]}]], "Input",
 CellChangeTimes->{{3.428928668808182*^9, 3.428928748243292*^9}, {
  3.4289288594542103`*^9, 3.428928869884198*^9}, {3.42893818360579*^9, 
  3.428938207781085*^9}, {3.4289382412163973`*^9, 3.4289382417010736`*^9}, {
  3.428940498332073*^9, 3.428940511698041*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"d3pb", " ", "d3pw", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{
      RowBox[{"-", "pb"}], "+", "pt", "-", "pw"}], ")"}]}], 
   RowBox[{"16", " ", "Eb", " ", "Ew", " ", 
    SuperscriptBox["\[Pi]", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428928862716354*^9, 3.428928870072042*^9}, 
   3.428929126861431*^9, 3.428929574710586*^9, {3.428938234752118*^9, 
   3.428938241930442*^9}, 3.428938501869619*^9, 3.4289390157281837`*^9, 
   3.428940513564455*^9}]
}, Open  ]],

Cell["\<\
Performing the integration over d3pb in the rest frame of the t gives\
\>", "Text",
 CellChangeTimes->{{3.428928749821361*^9, 3.428928784904477*^9}, {
  3.4289288233373938`*^9, 3.428928824472897*^9}, {3.428938246362335*^9, 
  3.428938248774928*^9}, {3.428940519825862*^9, 3.428940522487805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "4"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "Pi"}], ")"}], "^", "2"}]}], " ", 
   RowBox[{"\[Delta]", "[", 
    RowBox[{"mt", "-", "Ew", " ", "-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"Ew", "^", "2"}], "-", 
       RowBox[{"mw", "^", "2"}]}], "]"}]}], "]"}], 
   RowBox[{
    RowBox[{"d3pw", "/", "Ew"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"Ew", "^", "2"}], "-", 
      RowBox[{"mw", "^", "2"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4289287922794847`*^9, 3.4289288819309*^9}, {
  3.42893825962851*^9, 3.42893826484441*^9}, {3.428940495085102*^9, 
  3.42894049515322*^9}, {3.428940527217524*^9, 3.4289405731543007`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"d3pw", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{
      RowBox[{"-", "Ew"}], "+", "mt", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["Ew", "2"], "-", 
        SuperscriptBox["mw", "2"]}]]}], ")"}]}], 
   RowBox[{"16", " ", "Ew", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["Ew", "2"], "-", 
      SuperscriptBox["mw", "2"]}]], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428928849656254*^9, 3.428928882523725*^9}, 
   3.428929068231016*^9, 3.428929127845537*^9, 3.428929574829381*^9, 
   3.42893826621164*^9, 3.428938504167341*^9, 3.4289386058116293`*^9, 
   3.4289386914875193`*^9, 3.4289390157737207`*^9, 3.428940573661015*^9, {
   3.4289408529820642`*^9, 3.428940868212055*^9}, 3.4289409333227367`*^9}]
}, Open  ]],

Cell["\<\
Going to spherical coordinates, and usging pw dpw = Ew dEw, we get\
\>", "Text",
 CellChangeTimes->{{3.428928883567082*^9, 3.4289289264749002`*^9}, {
  3.4289382922025423`*^9, 3.428938296218473*^9}, {3.4289406507943153`*^9, 
  3.428940654855733*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{"PS", "/.", " ", 
   RowBox[{"d3pw", "\[Rule]", 
    RowBox[{"4", "Pi", " ", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"Ew", "^", "2"}], "-", 
       RowBox[{"mw", "^", "2"}]}], "]"}], "Ew", " ", "dEw"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4289289441444197`*^9, 3.428929022421103*^9}, 
   3.428929070151713*^9, {3.4289382799967327`*^9, 3.428938290196628*^9}, {
   3.428938584824209*^9, 3.428938599062233*^9}, {3.428940668498803*^9, 
   3.428940709969864*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"dEw", " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{
      RowBox[{"-", "Ew"}], "+", "mt", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["Ew", "2"], "-", 
        SuperscriptBox["mw", "2"]}]]}], ")"}]}], 
   RowBox[{"4", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.428929025150517*^9, 3.428929070325218*^9, 3.4289291311060667`*^9, 
   3.428929574875102*^9, 3.428938297415737*^9, 3.428938505065439*^9, {
   3.428938600499318*^9, 3.428938606660725*^9}, {3.4289386861864023`*^9, 
   3.428938692218741*^9}, 3.4289390158068933`*^9, 3.4289407114162188`*^9, {
   3.428940853812212*^9, 3.428940869000046*^9}, 3.42894093432963*^9}]
}, Open  ]],

Cell["\<\
Using the fact  that 

\[Delta] (mt - Ew - Sqrt[Ew^2 - mw^2]) = 1/2 (1 - x^2) \[Delta] (Ew - (mt^2 + \
mw^2)/2/mt)

we get\
\>", "Text",
 CellChangeTimes->{{3.428940727592554*^9, 3.428940828727889*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", " ", "=", " ", 
  RowBox[{"PS", " ", "/.", " ", 
   RowBox[{
    RowBox[{"\[Delta]", "[", 
     RowBox[{"mt", "-", "Ew", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"Ew", "^", "2"}], "-", 
        RowBox[{"mw", "^", "2"}]}], "]"}]}], "]"}], "->", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], " ", 
     RowBox[{"\[Delta]", "[", 
      RowBox[{"Ew", "-", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mt", "^", "2"}], "+", 
           RowBox[{"mw", "^", "2"}]}], ")"}], "/", "2"}], "/", "mt"}]}], 
      "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.428940823713065*^9, 3.428940865439296*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"dEw", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{"Ew", "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["mt", "2"], "+", 
        SuperscriptBox["mw", "2"]}], 
       RowBox[{"2", " ", "mt"}]]}], ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.4289408454932737`*^9, 3.428940870390575*^9}, 
   3.428940936273623*^9}]
}, Open  ]],

Cell["Performing the integration", "Text",
 CellChangeTimes->{{3.428929031938621*^9, 3.428929037282918*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PS", "=", 
  RowBox[{
   RowBox[{"PS", "/.", 
    RowBox[{
     RowBox[{"dEw", " ", 
      RowBox[{"\[Delta]", "[", 
       RowBox[{"Ew", "-", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mt", "^", "2"}], "+", 
            RowBox[{"mw", "^", "2"}]}], ")"}], "/", "2"}], "/", "mt"}]}], 
       "]"}]}], "\[Rule]", "1"}]}], "/.", 
   RowBox[{"Ew", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mt", "^", "2"}], "+", 
        RowBox[{"mw", "^", "2"}]}], ")"}], "/", "2"}], "/", 
     "mt"}]}]}]}]], "Input",
 CellChangeTimes->{{3.428929044586605*^9, 3.428929056603554*^9}, {
  3.428938304472186*^9, 3.428938307564096*^9}, {3.428938621479186*^9, 
  3.428938627852805*^9}, {3.4289386823375387`*^9, 3.428938682419998*^9}, {
  3.42894088870361*^9, 3.428940930891738*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"8", " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428929056861126*^9, 3.428929071114458*^9}, 
   3.4289291321148567`*^9, 3.428929574912538*^9, 3.428938307856097*^9, 
   3.428938506325878*^9, 3.4289386297502537`*^9, {3.4289386829460487`*^9, 
   3.428938694746279*^9}, 3.42893901583956*^9, {3.4289409036435966`*^9, 
   3.428940937548481*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Result", "Subsection",
 CellChangeTimes->{{3.4289292627868023`*^9, 3.4289292633475027`*^9}}],

Cell["The decay rate of the t then becomes", "Text",
 CellChangeTimes->{{3.428929073874954*^9, 3.428929081291203*^9}, 
   3.4289383237898083`*^9, 3.428940943883102*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalGamma]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "2"}], "/", "mt"}], " ", "PS", " ", "M2"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.428929087038114*^9, 3.428929107627933*^9}, 
   3.428929346599481*^9, {3.428938314727579*^9, 3.428938334043777*^9}, 
   3.42893864433534*^9, 3.4289389462936773`*^9, {3.428940947099462*^9, 
   3.428940947409854*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"Gf", " ", 
    SuperscriptBox["mt", "3"], " ", "Vtb2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "1"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", "1"}], ")"}]}], 
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.428929108658009*^9, 3.428929133003119*^9}, 
   3.4289293476527367`*^9, 3.4289295771229353`*^9, {3.428938319056734*^9, 
   3.4289383343919973`*^9}, 3.4289385085419197`*^9, {3.4289386319695272`*^9, 
   3.428938644554867*^9}, 3.428938696988208*^9, 3.428938947199583*^9, 
   3.42893901589124*^9, 3.428940948763257*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{710, 706},
WindowMargins->{{Automatic, 230}, {Automatic, 4}},
ShowSelection->True,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 224, 5, 76, "Title"],
Cell[CellGroupData[{
Cell[839, 32, 36, 0, 34, "Subsection"],
Cell[878, 34, 83, 2, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[998, 41, 154, 2, 67, "Section"],
Cell[CellGroupData[{
Cell[1177, 47, 103, 1, 34, "Subsection"],
Cell[1283, 50, 1926, 54, 133, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3246, 109, 111, 1, 34, "Subsection"],
Cell[3360, 112, 228, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[3613, 119, 1536, 40, 58, "Input"],
Cell[5152, 161, 2321, 77, 48, "Output"]
}, Open  ]],
Cell[7488, 241, 114, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[7627, 246, 236, 5, 27, "Input"],
Cell[7866, 253, 543, 16, 51, "Output"]
}, Open  ]],
Cell[8424, 272, 191, 2, 26, "Text"],
Cell[CellGroupData[{
Cell[8640, 278, 640, 16, 27, "Input"],
Cell[9283, 296, 683, 19, 39, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10015, 321, 101, 1, 34, "Subsection"],
Cell[10119, 324, 164, 2, 26, "Text"],
Cell[CellGroupData[{
Cell[10308, 330, 832, 25, 27, "Input"],
Cell[11143, 357, 528, 12, 48, "Output"]
}, Open  ]],
Cell[11686, 372, 305, 5, 26, "Text"],
Cell[CellGroupData[{
Cell[12016, 381, 775, 22, 27, "Input"],
Cell[12794, 405, 838, 21, 71, "Output"]
}, Open  ]],
Cell[13647, 429, 260, 5, 26, "Text"],
Cell[CellGroupData[{
Cell[13932, 438, 523, 12, 27, "Input"],
Cell[14458, 452, 716, 17, 61, "Output"]
}, Open  ]],
Cell[15189, 472, 212, 8, 86, "Text"],
Cell[CellGroupData[{
Cell[15426, 484, 784, 24, 27, "Input"],
Cell[16213, 510, 522, 16, 58, "Output"]
}, Open  ]],
Cell[16750, 529, 108, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[16883, 534, 890, 26, 27, "Input"],
Cell[17776, 562, 468, 10, 48, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18293, 578, 98, 1, 34, "Subsection"],
Cell[18394, 581, 168, 2, 26, "Text"],
Cell[CellGroupData[{
Cell[18587, 587, 423, 10, 27, "Input"],
Cell[19013, 599, 766, 19, 55, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
