import madgraph.various.cluster as cluster
import madgraph.various.misc as misc
import subprocess

ClusterManagmentError = cluster.ClusterManagmentError

class SLAC_cluster(cluster.LSFCluster):

    @cluster.multiple_try()
    def submit(self, prog, argument=[], cwd=None, stdout=None, stderr=None, log=None,
               required_output=[], nb_submit=0):
        """Submit the job prog to an LSF cluster"""
        # misc.sprint('In custom submit')
        me_dir = self.get_jobs_identifier(cwd, prog)
        
        text = ""
        command = ['bsub' ,'-R','"mem > 1000"','-M','1000' ,
                   '-W','119:59','-C0', '-J', me_dir]
        stdout = '/dev/null'
        stderr = '/dev/null'
        if cwd is None:
            cwd = os.getcwd()
        else: 
            text = " cd %s;" % cwd
        if stdout and isinstance(stdout, str):
            command.extend(['-o', stdout])
        if stderr and isinstance(stdout, str):
            command.extend(['-e', stderr])
        elif stderr == -2: # -2 is subprocess.STDOUT
            pass
        if log is None:
            log = '/dev/null'
        
        text += prog
        if argument:
            text += ' ' + ' '.join(argument)
        
        if self.cluster_queue and self.cluster_queue != 'None':
            command.extend(['-q', self.cluster_queue])

        a = misc.Popen(command, stdout=subprocess.PIPE, 
                                      stderr=subprocess.STDOUT,
                                      stdin=subprocess.PIPE, cwd=cwd)
            
        output = a.communicate(text)[0]
        #Job <nnnn> is submitted to default queue <normal>.
        try:
            id = output.split('>',1)[0].split('<')[1]
        except:
            raise ClusterManagmentError, 'fail to submit to the cluster: \n%s' \
                                                                        % output 
        if not id.isdigit():
            raise ClusterManagmentError, 'fail to submit to the cluster: \n%s' \
                                                                        % output 
        self.submitted += 1
        self.submitted_ids.append(id)
        return id

    @cluster.multiple_try()
    def control_one_job(self, id):
        """ control the status of a single job with it's cluster id """
        cmd = 'bjobs '+str(id)
        # misc.sprint('IN custom control_one_job')
        status = misc.Popen([cmd], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        for line in status.stderr:
           if 'is not found' in line:
             misc.sprint('Waiting for bullet cluster...')
             raise Exception, 'Jobs not registered yet, Waiting for it now...'
        for line in status.stdout:
            line = line.strip().upper()
            if 'JOBID' in line:
                continue
            elif str(id) not in line:
                continue
            try:
                status = line.split()[2]
            except IndexError:
                raise Exception, 'Incorrect output of bjobs: "%s"\nRetrying now...'%line            
            if status in ['RUN','SSUSP']:
                return 'R'
            elif status == 'PEND':
                return 'I'
            elif status == 'DONE':
                return 'F'
            else:
                return 'H'
            return 'F'

    @cluster.multiple_try()   
    def control(self, me_dir):
        """ control the status of a single job with it's cluster id """
        
        if not self.submitted_ids:
            return 0, 0, 0, 0
        batch_size        = 25
        monitor_batches = [self.submitted_ids[b:b+batch_size] for b in 
                                                  range(0,len(self.submitted_ids),batch_size)]
        # misc.sprint('In custom control')
        jobstatus = {}
        for batch in monitor_batches: 
            cmd = "bjobs " + ' '.join(batch)
            status = misc.Popen([cmd], shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            for line in status.stderr:
                if 'is not found' in line:
                    misc.sprint('Waiting for bullet cluster...')
                    raise Exception, 'Jobs not registered yet, Waiting for it now...'
            output = status.communicate()[0]
            for line in output.split('\n'):
                if line=='':
                    continue
                line = line.strip()
                if 'JOBID' in line:
                    continue
                splitline = line.split()
                id = splitline[0]
                if id not in self.submitted_ids:
                    continue
                try:
                    jobstatus[id] = splitline[2]
                except IndexError:
                    raise Exception, 'Incorrect output of bjobs: "%s"\n\n%s\n\nRetrying now...'%(line,output) 
            
        idle, run, fail = 0, 0, 0
        for id in self.submitted_ids[:]:
            if id in jobstatus:
                status = jobstatus[id]
            else:
                status = 'MISSING'
            if status in ['RUN','SSUSP']:
                run += 1
            elif status == 'PEND':
                idle += 1
            else:
                status = self.check_termination(id)
                if status == 'wait':
                    run += 1
                elif status == 'resubmit':
                    idle += 1                

        return idle, run, self.submitted - (idle+run+fail), fail
