(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    256118,       5433]
NotebookOptionsPosition[    254150,       5364]
NotebookOutlinePosition[    254573,       5381]
CellTagsIndexPosition[    254530,       5378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\nNeutrino' s Oscillations\n",
 StyleBox["(from G. Gollin's lecture at UIUC)", "Subsection"]
}], "Section",
 CellChangeTimes->{{3.446279524122033*^9, 3.446279555616667*^9}}],

Cell[CellGroupData[{

Cell["\<\
 This notebook does neutrino oscillation calculations. Load the packages \
needed and define the t = 0 production eigenstate amplitudes\
\>", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.446279589632365*^9}, {3.446279832037991*^9, 3.446279838088664*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`Animation`"}], ";"}], "\n", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462795947099333`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"obspkg\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\\"Graphics`Animation`\\\"\\) is now obsolete. The \
legacy version being loaded may conflict with current Mathematica \
functionality. See the Compatibility Guide for updating information. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Compatibility/Tutorials/Graphics/Animation\\\", \
ButtonNote -> \\\"General::obspkg\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.446279920586542*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["t = 0 production eigenstate amplitudes ", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.446279600245813*^9}, 3.446279887268866*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.4462797726304197`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tinitial", "=", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuE", "=", "0."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuMu", "=", "1."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuTau", "=", "0."}], ";"}]}], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796349088583`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
make sure they' re properly normalized, since the production eigenstates are \
orthogonal \
\>", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.446279651104116*^9}, {3.446279893653021*^9, 3.446279894310679*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"norm", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", "AmpNuE", "]"}], "^", "2"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"Abs", "[", "AmpNuMu", "]"}], "^", "2"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"Abs", "[", "AmpNuTau", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuE", "=", 
   RowBox[{"AmpNuE", " ", "/", " ", "norm"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuMu", "=", 
   RowBox[{"AmpNuMu", " ", "/", " ", "norm"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AmpNuTau", "=", 
   RowBox[{"AmpNuTau", " ", "/", " ", "norm"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796364447308`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
define a 3 - component object from the production amplitudes now \
\>", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796524971027`*^9}, {3.446279897109918*^9, 3.446279897581273*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "a", " ", "define"}], "-", 
  RowBox[{
  "amplitudes", " ", "component", " ", "from", " ", "now", " ", "object", " ",
    "production", " ", "the"}]}]], "Output",
 CellChangeTimes->{3.4462797736611156`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"AmpProductionT0", "=", 
   RowBox[{"{", 
    RowBox[{"AmpNuE", ",", " ", "AmpNuMu", ",", " ", "AmpNuTau"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.446279657735013*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Define the mixing between production eigenstates 
(electron, muon, tau neutrinos) and mass eigenstates (nu1, nu2, nu3).
   
   Use a 3 x3 unitary neutrino mixing matrix using the standard MNS \
formulation.
   Also define the inverse of the matrix.
   
   Mixing angles (including delta) are in degrees.
   
   Use the matrices this way : 
   \t(neutrino mixture in terms of production eigenstates) = 
 \tMixingMatrix * (neutrino mixture in terms of mass eigenstates) 
 
 (neutrino mixture in terms of mass eigenstates) = 
  \tMixingMatrixInverse * (neutrino mixture in terms of production \
eigenstates) 
 \
\>", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796228608294`*^9}, {3.44627989968404*^9, 3.446279899906705*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 RowBox[{"between", " ", "Define", " ", "eigenstates", " ", "mixing", " ", 
  "production", " ", "the"}]], "Output",
 CellChangeTimes->{3.44627986729141*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["between Define eigenstates mixing production the", "Subsection",
 CellChangeTimes->{
  3.446279773727149*^9, {3.446279904261318*^9, 3.446279905101623*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{"(*", " ", 
   RowBox[{"here", " ", "are", " ", "the", " ", "MNS", " ", 
    RowBox[{"angles", "."}]}], " ", "*)"}], 
  StyleBox["\n", "Subsection"], 
  RowBox[{
   RowBox[{
    RowBox[{"theta12", "=", "10."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"theta13", "=", "20."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"theta23", "=", "30."}], ";"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"CP", "-", 
     RowBox[{"violating", " ", "phase"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "=", "0."}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"cosines", ",", " ", "sines", ",", " ", 
     RowBox[{
      RowBox[{"etc", ".", " ", "of"}], " ", "the", " ", "MNS", " ", 
      "angles"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"c12", "=", 
     RowBox[{"Cos", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta12", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"s12", "=", 
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta12", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"c13", "=", 
     RowBox[{"Cos", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta13", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"s13", "=", 
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta13", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"c23", "=", 
     RowBox[{"Cos", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta23", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"s23", "=", 
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", " ", "*", " ", 
       RowBox[{"theta23", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"expid", "=", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "*", " ", "Pi", " ", "*", " ", 
       RowBox[{"delta", " ", "/", " ", "180"}]}], "]"}]}], ";"}], "\n", "\n", 
   
   RowBox[{"(*", " ", 
    RowBox[{"specify", " ", 
     RowBox[{"mc", "^", "2"}], " ", "for", " ", "the", " ", "three", " ", 
     "mass", " ", 
     RowBox[{"eigenstates", " ", "[", "eV", "]"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"mcsq1", "=", "0.1"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mcsq2", "=", "0.3"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mcsq3", "=", "0.4"}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"hbar", ",", " ", 
     RowBox[{"in", " ", "eV", " ", "sec"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"hbar", "=", 
     RowBox[{"6.582173", "*", 
      RowBox[{"10", "^", 
       RowBox[{"-", "16"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Now", " ", "set", " ", "up", " ", "the", " ", "MNS"}], "-", 
     RowBox[{"style", " ", 
      RowBox[{"matrix", ".", " ", "Note"}], " ", "the", " ", "convenient", 
      " ", "form", " ", "as", " ", "a", " ", "\[IndentingNewLine]", "product",
       " ", "of", " ", "three", " ", "different", " ", "two"}], "-", 
     RowBox[{"neutrino", " ", "mixing", " ", 
      RowBox[{"matrices", "."}]}]}], " ", "\[IndentingNewLine]", "*)"}], "\n",
    " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R12", "=", 
     RowBox[{"{", "     ", 
      RowBox[{
       RowBox[{"{", "  ", 
        RowBox[{"c12", ",", "        ", "s12", ",", "      ", "0"}], " ", 
        "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "s12"}], ",", "        ", "c12", ",", "      ", "0"}], 
        " ", "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", "   ", 
        RowBox[{"0", ",", "            ", "0", ",", "           ", "1"}], " ",
         "}"}]}], " ", "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R13", "=", 
     RowBox[{"{", "     ", 
      RowBox[{
       RowBox[{"{", "  ", 
        RowBox[{
        "c13", ",", "                               ", "0", ",", "      ", 
         RowBox[{"s13", "/", "expid"}]}], " ", "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", "   ", 
        RowBox[{
        "0", ",", "                                   ", "1", ",", "      ", 
         "0"}], "                            ", "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "s13"}], "*", "expid"}], ",", "        ", "0", ",", 
         "      ", "c13"}], "                        ", "}"}]}], "  ", 
      "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R23", "=", 
     RowBox[{"{", "     ", 
      RowBox[{
       RowBox[{"{", "  ", 
        RowBox[{"1", ",", "             ", "0", ",", "           ", "0"}], 
        " ", "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", "   ", 
        RowBox[{"0", ",", "            ", "c23", ",", "    ", "s23"}], " ", 
        "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", "   ", 
        RowBox[{"0", ",", "          ", 
         RowBox[{"-", "s23"}], ",", "    ", "c23"}], " ", "}"}]}], " ", 
      "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MixingMatrix", "=", 
     RowBox[{"R23", " ", ".", " ", "R13", " ", ".", " ", "R12"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<MNS Mixing matrix to transform mass eigenstates into production \
eigenstates is \\n\>\"", ",", "\n", "\t\t", 
      RowBox[{"MatrixForm", "[", "MixingMatrix", "]"}]}], " ", "]"}], ";"}], 
   "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Also", " ", "calculate", " ", "the", " ", "inverse", " ", "of", " ", 
     "the", " ", "matrix"}], " ", "*)"}], "\n", "\n", 
   RowBox[{
    RowBox[{"MixingMatrixInverse", "=", 
     RowBox[{"Conjugate", "[", 
      RowBox[{"Transpose", "[", "MixingMatrix", "]"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Mixing matrix to transform production eigenstates back into mass \
eigenstates is\\n\>\"", ",", "\n", "\t\t", 
      RowBox[{"MatrixForm", "[", "MixingMatrixInverse", "]"}]}], " ", "]"}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"re", "-", 
      RowBox[{"express", " ", "t"}]}], "=", 
     RowBox[{
     "0", " ", "neutrino", " ", "state", " ", "in", " ", "terms", " ", "of", 
      " ", "mass", " ", "eigenstates"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"AmpMassT0", "=", 
     RowBox[{"MixingMatrixInverse", " ", ".", " ", "AmpProductionT0"}]}], 
    ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Initial state neutrino, in terms of e, mu, tau amplitudes is \
\\n\>\"", ",", "\n", "\t\t", 
      RowBox[{"MatrixForm", "[", "AmpProductionT0", "]"}]}], " ", "]"}], 
    ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Initial state neutrino, in terms of mass eigenstate amplitudes is \
\\n\>\"", ",", "\n", "\t\t", 
      RowBox[{"MatrixForm", "[", "AmpMassT0", "]"}]}], " ", "]"}], ";"}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Now invert the mass eigenstate amplitudes to recover e, mu, tau \
amplitudes:\\n\>\"", ",", "\n", "\t\t", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"MixingMatrix", " ", ".", " ", "AmpMassT0"}], "]"}]}], " ", 
     "]"}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "generate", " ", "the", " ", "time", " ", "evolution", " ", "matrix", " ",
      "for", " ", "the", " ", "mass", " ", "eigenstates"}], " ", "*)"}], "\n",
    
   RowBox[{
    RowBox[{
     RowBox[{"TimeEvolutionMatrix", "[", "t_", "]"}], ":=", "\n", 
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "*", " ", "mcsq1", "*", 
           RowBox[{"t", "/", "hbar"}]}], "]"}], ",", "  ", "0", ",", 
         "                                                    ", "0"}], "}"}],
        ",", "\n", "\t", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "                                                    ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "*", " ", "mcsq2", "*", 
           RowBox[{"t", "/", "hbar"}]}], "]"}], ",", "  ", "0"}], "}"}], ",", 
       "\n", "\t", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "                                                    ", "0",
          ",", "                                                     ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "*", "  ", "mcsq3", "*", 
           RowBox[{"t", "/", "hbar"}]}], "]"}]}], "}"}]}], "\n", "}"}]}], 
    ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "clear", " ", "a", " ", "possible", " ", "definition", " ", "of", " ", 
     "t", " ", "so", " ", "that", " ", 
     RowBox[{"we", "'"}], "ll", " ", "see", " ", "the", " ", "matrix", " ", 
     "in", " ", "symbolic", " ", "form"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Clear", "[", "t", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Time evolution matrix for mass eigenstates is \\n\>\"", "\n", 
      "\t\t", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"TimeEvolutionMatrix", "[", "t", "]"}], "]"}]}], " ", "]"}], 
    ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "the", " ", "function", " ", "that", " ", "gives", " ", 
     "the", " ", "mass", " ", "eigenstate", " ", "components", " ", "at", " ",
      "time", " ", "t"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"AmpMass", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"TimeEvolutionMatrix", "[", "t", "]"}], " ", ".", " ", 
      "AmpMassT0"}]}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "the", " ", "function", " ", "that", " ", "gives", " ", 
     "the", " ", "production", " ", "eigenstate", " ", "components", " ", 
     "at", " ", "time", " ", "t"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"AmpProduction", "[", "t_", "]"}], ":=", 
     RowBox[{"MixingMatrix", " ", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"TimeEvolutionMatrix", "[", "t", "]"}], " ", ".", " ", 
        "AmpMassT0"}], ")"}]}]}], ";"}], "\n", "\n"}]}]], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796228608294`*^9}, 3.446279673268849*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"MNS Mixing matrix to transform mass eigenstates into \
production eigenstates is \\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"0.9254165783983233`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.16317591116653485`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.34202014332566877`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.31879577759716793`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.8231729446455007`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.46984631039295427`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.2048741287028621`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.5438381424823258`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.8137976813493736`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "MNS Mixing matrix to transform mass eigenstates into production \
eigenstates is \n", 
   MatrixForm[{{Complex[0.9254165783983233, 0.], Complex[0.16317591116653485`,
     0.], Complex[0.34202014332566877`, 0.]}, {Complex[-0.31879577759716793`, 
    0.], Complex[0.8231729446455007, 0.], Complex[0.46984631039295427`, 
    0.]}, {Complex[-0.2048741287028621, 0.], Complex[-0.5438381424823258, 0.],
     Complex[0.8137976813493736, 0.]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.446279920868536*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Mixing matrix to transform production eigenstates back into \
mass eigenstates is\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"0.9254165783983233`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.31879577759716793`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.2048741287028621`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.16317591116653485`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.8231729446455007`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.5438381424823258`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.34202014332566877`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.46984631039295427`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.8137976813493736`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Mixing matrix to transform production eigenstates back into mass \
eigenstates is\n", 
   MatrixForm[{{Complex[0.9254165783983233, 0.], 
    Complex[-0.31879577759716793`, 0.], Complex[-0.2048741287028621, 0.]}, {
    Complex[0.16317591116653485`, 0.], Complex[0.8231729446455007, 0.], 
    Complex[-0.5438381424823258, 0.]}, {Complex[0.34202014332566877`, 0.], 
    Complex[0.46984631039295427`, 0.], Complex[0.8137976813493736, 0.]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.4462799208744993`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state neutrino, in terms of e, mu, tau amplitudes is \
\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.`"},
        {"1.`"},
        {"0.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Initial state neutrino, in terms of e, mu, tau amplitudes is \n", 
   MatrixForm[{0., 1., 0.}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.446279920880884*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial state neutrino, in terms of mass eigenstate amplitudes \
is \\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          RowBox[{"-", "0.31879577759716793`"}], "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
        {
         RowBox[{"0.8231729446455007`", "\[InvisibleSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
        {
         RowBox[{"0.46984631039295427`", "\[InvisibleSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Initial state neutrino, in terms of mass eigenstate amplitudes is \n", 
   MatrixForm[{Complex[-0.31879577759716793`, 0.], Complex[0.8231729446455007,
     0.], Complex[0.46984631039295427`, 0.]}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.446279920886834*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Now invert the mass eigenstate amplitudes to recover e, mu, \
tau amplitudes:\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"5.551115123125783`*^-17", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
        {
         RowBox[{"1.`", "\[InvisibleSpace]", "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]},
        {
         RowBox[{
          RowBox[{"-", "5.551115123125783`*^-17"}], "+", 
          RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Now invert the mass eigenstate amplitudes to recover e, mu, tau \
amplitudes:\n", 
   MatrixForm[{Complex[5.551115123125783*^-17, 0.], Complex[1., 0.], 
    Complex[-5.551115123125783*^-17, 0.]}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.4462799208929367`*^9}],

Cell[BoxData[
 RowBox[{"\<\"Time evolution matrix for mass eigenstates is \\n\"\>", " ", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "1.5192551152939922`*^14"}], " ", "\[ImaginaryI]", " ", 
         "t"}]], "0", "0"},
      {"0", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "4.5577653458819756`*^14"}], " ", "\[ImaginaryI]", " ", 
         "t"}]], "0"},
      {"0", "0", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "6.077020461175969`*^14"}], " ", "\[ImaginaryI]", " ", 
         "t"}]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Print",
 CellChangeTimes->{3.4462797741396923`*^9, 3.4462799208992767`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now specify the t = 0 state of the neutrino and
make some argand diagrams to show the initial amplitudes.
  \
\>", "Subsection",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796228608294`*^9}, {3.446279673268849*^9, 3.446279689085381*^9}, 
   3.446279881790246*^9},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"write\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Tag \\!\\(Times\\) in \\!\\(Now\\\\ specify\\\\ t\\\\ \
the\\) is Protected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/write\\\", ButtonNote -> \
\\\"Set::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.446279774225973*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.44627977423181*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"modulus1", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"AmpMassT0", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"modulus2", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"AmpMassT0", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"modulus3", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"AmpMassT0", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"empty", " ", "space", " ", "between", " ", "circles"}], ",", " ",
     
    RowBox[{"in", " ", "inches"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"gap", "=", "0.35"}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"background", " ", "grayscale"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"bkgnd", "=", "0.97"}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"plot", " ", "height", " ", "and", " ", "width"}], ",", " ", 
    RowBox[{"in", " ", "inches"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"plotheight", "=", 
   RowBox[{"4", "+", 
    RowBox[{"5", "*", "gap"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"plotwidth", "=", 
    RowBox[{"6", "+", 
     RowBox[{"4", "*", "gap"}], " ", "+", " ", "1.5"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "coordinates", " ", "of", " ", "centers", " ", "of", " ", "amplitude", " ",
     "plots", " ", 
    RowBox[{"(", 
     RowBox[{"max", " ", "amplitude", " ", "is", " ", "1"}], ")"}]}], " ", 
   "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"production", " ", "eigenstates"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"xe", "=", 
   RowBox[{"1.", " ", "+", " ", "gap"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xmu", "=", 
   RowBox[{"x1", " ", "+", " ", "2.", " ", "+", " ", "gap"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xtau", "=", 
   RowBox[{"x2", " ", "+", " ", "2.", " ", "+", " ", "gap"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ye", "=", 
   RowBox[{
    RowBox[{"4", "*", "gap"}], " ", "+", " ", "3"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ymu", "=", "ye"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ytau", "=", "ye"}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"mass", " ", "eigenstates"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"x1", "=", "xe"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x2", "=", "xmu"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x3", "=", "xtau"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"y1", "=", 
   RowBox[{
    RowBox[{"2", "*", "gap"}], " ", "+", " ", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"y2", "=", "y1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"y3", "=", "y1"}], ";"}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "y", " ", "positions", " ", "for", " ", "text", " ", "labeling", " ", 
    "the", " ", "graphs"}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"production", " ", "eigenstates"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textye", "=", 
    RowBox[{
     RowBox[{"3", "*", "gap"}], " ", "+", " ", "2"}]}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"mass", " ", "eigenstates"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"texty", "=", "gap"}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.446277687673831*^9, 3.446277754713615*^9, {3.44627957958817*^9, 
   3.4462796228608294`*^9}, {3.446279673268849*^9, 3.446279684401219*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*****)"}],
   "\n", "\n", "\n", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"In", " ", "this", " ", "cell"}], ",", " ", 
     RowBox[{
     "make", " ", "some", " ", "animated", " ", "argand", " ", "diagrams", 
      " ", "to", " ", "show", " ", "the", " ", "amplitudes"}]}], 
    "Subsection"], 
   StyleBox["\n", "Subsection"], 
   RowBox[{
    StyleBox["as", "Subsection"], 
    StyleBox[" ", "Subsection"], 
    StyleBox["functions", "Subsection"], 
    StyleBox[" ", "Subsection"], 
    StyleBox["of", "Subsection"], 
    StyleBox[" ", "Subsection"], 
    RowBox[{
     StyleBox["time", "Subsection"], 
     StyleBox[".", "Subsection"], "\n"}]}]}]}]], "Input",
 CellChangeTimes->{{3.446277704607821*^9, 3.4462777093195353`*^9}, {
  3.446277764763568*^9, 3.446277843832737*^9}, {3.446279710918833*^9, 
  3.446279717469611*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "periods", " ", "for", " ", "a", " ", "360", " ", "degree", " ", "phase", 
    " ", "rotation", " ", "of", " ", "each", " ", "mass", " ", 
    "eigenfunction"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"period1", "=", 
     RowBox[{"2", " ", "*", " ", "Pi", " ", "*", " ", 
      RowBox[{"hbar", " ", "/", " ", "mcsq1"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"period2", "=", 
     RowBox[{"2", " ", "*", " ", "Pi", " ", "*", " ", 
      RowBox[{"hbar", " ", "/", " ", "mcsq2"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"period3", "=", 
     RowBox[{"2", " ", "*", " ", "Pi", " ", "*", " ", 
      RowBox[{"hbar", " ", "/", " ", "mcsq3"}]}]}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"maximum", " ", "period"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"periodmax", "=", 
     RowBox[{"Max", "[", 
      RowBox[{"period1", ",", " ", "period2", ",", " ", "period3"}], "]"}]}], 
    ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"time", " ", "for", " ", "first", " ", "amplitude", " ", "plot"}],
     " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"tinitial", "=", "0."}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "time", " ", "step", " ", "size"}], " ", "*)"}], 
   "\n", 
   RowBox[{
    RowBox[{"dt", "=", 
     RowBox[{"periodmax", " ", "/", " ", "30"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.446277704607821*^9, 3.4462777093195353`*^9}, {
  3.446277764763568*^9, 3.446277843832737*^9}, {3.446279710918833*^9, 
  3.446279733748246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MixingMovie", "=", 
    RowBox[{
     StyleBox["Table",
      FontSize->14], 
     StyleBox["[",
      FontSize->14], 
     RowBox[{
      RowBox[{
       StyleBox["Graphics",
        FontSize->14], 
       StyleBox["[",
        FontSize->14], "\n", "\t", 
       RowBox[{
        StyleBox[
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"plotwidth", ",", "plotheight"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"plotwidth", ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "plotheight"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".8", ",", "0", ",", "0"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1", ",", "y1"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpMass", "[", "t", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "y1"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x1", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"y1", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", ".6", ",", "0"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x2", ",", "y2"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpMass", "[", "t", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x2", ",", "y2"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x2", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"y2", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "0", ",", ".8"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x3", ",", "y3"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpMass", "[", "t", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x3", ",", "y3"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x3", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"y3", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpMass", "[", "t", "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(1\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "texty"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(2\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "texty"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(3\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"x3", ",", "texty"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV\>\"", ",", 
               RowBox[{"ToString", "[", "mcsq1", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", 
               RowBox[{"texty", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV\>\"", ",", 
               RowBox[{"ToString", "[", "mcsq2", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", 
               RowBox[{"texty", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV\>\"", ",", 
               RowBox[{"ToString", "[", "mcsq3", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x3", ",", 
               RowBox[{"texty", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", ".6", ",", ".6"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"xe", ",", "ye"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"xe", ",", "ye"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"xe", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"ye", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".6", ",", "0", ",", ".6"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"xmu", ",", "ymu"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"xmu", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"ymu", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"xmu", ",", "ymu"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".6", ",", ".6", ",", "0"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"xtau", ",", "ytau"}], "}"}], ",", 
             RowBox[{"Abs", "[", " ", 
              RowBox[{
               RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}], " ", "]"}], ",", 
           "\t", 
           RowBox[{"Line", "[", " ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"xtau", ",", "ytau"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"xtau", " ", "+", " ", 
                 RowBox[{"Re", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}], ",", " ", 
                RowBox[{"ytau", " ", "+", " ", 
                 RowBox[{"Im", "[", " ", 
                  RowBox[{
                   RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}]}], " ", 
               "}"}]}], " ", "}"}], " ", "]"}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{"\"\<P = ``\>\"", ",", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Abs", "[", " ", 
                   RowBox[{
                    RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "]"}], "^", "2"}], 
                 ",", "3"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "\t",
              
             RowBox[{"{", 
              RowBox[{"xe", ",", 
               RowBox[{"textye", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "18"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{"\"\<P = ``\>\"", ",", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Abs", "[", " ", 
                   RowBox[{
                    RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "]"}], "^", "2"}], 
                 ",", "3"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "\t",
              
             RowBox[{"{", 
              RowBox[{"xmu", ",", 
               RowBox[{"textye", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "18"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{"\"\<P = ``\>\"", ",", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Abs", "[", " ", 
                   RowBox[{
                    RowBox[{"AmpProduction", "[", "t", "]"}], "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "]"}], "^", "2"}], 
                 ",", "3"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "\t",
              
             RowBox[{"{", 
              RowBox[{"xtau", ",", 
               RowBox[{"textye", "-", "gap"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "18"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", "\n", "\t", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(e\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"xe", ",", "textye"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", "\n", 
           "\t", 
           RowBox[{"Text", "[", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(\[Mu]\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"xmu", ",", "textye"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", "\n", 
           "\t", 
           RowBox[{"Text", "[", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[\(\[Nu]\), \(\[Tau]\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"xtau", ",", "textye"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "24"}], "}"}]}]}], "]"}], ",", "\n", 
           "\t", "\n", "\t", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg\>\"", 
               ",", 
               RowBox[{"ToString", "[", "theta12", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", 
               RowBox[{"texty", "-", 
                RowBox[{"2", "*", "gap"}]}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", "\n", 
           "\t", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg\>\"", 
               ",", 
               RowBox[{"ToString", "[", "theta13", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", 
               RowBox[{"texty", "-", 
                RowBox[{"2", "*", "gap"}]}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", "\n", 
           "\t", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg\>\"", 
               ",", 
               RowBox[{"ToString", "[", "theta23", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x3", ",", 
               RowBox[{"texty", "-", 
                RowBox[{"2", "*", "gap"}]}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "14"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringForm", "[", 
              RowBox[{"\"\<t = `` sec\>\"", ",", 
               RowBox[{"ScientificForm", "[", 
                RowBox[{"t", ",", "4"}], "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"xtau", "+", "0.5"}], ",", "texty"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
             
             RowBox[{"TextStyle", "->", 
              RowBox[{"{", 
               RowBox[{"FontSize", "->", "12"}], "}"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "\t", "}"}],
         FontSize->14], 
        StyleBox[",",
         FontSize->14], "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}],
         FontSize->14], 
        StyleBox[",",
         FontSize->14], "\n", "\t", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"72", "*", 
          RowBox[{"{", 
           RowBox[{"plotwidth", ",", "plotheight"}], "}"}]}]}]}], 
       StyleBox["]",
        FontSize->14]}], 
      StyleBox[",",
       FontSize->14], "\n", "\t", 
      RowBox[{"{", 
       RowBox[{"t", ",", " ", "tinitial", ",", " ", 
        RowBox[{"tinitial", "+", "periodmax", "-", "dt"}], ",", " ", "dt"}], 
       "}"}]}], "]"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.446277704607821*^9, 3.4462777093195353`*^9}, {
  3.446277764763568*^9, 3.446277843832737*^9}, {3.446279710918833*^9, 
  3.4462797404349003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"List", 
    StyleBox["Animate",
     FontSize->14]}]], 
  StyleBox["[",
   FontSize->14], 
  StyleBox["MixingMovie",
   FontSize->14], 
  StyleBox["]",
   FontSize->14]}]], "Input",
 CellChangeTimes->{{3.446277704607821*^9, 3.4462777093195353`*^9}, {
  3.446277764763568*^9, 3.446277843832737*^9}, {3.446279710918833*^9, 
  3.4462797404349003`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i1$$ = 7, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i1$$], 1, ""}, 1, 30, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i1$184$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i1$$], {1, 30, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                ColumnsEqual->False,
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                RowsEqual->False],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            TagBox[
             StyleBox[
              PaneBox[Cell[BoxData[
                TagBox[
                 PaneSelectorBox[{1->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.0312042224028322`, 1.7}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.523172944645501, 1.7}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.519846310392955, 
                    1.7}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 5.551115123125783*^-17], 
                    LineBox[{{1.35, 4.4}, {1.35, 4.4}}]}, 
                    {RGBColor[0.6, 0, 0.6], LineBox[{{3.7, 4.4}, {4.7, 4.4}}],
                     CircleBox[{3.7, 4.4}]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 
                    5.551115123125783*^-17], 
                    LineBox[{{6.050000000000001, 4.4}, {6.050000000000001, 
                    4.4}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\(\\\"3.08\\\" \[Times] 10\\^\\\"-33\\\"\\)\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[3.0814879110195774`*^-33, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \\!\\(TraditionalForm\\`\\\"1.\
\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[1., 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\(\\\"3.08\\\" \[Times] 10\\^\\\"-33\\\"\\)\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[3.0814879110195774`*^-33, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \\!\\(TraditionalForm\\`\\\"0.\
\\\"\\) sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[0., 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 2->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.0381706750192623`, 
                    1.7662813691457895`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.365960901527878, 
                    1.2161510830512061`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.36438854656871, 
                    1.3508361456618303`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.1549744119485853], 
                    LineBox[{{1.35, 4.4}, {1.2776239656975443`, 
                    4.262964318451509}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.495325167099422, 
                    3.8165250929713164`}}], 
                    CircleBox[{3.7, 4.4}, 0.9864000651631436]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.05475256238146247], 
                    LineBox[{{6.050000000000001, 4.4}, {6.00755949184707, 
                    4.365407423411129}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.024\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.024017068358809818`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.973\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.9729850885538539, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.003\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0029978430873359393`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.379\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.3785670894304726`*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 3->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.0587655654604666`, 
                    1.8296659244066116`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455008], 
                    LineBox[{{3.7, 1.7}, {3.9543744292051275`, 
                    0.9171160069570267}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {6.000887687202648, 
                    1.232727556856209}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.29666127566530637`], 
                    LineBox[{{1.35, 4.4}, {1.1051972050776628`, 
                    4.2324305992205655`}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.9791632169907047`, 
                    3.4946678955725154`}}], 
                    CircleBox[{3.7, 4.4}, 0.9473955462359414]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.12014061133911028`],
                     LineBox[{{6.050000000000001, 4.4}, {5.931360397670449, 
                    4.418931752481507}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.088\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0880079124793669, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.898\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.8975583210276977, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0144\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.014433766492935153`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.757\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.757134178860945*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 4->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.318795777597168], 
                    LineBox[{{1.35, 1.7}, {1.0920887981889151`, 
                    1.8873834565647265`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455008], 
                    LineBox[{{3.7, 1.7}, {3.4456255707948724`, 
                    0.9171160069570267}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {5.669886350147734, 
                    1.4238312679069898`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.4130817066485086], 
                    LineBox[{{1.35, 4.4}, {0.9398103938238572, 
                    4.351204678987578}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.394231858287995, 
                    3.56605716356679}}], 
                    CircleBox[{3.7, 4.4}, 0.8882312823382664]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.20101913517890388`],
                     LineBox[{{6.050000000000001, 4.4}, {5.931842242928651, 
                    4.56262668032012}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.171\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.1706364963676445, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.789\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.7889548109242812, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0404\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.04040869270807443, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"4.136\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[4.1357012682914175`*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 5->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.1366839880317634`, 
                    1.9369114325053776`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.034039098472122, 
                    1.2161510830512063`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295416`],
                     LineBox[{{6.050000000000001, 1.7}, {5.590420958775502, 
                    1.7976865408182852`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.4947542375891875], 
                    LineBox[{{1.35, 4.4}, {0.8867397596296036, 
                    4.573700044054171}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.003871730726603, 
                    3.972079958703037}}], 
                    CircleBox[{3.7, 4.4}, 0.817135318674435]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.29581770630300547`],
                     LineBox[{{6.050000000000001, 4.4}, {6.081873513597873, 
                    4.694095553338193}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.245\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.2447817556124582, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.668\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6677101290251705, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0875\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0875081153623712, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"5.514\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[5.51426835772189*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 6->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.1906021112014162`, 
                    1.9760852420183614`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {2.8768270553544992`, 1.7}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.8150768448035235`, 
                    2.106898840674687}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.5356602883070314], 
                    LineBox[{{1.35, 4.4}, {0.9878201046431117, 
                    4.79466145982151}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {2.962823899415611, 
                    4.503165109581826}}], 
                    CircleBox[{3.7, 4.4}, 0.7443598881642104]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.3987435421708947], 
                    LineBox[{{6.050000000000001, 4.4}, {6.33914942974823, 
                    4.674570609678578}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.287\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.286931944469172, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.554\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5540716431078359, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.159\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.15899641242299206`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"6.893\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[6.892835447152363*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 7->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.251486686987499, 
                    2.003192801651167}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455008], 
                    LineBox[{{3.7, 1.7}, {3.034039098472122, 
                    2.1838489169487936`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.19519049465579, 
                    2.1468503951564544`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.5339193150121708], 
                    LineBox[{{1.35, 4.4}, {1.1998234438288877`, 
                    4.912363969185628}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.2514218501141685`, 
                    4.911585762225921}}], 
                    CircleBox[{3.7, 4.4}, 0.6803986689193859]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.5019838806073976], 
                    LineBox[{{6.050000000000001, 4.4}, {6.550513456726695, 
                    4.4383939581855945`}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.285\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.2850698349430657, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.463\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.4629423486672722, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.252\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.25198781638966206`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"8.271\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[8.271402536582835*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 8->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.3166767672715516`, 
                    2.017049380971338}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.4456255707948724`, 
                    2.4828839930429734`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929543], 
                    LineBox[{{6.050000000000001, 1.7}, {6.47922596264962, 
                    1.8911037110507802`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.49217663982664556`], 
                    LineBox[{{1.35, 4.4}, {1.4244582739887752`, 
                    4.88651188086794}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.7028993928342016`, 
                    5.033164291465164}}], 
                    CircleBox[{3.7, 4.4}, 0.6331709298960195]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.5973748645060004], 
                    LineBox[{{6.050000000000001, 4.4}, {6.544468678523936, 
                    4.064802364712465}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.242\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.2422378447910476, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.401\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.40090542646539007`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.357\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.35685672874356233`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"9.65\\\" \[Times] 10\\^\\\"-15\\\"\\)\\) sec\"\
\>",
                    StringForm["t = `` sec", 
                    ScientificForm[9.649969626013308*^-15, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 9->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.3833232327284488`, 
                    2.017049380971338}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455006], 
                    LineBox[{{3.7, 1.7}, {3.9543744292051284`, 
                    2.482883993042973}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.479225962649619, 
                    1.5088962889492188`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.4178666327256273], 
                    LineBox[{{1.35, 4.4}, {1.5691495765402668`, 
                    4.7557892435806295`}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.100441076917374, 
                    4.853585544385943}}], 
                    CircleBox[{3.7, 4.4}, 0.6050561148840974]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.6777127526437047], 
                    LineBox[{{6.050000000000001, 4.4}, {6.254137507834491, 
                    3.753762850811693}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.175\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.1746125227454543, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.366\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.36609290215863804`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.459\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.45929457509590726`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.103\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.102853671544378*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 10->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.4485133130125012`, 
                    2.003192801651167}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.365960901527878, 
                    2.183848916948793}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.195190494655789, 
                    1.2531496048435453`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.32399324363458537`], 
                    LineBox[{{1.35, 4.4}, {1.5994927037545081`, 
                    4.606700296792543}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.285012586322133, 
                    4.491683743302133}}], 
                    CircleBox[{3.7, 4.4}, 0.5921533880180051]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7378229754744275], 
                    LineBox[{{6.050000000000001, 4.4}, {5.785797919083005, 
                    3.711102327208847}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.105\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.10497162192085979`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.351\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3506456349412021, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.544\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5443827431379377, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.241\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.2407103804874253`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 11->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.5093978887985842`, 
                    1.9760852420183612`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.523172944645501, 
                    1.7000000000000002`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.8150768448035235`, 
                    1.2931011593253132`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.2326525204166003], 
                    LineBox[{{1.35, 4.4}, {1.5514829929352536`, 
                    4.5163262602083005`}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.216420545194517, 
                    4.120805271593483}}], 
                    CircleBox[{3.7, 4.4}, 0.5870603681641192]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7753921129820782], 
                    LineBox[{{6.050000000000001, 4.4}, {5.378490732263427, 
                    4.012303943508962}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0541\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.05412719525619662, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.345\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3446398758689912, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.601\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.601232928874812, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.379\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.3785670894304726`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 12->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.5633160119682368`, 
                    1.9369114325053776`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.3659609015278775`, 
                    1.216151083051206}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.590420958775502, 
                    1.6023134591817152`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.18327888075828863`], 
                    LineBox[{{1.35, 4.4}, {1.4988896612722433`, 
                    4.506878514670853}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.9642652355668724`, 
                    3.8802846371459925`}}], 
                    CircleBox[{3.7, 4.4}, 0.5830438860975111]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7914977439969751], 
                    LineBox[{{6.050000000000001, 4.4}, {5.2701177701115975`, 
                    4.53510139250427}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0336\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.03359114813201098, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.34\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3399401731156875, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.626\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6264686787523012, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.516\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.51642379837352*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 13->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.607911201811085, 
                    1.8873834565647265`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.954374429205128, 
                    0.9171160069570269}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.669886350147734, 
                    1.9761687320930101`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.20539053590965575`], 
                    LineBox[{{1.35, 4.4}, {1.5001765561711125`, 
                    4.540115217652618}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.648578149885832, 
                    3.8255708832063924`}}], 
                    CircleBox[{3.7, 4.4}, 0.5767261194791238]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7906969779057561], 
                    LineBox[{{6.050000000000001, 4.4}, {5.549486543273305, 
                    5.012117627997096}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0422\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.04218527224125559, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.333\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.33261301688944855`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.625\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6252017108692958, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.654\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.654280507316567*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 14->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.6412344345395338`, 
                    1.8296659244066111`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.4456255707948715`, 
                    0.9171160069570271}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.000887687202649, 
                    2.167272443143791}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.26025412315197266`], 
                    LineBox[{{1.35, 4.4}, {1.5612079943983266`, 
                    4.552063775172915}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.374686305083894, 
                    3.933760362291339}}], 
                    CircleBox[{3.7, 4.4}, 0.568514203754553]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7804225724001866], 
                    LineBox[{{6.050000000000001, 4.4}, {6.088704629769173, 
                    5.179462214059256}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0677\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.06773220861760215, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.323\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.32320839987067335`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.609\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6090593915117246, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.792\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.7921372162596144`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 15->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.6618293249807379`, 
                    1.7662813691457893`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.0340390984721224`, 
                    1.216151083051206}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929543], 
                    LineBox[{{6.050000000000001, 1.7}, {6.364388546568711, 
                    2.049163854338169}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.30492757873824183`], 
                    LineBox[{{1.35, 4.4}, {1.6374304658172139`, 
                    4.501806461461276}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.2001034301708025`, 
                    4.14463179033806}}], 
                    CircleBox[{3.7, 4.4}, 0.5613461525947626]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7693566589637674], 
                    LineBox[{{6.050000000000001, 4.4}, {6.604137848633763, 
                    4.933704893553953}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.093\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.09298082827516667, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.315\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3151095030329425, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.592\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5919096686918907, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"1.93\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) sec\"\
\>",
                    StringForm["t = `` sec", 
                    ScientificForm[1.9299939252026616`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 16->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.668795777597168, 1.7}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {2.8768270553544992`, 
                    1.6999999999999997`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.519846310392955, 
                    1.6999999999999993`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.3213938048432697], 
                    LineBox[{{1.35, 4.4}, {1.6713938048432697`, 4.4}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.141511110779745, 
                    4.3999999999999995`}}], 
                    CircleBox[{3.7, 4.4}, 0.5584888892202553]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7647196759766886], 
                    LineBox[{{6.050000000000001, 4.4}, {6.814719675976689, 
                    4.4}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.103\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.10329397779163371`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.312\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3119098393824746, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.585\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5847961828258915, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.068\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.067850634145709*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 17->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.6618293249807379`, 
                    1.6337186308542102`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455006], 
                    LineBox[{{3.7, 1.7}, {3.034039098472123, 
                    2.1838489169487945`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929543], 
                    LineBox[{{6.050000000000001, 1.7}, {6.364388546568709, 
                    1.3508361456618296`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.30492757873824156`], 
                    LineBox[{{1.35, 4.4}, {1.6374304658172134`, 
                    4.298193538538724}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.2001034301708025`, 
                    4.65536820966194}}], 
                    CircleBox[{3.7, 4.4}, 0.5613461525947628]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7693566589637671], 
                    LineBox[{{6.050000000000001, 4.4}, {6.604137848633761, 
                    3.866295106446046}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.093\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0929808282751665, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.315\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3151095030329428, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.592\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5919096686918903, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.206\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.205707343088756*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 18->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.6412344345395335`, 
                    1.5703340755933883`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.4456255707948724`, 
                    2.482883993042973}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.000887687202647, 
                    1.232727556856209}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.2602541231519723], 
                    LineBox[{{1.35, 4.4}, {1.561207994398326, 
                    4.247936224827086}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.3746863050838933`, 
                    4.866239637708662}}], 
                    CircleBox[{3.7, 4.4}, 0.5685142037545534]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7804225724001863], 
                    LineBox[{{6.050000000000001, 4.4}, {6.08870462976917, 
                    3.6205377859407455`}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0677\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.06773220861760199, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.323\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3232083998706739, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.609\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6090593915117241, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.344\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.3435640520318032`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 19->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.6079112018110848`, 
                    1.5126165434352732`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.954374429205129, 
                    2.482883993042973}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.669886350147733, 
                    1.4238312679069909`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.20539053590965553`], 
                    LineBox[{{1.35, 4.4}, {1.5001765561711122`, 
                    4.259884782347383}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.6485781498858323`, 
                    4.974429116793608}}], 
                    CircleBox[{3.7, 4.4}, 0.576726119479124]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7906969779057559], 
                    LineBox[{{6.050000000000001, 4.4}, {5.549486543273305, 
                    3.7878823720029056`}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0422\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0421852722412555, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.333\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.33261301688944883`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.625\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6252017108692954, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.481\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.4814207609748507`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 20->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.318795777597168], 
                    LineBox[{{1.35, 1.7}, {1.5633160119682366`, 
                    1.4630885674946223`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455008], 
                    LineBox[{{3.7, 1.7}, {4.365960901527879, 
                    2.1838489169487927`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {5.590420958775502, 
                    1.7976865408182858`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.18327888075828871`], 
                    LineBox[{{1.35, 4.4}, {1.4988896612722433`, 
                    4.293121485329148}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.9642652355668737`, 
                    4.919715362854007}}], 
                    CircleBox[{3.7, 4.4}, 0.5830438860975111]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7914977439969754], 
                    LineBox[{{6.050000000000001, 4.4}, {5.270117770111597, 
                    4.264898607495732}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0336\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.033591148132011014`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.34\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3399401731156875, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.626\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6264686787523016, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.619\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.6192774699178978`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 21->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.3187957775971679], 
                    LineBox[{{1.35, 1.7}, {1.509397888798584, 
                    1.4239147579816385`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.523172944645501, 
                    1.7000000000000004`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {5.815076844803524, 
                    2.1068988406746874`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.23265252041660042`], 
                    LineBox[{{1.35, 4.4}, {1.5514829929352538`, 
                    4.2836737397917}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.216420545194517, 
                    4.679194728406519}}], 
                    CircleBox[{3.7, 4.4}, 0.5870603681641201]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7753921129820776], 
                    LineBox[{{6.050000000000001, 4.4}, {5.378490732263428, 
                    4.78769605649104}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0541\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.05412719525619668, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.345\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.34463987586899225`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.601\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.601232928874811, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.757\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.7571341788609452`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 22->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.4485133130125012`, 
                    1.3968071983488328`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455005], 
                    LineBox[{{3.7, 1.7}, {4.365960901527878, 
                    1.2161510830512068`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.195190494655789, 
                    2.1468503951564544`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.3239932436345855], 
                    LineBox[{{1.35, 4.4}, {1.5994927037545081`, 
                    4.193299703207458}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.285012586322133, 
                    4.308316256697867}}], 
                    CircleBox[{3.7, 4.4}, 0.5921533880180052]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.7378229754744274], 
                    LineBox[{{6.050000000000001, 4.4}, {5.785797919083006, 
                    5.088897672791154}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.105\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.10497162192085986`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.351\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3506456349412022, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.544\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.5443827431379376, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"2.895\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[2.8949908878039923`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 23->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.3833232327284486`, 
                    1.382950619028662}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455008], 
                    LineBox[{{3.7, 1.7}, {3.954374429205127, 
                    0.9171160069570264}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.47922596264962, 
                    1.8911037110507805`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.41786663272562746`], 
                    LineBox[{{1.35, 4.4}, {1.5691495765402665`, 
                    4.044210756419371}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.100441076917373, 
                    3.946414455614057}}], 
                    CircleBox[{3.7, 4.4}, 0.6050561148840972]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.6777127526437049], 
                    LineBox[{{6.050000000000001, 4.4}, {6.254137507834492, 
                    5.046237149188308}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.175\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.17461252274545444`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.366\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.36609290215863777`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.459\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.45929457509590754`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.033\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.03284759674704*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 24->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.318795777597168], 
                    LineBox[{{1.35, 1.7}, {1.3166767672715511`, 
                    1.382950619028662}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.4456255707948715`, 
                    0.9171160069570271}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.479225962649618, 
                    1.508896288949217}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.49217663982664617`], 
                    LineBox[{{1.35, 4.4}, {1.4244582739887741`, 
                    3.9134881191320603`}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.7028993928342, 
                    3.7668357085348356`}}], 
                    CircleBox[{3.7, 4.4}, 0.6331709298960205]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.5973748645059986], 
                    LineBox[{{6.050000000000001, 4.4}, {6.544468678523935, 
                    4.735197635287534}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.242\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.24223784479104818`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.401\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.40090542646539135`, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.357\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.3568567287435602, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.171\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.170704305690087*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 25->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.318795777597168], 
                    LineBox[{{1.35, 1.7}, {1.2514866869874992`, 
                    1.3968071983488328`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.0340390984721224`, 
                    1.216151083051206}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {6.19519049465579, 
                    1.2531496048435455`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.5339193150121708], 
                    LineBox[{{1.35, 4.4}, {1.199823443828888, 
                    3.887636030814373}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.251421850114169, 
                    3.888414237774079}}], 
                    CircleBox[{3.7, 4.4}, 0.6803986689193858]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.5019838806073977], 
                    LineBox[{{6.050000000000001, 4.4}, {6.550513456726695, 
                    4.361606041814406}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.285\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.2850698349430657, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.463\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.462942348667272, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.252\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.25198781638966217`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.309\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.308561014633134*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 26->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.1906021112014158`, 
                    1.4239147579816387`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {2.8768270553544992`, 
                    1.6999999999999995`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.815076844803522, 
                    1.2931011593253139`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.5356602883070318], 
                    LineBox[{{1.35, 4.4}, {0.9878201046431107, 
                    4.0053385401784904`}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {2.96282389941561, 
                    4.296834890418174}}], 
                    CircleBox[{3.7, 4.4}, 0.7443598881642112]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.39874354217089286`],
                     LineBox[{{6.050000000000001, 4.4}, {6.339149429748228, 
                    4.125429390321424}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.287\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.2869319444691725, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.554\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.554071643107837, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.159\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.15899641242299062`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.446\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.4464177235761814`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 27->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.1366839880317632`, 
                    1.4630885674946228`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.0340390984721237`, 
                    2.1838489169487953`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {5.590420958775501, 
                    1.6023134591817174`}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.49475423758918713`], 
                    LineBox[{{1.35, 4.4}, {0.8867397596296034, 
                    4.226299955945832}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.003871730726604, 
                    4.8279200412969665`}}], 
                    CircleBox[{3.7, 4.4}, 0.8171353186744356]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.2958177063030044], 
                    LineBox[{{6.050000000000001, 4.4}, {6.081873513597872, 
                    4.105904446661809}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.245\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.24478175561245782`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.668\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.6677101290251714, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0875\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.08750811536237058, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.584\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.584274432519229*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 28->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.0920887981889151`, 
                    1.5126165434352734`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.445625570794872, 
                    2.482883993042973}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.4698463103929542], 
                    LineBox[{{6.050000000000001, 1.7}, {5.669886350147734, 
                    1.97616873209301}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.4130817066485087], 
                    LineBox[{{1.35, 4.4}, {0.9398103938238571, 
                    4.448795321012422}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.3942318582879945`, 
                    5.233942836433211}}], 
                    CircleBox[{3.7, 4.4}, 0.8882312823382662]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.20101913517890393`],
                     LineBox[{{6.050000000000001, 4.4}, {5.931842242928651, 
                    4.237373319679881}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.171\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.17063649636764458`, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.789\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.7889548109242808, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0404\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.040408692708074456`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.722\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.7221311414622757`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 29->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.318795777597168], 
                    LineBox[{{1.35, 1.7}, {1.0587655654604664`, 
                    1.5703340755933888`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {3.954374429205127, 
                    2.4828839930429734`}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.00088768720265, 
                    2.167272443143791}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.29666127566530615`], 
                    LineBox[{{1.35, 4.4}, {1.1051972050776633`, 
                    4.567569400779436}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {3.979163216990705, 
                    5.305332104427485}}], 
                    CircleBox[{3.7, 4.4}, 0.9473955462359417]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.12014061133910847`],
                     LineBox[{{6.050000000000001, 4.4}, {5.931360397670451, 
                    4.381068247518494}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.088\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.08800791247936676, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.898\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.8975583210276983, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.0144\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.01443376649293472, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.86\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) sec\"\
\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.859987850405323*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}], 30->
                  
                  GraphicsBox[{PointBox[{0, 0}], PointBox[{8.9, 5.75}], 
                    PointBox[{8.9, 0}], PointBox[{0, 5.75}], 
                    {RGBColor[0.8, 0, 0], 
                    CircleBox[{1.35, 1.7}, 0.31879577759716793`], 
                    LineBox[{{1.35, 1.7}, {1.0381706750192623`, 
                    1.6337186308542109`}}]}, 
                    {RGBColor[0, 0.6, 0], 
                    CircleBox[{3.7, 1.7}, 0.8231729446455007], 
                    LineBox[{{3.7, 1.7}, {4.365960901527879, 
                    2.183848916948792}}]}, 
                    {RGBColor[0, 0, 0.8], 
                    CircleBox[{6.050000000000001, 1.7}, 0.46984631039295427`],
                     LineBox[{{6.050000000000001, 1.7}, {6.364388546568712, 
                    2.049163854338168}}]}, 
                    {RGBColor[0, 0, 0], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(1\\)]\
\\)\"\>", {1.35, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(2\\)]\
\\)\"\>", {3.7, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(3\\)]\
\\)\"\>", {6.050000000000001, 0.35}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(1\\)]\\) = 0.1 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(1\)]\) = `` eV", "0.1"],
                    Editable->False], {1.35, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(2\\)]\\) = 0.3 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(2\)]\) = `` eV", "0.3"],
                    Editable->False], {3.7, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(m\\), \
\\(3\\)]\\) = 0.4 eV\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(m\), \(3\)]\) = `` eV", "0.4"],
                    Editable->False], {6.050000000000001, 0.}, {0, -1},
                    BaseStyle->{FontSize -> 14}]}, 
                    {RGBColor[0, 0.6, 0.6], 
                    CircleBox[{1.35, 4.4}, 0.15497441194858447`], 
                    LineBox[{{1.35, 4.4}, {1.277623965697545, 
                    4.537035681548491}}]}, 
                    {RGBColor[0.6, 0, 0.6], 
                    LineBox[{{3.7, 4.4}, {4.495325167099423, 
                    4.983474907028682}}], 
                    CircleBox[{3.7, 4.4}, 0.9864000651631438]}, 
                    {RGBColor[0.6, 0.6, 0], 
                    CircleBox[{6.050000000000001, 4.4}, 0.05475256238146174], 
                    LineBox[{{6.050000000000001, 4.4}, {6.007559491847071, 
                    4.434592576588872}}]}, 
                    {RGBColor[0, 0, 0], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.024\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.02401706835880956, 3]],
                    Editable->False], {1.35, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.973\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.9729850885538543, 3]],
                    Editable->False], {3.7, 2.6999999999999997`}, {0, -1},
                    BaseStyle->{FontSize -> 18}], InsetBox[
                    
                    InterpretationBox["\<\"P = \
\\!\\(TraditionalForm\\`\\\"0.003\\\"\\)\"\>",
                    StringForm["P = ``", 
                    NumberForm[0.0029978430873358595`, 3]],
                    
                    Editable->
                    False], {6.050000000000001, 2.6999999999999997`}, {0, -1},
                    
                    BaseStyle->{FontSize -> 18}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(e\\)]\
\\)\"\>", {1.35, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \\(\[Mu]\
\\)]\\)\"\>", {3.7, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], 
                    InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Nu]\\), \
\\(\[Tau]\\)]\\)\"\>", {6.050000000000001, 3.05}, {0, -1},
                    BaseStyle->{FontSize -> 24}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(12\\)]\\)=10. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(12\)]\)=`` deg", 
                    "10."],
                    Editable->False], {1.35, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(13\\)]\\)=20. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(13\)]\)=`` deg", 
                    "20."],
                    Editable->False], {3.7, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\\
), \\(23\\)]\\)=30. deg\"\>",
                    StringForm[
                    "\!\(\*SubscriptBox[\(\[Theta]\), \(23\)]\)=`` deg", 
                    "30."],
                    Editable->False], {6.050000000000001, -0.35}, {0, -1},
                    BaseStyle->{FontSize -> 14}], InsetBox[
                    
                    InterpretationBox["\<\"t = \
\\!\\(TraditionalForm\\`\\(\\\"3.998\\\" \[Times] 10\\^\\\"-14\\\"\\)\\) \
sec\"\>",
                    StringForm["t = `` sec", 
                    ScientificForm[3.9978445593483705`*^-14, 4]],
                    Editable->False], {6.550000000000001, 0.35}, {-1, -1},
                    BaseStyle->{FontSize -> 12}]}},
                   AspectRatio->Automatic,
                   ImageSize->{640.8000000000001, 414.}]}, 
                  Dynamic[$CellContext`i1$$],
                  Alignment->Automatic,
                  ImageSize->All],
                 Identity,
                 Editable->True,
                 Selectable->True]],
                ScriptLevel->0,
                Background->GrayLevel[1]],
               ImageMargins->10],
              Deployed->False,
              StripOnInput->False,
              GraphicsBoxOptions->{PreserveImageOptions->True},
              Graphics3DBoxOptions->{PreserveImageOptions->True}],
             Identity,
             Editable->False,
             Selectable->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         ColumnsEqual->False,
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i1$$, \
$CellContext`i1$184$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 30, 1}, 30, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{671., {234.875, 240.125}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.4462777118099117`*^9, {3.446277769089322*^9, 3.446277800517777*^9}, 
   3.446277845679534*^9, 3.44627977567605*^9, 3.446279923401156*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{894, 668},
WindowMargins->{{Automatic, 34}, {Automatic, 0}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 191, 4, 105, "Section"],
Cell[CellGroupData[{
Cell[806, 31, 327, 6, 49, "Subsection"],
Cell[CellGroupData[{
Cell[1158, 41, 276, 7, 43, "Input"],
Cell[1437, 50, 579, 11, 41, "Message"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2065, 67, 199, 3, 34, "Subsection"],
Cell[2267, 72, 72, 1, 27, "Output"],
Cell[2342, 75, 369, 11, 73, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2748, 91, 312, 7, 34, "Subsection"],
Cell[3063, 100, 778, 23, 73, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3878, 128, 259, 5, 34, "Subsection"],
Cell[4140, 135, 250, 6, 27, "Output"],
Cell[4393, 143, 287, 8, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4717, 156, 830, 22, 244, "Subsection"],
Cell[5550, 180, 171, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5758, 188, 161, 2, 34, "Subsection"],
Cell[CellGroupData[{
Cell[5944, 194, 10530, 272, 1288, "Input"],
Cell[CellGroupData[{
Cell[16499, 470, 2368, 52, 71, "Print"],
Cell[18870, 524, 2370, 52, 71, "Print"],
Cell[21243, 578, 1017, 28, 71, "Print"],
Cell[22263, 608, 1467, 36, 71, "Print"],
Cell[23733, 646, 1446, 37, 78, "Print"],
Cell[25182, 685, 1230, 32, 92, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26473, 724, 358, 9, 64, "Subsection"],
Cell[26834, 735, 430, 9, 23, "Message"],
Cell[27267, 746, 69, 1, 27, "Output"],
Cell[27339, 749, 3495, 107, 553, "Input"],
Cell[30837, 858, 1153, 30, 111, "Input"],
Cell[31993, 890, 1605, 41, 223, "Input"],
Cell[33601, 933, 21446, 511, 1208, "Input"],
Cell[CellGroupData[{
Cell[55072, 1448, 397, 14, 29, "Input"],
Cell[55472, 1464, 198638, 3895, 506, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
