#!/usr/bin/perl
use strict;
use POSIX;
use File::Copy;

use Carp ();
$SIG{__WARN__} = \&Carp::cluck;
$SIG{__DIE__}  = \&Carp::confess;




# ########################################################################################
#                                                                                       #
#       MatchCheckerCardReader: Tool which read the Card of MatchChecker tool		#
# 											#
# Produce necessary files for doing matching validation plots				#
# 	--->LaunchQpar.sh								#
# 	--->LaunchDistrib.sh								#
# 											#
#       S. de Visscher, last modification: August 2007					#
# 	Universite Catholique de Louvain             Fynu/Cp3				#
#                                                                                       #
#                                                                                       #
# ########################################################################################


open(INFILE1,"MadCheckerCard.dat") or die "MatchCheckerCard not present!";
open(INFILE2,"TextFiles/MatchChecker_I") or die "MatchChecker_I not present!";
open(INFILE3,"TextFiles/matching_plots_card_I") or die "MatchChecker_I not present!";
open(INFILE4,"TextFiles/matching_plots_card_II") or die "MatchChecker_II not present!";
open(INFILE5,"TextFiles/matching_plots_card_III") or die "MatchChecker_II not present!";
open(INFILE10,"TextFiles/matching_plots_card_IIII") or die "MatchChecker_II not present!";
open(INFILE6,"TextFiles/MergeMacro_I") or die "MergeMacro_I not present!";
open(INFILE7,"TextFiles/MergeMacro_II") or die "MergeMacro_II not present!";
open(INFILE8,"TextFiles/MergeMacro_III") or die "MergeMacro_III not present!";
open(INFILE9,"Cosmetics.dat") or die "Cosmetics.dat not present!";
open(INFILE50,"pdgcard.dat") or die "pdgcard.dat not present!";
open(OUTFILE1,">LaunchQpar.sh") or die "No output writing possibilities->Abort";
open(OUTFILE2,">LaunchDistrib.sh") or die "No output writing possibilities->Abort";
open(OUTFILE3,">MatchChecker.sh") or die "No output writing possibilities->Abort";
open(OUTFILE5,">MadReport.tex") or die "No output writing possibilities->Abort";


my @ProductionName;
my @ListProduction;
my @MultiplicityList;
my @xqcutList;
my @qcutList;
my $XChoice;
my $blocknumber;
my $NP=0;
my $EtaMax=5;
my @PlotSpec;
my @PDGList;
my @LegendList;
my $Legend;
my @CentralList;
my $JetScale;
my $AlgoJetChoice;
my @MultiplicityOfSample;
my $LatexLegend;
my @LatexLegendList;
my @WrittenLatexLegendList;
my $WrittenLatexLegend;
my @DetailPlotLevel;

sub VerifFichier{
	my $result=0;
	if (-f "$_[0]"){$result=1;}
	return $result; 
}

sub AssignLegendToPDGCode{
	my $LocalLegend;
	seek (INFILE50,my $curpos,0);
	while(my $current_line=<INFILE50>){
			chomp($current_line);
			my @div;
			@div=split /\s+/,$current_line;
			my $number;
			if($_[0]==$div[0]){
				if($_[1]=="1"){$LocalLegend=$div[1];}
				if($_[1]=="2"){$LocalLegend=$div[2];}
				if($_[1]=="3"){$LocalLegend=$div[3];}
			}
	}
	return $LocalLegend;
}
# Read the Card and save all inouts for creating shell scripts.
while(my $current_line=<INFILE1>){
	if($current_line=~/BLOCK1/){$blocknumber=1;}
	if($current_line=~/BLOCK2/){$blocknumber=2;}
	if($current_line=~/BLOCK3/){$blocknumber=3;}
	if($current_line=~/BLOCK4/){$blocknumber=4;}
	if($current_line=~/BLOCK5/){$blocknumber=5;}
	if($blocknumber==1){
		unless(!($current_line=~/[a_z]/) || $current_line=~/#/){	
			chomp($current_line);
			my @Split=split /::/,$current_line;
			$ListProduction[$NP]=$Split[0];
			my @SplittedLine=split /\s+/,$Split[1];
			$MultiplicityList[$NP]=$SplittedLine[1];
			$xqcutList[$NP]=$SplittedLine[2];
			$qcutList[$NP]=$SplittedLine[3];
			$Split[2] =~ s/\s//g;
			$ProductionName[$NP]=$Split[2];
			$NP++;
		}
	}
	if($blocknumber==2){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
			chomp($current_line);
			my @Split=split /\s/,$current_line;
			for(my $j=0;$j<@Split;$j++){
				$PDGList[$j]=$Split[$j];
				$LegendList[$j]=AssignLegendToPDGCode($Split[$j],1);
				$LatexLegendList[$j]=AssignLegendToPDGCode($Split[$j],2);
				$WrittenLatexLegendList[$j]=AssignLegendToPDGCode($Split[$j],3);
			}
		}
	}
	if($blocknumber==3){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
			chomp($current_line);
			$AlgoJetChoice=$current_line;
		}
	}
	if($blocknumber==4){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
 			chomp($current_line);
			$JetScale=$current_line;
		}
	}
	if($blocknumber==5){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
 			chomp($current_line);
			my @SplittedLine=split /\s+/,$current_line;
			if($SplittedLine[0]=~/DJR/){ $DetailPlotLevel[0]=$SplittedLine[1];}
			if($SplittedLine[0]=~/KinCentral/){ $DetailPlotLevel[1]=$SplittedLine[1];}
			if($SplittedLine[0]=~/KinJet/){ $DetailPlotLevel[2]=$SplittedLine[1];}
			}
	}
}
for(my $j=0;$j<@LegendList;$j++){
		$Legend=$Legend.$LegendList[$j];
		$LatexLegend=$LatexLegend.$LatexLegendList[$j];
		if($j==0){$WrittenLatexLegend=$WrittenLatexLegend.$WrittenLatexLegendList[$j];}
		if($j!=0){$WrittenLatexLegend=$WrittenLatexLegend."-".$WrittenLatexLegendList[$j];}
	}
while(my $current_line=<INFILE9>){
		unless($current_line=~/^\s/){	
			chomp($current_line);
			my @SplittedLine=split /\s+/,$current_line;
			if($SplittedLine[0]=~/PTXmin/){@PlotSpec[0]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTXmax/){$PlotSpec[1]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTXLog/){$PlotSpec[2]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTYmax/){$PlotSpec[3]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTYmin/){$PlotSpec[4]=$SplittedLine[1];}
	
			if($SplittedLine[0]=~/DPHIXmin/){$PlotSpec[5]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIXmax/){$PlotSpec[6]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHILog/){$PlotSpec[7]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIYmax/){$PlotSpec[8]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIYmin/){$PlotSpec[9]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/ETAXmin/){$PlotSpec[10]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAXmax/){$PlotSpec[11]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETALog/){$PlotSpec[12]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAYmax/){$PlotSpec[13]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAYmin/){$PlotSpec[14]=$SplittedLine[1];}

			if($SplittedLine[0]=~/MINVXmin/){@PlotSpec[25]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVXmax/){@PlotSpec[26]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVXLog/){@PlotSpec[27]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVYmax/){@PlotSpec[28]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVYmin/){@PlotSpec[29]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/PTOXmin/){@PlotSpec[30]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOXmax/){@PlotSpec[31]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOLog/){@PlotSpec[32]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOYmax/){@PlotSpec[33]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOYmin/){@PlotSpec[34]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/METXmin/){@PlotSpec[35]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METXmax/){@PlotSpec[36]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METLog/){@PlotSpec[37]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METYmax/){@PlotSpec[38]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METYmin/){@PlotSpec[39]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/RAPOXmin/){@PlotSpec[40]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOXmax/){@PlotSpec[41]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOLog/){@PlotSpec[42]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOYmax/){@PlotSpec[43]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOYmin/){@PlotSpec[44]=$SplittedLine[1];}

		
			if($SplittedLine[0]=~/PTJETXmin/){$PlotSpec[15]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETXmax/){$PlotSpec[16]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETLog/){$PlotSpec[17]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETYmax/){$PlotSpec[18]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETYmin/){$PlotSpec[19]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/ETAJETXmin/){$PlotSpec[20]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETXmax/){$PlotSpec[21]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETLog/){$PlotSpec[22]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETYmax/){$PlotSpec[23]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETYmin/){$PlotSpec[24]=$SplittedLine[1];}
		}
}


print OUTFILE3 "echo \"Q plots making\"\n";
print OUTFILE3 "./LaunchQpar.sh\n";
print OUTFILE3 "./LaunchDistrib.sh\n";
print OUTFILE3 "mv *.eps MatchingPlots/.\n";
print OUTFILE3 "latex MadReport.tex\n";
print OUTFILE3 "latex MadReport.tex\n";
print OUTFILE3 "dvips MadReport.dvi\n";
#if($response=~/y/){print OUTFILE3 "rm -f *.root\n";}

#########################################################################"
# Write LaunchQpar.sh

print OUTFILE1 "#! /bin/sh\n";
print OUTFILE1 "root -l -b << EOF\n";
for(my $j=0;$j<$NP;$j++){
	print OUTFILE1 "TString f$j=\"Prod$j.root\"\n";
}
print OUTFILE1 "gSystem->Load(\"libPhysics\")\n";
print OUTFILE1 "gSystem->Load(\"libEG\")\n";
print OUTFILE1 "gSystem->Load(\"ExRootAnalysis/lib/libExRootAnalysis.so\")\n";
print OUTFILE1 ".include ExRootAnalysis\n";

print OUTFILE1 ".L QparPlots.C++\n";
print OUTFILE1 "HistoList histo[$NP];\n";
print OUTFILE1 "TString qcut[$NP];\n";
print OUTFILE1 "TString multiplicity[$NP];\n";
my $incltag=0;
for(my $j=0;$j<$NP;$j++){
	my @xseclist;
	if($ListProduction[$j]=~/&/){
		my @indprod=split /&/,$ListProduction[$j];
		for(my $k=0;$k<@indprod;$k++){
			$indprod[$k]=~s/^\s+//g;
			$indprod[$k]=~s/\s+$//g;
			my @member=split /\s+/,$indprod[$k];
			if($member[0]){
				if($member[1]!=-1){
					$xseclist[$member[1]]="xsec$j$k.txt";
				}
				else{
					$incltag=1;
				}
			}
		}
	}
	
	my $arr=$MultiplicityList[$j]+1;
	print OUTFILE1 "Float_t xsec$j\v[$arr];\n";
	for(my $i=0;$i<=$MultiplicityList[$j];$i++){
			if($incltag==0){
				my $file=$xseclist[$i];
				print "$j $i\n";
				print "searching forr $file\n";
				if($file){
					open(INFILE60,$file) or die "No xsec->Abort";
					while(my $line=<INFILE60>){
						print "$line\n";
						my @splittedl= split /\s+/,$line;
						my $ss=$splittedl[2];
						print OUTFILE1 "xsec$j\v[$i]=$ss\n";
					}
				}
			}
			else{
				print OUTFILE1 "xsec$j\v[$i]=1\n";
			}
	}
	print OUTFILE1 "QparPlots(f$j,\"$xqcutList[$j]\",\"$qcutList[$j]\",\"$Legend\",$MultiplicityList[$j],\"$j\",xsec$j\v,$arr,&histo[$j]);\n";
	print OUTFILE1 "qcut[$j]=\"$qcutList[$j]\";\n";
	print OUTFILE1 "multiplicity[$j]=\"$MultiplicityList[$j]\";\n";
# 	print OUTFILE1 "HistoPlots(f$j,&histo[$j],\"overlay$j\",xsec$j\v,$arr);\n";
}
print OUTFILE1 "QCompPlot(histo,qcut,multiplicity,$NP,\"$Legend\");\n";
print OUTFILE1 "EOF\n";

##################################################"
# write LaunchDistrib.sh
my $z=0;
print OUTFILE2 "#! /bin/sh\n";
print OUTFILE2 "root -l -b<< EOF\n";
for(my $j=0;$j<$NP;$j++){
	print OUTFILE2 "TString match$j=\"Prod$j.root\"\n";
	print OUTFILE2 "TString stdhep$j=\"Root$j.root\"\n";
}
print OUTFILE2 "gSystem->Load(\"libPhysics\");\n";
print OUTFILE2 "gSystem->Load(\"libEG\");\n";
print OUTFILE2 "gSystem->Load(\"ExRootAnalysis/lib/libExRootAnalysis.so\");\n";
print OUTFILE2 ".include ExRootAnalysis\n";
print OUTFILE2 ".L DistribPlots.C++\n";
my $number=@PDGList;
print OUTFILE2 "TString AJC=\"$AlgoJetChoice\";\n";
print OUTFILE2 "TString JS=\"$JetScale\";\n";
print OUTFILE2 "Int_t PdgList[$number];\n";
for(my $j=0;$j<@PDGList;$j++){
	print OUTFILE2 "PdgList[$j]=$PDGList[$j];\n";
}
print OUTFILE2 "HistoList histo[$NP];\n";
print OUTFILE2 "TString qcut[$NP];\n";
print OUTFILE2 "Int_t multiplicity[$NP];\n";
print OUTFILE2 "TString Pname[$NP];\n";
for(my $j=0;$j<$NP;$j++){
	print OUTFILE2 "qcut[$j]=\"$qcutList[$j]\";\n";
	print OUTFILE2 "multiplicity[$j]=$MultiplicityList[$j];\n";
	print OUTFILE2 "Pname[$j]=\"$ProductionName[$j]\";\n";
}
print OUTFILE2 "Float_t Plots[45];\n";
for(my $j=0;$j<45;$j++){
	print OUTFILE2 "Plots[$j]=$PlotSpec[$j];\n";
}
$incltag=0;
my $index=0;
for(my $j=0;$j<$NP;$j++){
	my @xseclist;
	if($ListProduction[$j]=~/&/){
		my @indprod=split /&/,$ListProduction[$j];
		for(my $k=0;$k<@indprod;$k++){
			$indprod[$k]=~s/^\s+//g;
			$indprod[$k]=~s/\s+$//g;
			my @member=split /\s+/,$indprod[$k];
			if($member[0]){
				if($member[1]!=-1){
					$xseclist[$member[1]]="xsec$j$k.txt";
				}
				else{
					$incltag=1;
				}
			}
		}
	}
	
	my $arr=$MultiplicityList[$j]+1;
	print OUTFILE2 "Float_t xsec$j\v[$arr];\n";
	for(my $i=0;$i<=$MultiplicityList[$j];$i++){
		if($incltag==0){
			my $file=$xseclist[$i];
			if($file){
				print "$j $i\n";
				print "searching for $file\n";
				open(INFILE60,$file) or die "No xsec->Abort";
				while(my $line=<INFILE60>){
					print "$line\n";
					my @splittedl= split /\s+/,$line;
					my $ss=$splittedl[2];
					print OUTFILE2 "xsec$j\v[$i]=$ss\n";
				}
			}
		}
		else{
			print OUTFILE2 "xsec$j\v[$i]=1\n";
		}
	}
	print OUTFILE2 "HistoPlots(match$j,stdhep$j,&histo[$j],\"overl$j\",1,qcut[$j],\"$Legend\",multiplicity[$j],\"$j\",Plots,JS,AJC,PdgList,$number,Pname[$j],xsec$j\v,$arr);\n";
}
print OUTFILE2 "PrintCompHisto(histo,$NP,qcut,multiplicity,\"$Legend\",Plots,JS,AJC,Pname);\n";
print OUTFILE2 "EOF\n";

############################################
# writing MadReport.tex
$LatexLegend="\$".$LatexLegend."\$";
my $writtentitle;
my $minipagesize=0.35;
print OUTFILE5 "\\documentclass[a4paper,11pt]{article}\n";
print OUTFILE5 "\\usepackage{geometry}\n";
print OUTFILE5 "\\usepackage[latin1]{inputenc}\n";
print OUTFILE5 "\\usepackage[dvips]{graphicx,epsfig,color}\n";
print OUTFILE5 "\\geometry{hmargin=10pt, vmargin=50pt}\n";
print OUTFILE5 "\\title{Matching Validation and kinematics of $WrittenLatexLegend and extra-jets}\n";
 print OUTFILE5 "\\author{MadReport}\n";
print OUTFILE5 "\\begin{document}\n";
print OUTFILE5 "\\vspace{5cm}\n";
print OUTFILE5 "\\maketitle\n";
print OUTFILE5 "\\newpage\n";
print OUTFILE5 "\\tableofcontents\n";
print OUTFILE5 "\\newpage\n";

my $DIR="MatchingPlots/";
my $Plot;
my $sentence;
for(my $u=0;$u<$NP;$u++){
	$sentence=$sentence."_".$qcutList[$u];
}
if($DetailPlotLevel[0]==1){
print OUTFILE5 "\\section{Differential Jet Rate}\n";
for(my $u=0;$u<$NP;$u++){
print OUTFILE5 "\\subsection{$LatexLegend + max $MultiplicityList[$u] partons, run with $ProductionName[$u], xqcut=$xqcutList[$u] and Qcut=$qcutList[$u] GeV.}\n";
print OUTFILE5 "\\begin{figure}[htb]\n";
print OUTFILE5 "\\begin{center}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="Q1_$xqcutList[$u]_$qcutList[$u]_$u.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="Q2_$xqcutList[$u]_$qcutList[$u]_$u.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="Q3_$xqcutList[$u]_$qcutList[$u]_$u.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="Q4_$xqcutList[$u]_$qcutList[$u]_$u.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
 print OUTFILE5 "\\caption{Differential jet rate with \$Qcut\$= $qcutList[$u] GeV.\\label{djr$u}}\n";
print OUTFILE5 "\\end{center}\n";
print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
}

print OUTFILE5 "\\subsection{Comparison of differential jet rates (global shapes) between productions}\n";
print OUTFILE5 "\\begin{figure}[htb]\n";
print OUTFILE5 "\\begin{center}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="Q1_comparison$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="Q2_comparison$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="Q3_comparison$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="Q4_comparison$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
print OUTFILE5 "\\end{minipage}\n";
 print OUTFILE5 "\\caption{Comparison of differential jet rates between different parametrization .\\label{djrcomp}}\n";
print OUTFILE5 "\\end{center}\n";
print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
}
if($DetailPlotLevel[2]==1){
print OUTFILE5 "\\section{X kinematics}\n";
for(my $u=0;$u<$NP;$u++){
	my $identifier="$qcutList[$u]_$u\_$JetScale\_$AlgoJetChoice\_$ProductionName[$u]";
	print OUTFILE5 "\\subsection{$LatexLegend + max $MultiplicityList[$u] partons, run with $ProductionName[$u], xqcut=$xqcutList[$u] and Qcut=$qcutList[$u] GeV.}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="ptcentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="dphicentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="etacentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="invmasscentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="ptonecentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="rapidonecentralCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="missingtranverseenergyCutOff$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Kinematics variables for $LatexLegend with a multiplicity up to $MultiplicityList[$u] using $ProductionName[$u], .\\label{xkin$u}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
	print OUTFILE5 "\\newpage\n";
}
if($NP>1){
print OUTFILE5 "\\subsection{Comparison of \"X\" kinematics (global shapes) between productions}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="PtCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="DPhiCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="EtaCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="InvmassCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="PtOneCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="RapidOneCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="MissingETComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
print OUTFILE5 "\\subsection{Ratio of distributions}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="DivisionDPhiCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionEtaCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="DivisionInvmassCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtOneCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="DivisionRapidOneCentralComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="DivisionMissingETComp$sentence.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
}
}
if($DetailPlotLevel[2]==1){
print OUTFILE5 "\\section{Jet \$P_{T}\$}\n";
for(my $u=0;$u<$NP;$u++){
	print OUTFILE5 "\\subsection{$LatexLegend + max $MultiplicityList[$u] partons, run with $ProductionName[$u], xqcut=$xqcutList[$u] and Qcut=$qcutList[$u] GeV.}\n";
	my $identifier="$qcutList[$u]_$u\_$JetScale\_$AlgoJetChoice";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="pt_jet0_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="pt_jet1_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="pt_jet2_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="pt_jet3_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Pt of the four first extra-jets in Pt for $LatexLegend using $ProductionName[$u], .\\label{xkin$u}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
	print OUTFILE5 "\\newpage\n";
}
if($NP>1){
print OUTFILE5 "\\subsection{Comparison of Jet kinematics (global shapes) between productions}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="PtJetComp$sentence\_jet0_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="PtJetComp$sentence\_jet1_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="PtJetComp$sentence\_jet2_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="PtJetComp$sentence\_jet3_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
print OUTFILE5 "\\subsection{Ratio of distributions}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtJetComp$sentence\_jet0_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtJetComp$sentence\_jet1_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtJetComp$sentence\_jet2_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="DivisionPtJetComp$sentence\_jet3_cut0_$JetScale\_$AlgoJetChoice.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
print OUTFILE5 "\\newpage\n";
}
print OUTFILE5 "\\section{Jet rapidity}\n";
my @cut;
$cut[0]=0;
$cut[1]=20;
$cut[2]=50;
$cut[3]=150;
for(my $c=0;$c<@cut;$c++){
for(my $u=0;$u<$NP;$u++){
	print OUTFILE5 "\\subsection{$LatexLegend + max $MultiplicityList[$u] partons, run with $ProductionName[$u]. Jets with cut of $cut[$c] Gev in \$P_{T}\$, xqcut=$xqcutList[$u] and Qcut=$qcutList[$u] GeV}\n";
	my $identifier="$qcutList[$u]_$u\_$JetScale\_$AlgoJetChoice";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="eta_jet0_$cut[$c]\_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="eta_jet1_$cut[$c]\_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";$Plot="eta_jet2_$cut[$c]\_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";$Plot="eta_jet3_$cut[$c]\_$identifier.eps";
if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Pt of the four first extra-jets in Pt for $LatexLegend using $ProductionName[$u], .\\label{xkin$u}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
	print OUTFILE5 "\\newpage\n";
}
if($NP>1){
print OUTFILE5 "\\subsection{Comparison of Jets with a cut of $cut[$c] Gev in \$P_{T}\$\n}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";
	$Plot="EtaJetComp$sentence\_jet0_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n"; }
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";
	$Plot="EtaJetComp$sentence\_jet1_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";
	$Plot="EtaJetComp$sentence\_jet2_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";
	$Plot="EtaJetComp$sentence\_jet3_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
	print OUTFILE5 "\\newpage\n";
print OUTFILE5 "\\subsection{Ratio of distributions}\n";
	print OUTFILE5 "\\begin{figure}[htb]\n";
	print OUTFILE5 "\\begin{center}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";
	$Plot="DivisionEtaJetComp$sentence\_jet0_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";
	$Plot="DivisionEtaJetComp$sentence\_jet1_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\linewidth}\n";
	$Plot="DivisionEtaJetComp$sentence\_jet2_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\begin{minipage}[t]{$minipagesize\\textwidth}\n";
	$Plot="DivisionEtaJetComp$sentence\_jet3_cut$c\_$JetScale\_$AlgoJetChoice.eps";
	if(VerifFichier("$DIR$Plot")==1){print OUTFILE5 "\t\\includegraphics[width=1\\textwidth]{$DIR$Plot}\n";}
	print OUTFILE5 "\\end{minipage}\n";
	print OUTFILE5 "\\caption{Comparison of kinematics variables for $LatexLegend.\\label{xkincompu}}\n";
	print OUTFILE5 "\\end{center}\n";
	print OUTFILE5 "\\end{figure}\n";
	print OUTFILE5 "\\newpage\n";
}
}
}
print OUTFILE5 "\\end{document}\n";


