#! /bin/sh

echo "*****************************************************************************************"
echo "*                                                                                       *"
echo "*    MadChecker: a tool to produce validation plots for X + Njets matched productions   *"
echo "*                                                                                       *"
echo "*                              June07 -  CP3 UCL                                        *"
echo "*				Plotting scripts: Simon de Visscher                           *"
echo "*                             ExRootAnalysis: Pavel Demin                               *"
echo "*                                                                                       *"
echo "*****************************************************************************************"
echo ""
echo "Make plotting scripts executables"
chmod u+x LaunchQpar.sh
chmod u+x LaunchDistrib.sh

mv matching_plots_card_0.tcl ExRootAnalysis/.
echo "Listing files"
echo "********************"
FILE_00="../../MatchingProductions/zz.hep"
echo "FILE_00=../../MatchingProductions/zz.hep"
cp $FILE_00 Prod00.hep
mv Prod00.hep ExRootAnalysis/.
echo "Converting Prod00.hep in files.root"
cd ExRootAnalysis/
./MatchingSTDHEPConverter Prod00.hep Root00.root xsec00.txt
cd ../
echo "********************"
echo "********************"
FILE_01="../../MatchingProductions/zzj.hep"
echo "FILE_01=../../MatchingProductions/zzj.hep"
cp $FILE_01 Prod01.hep
mv Prod01.hep ExRootAnalysis/.
echo "Converting Prod01.hep in files.root"
cd ExRootAnalysis/
./MatchingSTDHEPConverter Prod01.hep Root01.root xsec01.txt
cd ../
echo "********************"
echo "********************"
FILE_02="../../MatchingProductions/zzjj.hep"
echo "FILE_02=../../MatchingProductions/zzjj.hep"
cp $FILE_02 Prod02.hep
mv Prod02.hep ExRootAnalysis/.
echo "Converting Prod02.hep in files.root"
cd ExRootAnalysis/
./MatchingSTDHEPConverter Prod02.hep Root02.root xsec02.txt
cd ../
echo "********************"
echo "********************"
FILE_03="../../MatchingProductions/zzj_2.hep"
echo "FILE_03=../../MatchingProductions/zzj_2.hep"
cp $FILE_03 Prod03.hep
mv Prod03.hep ExRootAnalysis/.
echo "Converting Prod03.hep in files.root"
cd ExRootAnalysis/
./MatchingSTDHEPConverter Prod03.hep Root03.root xsec03.txt
cd ../
echo "********************"
cd ExRootAnalysis/
rm *.hep
echo "Running ExRootAnalysis Code on M-E STDHEP files"
echo  > pythia_events.list
echo Root00.root >> pythia_events.list
echo Root01.root >> pythia_events.list
echo Root02.root >> pythia_events.list
echo Root03.root >> pythia_events.list
./ExRootMain matching_plots_card_0.tcl
mv MatchingTree.root ../Prod0.root
mv Root00.root ../.
mv xsec00.txt ../.
mv Root01.root ../.
mv xsec01.txt ../.
mv Root02.root ../.
mv xsec02.txt ../.
mv Root03.root ../.
mv xsec03.txt ../.
cd ../
chmod u+x LaunchMerge0.sh
./LaunchMerge0.sh
