#ifndef UTILS_H
#define UTILS_H


void PrintComment(){
	TPaveText *comment = new TPaveText(0.23,0.2,0.33,0.25,"NDCARC");
	comment->SetTextSize(0.04);
	comment->SetTextFont(42);
	comment->SetTextAlign(22);
	comment->SetFillColor(10);
	comment->SetTextColor(5);
	comment->SetBorderSize(0);
	TString texte=Form("[MatchChecker]");
	comment->AddText(texte);
	comment->Draw();
}


void HistStyle(TH1 *hist, Bool_t stats,Int_t color,Style_t linestyle,Style_t linewidth)
{
	hist->SetLineWidth(linewidth);
	hist->SetLineStyle(linestyle);
	hist->SetLineColor(color);


	hist->GetXaxis()->SetTitleOffset(1.2);
	hist->GetYaxis()->SetTitleOffset(1.2);
	hist->GetZaxis()->SetTitleOffset(1.5);
	hist->GetXaxis()->SetTitleFont(42);
	hist->GetYaxis()->SetTitleFont(42);
	hist->GetZaxis()->SetTitleFont(42);
	hist->GetXaxis()->SetTitleSize(0.06);
	hist->GetYaxis()->SetTitleSize(0.06);
	hist->GetZaxis()->SetTitleSize(0.04);
	hist->GetXaxis()->SetLabelFont(42);
	hist->GetYaxis()->SetLabelFont(42);
	hist->GetZaxis()->SetLabelFont(42);
	hist->GetXaxis()->SetLabelSize(0.06);
	hist->GetYaxis()->SetLabelSize(0.06);
	hist->GetZaxis()->SetLabelSize(0.06);

	hist->SetStats(stats);
}

void Style(){
	const Font_t kExRootFont = 42;
	const Float_t kExRootFontSize = 0.06; 
	gStyle->SetCanvasColor(10);
	gStyle->SetPadColor(10);
	gStyle->SetFillColor(-1);
	gStyle->SetPaperSize(20, 24);
	gStyle->SetStatFont(kExRootFont);
	gStyle->SetTextFont(kExRootFont);
	gStyle->SetTextSize(kExRootFontSize);
	gStyle->SetOptStat(0);
// 	gStyle->SetOptStat(111110);
}

TCanvas CanvasDefine(){
	TCanvas a1("a1", "a1", 700, 482);
	a1.SetLeftMargin(0.15);
	a1.SetBottomMargin(0.17);
	a1.SetTopMargin(0.01);
	a1.SetRightMargin(0.01);
	return a1; 
}

Int_t Color(Int_t param){
	Int_t result=0;
	switch (param){
		case 0:result=2;break;
		case 1:result=4;break;
		case 2:result=8;break;
		case 3:result=1;break;
		case 4:result=12;break;
		case 5:result=13;break;
		case 6:result=14;break;
	}
	return result;
}

struct FloatSerie{
        Float_t f1;
        Float_t f2;
        Float_t f3;
        Float_t f4;
        Float_t f5;
        Float_t f6;
        Float_t f7;
};

Float_t Deltafi(TLorentzVector t1,TLorentzVector t2){
	float DP=t1.Phi()-t2.Phi();
	if(DP>3.14159)DP=6.28318-DP;
	return DP;
}

#endif
