#include <iostream>
#include <utility>
#include <vector>
#include <math.h>
#include "TStyle.h"
#include "TPad.h"
#include "TCanvas.h"
#include "TSystem.h"
#include "TROOT.h"
#include "TApplication.h"
#include "THStack.h"
#include "stdio.h"
#include "TChain.h"
#include "TString.h"

#include "TH2.h"
#include "THStack.h"
#include "TLegend.h"
#include "TPaveText.h"
#include "TLorentzVector.h"

#include "ExRootAnalysis/ExRootAnalysis/ExRootClasses.h"

#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeReader.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeWriter.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeBranch.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootResult.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootUtilities.h"
#include "Utils.h"

using namespace std;


struct HistoList{
	TH1F *GCentral[50];
	TH1F *GJet[50][50][50];
};



FloatSerie KineVar(TIter it_Gen,const Int_t* PdgList,const Int_t Ndg){
//	cout<<"enter"<<endl;
	ExRootGenParticle *current_part;
	Float_t InvariantTransverseMomentum=-10;
	Float_t DeltaPhi=-10;
	Float_t Eta=-1000;
	Float_t PartPT=-1000;
        Float_t PartEta=-1000;
        Float_t MET=-1000;
	Float_t InvariantMass;

	TLorentzVector P[Ndg];
	Int_t Xok[Ndg];
	Int_t PidX[Ndg];
	for(int k=0;k<Ndg;k++){
		PidX[k]=PdgList[k];//cout<<PdgList[k]<<endl;
	}

	it_Gen.Reset();
	
	while((current_part = (ExRootGenParticle*) it_Gen.Next())){
		Float_t Px=current_part->Px;
		Float_t Py=current_part->Py;
		Float_t Pz=current_part->Pz;
		Float_t E=current_part->E;
		Int_t PID=current_part->PID;
		for(int i=0;i<Ndg;i++){
			if(abs(PID)==abs(PidX[i]) && Xok[i]==0){
				P[i].SetPxPyPzE(Px,Py,Pz,E);
				Xok[i]=1;
			//	cout<<"Phi="<<P[i].Phi()<<endl;
				break;
			}
		}
		int flag=0;
		for(int i=0;i<Ndg;i++){
			if(Xok[i]==1)flag++;
		}
		
		TLorentzVector sum;
		if(flag==Ndg){
		//	cout<<"particles trouvees"<<endl;
			for(int i=0;i<Ndg;i++){sum=sum+P[i];}
			InvariantTransverseMomentum=sum.Pt();
			Eta=sum.Eta();
			if(Ndg==2)DeltaPhi=Deltafi(P[0],P[1]);
			PartPT=P[0].Pt();
			PartEta=P[0].Eta();
			InvariantMass=sum.M();
			break;
		}
		
	}
	FloatSerie result;
	result.f1=InvariantTransverseMomentum;
	result.f2=fabs(DeltaPhi);
	result.f3=Eta;
	result.f4=InvariantMass;
        result.f5=PartPT;
        result.f6=PartEta;
        //result.f7=MET.Pt();
	//cout<<InvariantTransverseMomentum<<" "<<DeltaPhi<<" "<<Eta<<" "<<InvariantMass<<" "<<PartPT<<" "<<PartEta<<endl;
	//cout<<"Eta"<<Eta<<endl;
	return result;

}

TString Legende(int n,int excl){
	TString h1,leg;
	if(excl==1){h1=" excl.";}
	else{h1=" incl.";}
	if(n==0)leg="up to 0 jets "+h1;
	if(n==1)leg="up to 1 jets"+h1;
	if(n==2)leg="up to 2 jets"+h1;
	if(n==3)leg="up to 3 jets"+h1;
	if(n==4)leg="up to 4 jets"+h1;
	if(n==5)leg="up to 5 jets"+h1;
	if(n==6)leg="up to 6 jets"+h1;
	return leg;
}

void CMEP(ExRootTreeReader *treeReader,HistoList *histo,const char *prefix,Int_t SAorME,const TString &cutoff,const TString &legende,Int_t mult,const TString &numero,Float_t *PlotSpec,const TString &JetScale,const TString &AlgoJetChoice,const Int_t* PdgList,Int_t Ndg,const TString &genName,const float* xsectab,Int_t nxsec){
	cout<<"ok"<<endl;
	TH1F::SetDefaultSumw2(kTRUE);
	Style();
	cout<<"access to branches"<<endl;
	TClonesArray *branchParton= treeReader->UseBranch("Parton");
	TClonesArray *branchJet= treeReader->UseBranch("PartonJet");
	TClonesArray *branchGenParticle= treeReader->UseBranch("GenParticle");
	ExRootGenParticle *current_part,*current_jet;
	Long64_t allEntries = treeReader->GetEntries();
	cout << "** Chain contains " << allEntries << " Match" << endl;
	//int choice=Choice(legende);
	Int_t kDataJet=2;
	Int_t kDataCentral=7;
	Int_t nj[5];for(Int_t a=0;a<5;a++)nj[a]=0;
	Float_t NJetMax=0;
	TString kTitre[kDataCentral];
	kTitre[0]=";P_{T}^{"+ legende+"};";
	kTitre[1]=";#Delta#Phi_{"+ legende +"};Events";
	kTitre[2]=";#eta_{"+ legende +"};Nevent";
	kTitre[3]=";Invariant Mass of {"+ legende+"};";
        kTitre[4]=";P_{T} of one particle;Events";
        kTitre[5]=";Rapidity of one particle;Nevent";
        kTitre[6]=";Missing Transverse Energy;Nevent";
	float xsec[nxsec];
	for(int i=0;i<nxsec;i++){xsec[i]=xsectab[i];}
	Float_t XminCentral[7],XmaxCentral[7];
	XminCentral[0]=PlotSpec[0];
	XmaxCentral[0]=PlotSpec[1];
	XminCentral[1]=PlotSpec[5];
	XmaxCentral[1]=PlotSpec[6];
	XminCentral[2]=PlotSpec[10];
	XmaxCentral[2]=PlotSpec[11];
	XminCentral[3]=PlotSpec[25];
        XmaxCentral[3]=PlotSpec[26];
        XminCentral[4]=PlotSpec[30];
        XmaxCentral[4]=PlotSpec[31];
        XminCentral[5]=PlotSpec[40];
        XmaxCentral[5]=PlotSpec[41];
        XminCentral[6]=PlotSpec[35];
        XmaxCentral[6]=PlotSpec[36];
	TH1F *Central[50][50];
	TH1F *Jet[10][10][50][4];
	for(int m=0;m<nxsec;m++){
		cout<<xsec[m]<<endl;
	}

	for(int kMult=0;kMult<=mult;kMult++)
	for(int kType=0;kType<kDataCentral;kType++){
		//cout<<kMult<<" "<<kType<<endl;
		TString h1=Form("histo_%s_%d_%d", prefix, kMult,kType);
		TString h2=Form("ghisto_%s_%d_%d", prefix, kMult,kType);
		Central[kType][kMult]=new TH1F(h1,kTitre[kType],25,XminCentral[kType],XmaxCentral[kType]);
		histo->GCentral[kType]=new TH1F(h2,kTitre[kType],25,XminCentral[kType],XmaxCentral[kType]);
	}
	int cut[4];
	cut[0]=0;
	cut[1]=20;
	cut[2]=50;
	cut[3]=150;
	for(int kMult=0;kMult<=mult;kMult++)
	for(int kType=0;kType<kDataJet;kType++)
	for(int kJet=0;kJet<50;kJet++)
	for(int kCut=0;kCut<4;kCut++){
		TString l1;
		TString h1a=Form("histo_%s_%d_%d_%d_%d", prefix,kType, kMult,kJet,kCut);
		TString h2a=Form("ghisto_%s_%d_%d_%d_%d", prefix,kType, kMult,kJet,kCut);
		if(kType==0){
			l1=Form(";P_{T} of jet n^{o}%d;Normalized scale", kJet+1);
			Jet[kType][kMult][kJet][kCut]=new TH1F(h1a,l1,50,PlotSpec[15],PlotSpec[16]);
			histo->GJet[kType][kJet][kCut]=new TH1F(h2a,l1,50,PlotSpec[15],PlotSpec[16]);
		}
		if(kType==1){
			l1=Form(";Rapidity of jet n^{o}%d with P_{T}>%d;Normalized scale",kJet+1, cut[kCut]);
			Jet[kType][kMult][kJet][kCut]=new TH1F(h1a,l1,50,PlotSpec[20],PlotSpec[21]);
			histo->GJet[kType][kJet][kCut]=new TH1F(h2a,l1,50,PlotSpec[20],PlotSpec[21]);
			
		}
	}
	
//  	
//  	Int_t Njetstotal=0;
	for(Int_t entry = 0; entry <allEntries; ++entry){
		if(entry%500==0)cout<<"*******event n0 "<<entry<<endl;
		treeReader->ReadEntry(entry);
		//cout<<"entry red"<<endl;
		TIter it_Gen(branchGenParticle);
		TIter it_parton(branchParton);
		it_parton.Reset();
	
		FloatSerie kinevariables=KineVar(it_Gen,PdgList,Ndg);
		Float_t kinev[20];
		kinev[0]=kinevariables.f1;
		kinev[1]=kinevariables.f2;
		kinev[2]=kinevariables.f3;
		kinev[3]=kinevariables.f4;
                kinev[4]=kinevariables.f5;
                kinev[5]=kinevariables.f6;
                kinev[6]=kinevariables.f7;


		Int_t npartvalue=0;
		while((current_part = (ExRootGenParticle*) it_parton.Next())) {npartvalue++;}
		//cout<<"il y a "<<npartvalue<<" partons generes"<<endl;
		TLorentzVector j1;

		for(Int_t kMult=0;kMult<=mult;kMult++){
			//cout<<npartvalue<<endl;
			if(npartvalue<=kMult){
				for(int kType=0;kType<kDataCentral;kType++){
					//cout<<kType<<" "<<kMult<<endl;
					Central[kType][kMult]->Fill(kinev[kType]);
				}
			}
		}

		for(int kJet=0;kJet<branchJet->GetEntriesFast();kJet++){
			ExRootGenJet *jet;
			jet=(ExRootGenJet*) branchJet->At(kJet);
			for(Int_t kMult=0;kMult<=mult;kMult++){
				if(npartvalue<=kMult){
						
						Jet[0][kMult][kJet][0]->Fill(jet->PT);
					for(int kCut=0;kCut<4;kCut++){
						j1.SetPtEtaPhiM(jet->PT,jet->Eta,jet->Phi,0);
						Float_t rapidity=j1.Rapidity();
						if(jet->PT>cut[kCut])Jet[1][kMult][kJet][kCut]->Fill(rapidity);	
					}
				}
			}
// 			
		}
		if(branchJet->GetEntriesFast()>NJetMax)NJetMax=branchJet->GetEntriesFast();

 	}
	for(Int_t kMult=0;kMult<=mult;kMult++)for(int kType=0;kType<kDataCentral;kType++){
		cout<<" multiplicity="<<kMult<<" "<<Central[kType][kMult]->Integral()<<endl;;
				}
cout<<"end"<<endl;
// //*****************Cosmetics*****************************
	Int_t color[10],markerstyle[10],width[10];
	color[0]=1;
	color[1]=2;
	color[2]=3;
	color[3]=4;
	color[4]=6;
	color[5]=7;
	color[6]=8;
	markerstyle[0]=22;
	markerstyle[1]=23;
	markerstyle[2]=29;
	markerstyle[3]=21;
	markerstyle[4]=20;
	markerstyle[5]=29;
	markerstyle[6]=21;
	width[0]=3;
	width[1]=2;
	width[2]=2;
	width[3]=2;
	width[4]=2;
	for(int kType=0;kType<kDataCentral;kType++)
	for(int kMult=0;kMult<=mult;kMult++){
		if(Central[kType][kMult]->Integral()!=0)HistStyle(Central[kType][kMult],0,color[kMult],width[kMult],2);
	}
	for(int kMult=1;kMult<=mult;kMult++)
	for(int kType=0;kType<kDataCentral;kType++){
		Central[kType][kMult]->SetMarkerStyle(markerstyle[kMult]);
		Central[kType][kMult]->SetMarkerColor(color[kMult]);
	}


	for(int kType=0;kType<kDataJet;kType++)
	for(int kMult=0;kMult<=mult;kMult++)
	for(int kJet=0;kJet<NJetMax;kJet++)
	for(int kCut=0;kCut<4;kCut++){
		if(Jet[kType][kMult][kJet][kCut]->Integral()!=0)HistStyle(Jet[kType][kMult][kJet][kCut],0,color[kMult],width[kMult],2);
	}
	
	cout<<"ok20"<<endl;
	Float_t UpScaleFactorCentral[kDataCentral];
	Float_t DownScaleFactorCentral[kDataCentral];
	Int_t LogOrNotCentral[kDataCentral];
	UpScaleFactorCentral[0]=PlotSpec[3];
	UpScaleFactorCentral[1]=PlotSpec[8];
	UpScaleFactorCentral[2]=PlotSpec[13];
	UpScaleFactorCentral[3]=PlotSpec[28];
        UpScaleFactorCentral[4]=PlotSpec[33];
        UpScaleFactorCentral[5]=PlotSpec[43];
        UpScaleFactorCentral[6]=PlotSpec[38];
	

	LogOrNotCentral[0]=int(PlotSpec[2]);
	LogOrNotCentral[1]=int(PlotSpec[7]);
	LogOrNotCentral[2]=int(PlotSpec[12]);
	LogOrNotCentral[3]=int(PlotSpec[27]);
        LogOrNotCentral[4]=int(PlotSpec[32]);
        LogOrNotCentral[5]=int(PlotSpec[42]);
        LogOrNotCentral[6]=int(PlotSpec[37]);

	DownScaleFactorCentral[0]=PlotSpec[4];
	DownScaleFactorCentral[1]=PlotSpec[9];
	DownScaleFactorCentral[2]=PlotSpec[14];
	DownScaleFactorCentral[3]=PlotSpec[29];
        DownScaleFactorCentral[4]=PlotSpec[34];
        DownScaleFactorCentral[5]=PlotSpec[44];
        DownScaleFactorCentral[6]=PlotSpec[39];

	TString PlotNameCentral[kDataCentral];
	PlotNameCentral[0]="ptcentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
	PlotNameCentral[1]="dphicentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
	PlotNameCentral[2]="etacentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
	PlotNameCentral[3]="invmasscentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
        PlotNameCentral[4]="ptonecentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
        PlotNameCentral[5]="rapidonecentralCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";
        PlotNameCentral[6]="missingtranverseenergyCutOff"+cutoff+"_"+numero+"_"+JetScale+"_"+AlgoJetChoice+"_"+genName+".eps";

	
	Float_t UpScaleFactorJet[2];
	Float_t DownScaleFactorJet[2];
	Int_t LogOrNotJet[2];
	UpScaleFactorJet[0]=PlotSpec[18];
	UpScaleFactorJet[1]=PlotSpec[23];
	
	DownScaleFactorJet[0]=PlotSpec[19];
	DownScaleFactorJet[1]=PlotSpec[24];
	TString PlotNameJet[2][50][50];
	for(int kJet=0;kJet<50;kJet++){
		TString sen1=Form("%d",kJet);
		PlotNameJet[0][kJet][0]="pt_jet"+sen1+"_"+cutoff+"_"+numero+"_"+ JetScale + "_"+ AlgoJetChoice +".eps";
		for(int kCut=0;kCut<4;kCut++){
			TString sen2=Form("%d_%d",kJet,cut[kCut]);
			PlotNameJet[1][kJet][kCut]="eta_jet"+sen2+"_"+cutoff+"_"+numero+"_"+ JetScale + "_"+ AlgoJetChoice +".eps";
		}
	}
	cout<<"ok14"<<endl;
//**********rescale the central histos**********************************
	for(int kType=0;kType<kDataCentral;kType++){
		float cumulxsec=0;
		for(Int_t kMult=0;kMult<=mult;kMult++){
			if(Central[kType][kMult]->Integral()!=0){
			cumulxsec=cumulxsec+xsec[kMult];
		cout<<kType<<" "<<kMult<<" multiplicity="<<kMult<<" "<<xsec[kMult]<<" "<<Central[kType][kMult]->Integral()<<endl;
			Central[kType][kMult]->Scale(cumulxsec/Central[kType][kMult]->Integral());
		cout<<kType<<" "<<kMult<<" multiplicity="<<kMult<<" "<<xsec[kMult]<<" "<<Central[kType][kMult]->Integral()<<endl;
			}
			
		}
		histo->GCentral[kType]->Add(Central[kType][mult]);
		cout<<"ok14b"<<endl;
		
		for(Int_t kMult=0;kMult<=mult;kMult++){
			Central[kType][kMult]->Scale(1/(Central[kType][mult]->Integral()));
		}
		histo->GCentral[kType]->Scale(1/(histo->GCentral[kType]->Integral()));
		cout<<"ok14c"<<endl;
		Float_t maximum=UpScaleFactorCentral[kType]*(histo->GCentral[kType]->GetBinContent(histo->GCentral[kType]->GetMaximumBin()));
		Float_t minimum=(histo->GCentral[kType]->GetBinContent(histo->GCentral[kType]->GetMaximumBin()))/DownScaleFactorCentral[kType];
		histo->GCentral[kType]->SetMaximum(maximum);
		histo->GCentral[kType]->SetMinimum(minimum);
		Central[kType][mult]->SetMaximum(maximum);
		Central[kType][mult]->SetMinimum(minimum);
		for(Int_t kMult=0;kMult<=mult;kMult++){
			cout<<Central[kType][kMult]->Integral()<<endl;
		}
	}
	cout<<"ok15"<<endl;
	for(int kJet=0;kJet<NJetMax;kJet++){
	
		//PT************
		float cumulxsec=0;
		for(Int_t kMult=0;kMult<=mult;kMult++){
			if(Jet[0][kMult][kJet][0]->Integral()!=0){
			cumulxsec=cumulxsec+xsec[kMult];
			Jet[0][kMult][kJet][0]->Scale(cumulxsec/(Jet[0][kMult][kJet][0]->Integral()));
			}
		}
		histo->GJet[0][kJet][0]->Add(Jet[0][mult][kJet][0]);
		for(Int_t kMult=0;kMult<=mult;kMult++){
			Jet[0][kMult][kJet][0]->Scale(1/(Jet[0][mult][kJet][0]->Integral()));
		}
		histo->GJet[0][kJet][0]->Scale(1/(histo->GJet[0][kJet][0]->Integral()));
		

		Float_t BC=histo->GJet[0][kJet][0]->GetBinContent(histo->GJet[0][kJet][0]->GetMaximumBin());
		Float_t maximum=UpScaleFactorJet[0]*BC;
		Float_t minimum=BC/DownScaleFactorJet[0];
		histo->GJet[0][kJet][0]->SetMaximum(maximum);
		histo->GJet[0][kJet][0]->SetMinimum(minimum);
		Jet[0][mult][kJet][0]->SetMaximum(maximum);
		Jet[0][mult][kJet][0]->SetMinimum(minimum);
		cout<<"ok15b"<<endl;
		//ETA************************
		
		for(int kCut=0;kCut<4;kCut++){
			cumulxsec=0;
			for(Int_t kMult=0;kMult<=mult;kMult++){
		cout<<"Rescaling eta plots: jetN°"<<kJet<<" cut n°"<<kCut<<" mult="<<kMult<<" integral:"<<Jet[1][kMult][kJet][kCut]->Integral()<<endl;
				if(Jet[1][kMult][kJet][kCut]->Integral()!=0){
					cumulxsec=cumulxsec+xsec[kMult];
					Jet[1][kMult][kJet][kCut]->Scale(cumulxsec/(Jet[1][kMult][kJet][kCut]->Integral()));
				}
			}
			histo->GJet[1][kJet][kCut]->Add(Jet[1][mult][kJet][kCut]);
			for(Int_t kMult=0;kMult<=mult;kMult++){
				Jet[1][kMult][kJet][kCut]->Scale(1/(Jet[1][mult][kJet][kCut]->Integral()));
			}
			histo->GJet[1][kJet][kCut]->Scale(1/(histo->GJet[1][kJet][kCut]->Integral()));
			Float_t BC=histo->GJet[1][kJet][kCut]->GetBinContent(histo->GJet[1][kJet][kCut]->GetMaximumBin());
			Float_t maximum=UpScaleFactorJet[1]*BC;
			Float_t minimum=BC/DownScaleFactorJet[1];
			histo->GJet[1][kJet][kCut]->SetMaximum(maximum);
			histo->GJet[1][kJet][kCut]->SetMinimum(minimum);
			Jet[1][mult][kJet][kCut]->SetMaximum(maximum);
			Jet[1][mult][kJet][kCut]->SetMinimum(minimum);
		}
		
	}
	//********************************************************************************************

	
	cout<<"ok16"<<endl;
//*********************************Draw...
	
	Float_t legXmin=0.50;
	Float_t legYmin=0.75;
	TCanvas a1=CanvasDefine();

	for(int kType=0;kType<kDataCentral;kType++){
		int flag=-1;
 		gPad->SetLogy(LogOrNotCentral[kType]);
		TString leg;
		for(int t=0;t<=mult;t++){
			if(Central[kType][t]->Integral()>0)flag=1;
		}
 		if(flag==1){
			TLegend *legend = new TLegend(legXmin, legYmin, 0.99, 0.995);
			for(Int_t kMult=mult;kMult>=0;kMult--){
				int excl=1;
				if(kMult==mult)excl=0;
				TString leg=Legende(kMult,excl);
			if(Central[kType][kMult]->Integral()!=0)legend->AddEntry(Central[kType][kMult], legende+"+"+ leg );
			if(Central[kType][kMult]->Integral()==0)legend->AddEntry(Central[kType][kMult], legende+"+"+ leg + ": void" );
				if(kMult==mult){Central[kType][kMult]->Draw("hist");}
				if(kMult!=mult){Central[kType][kMult]->Draw("histsame");}
			}
			PrintComment();
			legend->Draw();
			a1.Print(PlotNameCentral[kType]);
			delete legend;
 		}else{cout<<"!!!! central probleme !!!!"<<endl;}
	}
//PT Jets plotting
	LogOrNotJet[0]=int(PlotSpec[17]);
	LogOrNotJet[1]=int(PlotSpec[22]);
	for(int kJet=0;kJet<NJetMax;kJet++){
		int flag=-1;
		for(int t=0;t<=mult;t++){
			if(Jet[0][t][kJet][0]->Integral()>0)flag=1;
		}
		if(flag==1){
			gPad->SetLogy(LogOrNotJet[0]);
			TString leg;
			TLegend *legend = new TLegend(legXmin, legYmin, 0.99, 0.995);
			for(Int_t kMult=mult;kMult>=0;kMult--){
				int excl=1;
				if(kMult==mult)excl=0;
				TString leg=Legende(kMult,excl);
			if(Jet[0][kMult][kJet][0]->Integral()!=0)legend->AddEntry(Jet[0][kMult][kJet][0], legende+"+"+ leg );
				if(kMult==mult){Jet[0][kMult][kJet][0]->Draw("hist");}
				if(kMult!=mult){Jet[0][kMult][kJet][0]->Draw("histsame");}
			}
			PrintComment();
			legend->Draw();
			a1.Print(PlotNameJet[0][kJet][0]);
			delete legend;
		}
	}

//Eta jets plotting
	for(int kJet=0;kJet<NJetMax;kJet++)
	for(int kCut=0;kCut<4;kCut++){
		int flag=-1;
		for(int t=0;t<=mult;t++){
			cout<<t<<" "<<kJet<<" "<<kCut<<Jet[1][t][kJet][kCut]->Integral()<<endl;
			if(Jet[1][t][kJet][kCut]->Integral()>0)flag=1;
		}
		if(flag==1){
			cout<<"eta plotting ok"<<endl;
			gPad->SetLogy(LogOrNotJet[1]);
			TString leg;
			TLegend *legend = new TLegend(legXmin, legYmin, 0.99, 0.995);
			for(Int_t kMult=mult;kMult>=0;kMult--){
				int excl=1;
				if(kMult==mult)excl=0;
				TString leg=Legende(kMult,excl);
		if(Jet[1][kMult][kJet][kCut]->Integral()!=0)legend->AddEntry(Jet[1][kMult][kJet][kCut], legende+"+"+ leg );
				if(kMult==mult){Jet[1][kMult][kJet][kCut]->Draw("hist");}
				if(kMult!=mult){Jet[1][kMult][kJet][kCut]->Draw("histsame");}
			}
			PrintComment();
			legend->Draw();
			a1.Print(PlotNameJet[1][kJet][kCut]);
			delete legend;
		}
	}
	for(int kMult=0;kMult<=mult;kMult++)
	for(int kType=0;kType<kDataCentral;kType++){
		delete Central[kType][kMult];
	}

// 	for(int kMult=0;kMult<=mult;kMult++)
// 	for(int kType=0;kType<kDataJet;kType++)
// 	for(int kJet=0;kJet<50;kJet++)
// 	for(int kCut=0;kCut<4;kCut++){
// 		delete Jet[kType][kMult][kJet][kCut];
// 	}
	
}

void HistoPlots(const char* file,const char* file_pythia,HistoList *histo,const char *prefix,Int_t SAorME,const TString &cutoff,const TString &legende,Int_t mult,const TString &numero,Float_t *PlotSpec,const TString &JetScale,const TString &AlgoJetChoice,Int_t *PdgList,Int_t Ndg,const TString &genName,const float* xsec,Int_t nxsec){

	TChain *chain = new TChain("Matching");
	TChain *chain_pythia = new TChain("STDHEP");
	
	chain->Add(file);
	//FillChain(chain_pythia,file_pythia);
	chain_pythia->Add(file_pythia);
	chain->AddFriend(chain_pythia,"STDHEP");
	ExRootTreeReader *treeReader = new ExRootTreeReader(chain);
  	cout <<"tree reader declared"<<endl;
	CMEP(treeReader,histo,prefix,SAorME,cutoff,legende,mult,numero,PlotSpec,JetScale,AlgoJetChoice,PdgList,Ndg,genName,xsec,nxsec);
	cout<<"okok"<<endl;
	delete chain;
	delete chain_pythia;
	delete treeReader;
}

void PrintCompHisto(HistoList *histo,Int_t N,const TString *qcutlist,Int_t *multiplicity,const TString &legende,Float_t *PlotSpec,const TString &JetScale,const TString &AlgoJetChoice,const TString *genName){
	Style();
	Int_t kDataCentral=7;
	Int_t Ntot=N;
	//cout<<"01"<<endl;
	TString *TitreCentral=new TString[50];
	TString TitreJet[Ntot];
	//cout<<"02"<<endl;
	for(int i=0;i<Ntot;i++){
		TString TC=Form("%d",multiplicity[i]);
		TitreCentral[i]=genName[i]+": "+legende + "+" + TC+ " jets w/ cutoff at " + qcutlist[i] + " GeV";
		TitreJet[i]=genName[i]+": "+legende + "+" + TC+ " jets w/ cutoff at " + qcutlist[i] + " GeV";
	}
	TString NameCentral[10];
	TString MiddleNameCentral;
	for(int i=0;i<Ntot;i++){
		MiddleNameCentral= MiddleNameCentral + "_" +qcutlist[i];
	}
	NameCentral[0]="PtCentralComp"+MiddleNameCentral +".eps";
	NameCentral[1]="DPhiCentralComp"+MiddleNameCentral +".eps";
	NameCentral[2]="EtaCentralComp"+MiddleNameCentral +".eps";
	NameCentral[3]="InvmassCentralComp"+MiddleNameCentral +".eps";
        NameCentral[4]="PtOneCentralComp"+MiddleNameCentral +".eps";
        NameCentral[5]="RapidOneCentralComp"+MiddleNameCentral +".eps";
        NameCentral[6]="MissingETComp"+MiddleNameCentral +".eps";

	
//	JET***********************************************************	
	
	TString NameJet[2][50][4];
	TString MiddleNameJet;
	for(int i=0;i<Ntot;i++){
		MiddleNameJet= MiddleNameJet + "_" +qcutlist[i];
	}
	for(int i=0;i<50;i++)
	for(int j=0;j<4;j++){
		TString middle1=Form("PtJetComp"+MiddleNameJet + "_jet%d_cut%d_"+ JetScale + "_"+ AlgoJetChoice +".eps",i,j);
		TString middle2=Form("EtaJetComp"+MiddleNameJet + "_jet%d_cut%d_"+ JetScale + "_"+ AlgoJetChoice +".eps",i,j);
		NameJet[0][i][j]=middle1;
		NameJet[1][i][j]=middle2;
	}
//	***************************************************************

	Int_t LogOrNotCentral[kDataCentral];
	
	LogOrNotCentral[0]=int(PlotSpec[2]);
	LogOrNotCentral[1]=int(PlotSpec[7]);
	LogOrNotCentral[2]=int(PlotSpec[12]);
	LogOrNotCentral[3]=int(PlotSpec[27]);
        LogOrNotCentral[4]=int(PlotSpec[32]);
        LogOrNotCentral[5]=int(PlotSpec[42]);
        LogOrNotCentral[6]=int(PlotSpec[37]);


	Int_t color[10],markerstyle[10];
	color[0]=1;
	color[1]=2;
	color[2]=3;
	color[3]=4;
	color[4]=6;
	color[5]=7;
	color[6]=8;
	markerstyle[0]=1;
	markerstyle[1]=2;
	markerstyle[2]=3;
	markerstyle[3]=4;
	markerstyle[4]=2;
	markerstyle[5]=3;
	markerstyle[6]=4;
	for(int kType=0;kType<kDataCentral;kType++)
	for(int kHisto=0;kHisto<Ntot;kHisto++){
		histo[kHisto].GCentral[kType]->SetLineStyle(markerstyle[kHisto]);
		histo[kHisto].GCentral[kType]->SetLineColor(color[kHisto]);
	}
	Float_t Chi2Central[kDataCentral];
	Float_t chi2;
	Int_t ndf,igood;
	cout<<"chi2"<<endl;
	//Central*********************************************	
	for(int kType=0;kType<kDataCentral;kType++){
		if(histo[0].GCentral[kType]->Integral()!=0){
			TCanvas a1=CanvasDefine();
			gPad->SetLogy(LogOrNotCentral[kType]);
	// 		legXmin=0.75;
	// 		Float_t legYmin=0.9;
			TLegend *legend = new TLegend(0.3, 0.995-(Ntot*0.1), 0.9, 0.995);
			//histo[0].Central[kType][0]->SetLineColor(5);
			histo[0].GCentral[kType]->Draw("e1");
			histo[0].GCentral[kType]->Draw("same");
			legend->AddEntry(histo[0].GCentral[kType],TitreCentral[0]);
			Chi2Central[kType]=-1000;
			for(int kHisto=1;kHisto<Ntot;kHisto++){
// 				ndf=24;
// 				igood=2;
// 				
// 				Float_t temp=histo[kHisto].Central[kType][0]->Chi2TestX(histo[0].Central[kType][0],chi2,ndf,igood,"WW",0);
// 				if(temp>Chi2Central[kType])Chi2Central[kType]=temp;
				histo[kHisto].GCentral[kType]->Draw("e1same");
				histo[kHisto].GCentral[kType]->Draw("same");
				legend->AddEntry(histo[kHisto].GCentral[kType],TitreCentral[kHisto]);
			}
			//cout<<"Chi2 test:"<<Chi2Central[kType]<<endl;
			PrintComment();
			legend->Draw();
			a1.Print(NameCentral[kType]);
			// DIVISION
			TCanvas a2=CanvasDefine();
			gPad->SetLogy(LogOrNotCentral[kType]);
	// 		legXmin=0.75;
	// 		Float_t legYmin=0.9;
			TLegend *legend2 = new TLegend(0.3, 0.995-(Ntot*0.1), 0.9, 0.995);
			for(int kHisto=1;kHisto<Ntot;kHisto++){
				histo[kHisto].GCentral[kType]->SetMaximum(3);
				histo[kHisto].GCentral[kType]->SetMinimum(0);
				histo[kHisto].GCentral[kType]->Divide(histo[0].GCentral[kType]);
			}
			for(int kHisto=1;kHisto<Ntot;kHisto++){
				histo[kHisto].GCentral[kType]->SetFillColor(5);
				histo[kHisto].GCentral[kType]->Draw("e3same");
			}
			for(int kHisto=1;kHisto<Ntot;kHisto++){
				histo[kHisto].GCentral[kType]->Draw("e1same");
				legend2->AddEntry(histo[kHisto].GCentral[kType],TitreCentral[kHisto]+"/"+TitreCentral[0]);
			}
			gPad->SetLogy(0);
			legend2->Draw();
			a2.Print("Division" + NameCentral[kType]);
			delete legend;
			delete legend2;
		}
	}

 	//Jet*************************************************
	Int_t LogOrNotJet[2];
	LogOrNotJet[0]=PlotSpec[17];
	LogOrNotJet[1]=PlotSpec[22];
	

	for(int kType=0;kType<2;kType++)
	for(int kJet=0;kJet<50;kJet++)
	for(int kHisto=0;kHisto<Ntot;kHisto++)
	for(int kCut=0;kCut<4;kCut++){
		histo[kHisto].GJet[kType][kJet][kCut]->SetLineStyle(markerstyle[kHisto]);
		histo[kHisto].GJet[kType][kJet][kCut]->SetLineColor(color[kHisto]);
	}
	for(int kType=0;kType<2;kType++)
	for(int kJet=0;kJet<50;kJet++){
		Int_t isNonEmpty=1;
		for(int kCut=0;kCut<4;kCut++){
			for(int kHisto=0;kHisto<Ntot;kHisto++){
				//cout <<" kType:"<<kType<<" kJet"<<kJet<<"kCut"<<kCut<<endl;
				if(histo[kHisto].GJet[kType][kJet][kCut]->Integral()==0)isNonEmpty=0;
			}
			if(isNonEmpty==1 && kJet<=4){
				TCanvas a1=CanvasDefine();
				gPad->SetLogy(LogOrNotJet[kType]);
				TLegend *legend = new TLegend(0.3, 0.995-(Ntot*0.1), 0.9, 0.995);
				histo[0].GJet[kType][kJet][kCut]->Draw("e1");
				histo[0].GJet[kType][kJet][kCut]->Draw("same");
				legend->AddEntry(histo[0].GJet[kType][kJet][kCut],TitreJet[0]);
				for(int kHisto=1;kHisto<Ntot;kHisto++){
					histo[kHisto].GJet[kType][kJet][kCut]->Draw("e1same");
					histo[kHisto].GJet[kType][kJet][kCut]->Draw("same");
					legend->AddEntry(histo[kHisto].GJet[kType][kJet][kCut],TitreJet[kHisto]);
				}
				PrintComment();
				legend->Draw();
				a1.Print(NameJet[kType][kJet][kCut]);

				TCanvas a2=CanvasDefine();
		// 		legXmin=0.75;
		// 		Float_t legYmin=0.9;
				TLegend *legend2 = new TLegend(0.3, 0.995-(Ntot*0.1), 0.9, 0.995);
				for(int kHisto=1;kHisto<Ntot;kHisto++){
					histo[kHisto].GJet[kType][kJet][kCut]->SetMaximum(3);
					histo[kHisto].GJet[kType][kJet][kCut]->SetMinimum(0);
					histo[kHisto].GJet[kType][kJet][kCut]->Divide(histo[0].GJet[kType][kJet][kCut]);
				}
				for(int kHisto=1;kHisto<Ntot;kHisto++){
					histo[kHisto].GJet[kType][kJet][kCut]->SetFillColor(5);
					histo[kHisto].GJet[kType][kJet][kCut]->Draw("e3same");
				}
				for(int kHisto=1;kHisto<Ntot;kHisto++){
					histo[kHisto].GJet[kType][kJet][kCut]->Draw("e1same");
					legend2->AddEntry(histo[kHisto].GJet[kType][kJet][kCut],TitreCentral[kHisto]+"/"+TitreCentral[0]);
				}
				gPad->SetLogy(0);
				PrintComment();
				legend2->Draw();
				a2.Print("Division" + NameJet[kType][kJet][kCut]);

				delete legend2;
				delete legend;
			}
		}	
	}
	delete [] TitreCentral;

}
