#!/usr/bin/perl
use strict;
use POSIX;
use File::Copy;

open(INFILE1,"MadCheckerCard.dat") or die "MatchCheckerCard not present!";
open(INFILE2,"TextFiles/MatchChecker_I") or die "MatchChecker_I not present!";
open(INFILE3,"TextFiles/matching_plots_card_I") or die "MatchChecker_I not present!";
open(INFILE4,"TextFiles/matching_plots_card_II") or die "MatchChecker_II not present!";
open(INFILE5,"TextFiles/matching_plots_card_III") or die "MatchChecker_II not present!";
open(INFILE5b,"TextFiles/matching_plots_card_IIII") or die "MatchChecker_II not present!";
open(INFILE6,"TextFiles/MergeMacro_I") or die "MergeMacro_I not present!";
open(INFILE7,"TextFiles/MergeMacro_II") or die "MergeMacro_II not present!";
open(INFILE8,"TextFiles/MergeMacro_III") or die "MergeMacro_III not present!";

open(INFILE9,"Cosmetics.dat") or die "Cosmetics.dat not present!";
open(INFILE50,"pdgcard.dat") or die "pdgcard.dat not present!";
open(OUTFILE1,">LaunchQpar.sh") or die "No output writing possibilities->Abort";
open(OUTFILE2,">LaunchDistrib.sh") or die "No output writing possibilities->Abort";
open(OUTFILE3,">Convertor.sh") or die "No output writing possibilities->Abort";
open(OUTFILE5,">MadReport.tex") or die "No output writing possibilities->Abort";


my @ProductionName;
my @ListProduction;
my @MultiplicityList;
my @xqcutList;
my @qcutList;
my $XChoice;
my $blocknumber;
my $NP=0;
my $EtaMax=5;
my @PlotSpec;
my @PDGList;
my @LegendList;
my $Legend;
my @CentralList;
my $JetScale;
my $AlgoJetChoice;
my @MultiplicityOfSample;
my $LatexLegend;
my @LatexLegendList;
my @WrittenLatexLegendList;
my $WrittenLatexLegend;
my @DetailPlotLevel;
sub AssignLegendToPDGCode{
	my $LocalLegend;
	seek (INFILE50,my $curpos,0);
	while(my $current_line=<INFILE50>){
			chomp($current_line);
			my @div;
			@div=split /\s+/,$current_line;
			my $number;
			if($_[0]==$div[0]){
				if($_[1]=="1"){$LocalLegend=$div[1];}
				if($_[1]=="2"){$LocalLegend=$div[2];}
				if($_[1]=="3"){$LocalLegend=$div[3];}
			}
	}
	return $LocalLegend;
}
# Read the Card and save all inouts for creating shell scripts.
while(my $current_line=<INFILE1>){
	if($current_line=~/BLOCK1/){$blocknumber=1;}
	if($current_line=~/BLOCK2/){$blocknumber=2;}
	if($current_line=~/BLOCK3/){$blocknumber=3;}
	if($current_line=~/BLOCK4/){$blocknumber=4;}
	if($current_line=~/BLOCK5/){$blocknumber=5;}
	if($blocknumber==1){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
			chomp($current_line);
			my @Split=split /::/,$current_line;
			$ListProduction[$NP]=$Split[0];
			my @SplittedLine=split /\s/,$Split[1];
			$MultiplicityList[$NP]=$SplittedLine[1];
			$xqcutList[$NP]=$SplittedLine[2];
			$qcutList[$NP]=$SplittedLine[3];
			$Split[2] =~ s/\s//g;
			$ProductionName[$NP]=$Split[2];
			$NP++;
		}
	}
	if($blocknumber==2){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
			chomp($current_line);
			my @Split=split /\s/,$current_line;
			for(my $j=0;$j<@Split;$j++){
				$PDGList[$j]=$Split[$j];
				$LegendList[$j]=AssignLegendToPDGCode($Split[$j],1);
				$LatexLegendList[$j]=AssignLegendToPDGCode($Split[$j],2);
				$WrittenLatexLegendList[$j]=AssignLegendToPDGCode($Split[$j],3);
			}
		}
	}
	if($blocknumber==3){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
			chomp($current_line);
			$AlgoJetChoice=$current_line;
		}
	}
	if($blocknumber==4){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
 			chomp($current_line);
			$JetScale=$current_line;
		}
	}
	if($blocknumber==5){
		unless($current_line=~/^\s/ || $current_line=~/#/){	
 			chomp($current_line);
			my @SplittedLine=split /\s+/,$current_line;
			if($SplittedLine[0]=~/DJR/){ $DetailPlotLevel[0]=$SplittedLine[1];}
			if($SplittedLine[0]=~/KinCentral/){ $DetailPlotLevel[1]=$SplittedLine[1];}
			if($SplittedLine[0]=~/KinJet/){ $DetailPlotLevel[2]=$SplittedLine[1];}
			}
	}
}
for(my $j=0;$j<@LegendList;$j++){
		$Legend=$Legend.$LegendList[$j];
	}
while(my $current_line=<INFILE9>){
		unless($current_line=~/^\s/){	
			chomp($current_line);
			my @SplittedLine=split /\s+/,$current_line;
			if($SplittedLine[0]=~/PTXmin/){@PlotSpec[0]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTXmax/){$PlotSpec[1]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTXLog/){$PlotSpec[2]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTYmax/){$PlotSpec[3]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTYmin/){$PlotSpec[4]=$SplittedLine[1];}
	
			if($SplittedLine[0]=~/DPHIXmin/){$PlotSpec[5]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIXmax/){$PlotSpec[6]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHILog/){$PlotSpec[7]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIYmax/){$PlotSpec[8]=$SplittedLine[1];}
			if($SplittedLine[0]=~/DPHIYmin/){$PlotSpec[9]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/ETAXmin/){$PlotSpec[10]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAXmax/){$PlotSpec[11]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETALog/){$PlotSpec[12]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAYmax/){$PlotSpec[13]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAYmin/){$PlotSpec[14]=$SplittedLine[1];}

			if($SplittedLine[0]=~/MINVXmin/){@PlotSpec[25]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVXmax/){@PlotSpec[26]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVXLog/){@PlotSpec[27]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVYmax/){@PlotSpec[28]=$SplittedLine[1];}
			if($SplittedLine[0]=~/MINVYmin/){@PlotSpec[29]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/PTOXmin/){@PlotSpec[30]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOXmax/){@PlotSpec[31]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOLog/){@PlotSpec[32]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOYmax/){@PlotSpec[33]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTOYmin/){@PlotSpec[34]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/METXmin/){@PlotSpec[35]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METXmax/){@PlotSpec[36]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METLog/){@PlotSpec[37]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METYmax/){@PlotSpec[38]=$SplittedLine[1];}
			if($SplittedLine[0]=~/METYmin/){@PlotSpec[39]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/RAPOXmin/){@PlotSpec[40]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOXmax/){@PlotSpec[41]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOLog/){@PlotSpec[42]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOYmax/){@PlotSpec[43]=$SplittedLine[1];}
			if($SplittedLine[0]=~/RAPOYmin/){@PlotSpec[44]=$SplittedLine[1];}

		
			if($SplittedLine[0]=~/PTJETXmin/){$PlotSpec[15]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETXmax/){$PlotSpec[16]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETLog/){$PlotSpec[17]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETYmax/){$PlotSpec[18]=$SplittedLine[1];}
			if($SplittedLine[0]=~/PTJETYmin/){$PlotSpec[19]=$SplittedLine[1];}
			
			if($SplittedLine[0]=~/ETAJETXmin/){$PlotSpec[20]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETXmax/){$PlotSpec[21]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETLog/){$PlotSpec[22]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETYmax/){$PlotSpec[23]=$SplittedLine[1];}
			if($SplittedLine[0]=~/ETAJETYmin/){$PlotSpec[24]=$SplittedLine[1];}
		}
}
