#include <iostream>
#include <utility>
#include <vector>
#include <math.h>
#include "TStyle.h"
#include "TPad.h"
#include "TCanvas.h"
#include "TSystem.h"
#include "TArrow.h"
#include "TROOT.h"
#include "TApplication.h"
#include "THStack.h"
#include "stdio.h"
#include "TChain.h"
#include "TString.h"

#include "TH2.h"
#include "THStack.h"
#include "TLegend.h"
#include "TPaveText.h"
#include "TLorentzVector.h"

#include "ExRootAnalysis/ExRootAnalysis/ExRootClasses.h"

#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeReader.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeWriter.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootTreeBranch.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootResult.h"
#include "ExRootAnalysis/ExRootAnalysis/ExRootUtilities.h"
#include "Utils.h"

using namespace std;


struct HistoList{
	TH1F *GlobalQ[10];
};
void PrintHisto(TChain *simu,const TString &Absisse,Int_t Qpar,const TString &Output,Float_t xmin, Float_t xmax,Int_t nbin,const TString &legende,Int_t JM,const float* xsec,Int_t nxsec,HistoList *histo, Int_t log=0,Int_t optionlegend=1){

	
	Style();
	TCanvas a1=CanvasDefine();
	
	TString nom_total=";" + Absisse + ";Normalized scale";
	TH1F *histogram[10];
	TString constr[10];
	for(Int_t i=0;i<10;i++){constr[i]=Form("Parton_size==%d",i);}
	int indic;
	TString Input;
	if(Qpar==1)Input="log10(sqrt(Match.DMerge[0]))";/*cout<<"Retrieving Qpar1 info"<<endl;*/
	if(Qpar==2)Input="log10(sqrt(Match.DMerge[1]))";/*cout<<"Retrieving Qpar2 info"<<endl;*/
	if(Qpar==3)Input="log10(sqrt(Match.DMerge[2]))";/*cout<<"Retrieving Qpar3 info"<<endl;*/
	if(Qpar==4)Input="log10(sqrt(Match.DMerge[3]))";/*cout<<"Retrieving Qpar4 info"<<endl;*/
	for(int i=0;i<nxsec;i++){
		TString titre="histogram_" + i;
		histogram[i] =new TH1F(titre,nom_total,nbin,xmin,xmax);
		simu->Draw(Input +">>" + titre ,constr[i]);
		HistStyle(histogram[i],0,Color(i),2,2);
// 		cout<<"histo N°"<<i<<" contains "<<histogram[i]->Integral()<<" events"<<endl;
		if(histogram[i]->Integral()!=0)histogram[i]->Scale(xsec[i]/histogram[i]->Integral());
	}
	TString h=Form("histo_%d",Qpar);
	TString g=Form(";Log(Differential Jet Rate %d #rightarrow %d);Normalized scale",Qpar,Qpar-1);
	histo->GlobalQ[Qpar]=new TH1F(h,g,nbin,xmin,xmax);
	for(int i=0;i<nxsec;i++){
		if(histogram[i]->Integral()!=0)histo->GlobalQ[Qpar]->Add(histogram[i]);
	}
	
	HistStyle(histo->GlobalQ[Qpar],0,40,1,3);
	
	if(histo->GlobalQ[Qpar]->Integral()!=0){
		for(int i=0;i<nxsec;i++){histogram[i]->Scale(1/(histo->GlobalQ[Qpar]->Integral()));}
		histo->GlobalQ[Qpar]->Scale(1/(histo->GlobalQ[Qpar]->Integral()));
	}
	

	histo->GlobalQ[Qpar]->SetMaximum(50*histo->GlobalQ[Qpar]->GetBinContent(histo->GlobalQ[Qpar]->GetMaximumBin()));
	histo->GlobalQ[Qpar]->SetMinimum(histo->GlobalQ[Qpar]->GetBinContent(histo->GlobalQ[Qpar]->GetMaximumBin())/1000);
	histo->GlobalQ[Qpar]->Draw("hist");
	for(int i=0;i<nxsec;i++){
		histogram[i]->Draw("histsame");
	}
	PrintComment();
	gPad->SetLogy(log);
// 	TArrow arrow;
// 	arrow.SetLineWidth(2);
// 	arrow.SetArrowSize(0.03);
// 	a1.Update();
	Float_t legXmin=0.65;
	Float_t legYmin=0.7;	
	TLegend *legend = new TLegend(legXmin, legYmin, 0.99, 0.99);
	legend->AddEntry(histo->GlobalQ[Qpar], "Sum");
	for(int i=0;i<=JM;i++){
		TString h=Form(" + %d-jet sample", i);
		if(histogram[i]->Integral()!=0){legend->AddEntry(histogram[i], legende + h);}
		else{legend->AddEntry(histogram[i], legende + h + ": void!");}
	}
	if(optionlegend==1){legend->Draw();}
	a1.Print(Output);
	
	for(Int_t i=0;i<nxsec;i++){
		delete histogram[i];
	}
	delete legend;

}

void QparPlots(const char* matchingrootfilename,const TString &xqcut, TString &qcut,const char* legende,Int_t JM,const TString &numero,const float* xsec,Int_t nxsec,HistoList *histo){
	TH1F::SetDefaultSumw2(kTRUE);
	TChain *chain_matching = new TChain("Matching");
	chain_matching->Add(matchingrootfilename);

	TString commenttitleplot=xqcut + "_" + qcut;
	TString comment1="Q1_"+ commenttitleplot + "_" +numero + ".eps";
	TString comment2="Q2_"+ commenttitleplot + "_" +numero + ".eps";
	TString comment3="Q3_"+ commenttitleplot + "_" +numero + ".eps";
	TString comment4="Q4_"+ commenttitleplot + "_" +numero + ".eps";
	
	TString Xaxis1="Log(Differential Jet Rate 1 #rightarrow 0)";
	TString Xaxis2="Log(Differential Jet Rate 2 #rightarrow 1)";
	TString Xaxis3="Log(Differential Jet Rate 3 #rightarrow 2)";
	TString Xaxis4="Log(Differential Jet Rate 4 #rightarrow 3)";
	float xmin=0.01;
	float xmax=3;
	int nbin=50;
	cout<<" Printing Q plots with xqcut="<<xqcut<<" and qcut="<<qcut<<endl;
	PrintHisto(chain_matching,Xaxis1,1,comment1,xmin,xmax,nbin,legende,JM,xsec,nxsec,histo,1,1);
	PrintHisto(chain_matching,Xaxis2,2,comment2,xmin,xmax,nbin,legende,JM,xsec,nxsec,histo,1,1);
	PrintHisto(chain_matching,Xaxis3,3,comment3,xmin,xmax,nbin,legende,JM,xsec,nxsec,histo,1,1);
	PrintHisto(chain_matching,Xaxis4,4,comment4,xmin,xmax,nbin,legende,JM,xsec,nxsec,histo,1,1);
	delete chain_matching;
	
}

void JustOneHisto(HistoList *histo,const TString *qcutlist,const TString *multiplicity,Int_t number,const TString &legende){
	
	Style();
	for(int j=0;j<number;j++)
	for(int k=1;k<=4;k++){
		HistStyle(histo[j].GlobalQ[k],0,Color(j),1,2);
	}
	Float_t legXmin=0.5;
	Style();
	TCanvas a1=CanvasDefine();
	
	for(int j=0;j<number;j++)for(int k=1;k<=4;k++){
		if(histo[j].GlobalQ[k]->Integral()!=0)histo[j].GlobalQ[k]->Scale(1/(histo[j].GlobalQ[k]->Integral()));
	}
	for(int k=1;k<=4;k++){
		histo[0].GlobalQ[k]->SetMaximum(50*histo[0].GlobalQ[k]->GetBinContent(histo[0].GlobalQ[k]->GetMaximumBin()));
		histo[0].GlobalQ[k]->SetMinimum(histo[0].GlobalQ[k]->GetBinContent(histo[0].GlobalQ[k]->GetMaximumBin())/1500);
	}
	gPad->SetLogy(1);

	TLegend *legend = new TLegend(legXmin,0.99-(number*0.07), 0.99, 0.99);
	TString legendetitre[10];
	for(int j=0;j<number;j++){
		TString multi=multiplicity[j];
		TString q=qcutlist[j];
		TString leg;
		if(multi=="0")leg="0";
		if(multi=="1")leg="0,1";
		if(multi=="2")leg="0,1,2";
		if(multi=="3")leg="0,1,2,3";
		if(multi=="4")leg="0,1,2,3,4";
		legendetitre[j]=legende + "+" + leg + " jets with cutoff at " + q + " GeV";
		legend->AddEntry(histo[j].GlobalQ[1],legendetitre[j]);
	}
	TString middlenumbers="";
	for(int i=0;i<number;i++){
		const TString qcutname=qcutlist[i];
		middlenumbers= middlenumbers + "_" +qcutname;
	}
	
	TString name[10];
	name[0]="Q1_comparison"+middlenumbers +".eps";
	name[1]="Q2_comparison"+middlenumbers +".eps";
	name[2]="Q3_comparison"+middlenumbers +".eps";
	name[3]="Q4_comparison"+middlenumbers +".eps";

	for(int i=1;i<5;i++){
		for(int j=0;j<number;j++){
			if(j==0){histo[j].GlobalQ[i]->Draw();}
			else {histo[j].GlobalQ[i]->Draw("same");}
		}
		legend->Draw();
		PrintComment();
		a1.Print(name[i-1]);
	}
	

	delete legend;
	
}

void QCompPlot(HistoList *histo, const TString *qcutlist,const TString *multiplicity,Int_t number,const TString &legende){
	JustOneHisto(histo,qcutlist,multiplicity,number,legende);
	for(Int_t j=0;j<number;j++)for(Int_t k=1;k<5;k++){
		delete histo[j].GlobalQ[k];
	}
}
